# erArk 游戏系统说明文档目录

本目录包含 erArk 游戏各个系统的详细说明文档。为了方便查找和理解，本目录按照系统功能进行分类整理。

## 📖 目录导航

### 🏗️ 核心系统架构
基础架构和核心机制相关文档。

- [**角色行为系统**](./角色行为系统.md) - 游戏核心机制，管理角色行为循环、时间流逝、状态变化
- [**前提系统**](./前提系统.md) - 行为和事件的执行条件验证
- [**结算系统**](./结算系统.md) - 行为结算、数值计算、状态更新
- [**口上系统**](./口上系统.md) - 文本和对话系统
- [**事件系统**](./事件系统.md) - 剧情事件处理和特殊触发机制

### 🖌️ 绘制系统
绘制引擎和两种绘制模式相关文档。

- [**Tk绘制模式**](./Tk绘制模式.md) - Tk 模式的端到端流程、抽象 draw 类使用、事件处理与性能调优。
- [**Web绘制模式**](./Web绘制模式.md) - Web 模式的端到端流程、元素缓冲与下发机制、web_draw 适配与性能要点。

### 🔧 技术与工具系统
开发工具和技术实现相关文档。

- [**CSV数据加载机制说明**](./CSV数据加载机制说明.md) - CSV数据文件的加载和处理
- [**AI文本生成系统**](./AI文本生成系统.md) - AI文本生成功能的详细说明
- [**存档系统**](./存档系统.md) - 游戏数据持久化、跨版本兼容性管理
- [**通用结算函数函数**](./通用结算函数函数.md) - 通用的数值计算和结算函数
- [**多周目结算与继承系统**](./多周目结算与继承系统.md) - 跨周目数据继承
- [**ArkEditor编辑器系统说明**](./ArkEditor编辑器系统说明.md) - 内置编辑器系统

### 🎮 用户界面系统
一些重要的用户交互界面相关文档。

- [**主场景互动界面**](./主场景互动界面.md) - 主要游戏场景的交互界面
- [**指令面板系统**](./指令面板系统.md) - 玩家指令选择和交互面板
- [**通用NPC选择面板**](./通用NPC选择面板.md) - NPC选择和交互通用面板
- [**系统设置系统**](./系统设置系统.md) - 游戏设置配置界面
- [**全干员位置面板**](./全干员位置面板.md) - 查看所有角色位置信息
- [**PRTS系统**](./PRTS系统.md) - PRTS通讯和信息系统

### 🗺️ 场景与地图系统
游戏世界构建和地图管理相关文档。

- [**地图系统**](./地图系统.md) - 游戏地图数据结构和管理
- [**导航系统**](./导航系统.md) - 游戏导航和场景切换

### 👥 角色创建与成长系统
角色创建、成长和相关功能文档。

- [**角色创建流程**](./角色创建流程.md) - 新角色创建的完整流程
- [**能力升级面板**](./能力升级面板.md) - 角色能力提升界面

### 👗 外观与装饰系统
角色外观、服装和装饰相关文档。

- [**服装系统说明**](./服装系统说明.md) - 服装系统的详细说明
- [**衣柜检查功能**](./衣柜检查功能.md) - 服装管理和检查功能
- [**角色图片系统**](./角色图片系统.md) - 角色图片资源管理

### 🧼 污浊系统
角色身体污浊状态的相关文档。

- [**身体信息面板系统**](./身体信息面板系统.md) - 身体信息显示界面
- [**射精面板系统**](./射精面板系统.md) - 射精相关状态面板
- [**妊娠系统**](./妊娠系统.md) - 妊娠状态管理

### 🏢 罗德岛各部门系统
罗德岛的各个部门内系统的相关文档。

- [**管理罗德岛系统**](./管理罗德岛系统.md) - 罗德岛基地管理系统
- [**动力系统**](./动力系统.md) - 能源管理和分配
- [**助理系统**](./助理系统.md) - 助理角色功能和管理
- [**基建系统**](./基建系统.md) - 建筑建造和管理功能
- [**读书系统**](./读书系统.md) - 图书阅读和学习功能
- [**身体检查与管理系统**](./身体检查与管理系统.md) - 身体检查和健康管理

### 🧑‍💼 招募系统
角色招募与访客相关文档。

- [**招募系统**](./招募系统.md) - 新角色招募机制
- [**邀请访客系统**](./邀请访客系统.md) - 访客邀请和接待

### 🚚 外勤系统
外勤任务与相关管理文档。

- [**外勤委托系统**](./外勤委托系统.md) - 外勤任务委托和管理
- [**载具管理系统**](./载具管理系统.md) - 载具管理和使用
- [**装备维护系统**](./装备维护系统.md) - 装备维护和保养功能

### ⚙️ 资源与生产系统
资源与生产相关文档。

- [**资源交易系统**](./资源交易系统.md) - 资源交易和市场
- [**工业生产系统**](./工业生产系统.md) - 工业生产和管理
- [**农业生产系统**](./农业生产系统.md) - 农业生产和管理

### 🛍️ 物品与道具系统
物品管理和使用相关文档。

- [**道具背包系统**](./道具背包系统.md) - 道具存储和管理
- [**礼物系统**](./礼物系统.md) - 礼物赠送和接收功能
- [**食物系统**](./食物系统.md) - 食物制作和消费

### 🌟 源石技艺系统
源石技艺相关文档。

- [**源石技艺系统**](./源石技艺系统.md) - 源石技艺学习和管理
- [**时间停止系统**](./时间停止系统.md) - 时间停止特殊功能
- [**催眠系统**](./催眠系统.md) - 催眠功能和相关机制

### 🎭 特殊H方式系统
除常规H之外的其他H方式的相关文档。

- [**群交系统**](./群交系统.md) - 群体互动功能
- [**监禁调教系统**](./监禁调教系统.md) - 监禁和调教功能
- [**睡眠系统**](./睡眠系统.md) - 睡眠状态管理
- [**隐奸系统**](./隐奸系统.md) - 隐秘行为系统

### 🏆 收集系统
收集、成就与收藏相关文档。

- [**收藏品系统**](./收藏品系统.md) - 收藏品收集和管理
- [**成就(蚀刻章)系统**](./成就系统.md) - 成就系统的数据结构与判定流程

## 📋 使用指南

### 如何使用本目录
1. **按分类浏览**: 根据你关注的系统类型选择对应分类
2. **关键词搜索**: 使用 Ctrl+F 搜索特定系统名称或关键词
3. **系统关联**: 许多系统之间相互关联，建议结合阅读相关系统文档

### 文档结构说明
每个系统文档通常包含以下部分：
- **系统概述**: 系统的基本功能和作用
- **核心组件**: 系统的主要模块和文件
- **数据结构**: 相关的数据类型和结构
- **流程说明**: 系统运行的详细流程
- **配置说明**: 系统的配置和设置
- **技术细节**: 实现的技术要点
- **扩展指南**: 如何扩展和修改系统

### 开发者注意事项
- 修改任何系统前，建议先完整阅读对应的系统文档
- 注意系统间的依赖关系，避免破坏系统间的接口
- 参考现有的代码风格和注释规范
- 测试修改后的功能，确保不影响其他系统

## 🔄 文档更新

本目录的文档会随着游戏版本的更新而持续更新。如果发现文档内容与实际代码不符，或者需要添加新的系统说明，请及时更新对应的文档。

---

*最后更新: 2025-10-13*
*总文档数: 52个系统文档*