# ArkEditor 编辑器系统说明

## 概述

ArkEditor 是 erArk 游戏的专用内容编辑器，位于 `/tools/ArkEditor` 目录。这是一个基于 PySide6 (Qt for Python) 开发的图形化编辑工具，用于创建和编辑游戏的三种核心数据文件：

1. **口上数据（Talk Data）** - 角色对话文件（.csv格式）
2. **事件数据（Event Data）** - 游戏事件文件（.json格式）
3. **角色数据（Character Data）** - 角色属性文件（.csv格式）

## 系统架构

### 核心模块结构

```
ArkEditor/
├── main.py              # 程序入口，主窗口初始化
├── cache_control.py     # 数据缓存控制，全局状态管理
├── game_type.py         # 数据类型定义（Talk、Event、Chara_Data）
├── load_csv.py          # CSV配置文件加载器
├── json_handle.py       # JSON文件处理
├── function.py          # 核心功能函数
└── ui/                  # UI组件目录
    ├── window.py        # 主窗口布局
    ├── menu_bar.py      # 菜单栏
    ├── tools_bar.py     # 工具栏
    ├── data_list.py     # 数据列表面板
    ├── chara_list.py    # 角色编辑面板
    ├── item_premise_list.py  # 前提条件列表
    ├── item_effect_list.py   # 效果列表
    └── item_text_edit.py     # 文本编辑器
```

### 数据流程

1. **启动流程**：
   - `main.py` 初始化 Qt 应用
   - `load_csv.py` 加载所有配置文件到 `cache`
   - 创建主窗口，根据模式切换UI布局

2. **编辑流程**：
   - 用户选择编辑模式（口上/事件/角色）
   - 加载对应的数据文件
   - 通过UI组件进行编辑
   - 保存时调用相应的格式化和写入函数

3. **数据管理**：
   - 所有运行时数据存储在 `cache_control.cache` 中
   - 支持多种数据格式转换（CVP/CVE/CSE）
   - 自动处理文件编码和格式化

## 功能模块详解

### 1. 口上编辑模式

**功能说明**：
- 创建角色在特定行为/指令下的对话内容
- 支持设置触发前提条件
- 可配置权重影响选择概率

**核心数据结构**：
```python
class Talk:
    cid: int          # 角色ID（0为通用）
    behavior_id: int  # 行为ID
    adv_id: int       # 指令ID
    premise_list: list # 前提条件列表
    weight: int       # 权重值
    context: str      # 对话内容
```

**工作原理**：
- 根据角色当前行为和指令匹配对话
- 评估所有前提条件
- 按权重随机选择符合条件的对话

### 2. 事件编辑模式

**功能说明**：
- 创建游戏中的特殊事件
- 支持前提条件和效果设置
- 可创建选项分支（父子事件）

**事件类型**：
1. **跳过指令** - 事件替代原指令执行
2. **指令前置** - 先执行指令，再触发事件
3. **指令后置** - 先触发事件，再执行指令

**核心数据结构**：
```python
class Event:
    uid: str          # 唯一ID
    adv_id: int       # 触发指令ID
    premise_list: list # 前提条件
    effect_list: list  # 效果列表
    text: str         # 事件文本
    type: int         # 事件类型
    son_event_list: list # 子事件列表
```

### 3. 角色编辑模式

**功能说明**：
- 编辑角色的完整属性数据
- 包括基础信息、能力、经验、素质、服装等
- 生成符合游戏格式的CSV文件

**编辑内容**：
- 基础信息（姓名、种族、出生地等）
- 能力值（0-8级）
- 经验值
- 素质（天赋）
- 服装配置

### 4. CVP/CVE/CSE 系统

#### 概述

CVP/CVE/CSE 系统是 erArk 游戏中的核心条件和效果系统，用于实现复杂的游戏逻辑判断和数值变化。这个系统允许创建灵活的条件检查和效果执行，是游戏内容动态化的基础。

#### 系统组成

**CVP (Comprehensive Value Premise)** - 综合数值前提
- 用于检查角色的各种数值是否满足特定条件
- 作为事件、对话、行为等的触发前提
- 支持比较运算和逻辑组合

**CVE (Comprehensive Value Effect)** - 综合数值效果  
- 用于改变角色的数值属性
- 支持增加、减少、设置等操作
- 可以作用于自己、交互对象或指定角色

**CSE (Comprehensive State Effect)** - 综合状态效果
- 用于添加或移除角色的状态
- 管理临时或持续性的状态标记
- 影响角色的行为和互动选项

#### 编码格式详解

##### 基础格式
```
目标_属性类型_属性ID_操作符_数值
```

##### 目标编码（第1位）
- `0`: 自己（当前执行角色）
- `1`: 交互对象（当前互动的目标角色）
- `2+`: 特定角色ID（直接指定角色）

##### 属性类型（第2位）
- `1`: 能力（Ability）- 角色的技能等级
- `2`: 素质（Talent）- 角色的天赋特性
- `3`: 经验（Experience）- 各类经验值
- `4`: 状态（State）- 临时或持续状态
- `5`: 好感度（Favorability）- 对特定角色的好感
- `6`: 信赖度（Trust）- 对特定角色的信赖
- `7`: 刻印（Mark）- 特殊标记系统

##### 操作符说明

**CVP 比较操作符**：
- `=`: 等于
- `!=`: 不等于
- `>`: 大于
- `>=`: 大于等于
- `<`: 小于
- `<=`: 小于等于

**CVE 赋值操作符**：
- `=`: 设置为指定值
- `+=`: 增加指定值
- `-=`: 减少指定值
- `*=`: 乘以指定值
- `/=`: 除以指定值

#### 实际应用示例

##### CVP 前提条件示例

```python
# 基础能力检查
"0_1_1_>=_3"    # 自己的口技能力等级 >= 3
"1_1_5_>_5"     # 对方的料理能力等级 > 5
"2_1_3_=_0"     # ID为2的角色魔术能力等级 = 0

# 经验值检查
"0_3_1_>=_100"  # 自己的H经验 >= 100
"1_3_5_<_50"    # 对方的料理经验 < 50

# 素质检查
"0_2_10_=_1"    # 自己拥有素质ID为10的天赋
"1_2_20_!=_1"   # 对方没有素质ID为20的天赋

# 状态检查
"0_4_1_=_1"     # 自己处于睡眠状态
"1_4_5_!=_1"    # 对方不在H状态

# 好感度检查
"1_5_0_>=_500"  # 对方对自己的好感度 >= 500
"0_5_1_>_300"   # 自己对交互对象的好感度 > 300
```

##### CVE 效果示例

```python
# 能力提升
"0_1_1_+=_1"    # 自己的口技能力等级 +1
"1_1_5_=_3"     # 将对方的料理能力设为3级

# 经验增加
"0_3_1_+=_50"   # 自己的H经验 +50
"1_3_5_*=_2"    # 对方的料理经验翻倍

# 好感度变化
"1_5_0_+=_100"  # 对方对自己的好感度 +100
"0_5_1_-=_50"   # 自己对交互对象的好感度 -50
```

##### CSE 状态效果示例

```python
# 添加状态
"0_4_1_=_1"     # 给自己添加睡眠状态
"1_4_10_=_1"    # 给对方添加疲劳状态

# 移除状态
"0_4_1_=_0"     # 移除自己的睡眠状态
"1_4_5_=_0"     # 移除对方的H状态
```

#### 复杂条件组合

CVP 系统支持通过前提组（PremiseGroup）创建复杂的条件逻辑：

##### AND 逻辑（所有条件都满足）
```python
premise_group = {
    "conditions": [
        "0_1_1_>=_3",    # 口技 >= 3
        "0_3_1_>=_100",  # H经验 >= 100
        "1_5_0_>=_300"   # 对方好感 >= 300
    ],
    "logic": "AND"
}
```

##### OR 逻辑（任一条件满足）
```python
premise_group = {
    "conditions": [
        "0_2_10_=_1",    # 拥有天赋10
        "0_2_11_=_1",    # 或拥有天赋11
        "0_1_5_>=_5"     # 或料理能力 >= 5
    ],
    "logic": "OR"
}
```

#### 在编辑器中的使用

1. **添加 CVP 前提**：
   - 点击"添加前提"按钮
   - 选择"CVP"类型
   - 使用下拉菜单选择目标、属性类型、具体属性
   - 设置比较符和数值
   - 系统自动生成编码

2. **添加 CVE/CSE 效果**：
   - 在效果列表中点击"添加效果"
   - 选择"CVE"或"CSE"类型
   - 配置目标、属性和变化值
   - 预览生成的编码

3. **批量操作**：
   - 支持复制粘贴已有的CVP/CVE/CSE
   - 可以保存常用组合作为模板
   - 支持批量修改目标或数值

#### 系统实现原理

##### 解析流程
```python
def parse_cvp(cvp_string):
    parts = cvp_string.split('_')
    return {
        'target': int(parts[0]),      # 目标
        'attr_type': int(parts[1]),   # 属性类型
        'attr_id': int(parts[2]),     # 属性ID
        'operator': parts[3],         # 操作符
        'value': int(parts[4])        # 数值
    }
```

##### 执行流程
1. **前提检查**：遍历所有CVP条件，根据逻辑关系判断是否满足
2. **效果执行**：按顺序执行所有CVE和CSE，修改角色数据
3. **结果反馈**：记录变化日志，显示给玩家

#### 性能优化建议

1. **避免过多条件**：单个事件的前提条件不宜超过10个
2. **合理使用缓存**：频繁检查的条件可以缓存结果
3. **批量处理**：相同目标的多个效果应合并处理
4. **避免循环依赖**：确保条件和效果不会形成死循环

#### 扩展性设计

CVP/CVE/CSE 系统设计为可扩展的：

1. **新增属性类型**：
   - 在 CSV 配置中添加新的属性定义
   - 更新解析器支持新的类型编码
   - 在编辑器中添加对应的UI选项

2. **自定义操作符**：
   - 可以扩展支持更复杂的操作（如取模、位运算等）
   - 添加特殊的条件判断逻辑

3. **复合效果**：
   - 支持创建包含多个基础效果的复合效果
   - 可以定义效果执行的时机和顺序

#### 调试技巧

1. **日志记录**：
   - 启用 debug 模式查看CVP/CVE/CSE的解析和执行过程
   - 检查 `game_log.log` 中的条件判断结果

2. **测试工具**：
   - 使用编辑器的"测试"功能验证条件
   - 在游戏中使用调试面板实时查看数值变化

3. **常见问题**：
   - 目标ID错误：确保角色ID存在
   - 属性ID无效：检查CSV配置文件
   - 数值溢出：注意数值范围限制

## UI组件说明

### 主窗口布局

编辑器根据不同模式采用不同的布局：

1. **口上模式**（3面板）：
   - 左侧：数据列表
   - 中间：前提条件列表
   - 右侧：文本编辑器

2. **事件模式**（4面板）：
   - 左侧：数据列表
   - 中上：前提条件列表
   - 中下：效果列表
   - 右侧：文本编辑器

3. **角色模式**（单面板）：
   - 完整的角色属性编辑表单

### 关键UI功能

**数据列表面板**：
- 添加、复制、删除条目
- 上下移动调整顺序
- 按内容或前提搜索
- 右键菜单操作

**前提/效果列表**：
- 添加简单或复杂条件
- 支持CVP/CVE/CSE编辑
- 复制粘贴功能
- 权重计算显示

**文本编辑器**：
- 多行文本输入
- 支持特殊语法标记
- 实时保存编辑内容

## 配置文件说明

编辑器依赖以下CSV配置文件：

```
csv/
├── Ability.csv       # 能力定义
├── Talent.csv        # 素质（天赋）定义
├── Experience.csv    # 经验类型定义
├── CharacterState.csv # 角色状态定义
├── Behavior_Data.csv # 行为数据
├── Premise.csv       # 前提条件定义
├── Effect.csv        # 效果定义
├── PremiseGroup.csv  # 前提组定义
└── ...              # 其他配置文件
```

这些文件定义了游戏的基础数据结构，编辑器通过读取这些文件来提供选项列表和数据验证。

## 与主游戏的集成

### 数据文件位置

编辑器生成的文件保存在主游戏的相应目录：

- **口上文件**：`/data/talk/数字_角色名.csv`
- **事件文件**：`/data/event/事件名.json`
- **角色文件**：`/data/character/数字_角色名.csv`

### 数据加载流程

1. 游戏启动时通过 `buildconfig.py` 处理CSV文件
2. `load_csv.py` 将口上数据编译到 `Character_Talk.json`
3. 事件文件在运行时动态加载
4. 角色文件被编译到 `Character.json`

### 使用场景

1. **内容创作者**：
   - 创建新的角色对话
   - 设计游戏事件
   - 调整角色属性

2. **MOD开发者**：
   - 修改现有内容
   - 添加新角色
   - 创建特殊事件

3. **游戏测试**：
   - 快速修改数据进行测试
   - 验证条件和效果
   - 调试对话触发

## 技术特点

1. **用户友好**：
   - 图形化界面，无需直接编辑文本文件
   - 自动处理复杂的数据格式
   - 实时验证和错误提示

2. **功能完整**：
   - 覆盖游戏的主要数据类型
   - 支持复杂的条件和效果系统
   - 批量操作和搜索功能

3. **可扩展性**：
   - 模块化设计，易于添加新功能
   - 配置驱动，适应游戏更新
   - 开放的数据格式

## 注意事项

1. 编辑器需要正确的CSV配置文件才能运行
2. 保存的文件编码为UTF-8 with BOM
3. 角色ID 0 表示通用内容（适用于所有角色）
4. 权重系统中，角色专属内容自动获得10倍加成
5. 事件的父子关系通过UID关联实现

## 开发建议

使用ArkEditor时的最佳实践：

1. **备份数据**：编辑前备份原始文件
2. **测试验证**：编辑后在游戏中测试效果
3. **命名规范**：遵循游戏的文件命名规则
4. **条件设计**：合理使用前提条件避免冲突
5. **性能考虑**：避免创建过多复杂条件

这个编辑器是erArk游戏生态系统的重要组成部分，大大降低了内容创作的技术门槛，使更多人能够参与游戏内容的扩展和完善。