# AI文本生成系统说明

## 系统概述

erArk游戏的AI文本生成系统是一个完整的AI集成解决方案，支持多个主流LLM服务商（OpenAI GPT、Google Gemini、DeepSeek），用于在游戏过程中动态生成角色对话和场景描述文本。该系统具备完善的安全控制、自定义配置和流式输出等功能。

## 核心组件架构

### 1. 主控制模块
- **文件位置**: `Script/UI/Panel/chat_ai_setting.py`
- **核心类**: `Chat_Ai_Setting_Panel`
- **功能**: 提供完整的AI设置界面，包括免责声明、配置选项、API密钥管理、测试功能等

### 2. AI处理引擎
- **文件位置**: `Script/Design/handle_chat_ai.py`
- **核心函数**:
  - `judge_use_text_ai()`: 判断是否使用AI生成文本
  - `text_ai()`: 主要的AI文本生成函数
  - `direct_chat_with_ai()`: 直接与AI对话功能
  - `settle_direct_instruct()`: 处理直接对话的结果

### 3. 配置数据层

#### AI设置配置 (`data/csv/Ai_Chat_Setting.csv`)
包含14个主要配置项：
1. **总开关** - 是否启用AI功能
2. **安全模式** - 仅生成全年龄内容或包含R18内容
3. **触发条件** - 何时进行AI生成（仅地文或所有文本）
4. **显示模式** - 是否隐藏原文本
5. **模型选择** - 支持多种GPT、Gemini、DeepSeek模型
6. **数据发送量** - 少量/中量/大量数据选择
7. **自动保存** - 将生成内容保存为游戏口上文件
8. **提示显示** - 是否显示"正在生成"提示
9. **生成数量** - 1-10句文本
10. **自定义URL** - 支持第三方或本地API
11. **代理设置** - 网络代理配置
12. **传输协议** - Gemini的REST传输选项
13. **思考屏蔽** - 屏蔽思考型模型的思考过程
14. **流式输出** - 实时显示生成过程

#### 发送数据配置 (`data/csv/Ai_Chat_Send_Data.csv`)
定义发送给AI的上下文数据类型：

**必选数据** (小量):
- 角色名称、时间、地点

**可选基础数据** (小-中量):
- 好感度与信赖度
- 角色陷落状态
- 基础生理状态（饥饿、尿意、疲劳、心情、睡眠）
- 角色基本属性（年龄、种族、出身、势力）
- 特殊关系（女儿、助理、跟随、访客、称呼）

**可选高级数据** (中-大量):
- 催眠状态、监禁状态、时停状态
- 详细服装信息
- 完整角色素质数据

#### 系统提示词 (`data/ui_text/text_ai_system_promote.csv`)
包含6个组合的系统提示词组件：
- **背景设定**: 明日方舟世界观
- **角色关系**: 博士与干员的互动
- **输出格式**: 文本长度和结构要求
- **描写要求**: 对话、表情、动作、心理描写规范
- **内容要求**: 直白通俗、准确体现动作过程

### 4. 集成接口

#### 对话系统集成 (`Script/Design/talk.py`)
- **集成点**: `handle_talk_draw()` 函数（195, 241, 248, 253行）
- **功能**: 在角色对话触发时调用AI生成
- **翻译支持**: 支持非中文语言的AI翻译功能

#### 指令系统集成 (`Script/Design/handle_instruct.py`)
- **集成点**: `handle_chat_with_ai()` 函数（450行）
- **功能**: 提供玩家主动与AI对话的指令

#### 系统设置集成 (`Script/UI/Panel/system_setting.py`)
- **集成点**: `chat_ai_setting_panel_draw()` 函数（68-76, 104-108行）
- **功能**: 在系统设置菜单中添加AI设置入口

## 数据流程

### 1. 初始化流程
```
启动游戏 → 加载AI配置 → 检查API密钥文件 → 初始化AI设置缓存
```

### 2. 文本生成流程
```
触发对话/指令 → 安全检查 → 收集上下文数据 → 构建提示词 → 
调用API → 处理返回结果 → 格式化输出 → 可选保存到文件
```

### 3. 直接对话流程
```
玩家选择AI对话指令 → 进入对话界面 → 玩家输入 → 
AI处理并回复 → 流式或批量显示结果 → 记录对话历史
```

## 安全与风险控制

### 1. 多层安全检查
- **免责声明**: 用户必须同意风险条款才能使用
- **内容过滤**: 可选择仅生成全年龄内容
- **行为标签**: 基于行为标签（日常、娱乐、工作）进行安全过滤
- **上下文限制**: 限制发送的角色数据避免敏感信息泄露

### 2. 用户控制选项
- **模型选择**: 用户可选择不同风险等级的模型
- **数据控制**: 精确控制发送给AI的数据量和类型
- **输出控制**: 可选择隐藏原文本、调整生成数量等

## 技术实现细节

### 1. API集成
- **OpenAI GPT**: 使用官方Python SDK，支持自定义base_url和代理
- **Google Gemini**: 使用官方SDK，支持REST传输协议切换
- **DeepSeek**: 使用OpenAI兼容格式，自定义base_url到DeepSeek API

### 2. 并发与超时控制
- **异步测试**: 使用`concurrent.futures.ThreadPoolExecutor`进行10秒超时测试
- **错误处理**: 完善的异常捕获和错误信息显示
- **流式输出**: 支持实时显示生成过程

### 3. 数据持久化
- **API密钥**: 存储在`ai_chat_api_key.csv`文件中
- **配置缓存**: 通过`cache.ai_setting`管理运行时配置
- **生成内容**: 可自动保存到`data/talk/ai/ai_talk.csv`

## 使用场景

### 1. 角色对话增强
- 在触发角色通用地文时自动生成个性化对话
- 基于角色关系、状态、场景生成符合情境的文本
- 支持不同长度和风格的文本生成

### 2. 多语言支持
- 为非中文用户提供AI翻译功能
- 可选择翻译地文、口上或两者都翻译
- 保持游戏体验的连贯性

### 3. 直接AI交互
- 玩家可主动与AI进行对话
- AI具备完整的游戏世界观和角色认知
- 支持连续对话和上下文记忆

## 配置与维护

### 1. 系统提示词调整
- 修改`data/ui_text/text_ai_system_promote.csv`可调整AI行为
- 支持自定义世界观、写作风格、输出格式
- 修改后需重启游戏生效

### 2. 发送数据定制
- 通过`data/csv/Ai_Chat_Send_Data.csv`精确控制上下文信息
- 可根据需要添加新的数据类型
- 支持数据量分级和默认选择设置

### 3. 模型和API配置
- 支持添加新的模型名称
- 可配置第三方或本地部署的API
- 灵活的代理和网络设置

## 性能与成本考虑

### 1. Token使用优化
- 分级数据发送策略减少不必要的token消耗  
- 用户可根据需求选择发送数据量
- 支持调整生成文本数量控制成本

### 2. 响应速度优化
- 流式输出提升用户体验
- 异步处理避免游戏阻塞
- 可选择关闭提示信息减少延迟感知

### 3. 网络适配
- 支持多种代理配置适应不同网络环境
- REST协议选项适配受限网络环境
- 自定义API地址支持本地部署

## 扩展性设计

### 1. 新LLM服务商集成
- 模块化的API调用设计便于添加新服务商
- 统一的配置接口和错误处理机制
- 标准化的测试和验证流程

### 2. 功能扩展接口
- 可在游戏其他系统中调用AI功能
- 标准化的输入输出格式
- 灵活的配置和控制选项

### 3. 数据扩展能力
- CSV配置文件支持动态添加新选项
- 游戏数据的自动提取和格式化
- 可扩展的提示词模板系统

## 风险提示与免责

系统内置完整的风险提示机制，包括：
- API费用承担责任
- 生成内容的不可控性风险  
- 模型服务商制裁风险
- 网络安全和隐私风险
- 内容合规性风险

用户必须明确理解并同意承担所有相关风险才能使用此功能。