# 指令常用前提分支_种族

本文档记录了指令常用的种族前提，用于AI生成指令代码文本时提供参考。每个种族包含种族名、种族前提id及特征简述。

## 种族前提

- **卡特斯/奇美拉**: `CVP_A2_R|1_E_1`
  - 特征：混合种族，结合了卡特斯（猫科）和奇美拉（混合生物）的特征，通常拥有猫科动物的敏捷与灵活。
  - 兽娘特征：通常拥有猫耳和猫尾，可能同时具有其他种族的混合特征，如角、鳞片或其他动物的耳朵。外表上有明显的混合特征，各个个体之间差异较大。
  - 生殖特征：继承了猫科的发情周期，但由于混合基因，可能有不规则的发情期。子宫结构可能呈现双重特性，能适应多种基因的胚胎发育。

- **机械**: `CVP_A2_R|2_E_1`
  - 特征：人造生命体或机械构造体，通常具有精密的机械结构和先进的运算能力。
  - 兽娘特征：外形可能模仿其他种族，拥有人工合成的兽耳、兽尾等，通常带有明显的机械关节和零件，可能有发光的眼睛或其他部位。
  - 生殖特征：不具备自然生殖能力，但可能装配有模拟生殖系统。先进型号可能拥有自我复制或制造系统。

- **龙**: `CVP_A2_R|3_E_1`
  - 特征：强大的爬行类种族，通常体型庞大，拥有坚硬的鳞片、强健的体魄和喷吐龙息的能力。
  - 兽娘特征：头部有龙角，背部可能有小型翅膀，尾巴粗壮有力，皮肤上常有鳞片，特别是在手臂、腿部和脸颊周围。眼睛通常呈竖瞳，有时能够变色。
  - 生殖特征：类似爬行动物，卵生，但在兽娘形态下可表现为较长的妊娠期（9-12个月），一次通常只孕育1-2个后代。具有季节性发情周期，通常在春季。

- **奇美拉**: `CVP_A2_R|4_E_1`
  - 特征：混合生物，由不同种族特征组合而成，外观和能力多样，通常继承了多个种族的优势特性。
  - 兽娘特征：极其多样化，可能同时拥有不同种族的特征，如狮尾与鹰翼、蛇发与羊角等组合。身体各部位的皮肤纹理和颜色可能呈现明显差异。
  - 生殖特征：生殖系统复杂多变，可能具有多种动物的生殖特点。有些个体可能拥有多个子宫或特殊的生殖周期，繁殖能力强但生育过程复杂。

- **麒麟**: `CVP_A2_R|5_E_1`
  - 特征：神秘的灵兽，通常拥有鹿身马尾的优雅外形，被视为祥瑞之兽，具备高贵的气质和特殊的能力。
  - 兽娘特征：额头有单角或双角，耳朵似鹿，背部可能有彩色斑纹，尾巴长而飘逸，类似马尾但更为蓬松华丽。通常有一种神秘的光辉环绕。
  - 生殖特征：极度稀有的繁殖周期，可能几十年才会有一次发情期。孕期长达12-14个月，一胎通常只生一胎，新生儿出生时已具备一定灵力。

- **阿达克利斯**: `CVP_A2_R|6_E_1`
  - 特征：鳄类种族，拥有坚硬的鳞片皮肤和强壮的尾巴，适应水陆环境，咬合力强大，性格稳重且有领地意识。
  - 兽娘特征：皮肤上有鳞片，特别是手臂、脸颊和背部，有长而粗壮的尾巴，牙齿锋利，没有明显的兽耳，但头部轮廓可能呈现鳄形特征。
  - 生殖特征：类似鳄鱼的卵生特性，但在兽娘形态中表现为产卵前的孕期（3-4个月）。一次可孕育10-20个卵，但通常只有少数能成功发育。季节性繁殖，通常在温暖的季节。

- **阿纳缇**: `CVP_A2_R|7_E_1`
  - 特征：鼬类种族，身体细长灵活，动作敏捷迅速，适应各种狭小空间，具有出色的狩猎本能和警觉性。
  - 兽娘特征：小巧尖细的兽耳，细长的尾巴，身材苗条灵活，眼睛大而明亮，通常呈琥珀色或深棕色。皮肤可能有轻微的条纹图案。
  - 生殖特征：一年多次发情，每次妊娠期约40-50天。一胎可生育3-8个幼崽。发情时会散发特殊气味，吸引配偶。

- **皮洛萨**: `CVP_A2_R|8_E_1`
  - 特征：树懒种族，动作缓慢但力量不俗，善于攀爬，耐性极佳，性格温和，通常节能低耗的生活方式。
  - 兽娘特征：圆润的兽耳，短而浓密的尾巴，四肢有长而锋利的爪子（适合攀爬），皮肤和头发常带有绿色调（可能是共生藻类）。
  - 生殖特征：繁殖周期极慢，大约两年一次发情期。妊娠期长（6-7个月），通常只生一个幼崽。新生儿发育缓慢但早熟，出生后能迅速抓住母亲。

- **阿斯兰**: `CVP_A2_R|9_E_1`
  - 特征：狮类种族，威严而强大，拥有狮子的特征如鬃毛和强健的身体，常展现出领袖气质。
  - 兽娘特征：圆形的狮耳，蓬松或带鬃毛的尾巴，可能有短鬃。爪子锋利，眼睛通常呈金黄或琥珀色。
  - 生殖特征：群居繁殖，雌性同步发情现象明显。妊娠期约100-110天，一胎2-4个幼崽。哺乳期长达一年，族群中所有雌性可能会参与幼崽抚养。

- **埃拉菲亚**: `CVP_A2_R|10_E_1`
  - 特征：鹿类种族，优雅敏捷，头上有角，擅长在森林中穿行，具有敏锐的感知能力。
  - 兽娘特征：鹿耳柔软灵活，有时头上有分叉的角，尾巴短小蓬松，四肢修长，皮肤可能有斑点图案。眼睛大而明亮，通常呈棕色或绿色。
  - 生殖特征：季节性发情，通常在秋季。妊娠期约7个月，一般生1-2个幼崽。新生儿能在出生后短时间内站立行走。母亲会隐藏幼崽并定期回来哺乳。

- **安努拉**: `CVP_A2_R|11_E_1`
  - 特征：两栖类种族，可能基于青蛙或蟾蜍，适应水陆两栖环境，皮肤湿润有特殊分泌物。
  - 兽娘特征：没有明显的兽耳，头部可能有凸起的眼睛或特殊的斑纹。皮肤湿润，可能有鲜艳的色彩或图案。指间可能有蹼，没有明显尾巴。
  - 生殖特征：繁殖能力极强，一次可产数百个卵。在兽娘形态中，可能表现为特殊的"产卵期"，需在水中完成受精。发育过程包括类似蝌蚪的阶段，但在体内完成。

- **杜林**: `CVP_A2_R|12_E_1`
  - 特征：矮人种族，身材矮壮，技艺精湛，擅长锻造和工程，性格坚韧顽强。
  - 兽娘特征：没有典型的兽化特征，但通常有浓密的胡须（即使是女性），皮肤粗糙坚硬，体格矮壮但肌肉发达。
  - 生殖特征：生育能力较低，但寿命极长。妊娠期长达12个月，一胎通常只有一个幼崽。新生儿成长缓慢，但非常坚韧，很少生病。

- **菲林**: `CVP_A2_R|13_E_1`
  - 特征：猫类种族，敏捷灵活，拥有猫耳和尾巴，夜视能力强，性格多变。
  - 兽娘特征：明显的猫耳，长而灵活的尾巴，瞳孔可随光线变化呈竖状，指甲锋利可伸缩，身体柔软灵活。
  - 生殖特征：发情周期明显，约每2-3个月一次。妊娠期短，约60-65天。一胎可生3-5个幼崽。发情时会有特殊行为表现，如叫声改变、烦躁不安等。

- **丰蹄**: `CVP_A2_R|14_E_1`
  - 特征：马或鹿蹄类种族，下肢强健，擅长奔跑，可能拥有类似马蹄的特征，速度快。
  - 兽娘特征：耳朵长而灵活，类似马耳，腿部肌肉发达，脚可能呈蹄状或保留人形但有蹄的特征。尾巴长而有光泽，类似马尾。
  - 生殖特征：妊娠期长，约11个月。一胎通常只有一个幼崽。新生儿发育快，出生后几小时内就能站立和行走。哺乳期可达6-8个月。

- **鬼**: `CVP_A2_R|15_E_1`
  - 特征：类似东方神话中的鬼怪，可能拥有角、特殊肤色和超自然能力，性格多变。
  - 兽娘特征：头上有一对或多对角，皮肤可能呈现不自然的颜色如红、蓝或绿。眼睛可能有特殊的颜色或图案，如黑底红瞳。可能有尖牙和爪子。
  - 生殖特征：繁殖方式神秘，可能不遵循常规生物规律。有些传说认为她们可以通过梦境或精神力量繁殖。如果能怀孕，通常妊娠期长且不规律，一胎只有一个幼崽。

- **卡普里尼**: `CVP_A2_R|16_E_1`
  - 特征：山羊类种族，头上有角，适应山地环境，体格强健，性格固执坚毅。
  - 兽娘特征：羊角明显，可能向后弯曲或螺旋状，有小巧的羊耳和短小蓬松的尾巴。眼睛特征明显，瞳孔呈现横向长方形。
  - 生殖特征：季节性发情，通常在秋冬季节。妊娠期约5个月，一胎常有2-3个幼崽。哺乳期长达6个月，新生儿能在出生后很快站立和行走。

- **卡特斯**: `CVP_A2_R|17_E_1`
  - 特征：兔类种族，拥有长耳朵和敏捷的身手，警觉性高，奔跑速度快，适应多种环境。
  - 兽娘特征：长长的兔耳是最明显特征，尾巴短小蓬松，腿部肌肉发达，牙齿中门齿较为突出。
  - 生殖特征：极高的繁殖能力，拥有双子宫结构，可同时怀不同阶段的胚胎。发情频繁，妊娠期短（约30天），一胎可生4-8个幼崽。可在分娩后立即再次受孕。

- **库兰塔**: `CVP_A2_R|18_E_1`
  - 特征：马类种族，强壮敏捷，善于奔跑，体格健壮，通常拥有马的特征如马尾和蹄子，性格较为温顺但也有野性的一面。
  - 兽娘特征：长而灵活的马耳，长而有光泽的尾巴，四肢强健，可能有轻微蹄状的特征。皮肤可能有马匹般的花纹或色块。
  - 生殖特征：发情周期规律，约每21天一次。妊娠期长，约11个月。通常一胎只有一个幼崽，罕见双胞胎。新生儿出生后能迅速站立和行走。

- **黎博利**: `CVP_A2_R|19_E_1`
  - 特征：狐类种族，狡黠聪明，拥有狐耳和蓬松的尾巴，通常具有欺诈性和魅惑力。
  - 兽娘特征：尖细的狐耳，蓬松的大尾巴（可能有多条），眼睛细长，瞳孔在光线变化下可呈竖状。皮肤可能有轻微的斑纹。
  - 生殖特征：一年一度的发情期，通常在冬末春初。妊娠期约50-55天，一胎可生4-6个幼崽。传说中有些强大的个体能通过精神力量影响她人的生育能力，这在兽娘中表现为特殊的信息素。

- **鲁珀**: `CVP_A2_R|20_E_1`
  - 特征：狼类种族，群居性强，拥有狼耳和尾巴，擅长团队合作，具有强大的忠诚度和狩猎本能。
  - 兽娘特征：尖锐的狼耳，长而蓬松的尾巴，锋利的犬齿，身体肌肉结实，眼睛常呈金黄、蓝色或灰色。
  - 生殖特征：一年一次发情期，通常在冬季。妊娠期约60-65天，一胎可生4-7个幼崽。有明显的结合现象，交配后伴侣生理上会暂时无法分开。群体中通常只有首领狼有繁殖权。

- **曼提柯**: `CVP_A2_R|21_E_1`
  - 特征：狮蝎种族，上半身为狮子，下半身为蝎子，拥有蝎尾，强大而危险，具有攻击性和领地意识。
  - 兽娘特征：狮子般的耳朵，强壮的身体，最明显的是有一条能分泌毒素的蝎尾。下半身可能有几排额外的柔软肢体或角质化的外骨骼。
  - 生殖特征：繁殖方式独特，结合了哺乳动物和节肢动物的特性。雌性有特殊的育儿囊，妊娠期短（约45天），但后续在育儿囊中发育期较长（3-4个月）。一胎通常2-3个幼崽。

- **佩洛**: `CVP_A2_R|22_E_1`
  - 特征：犬科种族，忠诚友善，嗅觉敏锐，与库兰塔有亲缘关系但特性有所不同，适应性强。
  - 兽娘特征：圆形或三角形的犬耳，尾巴长短不一（取决于犬种特征），嗅觉极其发达，可能有轻微的犬科面部特征如鼻子略突出。
  - 生殖特征：发情周期约每6个月一次。妊娠期约60天，一胎可生4-6个幼崽。有明显的结合现象。母性极强，对幼崽保护欲望高。

- **匹特拉姆**: `CVP_A2_R|23_E_1`
  - 特征：龟类种族，拥有坚硬的甲壳，行动稳健但速度较慢，寿命长，性格沉稳坚韧。
  - 兽娘特征：没有明显的兽耳，背部可能有甲壳状的装甲或图案，皮肤坚硬，四肢强壮。没有明显的尾巴，或者尾巴短小坚硬。
  - 生殖特征：寿命及生育年龄极长，可能生育期长达百年以上。卵生特性，一次可产40-60个卵，但在兽娘形态中可能表现为特殊的"孕卵期"（5-6个月）后产下卵。

- **萨弗拉**: `CVP_A2_R|24_E_1`
  - 特征：爬行类种族，可能基于蜥蜴，皮肤有鳞片，适应性强，体温随环境变化。
  - 兽娘特征：皮肤上有鳞片，特别是手臂、腿部和脸颊两侧。尾巴长而有力，可能会断尾再生。没有明显的兽耳，但头部可能有冠状或鳍状装饰。
  - 生殖特征：卵生，但在兽娘形态中可能表现为短暂的"孕卵期"（2-3个月）后产卵。一次可产8-12个卵。某些个体可能具有单性生殖能力，不需要雄性也能繁殖。

- **萨卡兹**: `CVP_A2_R|25_E_1`
  - 特征：《明日方舟》中的恶魔类种族，通常拥有角和尾巴，具有强大的源石技艺，性格多变，擅长战斗。
  - 兽娘特征：头上有一对或多对角，尾巴长而尖锐，可能有翅膀（通常退化或不明显）。眼睛可能呈现不自然的颜色如红色或金色。皮肤可能有特殊的图案或标记。
  - 生殖特征：繁殖能力低下，妊娠期长达12-15个月。通常一胎只有一个幼崽，双胞胎极为罕见。源石技艺可能影响生育能力，导致某些个体不孕。

- **萨科塔**: `CVP_A2_R|26_E_1`
  - 特征：天使种族，通常拥有翅膀和光环，具备神圣的气质和能力，与堕天使有关联但保持纯净的形态。
  - 兽娘特征：背部有一对或多对翅膀，头顶上方有光环，皮肤常呈现出微微的光泽。眼睛通常呈现明亮的颜色如金色、蓝色或紫色。
  - 生殖特征：繁殖极其罕见，许多萨科塔传说是由天界直接创造而非出生。如果能够繁殖，妊娠期极长（可达24个月），幼崽出生时已具备一定的能力和记忆。

- **瓦伊凡**: `CVP_A2_R|27_E_1`
  - 特征：西方飞龙种族，拥有翅膀和龙的特征，善于飞行，通常具有喷火能力，性格高傲独立。
  - 兽娘特征：背部有一对龙翼，皮肤上有细小的鳞片，特别是手臂和脸颊周围。头部可能有小角，尾巴长而有力。眼睛通常呈现竖瞳。
  - 生殖特征：繁殖周期极长，可能几十年才会有一次发情期。卵生，但在兽娘形态中表现为短暂的"孕卵期"（约6个月）后产下龙卵。通常一次只产一个卵，孵化期长达一年。

- **沃尔珀**: `CVP_A2_R|28_E_1`
  - 特征：狐类种族，聪明狡猾，拥有狐耳和多条尾巴，在《明日方舟》中往往擅长源石技艺和幻术。
  - 兽娘特征：尖细的狐耳，最明显的特征是多条尾巴（数量可能随年龄和力量增长），眼睛细长，通常呈现金色或红色。皮肤可能有特殊的图案。
  - 生殖特征：发情期不规律，与力量和尾巴数量有关。妊娠期约60天，一胎通常只有1-2个幼崽。传说中有特殊能力诱导她人繁殖或抑制繁殖，这在兽娘中表现为特殊的信息素和魅惑能力。

- **乌萨斯**: `CVP_A2_R|29_E_1`
  - 特征：熊类种族，体型强壮，耐寒能力极强，性格坚韧，在《明日方舟》中与北国环境相关。
  - 兽娘特征：圆形的熊耳，身体强壮魁梧，皮肤上可能有厚厚的绒毛，特别是冬季。可能有短小的尾巴，爪子强壮有力。
  - 生殖特征：冬眠期特殊生理机制，受精卵在母体内延迟发育，直到冬眠结束。妊娠期实际只有约2个月，一胎通常生2-3个幼崽。幼崽出生时极其弱小，需要长时间的哺育。

- **依特拉**: `CVP_A2_R|30_E_1`
  - 特征：麝鹿种族，优雅矫健，可能有发达的角，善于在森林和山区环境活动，嗅觉灵敏。
  - 兽娘特征：鹿耳柔软，有时头上有大型分叉角，尾巴短小，四肢修长有力。皮肤可能有浅色斑点。
  - 生殖特征：季节性发情，通常在秋季。妊娠期约7-8个月，一胎通常生1-2个幼崽。新生儿能在出生几小时内站立和行走。有特殊的母子联结机制，通过气味识别。

- **札拉克**: `CVP_A2_R|31_E_1`
  - 特征：鼠类种族，体型灵活矫健，适应能力极强，善于在狭小空间穿行，嗅觉敏锐，繁殖能力强，群居性高。
  - 兽娘特征：圆形的鼠耳，细长的尾巴，牙齿中门齿发达，身材小巧灵活，嗅觉和听觉极其敏锐。
  - 生殖特征：极高的繁殖能力，几乎全年可繁殖。妊娠期短，约20-25天，一胎可生6-12个幼崽。雌性在分娩后24小时内就可再次受孕。哺乳期短，幼崽发育快速。

- **德拉克**: `CVP_A2_R|32_E_1`
  - 特征：红龙种族，与瓦伊凡有区别的龙类亚种，通常体型较小，鳞片呈红色，性格热情但易怒。
  - 兽娘特征：头部有短角，皮肤上有红色鳞片，特别是手臂、腿部和脸颊。尾巴较短但有力，可能有小型翅膀。眼睛呈现竖瞳，通常为金色或红色。
  - 生殖特征：繁殖周期与火山活动或季节温度相关。卵生，孕卵期约4-5个月。一次产1-2个卵，孵化需要高温环境，孵化期约6个月。

- **瑞柏巴**: `CVP_A2_R|33_E_1`
  - 特征：鬣狗种族，强壮凶猛，群居性强，擅长追踪和持久奔跑，领地意识强烈。
  - 兽娘特征：圆形的耳朵，强壮的下颌，斑点或条纹状的皮肤图案，尾巴中等长度。骨骼和肌肉结构适合长时间奔跑。
  - 生殖特征：特殊的生殖系统，雌性外生殖器官构造独特（类似雄性）。群体中雌性地位高于雄性。妊娠期约110天，一胎通常2-4个幼崽。群体共同哺育幼崽。

- **阿戈尔**: `CVP_A2_R|34_E_1`
  - 特征：可能是深海或水生种族，适应水下环境，可能有鳃或特殊呼吸系统。
  - 兽娘特征：皮肤上可能有鳞片或光滑的表面，颈部可能有鳃状结构。四肢间可能有蹼，眼睛较大，适应深水环境。可能有鱼尾或类似结构。
  - 生殖特征：繁殖方式类似鱼类，但适应了兽娘形态。可能有特殊的"产卵期"，需要在水中完成受精。一次可产数百个卵，但存活率低。某些个体可能有性转换能力。

- **海嗣**: `CVP_A2_R|35_E_1`
  - 特征：水生虫群型生物，由多个个体组成统一意识体，适应深海环境，具有集群智能和特殊的生物学特性。
  - 兽娘特征：皮肤质地特殊，可能有半透明或多层次的特性。体表可能有发光器官或触手状附属物。没有传统意义上的兽耳或尾巴，但可能有触须或其他感知器官。
  - 生殖特征：通过分裂或芽殖繁殖，不需要常规的性繁殖。在兽娘形态中，可能表现为能够分离身体的一部分形成新个体，或者通过特殊的"孢子"繁殖。集体意识可能在多个身体间共享。

- **精灵**: `CVP_A2_R|36_E_1`
  - 特征：优雅高贵的种族，通常寿命长，耳朵尖，与自然和魔法有紧密联系，技艺精湛。
  - 兽娘特征：尖长的耳朵是最明显特征，身材通常修长优雅，皮肤可能有微妙的光泽或纹路。眼睛大而明亮，可能呈现不常见的颜色如紫色、银色等。
  - 生殖特征：极长的生育期，可能延续数百年。妊娠期长，约12-15个月。通常一胎只有一个幼崽，多胎极为罕见。繁殖率低，但寿命极长，成熟期也很长。

- **阿纳萨**: `CVP_A2_R|37_E_1`
  - 特征：佛魔种族，综合了佛教和魔教元素的神秘种族，可能拥有特殊的灵性能力和宗教特征。
  - 兽娘特征：头部可能有角或特殊的装饰，如佛教头饰。皮肤可能有特殊的纹路或图案，类似宗教纹身。可能有多臂形态或其他非常规的身体特征。
  - 生殖特征：繁殖方式神秘，可能与精神力量和修行有关。某些传说认为她们可以通过冥想或特殊仪式繁殖。如果有常规生育能力，妊娠期长且伴随特殊的精神状态。

- **塞拉托**: `CVP_A2_R|38_E_1`
  - 特征：犀科种族，体型庞大，皮肤坚硬，头部有角，力量强大，性格通常固执且领地意识强。
  - 兽娘特征：额头上有一个或多个角，皮肤厚实，可能呈现出犀牛皮肤的褶皱特征。耳朵小而圆，没有明显的尾巴或尾巴短小。体格魁梧强壮。
  - 生殖特征：繁殖周期长，约3-4年一次发情期。妊娠期长，约16-18个月。一胎通常只有一个幼崽，多胎极为罕见。母子关系密切，保护期长达3-4年。

- **斐迪亚**: `CVP_A2_R|39_E_1`
  - 特征：蛇类种族，身体灵活，可能拥有特殊的毒素或缠绕能力，冷血动物特性，适应各种环境。
  - 兽娘特征：没有外耳，眼睛垂直瞳孔，皮肤可能有鳞片特别是在手臂和腿部。舌头可能分叉，下半身在某些个体中可能呈现蛇尾形态。
  - 生殖特征：卵生或卵胎生，有些个体可能保留蛇类的蜕皮习性。妊娠期约4-5个月，一胎可产10-20个卵或幼崽。某些个体可能有毒腺，与生殖系统相连。

- **堕天使**: `CVP_A2_R|40_E_1`
  - 特征：天使的变异种族，通常有翅膀但可能已经损坏或变色，拥有特殊的能力和黑暗的过去。
  - 兽娘特征：背部有一对受损或变色的翅膀（通常为黑色或暗色），头顶可能有破碎或暗淡的光环。皮肤可能有特殊的纹路或伤痕。眼睛可能呈现不自然的颜色。
  - 生殖特征：与萨科塔相似但有变异。繁殖能力通常受到堕落过程的影响，可能导致不孕或特殊的繁殖需求。如果能够繁殖，妊娠期约12个月，幼崽出生时可能带有堕落的特征。

- **羽蛇**: `CVP_A2_R|42_E_1`
  - 特征：基于美洲神话中的羽蛇神，蛇的身体但有羽毛装饰，可能拥有飞行或特殊魔法能力。
  - 兽娘特征：身体覆盖有鳞片和羽毛的混合，特别是手臂和腿部。没有外耳，眼睛可能呈竖瞳。可能有翅膀或羽毛状的装饰物。
  - 生殖特征：繁殖周期与星象有关，通常在特定星象排列时才会发情。卵生，孕卵期约6-7个月。一次产1-2个卵，孵化期长，约10-12个月。

- **神**: `CVP_A2_R|43_E_1`
  - 特征：强大的神祇种族，拥有超凡的力量和寿命，能力远超普通种族，可能掌控某种自然或宇宙力量。
  - 兽娘特征：外观可能非常多样，取决于所代表的神祇类型。可能有特殊的光环、标记或身体特征。通常散发出特殊的气场或光芒。
  - 生殖特征：繁殖极其罕见，通常不遵循常规生物学规律。可能通过思想创造生命，或者与凡人结合产生半神后代。也可能通过分享神力或灵魂分裂来"创造"后代。

- **鵺**: `CVP_A2_R|44_E_1`
  - 特征：基于日本神话中的混合妖怪，通常由多种动物特征组合而成，拥有变形和幻术能力。
  - 兽娘特征：外形多变，可能同时具有多种动物的特征，如虎爪、蛇尾、鸟翼等。能够部分变形，改变身体特定部位的形态。眼睛通常有特殊的颜色或图案。
  - 生殖特征：繁殖能力与其变形能力相关。可能能够改变自身生殖系统以适应不同种族的伴侣。妊娠期不固定，后代特征高度不确定，可能继承多种生物的特征。
  