---
mode: 'edit'
description: '扩充指令的代码文本'
---
# 扩充要求
1. 扩充当前代码文件中的对某一指令的代码文本，你需要参考示范代码，要求按照格式补充代码文本。
2. 你需要在同目录下使用一个新的csv文件，为代码文本第2列的每种行为，使用说明文件"指令前提分支.md"里作为第4列的前提，每种行为都写5行代码文本。
4. 如果提供了多个前提说明文件，你需要对其进行组合。如文件1中有3个前提，文件2中有2个前提，那么你需要组合成3*2=6种前提组合，前提组合之间用"&"连接。
# 代码文本的格式
1. 每一行的第1列cid为从某个数开始递增的正整数，如果其他条件中没有注明，则默认从1000开始递增。
2. 每一行的第2列为固定值"aromatherapy_8"，代表进行香薰疗愈，香薰疗愈的效果是减缓目标今日的疲惫速度。
3. 每一行的第3列是固定值0。
4. 每一行的第4列为前提条件id，为固定值'sys_5'。
5. 每一行的第5列context为对该指令的描述文本。
# 描述文本
## 描述的基本内容
当前指令为香薰疗愈，{Name}给{TargetName}进行香薰疗愈。
## 描述的背景
1. {Name}是博士，是{TargetName}所在公司的上司，会称呼{Name}为{Name}，或者博士。公司是一个叫做罗德岛的医疗企业，这个公司和设定背景自于一个叫做《明日方舟》的塔防手游。
2. {TargetName}是女性，是罗德岛的干员，如果前提条件中没有单独注明，则默认{TargetName}是少女。
3. {Name}和{TargetName}在同一个地点。
## 描述文本的具体内容
1. {Name}现场制作了该种类的香薰，并点燃。
2. {TargetName}在疗养床上坐着或者躺着，闻到了香薰的味道。
3. 根据不同的香薰种类，描述{TargetName}闻到香薰味道后的感受和反应。
4. 仅叙述香薰疗愈这个过程本身，不能描述之后要进行的行为，不能描述{Name}和{TargetName}对彼此进行了什么样的行为。
5. 该香薰的介绍如下：'静谧山泉：蠕动的星光们将暴力蚕食殆尽，提琴声铺成无边无际的草地，钢琴声化作水流，洗去一身疲惫，得以走过好长一段路，黑夜也不再沉重，徒留一片宁静。'
## 描述文本的要求
1. 描述文本的总字数在500个中文汉字左右，不少于400个中文汉字。
2. 描述文本除了描述动作本身之外，可以描述表情、手、腰、腿等相关的辅助动作，但不能描述与行动没有直接关联的动作。
3. 描述文本中如果一个句号不是文本的最后一个字符，则该句号的后面应有一个换行符"\n"。
4. 描述文本可以有语气词或者称呼，但不能有具体说出的话和发言，只能泛化描述发言的大概内容。
5. 描述文本的每一行的内容不能重复，尽量使用更多不同的描述方式以及同义词。
6. 描述文本的用语要直白、浅显、易懂，要尽可能的引起玩家和读者的兴趣。
7. 当前地点是专门用来进行香薰疗愈的香熏治疗室，房间里有专门的香薰设备和疗养床。
8. 如果需要提到{TargetName}的衣服的话，{TargetName}的上半身穿着{TargetUpClothName}，下半身穿着{TargetDownClothName}。
