---
mode: 'edit'
description: '扩充指令的代码文本'
---
# 扩充要求
1. 扩充当前代码文件中的对某一指令的代码文本，你需要参考示范代码，[**temple**](../../../tools/AI/temple.csv)，要求按照格式补充代码文本，并打印出来。
2. 如果需要多个前提，你需要对其进行组合，前提组合之间用"&"连接。
3. 如果没有注明，则默认生成10行代码文本。
# 代码文本的格式
1. 每一行的第1列cid为从某个数开始递增的正整数，如果其他条件中没有注明，则默认从1开始递增。
2. 每一行的第2列为固定值"chat"，代表聊天。
3. 每一行的第3列是固定值0。
4. 每一行的第4列为前提条件id，用于限定当前指令是在什么情况下发生的。基础前提为`work_is_library_manager&sys_4`。如果当前对话是在图书馆或者图书馆的办公室里发生的，则前提条件id应包含`&in_library_or_library_office`，其他情况下则不需要。
5. 每一行的第5列context为对该指令的描述文本。
# 描述文本
## 描述的基本内容
当前指令为聊天，{Name}主动向{TargetName}搭话，两人进行了一段五分钟左右的对话交流。
## 描述的背景
1. {TargetName}是博士，是{Name}所在公司的上司，会称呼{TargetName}为{TargetName}，或者博士。公司是一个叫做罗德岛的医疗企业，这个公司和设定背景自于一个叫做《明日方舟》的塔防手游。
2. {Name}是女性，是罗德岛的干员，如果前提条件中没有单独注明，则默认{Name}是少女。
3. {Name}和{TargetName}在同一个地点。
4. {Name}的工作职位是图书馆管理员，在图书馆里工作，负责图书的管理和借阅服务，以及为干员们提供阅读建议和帮助，自己在没有工作的时候也会阅读各种书籍。
5. 对话有一半是在{Name}的工作地点里发生，与该地点相关的描述可以适当出现，但不能过多。
6. 对话的另一半是在其他通用的地点里发生，不能特定发生在某个地点，不能提到当前具体的地点和家具。
## 描述文本的具体内容
1. {Name}看到{TargetName}之后，主动向{TargetName}搭话，{TargetName}回应了{Name}的搭话，两人进行了五分钟左右的对话交流。
2. 对话的内容与{Name}的工作有关，{Name}向{TargetName}分享自己在工作中的的知识点与技巧，作为对玩家的科普和知识分享。比如医生会分享某种疾病的预防和治疗方法，铁匠会分享某种武器或装备的锻造与保养技巧，厨师会分享某种菜肴的烹饪方法，花草种植员会分享某种香料花草的香味，按摩师会分享某种自我按摩和护理的方法等。
3. 仅叙述聊天这个过程本身，不能描述之前或之后要进行的行为。
4. 聊天内容不涉及研究发现，不涉及改进工作流程。
5. 聊天内容与时间无关，不能提到当前的具体时间或季节。
## 描述文本的要求
1. 描述文本的总字数在300个中文汉字到400个中文汉字。
2. 描述文本除了描述动作本身之外，可以描述表情、手、腰、腿等相关的辅助动作，但不能描述与行动没有直接关联的动作。
3. 描述文本的内容符合《明日方舟》的世界观设定。
4. 描述文本的每一行的内容不能重复，需要在内容上、格式上、用词上有较大差异。
5. 描述文本要尽可能的引起玩家和读者的兴趣。
6. 描述文本中不能随时用英文的标点符号，需要使用中文的标点符号，如中文双引号“”，中文单引号‘’等。
7. 描述文本不需要加到文件中，直接打印出来就可以。
