# 行为状态定义说明

本文档用于提示如何新增一个行为状态，包括在不同文件中需要添加的代码或数据。

## 一、行为状态定义

一个行为状态是一个类，包含以下属性和方法：

- **cn_name**：行为状态的中文名称，字符串类型，用于描述该状态的中文名称。
- **en_name**：行为状态的英文名称，字符串类型，用于描述该状态的英文名称。
- **id**：行为状态的唯一标识符，整数类型，用于区分不同的行为状态。
- **duration**：行为状态的持续时间，整数类型。一般为正整数，若为0则表示瞬间状态；若为-1，则表示需要另行赋值。
- **trigger**：行为状态的触发者，字符串类型。有效值为 "pl"、"npc" 或 "both"，分别表示由玩家、NPC 触发或两者均可触发。
- **tag**：行为状态的标签，字符串类型，用于描述该状态的标签。可以为单个标签或多个标签，多个标签之间用 "|" 分隔。
- **effect_id**：行为状态所触发的所有结算ID，字符串类型。可以为单个或多个结算ID，多个之间用 "|" 分隔。

## 二、相关文件说明

新增的行为状态需要写入以下文件：

1. **常量文件**：

   - **CharacterStatus.py**（路径：`..\..\Script\Core\constant\CharacterStatus.py`），链接为 [CharacterStatus.py](..\..\Script\Core\constant\CharacterStatus.py)

   - **在 `CharacterStatus` 类中**  
     找到已有数据中 id 小于新增行为状态 id 的最后一行，然后在其下新增一行，格式如下：
     ```
     "STATUS_"+<en_name大写> = <id>
     """ <cn_name> """
     ```

   - **Behavior.py**（路径：`..\..\Script\Core\constant\Behavior.py`），链接为 [Behavior.py](..\..\Script\Core\constant\Behavior.py)

   - **在 `Behavior` 类中**  
     找到已有数据中 id 小于新增行为状态 id 的最后一行，然后在其下新增一行，格式如下：
     ```
     <en_name大写> = <id>
     """ <cn_name> """
     ```

2. **CSV 文件**：

   - **Behavior_Data.csv**（路径：`..\..\data\csv\Behavior_Data.csv`），链接为 [Status.csv](..\..\data\csv\Behavior_Data.csv)  
     找到现有数据中 id 小于新增行为状态 id 的最后一行，然后在其下新增一行，格式如下：
     ```
     id,cn_name,duration,trigger,tag
     ```

   - **BehaviorEffect.csv**（路径：`..\..\data\csv\BehaviorEffect.csv`），链接为 [BehaviorEffect.csv](..\..\data\csv\Behavior_Effect.csv)  
     找到现有数据中 id 小于新增行为状态 id 的最后一行，然后在其下新增一行，格式如下：
     ```
     id,id,effect_id
     ```

## 三、使用范例

假设我们要新增一个行为状态，具体信息如下：

- **cn_name**：休息
- **en_name**：rest
- **id**：110
- **duration**：60
- **trigger**：both
- **tag**：日常
- **effect_id**：21|462|1751

### 1. 修改 `CharacterStatus.py`

在 `CharacterStatus` 类中新增：
```python
STATUS_REST = 110
""" 休息 """
```

### 2. 修改 `Behavior.py`

在 `Behavior` 类中新增：
```python
REST = 110
""" 休息 """
```

### 3. 修改 `Status.csv`

在 `Status.csv` 中新增：
```csv
110,休息,60,both,日常
```

### 4. 修改 `BehaviorEffect.csv`

在 `BehaviorEffect.csv` 中新增：
```csv
110,110,21|462|1751
```