# AI角色服装数据补充指南

## 任务说明
根据提供的角色立绘图片，识别并补充该角色在14个服装部位的服装名称。请严格按照本指南的格式和要求进行描述。

## 角色背景
这是一款叫做《明日方舟》(英文名为《Arknights》)的，由鹰角网络开发的一款策略向塔防手游。如果你知道这个游戏，请直接使用该游戏的背景，你要描写的角色都是该游戏里的同名角色。

## 服装部位分类
根据服装部位配置表，共有14个服装部位需要识别：

| 部位ID | 部位名称 | 部位描述 |
|--------|----------|----------|
| 0 | 帽子 | 戴在头部上的服装，包括各种帽子、头盔、头饰、头巾、发卡、发带等 |
| 1 | 眼镜 | 覆盖在眼睛位置的服装，包括各种眼镜、墨镜、眼罩、护目镜等 |
| 2 | 耳饰 | 在耳朵部位的服装，包括各种耳环、耳钉、耳坠、耳机、耳麦等 |
| 3 | 脖饰 | 在脖子部位的服装，包括项链、围巾、领带、颈环、项圈等 |
| 4 | 口饰 | 在嘴部位的服装，包括口罩、面纱等面部装饰物 |
| 5 | 上衣 | 上半身的所有服装，但并不包括胸衣，包括衬衫、T恤、外套、夹克、毛衣等 |
| 6 | 胸衣 | 贴身而专门用于遮挡胸部的服装，包括胸罩、背心、束胸等 |
| 7 | 手套 | 包括手套、护腕、戒指等手部装饰 |
| 8 | 下衣 | 下半身的服装，但并不包括内裤，包括裤子、短裤、裙子等 |
| 9 | 内裤 | 贴身而专门用于遮挡私处的服装，包括内裤、安全裤等 |
| 10 | 袜子 | 腿部的服装，包括长袜、短袜、丝袜、腿环等 |
| 11 | 鞋子 | 脚部的服装，包括靴子、拖鞋、高跟鞋等各种鞋类 |
| 12 | 武器 | 包括刀剑、枪械、法杖等武器装备 |
| 13 | 附属物 | 包括装饰品、挂饰等其他附属物品 |

## 服装描述规则

### 描述顺序
对于每件服装，必须按照以下顺序进行描述：
1. **颜色** - 服装的主要颜色和次要颜色
2. **材质** - 服装的材料质地（如棉质、丝绸、皮革、金属等）
3. **尺寸** - 服装的大小、长短、宽窄等尺寸特征
4. **花纹** - 服装上的图案、纹理、装饰等（如无则说明"无花纹"）
5. **款式** - 服装的设计风格、形状特征等
6. **名称** - 服装的类型，如夹克、裙子、手套、裤袜、运动鞋等

### 命名规则
- 每个服装的最终名称必须是一个**不少于4个字、不超过10个字**的短语
- 名称应该准确概括服装的主要特征
- 如果某个部位没有对应的服装，则标记为"**无**"
- 如果一个部位有多件服装，需要分别描述（如上衣可能同时有外套和多个内搭等）
- 如果某个上衣较长，延伸到了下半身，则在下衣中也重复记录该上衣的名称，如"连衣裙"等
- 每个角色必须要有的服装部位是：上衣、下衣、鞋子，其他部位可以根据实际情况选择性描述

### 示例格式
```
部位ID-序号: 服装名称
详细描述：颜色 + 材质 + 尺寸 + 花纹 + 款式
```

## 参考示例（阿米娅）

基于提供的阿米娅立绘图片和数据文件，以下是标准的描述示例：

### 0号部位-帽子
**无**

### 1号部位-眼镜
**无**

### 2号部位-耳饰
**无**

### 3号部位-脖饰
**3: 渐变蕾丝纱巾**
详细描述：青蓝色渐变 + 轻薄蕾丝材质 + 中等长度 + 蕾丝花纹 + 飘逸围巾款式

### 4号部位-口饰
**无**

### 5号部位-上衣
**5-1: 罗德岛制服夹克**
详细描述：深蓝色主体配橙色装饰 + 厚实面料材质 + 标准合身尺寸 + 罗德岛标志图案 + 制服外套款式

**5-2: 白色羊绒衫**
详细描述：纯白色 + 柔软羊绒材质 + 贴身修身尺寸 + 无花纹 + 基础内搭款式

### 6号部位-胸衣
**无**（通常不可见或被外衣遮挡）

### 7号部位-手套
**7: 抑制戒指**
详细描述：银色金属 + 金属材质 + 细窄尺寸 + 简约几何花纹 + 功能性戒指款式

### 8号部位-下衣
**8: 苏格兰风短格子裙**
详细描述：深蓝色为主的格子图案 + 厚实布料材质 + 短裙长度 + 经典格子花纹 + 苏格兰风格款式

### 9号部位-内裤
**无**（被外衣遮挡，不可见）

### 10号部位-袜子
**10: 黑色连裤袜**
详细描述：纯黑色 + 弹性纤维材质 + 连体长筒尺寸 + 无花纹 + 经典连裤袜款式

### 11号部位-鞋子
**11: 深蓝色小皮鞋**
详细描述：深蓝色 + 光滑皮革材质 + 小码精致尺寸 + 无花纹 + 学院风小皮鞋款式

### 12号部位-武器
**无**（此立绘中未携带武器）

### 13号部位-附属物
**无**

## 操作流程

1. **仔细观察图片** - 从头到脚系统性地观察角色的每个部位
2. **识别服装类型** - 根据部位分类表确定每件服装属于哪个部位
3. **详细分析** - 按照颜色、材质、尺寸、花纹、款式的顺序分析每件服装
4. **命名总结** - 将分析结果总结为4-10字的服装名称
5. **生成详细描述** - 按照详细描述格式输出所有14个部位的服装信息
6. **生成CSV数据** - 将有服装的部位转换为CSV格式，可直接添加到角色数据文件

## 重要提醒

**最终输出必须包含两部分：**
1. **详细描述** - 用于AI理解和参考的完整分析
2. **CSV数据** - 可直接复制粘贴到角色数据文件的格式化数据

CSV数据格式必须严格遵循：`C|部位ID,str,服装名称,1,服装名称` 或 `C|部位ID-序号,str,服装名称,1,服装名称`

## 注意事项

1. **完整性** - 必须对所有14个部位进行分析，即使某些部位没有服装也要标记为"无"
2. **准确性** - 服装名称要准确反映图片中的实际服装特征
3. **一致性** - 同类型角色的相似服装应使用相似的命名规则
4. **层次性** - 如果同一部位有多层服装（如内衣外衣），需要分别标注
5. **可见性** - 如果某个部位的服装被遮挡无法确认，可标记为"无"并说明原因
6. **数据格式** - CSV数据必须严格按照格式要求，确保可以直接添加到角色数据文件
7. **编号规则** - 同一部位有多件服装时，使用"-序号"进行区分（如C|5-1, C|5-2）

## 数据输出格式

### CSV数据格式（用于补充到角色数据文件）
生成的服装数据必须按照以下CSV格式，以便直接添加到角色的数据文件中：

```csv
C|部位ID,str,服装名称,1,服装名称
C|部位ID-序号,str,服装名称,1,服装名称
```

**格式说明：**
- `C|部位ID` 或 `C|部位ID-序号`：服装数据的键名
- `str`：数据类型固定为字符串
- `服装名称`：4-10个字的服装名称（重复两次，分别对应value和info字段）
- `1`：get_text字段固定为1

**示例（基于阿米娅）：**
```csv
C|3,str,渐变蕾丝纱巾,1,渐变蕾丝纱巾
C|5-1,str,罗德岛制服夹克,1,罗德岛制服夹克
C|5-2,str,白色羊绒衫,1,白色羊绒衫
C|7,str,抑制戒指 必带,1,抑制戒指
C|8,str,苏格兰风短格子裙,1,苏格兰风短格子裙
C|10,str,黑色连裤袜,1,黑色连裤袜
C|11,str,深蓝色小皮鞋,1,深蓝色小皮鞋
```

### 详细描述格式模板

```
# 角色名称 - 服装数据补充

## 服装清单

### 0号部位-帽子
[服装名称或"无"]
[详细描述]

### 1号部位-眼镜
[服装名称或"无"]
[详细描述]

### 2号部位-耳饰
[服装名称或"无"]
[详细描述]

### 3号部位-脖饰
[服装名称或"无"]
[详细描述]

### 4号部位-口饰
[服装名称或"无"]
[详细描述]

### 5号部位-上衣
[服装名称或"无"]
[详细描述]

### 6号部位-胸衣
[服装名称或"无"]
[详细描述]

### 7号部位-手套
[服装名称或"无"]
[详细描述]

### 8号部位-下衣
[服装名称或"无"]
[详细描述]

### 9号部位-内裤
[服装名称或"无"]
[详细描述]

### 10号部位-袜子
[服装名称或"无"]
[详细描述]

### 11号部位-鞋子
[服装名称或"无"]
[详细描述]

### 12号部位-武器
[服装名称或"无"]
[详细描述]

### 13号部位-附属物
[服装名称或"无"]
[详细描述]

## 生成的CSV数据
[按照上述CSV格式列出所有有服装的部位数据]
```

---

## 完整示例：阿米娅服装数据

### 详细描述部分

#### 0号部位-帽子
**无**

#### 1号部位-眼镜
**无**

#### 2号部位-耳饰
**无**

#### 3号部位-脖饰
**渐变蕾丝纱巾**
详细描述：青蓝色渐变 + 轻薄蕾丝材质 + 中等长度 + 蕾丝花纹 + 飘逸围巾款式

#### 4号部位-口饰
**无**

#### 5号部位-上衣
**罗德岛制服夹克**
详细描述：深蓝色主体配橙色装饰 + 厚实面料材质 + 标准合身尺寸 + 罗德岛标志图案 + 制服外套款式

**白色羊绒衫**
详细描述：纯白色 + 柔软羊绒材质 + 贴身修身尺寸 + 无花纹 + 基础内搭款式

#### 6号部位-胸衣
**无**（通常不可见或被外衣遮挡）

#### 7号部位-手套
**抑制戒指 必带**
详细描述：银色金属 + 金属材质 + 细窄尺寸 + 简约几何花纹 + 功能性戒指款式

#### 8号部位-下衣
**苏格兰风短格子裙**
详细描述：深蓝色为主的格子图案 + 厚实布料材质 + 短裙长度 + 经典格子花纹 + 苏格兰风格款式

#### 9号部位-内裤
**无**（被外衣遮挡，不可见）

#### 10号部位-袜子
**黑色连裤袜**
详细描述：纯黑色 + 弹性纤维材质 + 连体长筒尺寸 + 无花纹 + 经典连裤袜款式

#### 11号部位-鞋子
**深蓝色小皮鞋**
详细描述：深蓝色 + 光滑皮革材质 + 小码精致尺寸 + 无花纹 + 学院风小皮鞋款式

#### 12号部位-武器
**无**（此立绘中未携带武器）

#### 13号部位-附属物
**无**

### 生成的CSV数据（可直接添加到角色数据文件）

```csv
C|3,str,渐变蕾丝纱巾,1,渐变蕾丝纱巾
C|5-1,str,罗德岛制服夹克,1,罗德岛制服夹克
C|5-2,str,白色羊绒衫,1,白色羊绒衫
C|7,str,抑制戒指 必带,1,抑制戒指
C|8,str,苏格兰风短格子裙,1,苏格兰风短格子裙
C|10,str,黑色连裤袜,1,黑色连裤袜
C|11,str,深蓝色小皮鞋,1,深蓝色小皮鞋
```

**使用说明：**
1. 复制上述CSV数据
2. 粘贴到对应角色的CSV数据文件中
3. 确保格式与现有数据保持一致

---

请严格按照此指南进行角色服装数据的补充工作，确保数据的准确性和一致性。
