#Requires -RunAsAdministrator
[Console]::OutputEncoding = [System.Text.Encoding]::UTF8
$ErrorActionPreference = "Stop"
$errorOccurred = $false  # ʼ

# ɫ
function Write-Color {
    param(
        [string]$Text,
        [ConsoleColor]$Color = [ConsoleColor]::White,
        [switch]$Bold
    )
    $originalColor = $Host.UI.RawUI.ForegroundColor
    Write-Host $Text -ForegroundColor $Color
    $Host.UI.RawUI.ForegroundColor = $originalColor
}

# PowerShellִв
Write-Color -Text "`n========== PowerShellִв ==========" -Color Cyan
try {
    Set-ExecutionPolicy RemoteSigned -Scope CurrentUser -Force
    Write-Color -Text "ִвóɹCurrentUserRemoteSigned" -Color Green
}
catch {
    Write-Color -Text "ִвʧܣ$($_.Exception.Message), ִֶСSet-ExecutionPolicy RemoteSigned -Scope CurrentUser -Force" -Color Red
    Write-Color -Text "ʾϵͳֹ޸ִвԣֶͨԡ Get-Help Set-ExecutionPolicy 鿴" -Color Yellow
}

# ϵͳܹ
Write-Color -Text "`n========== ϵͳܹ ==========" -Color Cyan
$osArch = (Get-CimInstance -ClassName Win32_OperatingSystem).OSArchitecture
$arch = if ($osArch -eq "ARM64") { "arm64" } else { "x64" }
Write-Color -Text "⵽ϵͳܹ$arch" -Color Green

# ֶزװMicrosoft Visual C++ Redistributable
function Install-VCRedist {
    param(
        [string]$Arch
    )
    Write-Color -Text "`n========== װVC++ Redistributable ==========" -Color Cyan
    # ٷ
    $vcUrl = if ($Arch -eq "arm64") { 
        "https://aka.ms/vs/18/release/vc_redist.arm64.exe" 
    } else { 
        "https://aka.ms/vs/18/release/vc_redist.x64.exe" 
    }
    # ʱļ·
    $vcTemp = Join-Path -Path $env:TEMP -ChildPath "vc_redist_$Arch.exe"

    try {
        # ذװ
        Write-Color -Text "VC++ Redistributable ($Arch)..." -Color Yellow
        # ûSSL/
        Invoke-WebRequest -Uri $vcUrl -OutFile $vcTemp -UseBasicParsing -TimeoutSec 300
        Write-Color -Text "VC++װɣ·$vcTemp" -Color Green

        # Ĭװ/repair޸ģʽ /passiveװ /norestart
        Write-Color -Text "ʼĬװVC++ Redistributable..." -Color Yellow
        $installProcess = Start-Process -FilePath $vcTemp -ArgumentList "/repair /passive /norestart" -Wait -NoNewWindow -PassThru
        if ($installProcess.ExitCode -eq 0 -or $installProcess.ExitCode -eq 3010) {
            Write-Color -Text "VC++ Redistributableװɣ˳룺$($installProcess.ExitCode)3010ʾ" -Color Green
        } else {
            throw "VC++װʧܣ˳룺$($installProcess.ExitCode)"
        }

        # ʱļ
        Remove-Item -Path $vcTemp -Force -ErrorAction SilentlyContinue
    }
    catch {
        Write-Color -Text "VC++ Redistributableװʧܣ$($_.Exception.Message)" -Color Red
        $global:errorOccurred = $true
    }
}

# ֶزװ.NET Desktop Runtime 10
function Install-DotNetRuntime {
    param(
        [string]$Arch
    )
    Write-Color -Text "`n========== װ.NET Desktop Runtime 10 ==========" -Color Cyan
    # ٷ
    $dotnetUrl = if ($Arch -eq "arm64") { 
        "https://aka.ms/dotnet/10.0/windowsdesktop-runtime-win-arm64.exe" 
    } else { 
        "https://aka.ms/dotnet/10.0/windowsdesktop-runtime-win-x64.exe" 
    }
    # ʱļ·
    $dotnetTemp = Join-Path -Path $env:TEMP -ChildPath "dotnet_runtime_10_$Arch.exe"

    try {
        # ذװ
        Write-Color -Text ".NET Desktop Runtime 10 ($Arch)..." -Color Yellow
        Invoke-WebRequest -Uri $dotnetUrl -OutFile $dotnetTemp -UseBasicParsing -TimeoutSec 300
        Write-Color -Text ".NETװɣ·$dotnetTemp" -Color Green

        # Ĭװ
        Write-Color -Text "ʼĬװ.NET Desktop Runtime 10..." -Color Yellow
        $installProcess = Start-Process -FilePath $dotnetTemp -ArgumentList "/repair /passive /norestart" -Wait -NoNewWindow -PassThru
        if ($installProcess.ExitCode -eq 0 -or $installProcess.ExitCode -eq 3010) {
            Write-Color -Text ".NET Desktop Runtime 10װɣ˳룺$($installProcess.ExitCode)3010ʾ" -Color Green
        } else {
            throw ".NETװʧܣ˳룺$($installProcess.ExitCode)"
        }

        # ʱļ
        Remove-Item -Path $dotnetTemp -Force -ErrorAction SilentlyContinue
    }
    catch {
        Write-Color -Text ".NET Desktop Runtime 10װʧܣ$($_.Exception.Message)" -Color Red
        $global:errorOccurred = $true
    }
}

# ִаװ
Install-VCRedist -Arch $arch
Install-DotNetRuntime -Arch $arch

# װֶ
Write-Color -Text "`n========== װ ==========" -Color Cyan
if (-not $errorOccurred) {
    Write-Color -Text "п޸ɣԺٴγMFA" -Color Green
    Write-Color -Text "The runtime library repair is complete. Please restart your computer and try running MAA again." -Color Green
}
else {
    Write-Color -Text "װгִֶװ" -Color Red
    # VC++ Redistֶ
    $vcUrl = if ($arch -eq "arm64") { "https://aka.ms/vs/18/release/vc_redist.arm64.exe" } else { "https://aka.ms/vs/18/release/vc_redist.x64.exe" }
    Write-Color -Text "`nMicrosoft Visual C++ Redistributable ($arch)" -Color White
    Write-Color -Text $vcUrl -Color Cyan
    # .NET 10пֶ
    $dotnetUrl = if ($arch -eq "arm64") { "https://aka.ms/dotnet/10.0/windowsdesktop-runtime-win-arm64.exe" } else { "https://aka.ms/dotnet/10.0/windowsdesktop-runtime-win-x64.exe" }
    Write-Color -Text "`n.NET Desktop Runtime 10 ($arch)" -Color White
    Write-Color -Text $dotnetUrl -Color Cyan
}

# ȴû˳
Write-Color -Text "`n˳..." -Color Yellow
$null = $Host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")