/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.collection.IntCollections;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.EmptyPriorityQueue;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    static final int INITIAL_CHILDREN_MAP_SIZE = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.http2.childrenMapSize", (int)2));
    private static final int DEFAULT_MAX_STATE_ONLY_SIZE = 5;
    private final Http2Connection.PropertyKey stateKey;
    private final IntObjectMap<State> stateOnlyMap;
    private final PriorityQueue<State> stateOnlyRemovalQueue;
    private final Http2Connection connection;
    private final State connectionState;
    private int allocationQuantum = 1024;
    private final int maxStateOnlySize;

    /*
     * WARNING - void declaration
     */
    public WeightedFairQueueByteDistributor(Http2Connection connection) {
        this((Http2Connection)var1_1, 5);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WeightedFairQueueByteDistributor(Http2Connection connection, int maxStateOnlySize) {
        void var1_1;
        void var2_3;
        ObjectUtil.checkPositiveOrZero((int)maxStateOnlySize, (String)"maxStateOnlySize");
        if (maxStateOnlySize == 0) {
            this.stateOnlyMap = IntCollections.emptyMap();
            this.stateOnlyRemovalQueue = EmptyPriorityQueue.instance();
        } else {
            this.stateOnlyMap = new IntObjectHashMap(maxStateOnlySize);
            this.stateOnlyRemovalQueue = new DefaultPriorityQueue((Comparator)StateOnlyComparator.INSTANCE, maxStateOnlySize + 2);
        }
        this.maxStateOnlySize = maxStateOnlySize;
        this.connection = connection;
        this.stateKey = connection.newKey();
        Http2Stream connectionStream = connection.connectionStream();
        this.connectionState = new State((Http2Stream)var2_3, 16);
        connectionStream.setProperty(this.stateKey, this.connectionState);
        var1_1.addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ WeightedFairQueueByteDistributor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamAdded(Http2Stream stream) {
                void var2_2;
                void var1_1;
                State state = (State)this.this$0.stateOnlyMap.remove(stream.id());
                if (state == null) {
                    void var3_3;
                    state = this.this$0.new State(stream);
                    ArrayList<ParentChangedEvent> events = new ArrayList<ParentChangedEvent>(1);
                    this.this$0.connectionState.takeChild(state, false, events);
                    this.this$0.notifyParentChanged((List<ParentChangedEvent>)var3_3);
                } else {
                    this.this$0.stateOnlyRemovalQueue.removeTyped((Object)state);
                    state.stream = stream;
                }
                switch (stream.state()) {
                    case RESERVED_REMOTE: 
                    case RESERVED_LOCAL: {
                        state.setStreamReservedOrActivated();
                    }
                }
                var1_1.setProperty(this.this$0.stateKey, var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamActive(Http2Stream stream) {
                void var1_1;
                WeightedFairQueueByteDistributor.access$400(this.this$0, (Http2Stream)var1_1).setStreamReservedOrActivated();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamClosed(Http2Stream stream) {
                void var1_1;
                WeightedFairQueueByteDistributor.access$400(this.this$0, (Http2Stream)var1_1).close();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamRemoved(Http2Stream stream) {
                void var1_1;
                State state = WeightedFairQueueByteDistributor.access$400(this.this$0, stream);
                WeightedFairQueueByteDistributor.access$400(this.this$0, stream).stream = null;
                if (this.this$0.maxStateOnlySize == 0) {
                    state.parent.removeChild(state);
                    return;
                }
                if (this.this$0.stateOnlyRemovalQueue.size() == this.this$0.maxStateOnlySize) {
                    void var2_2;
                    State stateToRemove = (State)this.this$0.stateOnlyRemovalQueue.peek();
                    if (StateOnlyComparator.INSTANCE.compare(stateToRemove, state) >= 0) {
                        state.parent.removeChild(state);
                        return;
                    }
                    this.this$0.stateOnlyRemovalQueue.poll();
                    stateToRemove.parent.removeChild(stateToRemove);
                    this.this$0.stateOnlyMap.remove(var2_2.streamId);
                }
                this.this$0.stateOnlyRemovalQueue.add((Object)state);
                this.this$0.stateOnlyMap.put(state.streamId, (Object)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void updateStreamableBytes(StreamByteDistributor.StreamState state) {
        void var1_1;
        this.state(state.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(state), state.hasFrame() && var1_1.windowSize() >= 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void updateDependencyTree(int childStreamId, int parentStreamId, short weight, boolean exclusive) {
        void var3_7;
        State newParent;
        State state = this.state(childStreamId);
        if (state == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            state = new State(childStreamId);
            this.stateOnlyRemovalQueue.add((Object)state);
            this.stateOnlyMap.put(childStreamId, (Object)state);
        }
        if ((newParent = this.state(parentStreamId)) == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            newParent = new State(parentStreamId);
            this.stateOnlyRemovalQueue.add((Object)newParent);
            this.stateOnlyMap.put(parentStreamId, (Object)newParent);
            ArrayList<ParentChangedEvent> events = new ArrayList<ParentChangedEvent>(1);
            this.connectionState.takeChild(newParent, false, events);
            this.notifyParentChanged(events);
        }
        if (state.activeCountForTree != 0 && state.parent != null) {
            state.parent.totalQueuedWeights += (long)(weight - state.weight);
        }
        state.weight = var3_7;
        if (newParent != state.parent || exclusive && newParent.children.size() != 1) {
            void var1_2;
            ArrayList<ParentChangedEvent> events;
            if (newParent.isDescendantOf(state)) {
                events = new ArrayList<ParentChangedEvent>(2 + (exclusive ? newParent.children.size() : 0));
                state.parent.takeChild(newParent, false, events);
            } else {
                events = new ArrayList(1 + (exclusive ? newParent.children.size() : 0));
            }
            var1_2.takeChild(state, exclusive, events);
            this.notifyParentChanged(events);
        }
        while (this.stateOnlyRemovalQueue.size() > this.maxStateOnlySize) {
            void var2_6;
            State stateToRemove = (State)this.stateOnlyRemovalQueue.poll();
            stateToRemove.parent.removeChild(stateToRemove);
            this.stateOnlyMap.remove(var2_6.streamId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean distribute(int maxBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
        void var3_3;
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            int oldIsActiveCountForTree = this.connectionState.activeCountForTree;
            maxBytes -= this.distributeToChildren(maxBytes, writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (maxBytes > 0 || var3_3 != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void allocationQuantum(int allocationQuantum) {
        void var1_1;
        ObjectUtil.checkPositive((int)allocationQuantum, (String)"allocationQuantum");
        this.allocationQuantum = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int distribute(int maxBytes, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (state.isActive()) {
            int nsent = Math.min(maxBytes, state.streamableBytes);
            state.write(nsent, writer);
            if (nsent == 0 && maxBytes != 0) {
                State state2 = state;
                state2.updateStreamableBytes(state2.streamableBytes, false);
            }
            return nsent;
        }
        return this.distributeToChildren((int)var1_1, (StreamByteDistributor.Writer)var2_2, (State)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private int distributeToChildren(int maxBytes, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        long oldTotalQueuedWeights = state.totalQueuedWeights;
        State childState = state.pollPseudoTimeQueue();
        State nextChildState = state.peekPseudoTimeQueue();
        childState.setDistributing();
        try {
            void var1_1;
            void var2_3;
            assert (nextChildState == null || nextChildState.pseudoTimeToWrite >= childState.pseudoTimeToWrite) : "nextChildState[" + nextChildState.streamId + "].pseudoTime(" + nextChildState.pseudoTimeToWrite + ") <  childState[" + childState.streamId + "].pseudoTime(" + childState.pseudoTimeToWrite + ')';
            int nsent = this.distribute(nextChildState == null ? maxBytes : Math.min(maxBytes, (int)Math.min((nextChildState.pseudoTimeToWrite - childState.pseudoTimeToWrite) * (long)childState.weight / oldTotalQueuedWeights + (long)this.allocationQuantum, Integer.MAX_VALUE)), (StreamByteDistributor.Writer)var2_3, childState);
            state.pseudoTime += (long)nsent;
            childState.updatePseudoTime(state, nsent, oldTotalQueuedWeights);
            childState.unsetDistributing();
            if (childState.activeCountForTree != 0) {
                state.offerPseudoTimeQueue(childState);
            }
            return (int)var1_1;
        }
        catch (Throwable throwable) {
            childState.unsetDistributing();
            if (childState.activeCountForTree != 0) {
                void var3_4;
                var3_4.offerPseudoTimeQueue(childState);
            }
            throw throwable;
        }
    }

    private State state(Http2Stream stream) {
        return (State)stream.getProperty(this.stateKey);
    }

    /*
     * WARNING - void declaration
     */
    private State state(int streamId) {
        void var1_1;
        Http2Stream stream = this.connection.stream(streamId);
        if (stream != null) {
            void var2_2;
            return this.state((Http2Stream)var2_2);
        }
        return (State)this.stateOnlyMap.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean isChild(int childId, int parentId, short weight) {
        State parent = this.state(parentId);
        if (parent.children.containsKey(childId)) {
            void var3_5;
            void var1_2;
            void var2_4;
            State child = this.state(childId);
            if (child.parent == var2_4 && var1_2.weight == var3_5) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final int numChildren(int streamId) {
        void var1_2;
        State state = this.state(streamId);
        if (state == null) {
            return 0;
        }
        return var1_2.children.size();
    }

    /*
     * WARNING - void declaration
     */
    final void notifyParentChanged(List<ParentChangedEvent> events) {
        for (int i = 0; i < events.size(); ++i) {
            void var3_3;
            ParentChangedEvent event = events.get(i);
            this.stateOnlyRemovalQueue.priorityChanged((Object)event.state);
            if (event.state.parent == null || event.state.activeCountForTree == 0) continue;
            event.state.parent.offerAndInitializePseudoTime(event.state);
            event.state.parent.activeCountChangeForTree(var3_3.state.activeCountForTree);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$400(WeightedFairQueueByteDistributor x0, Http2Stream x1) {
        void var1_1;
        return x0.state((Http2Stream)var1_1);
    }

    private static final class ParentChangedEvent {
        final State state;
        final State oldParent;

        /*
         * WARNING - void declaration
         */
        ParentChangedEvent(State state, State oldParent) {
            void var2_2;
            void var1_1;
            this.state = var1_1;
            this.oldParent = var2_2;
        }
    }

    private final class State
    implements PriorityQueueNode {
        private static final byte STATE_IS_ACTIVE = 1;
        private static final byte STATE_IS_DISTRIBUTING = 2;
        private static final byte STATE_STREAM_ACTIVATED = 4;
        Http2Stream stream;
        State parent;
        IntObjectMap<State> children = IntCollections.emptyMap();
        private final PriorityQueue<State> pseudoTimeQueue;
        final int streamId;
        int streamableBytes;
        int dependencyTreeDepth;
        int activeCountForTree;
        private int pseudoTimeQueueIndex = -1;
        private int stateOnlyQueueIndex = -1;
        long pseudoTimeToWrite;
        long pseudoTime;
        long totalQueuedWeights;
        private byte flags;
        short weight = (short)16;

        /*
         * WARNING - void declaration
         */
        State(int streamId) {
            this((int)var2_2, null, 0);
            void var2_2;
        }

        /*
         * WARNING - void declaration
         */
        State(Http2Stream stream) {
            this((Http2Stream)var2_2, 0);
            void var2_2;
        }

        /*
         * WARNING - void declaration
         */
        State(Http2Stream stream, int initialSize) {
            this(stream.id(), (Http2Stream)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
        }

        /*
         * WARNING - void declaration
         */
        State(int streamId, Http2Stream stream, int initialSize) {
            void var2_2;
            void var3_3;
            this.stream = var3_3;
            this.streamId = var2_2;
            this.pseudoTimeQueue = new DefaultPriorityQueue((Comparator)StatePseudoTimeComparator.INSTANCE, initialSize);
        }

        final boolean isDescendantOf(State state) {
            State next = this.parent;
            while (next != null) {
                if (next == state) {
                    return true;
                }
                next = next.parent;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final void takeChild(State child, boolean exclusive, List<ParentChangedEvent> events) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.takeChild(null, (State)var1_1, (boolean)var2_2, (List<ParentChangedEvent>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        final void takeChild(Iterator<IntObjectMap.PrimitiveEntry<State>> childItr, State child, boolean exclusive, List<ParentChangedEvent> events) {
            void var3_3;
            State oldParent = child.parent;
            if (oldParent != this) {
                events.add(new ParentChangedEvent(child, oldParent));
                child.setParent(this);
                if (childItr != null) {
                    childItr.remove();
                } else if (oldParent != null) {
                    oldParent.children.remove(child.streamId);
                }
                this.initChildrenIfEmpty();
                State oldChild = (State)this.children.put(child.streamId, (Object)child);
                assert (oldChild == null) : "A stream with the same stream ID was already in the child map.";
            }
            if (var3_3 != false && !this.children.isEmpty()) {
                Iterator<IntObjectMap.PrimitiveEntry<State>> itr = this.removeAllChildrenExcept(child).entries().iterator();
                while (itr.hasNext()) {
                    Iterator<IntObjectMap.PrimitiveEntry<State>> iterator = itr;
                    child.takeChild(iterator, (State)((IntObjectMap.PrimitiveEntry)iterator.next()).value(), false, events);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        final void removeChild(State child) {
            if (this.children.remove(child.streamId) != null) {
                void var2_2;
                ArrayList<ParentChangedEvent> events = new ArrayList<ParentChangedEvent>(1 + child.children.size());
                State state = child;
                events.add(new ParentChangedEvent(state, state.parent));
                child.setParent(null);
                if (!child.children.isEmpty()) {
                    Iterator<IntObjectMap.PrimitiveEntry<State>> itr = child.children.entries().iterator();
                    long totalWeight = child.getTotalWeight();
                    do {
                        State dependency = (State)((IntObjectMap.PrimitiveEntry)itr.next()).value();
                        ((State)((IntObjectMap.PrimitiveEntry)itr.next()).value()).weight = (short)Math.max(1L, (long)(dependency.weight * child.weight) / totalWeight);
                        this.takeChild(itr, dependency, false, events);
                    } while (itr.hasNext());
                }
                WeightedFairQueueByteDistributor.this.notifyParentChanged((List<ParentChangedEvent>)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private long getTotalWeight() {
            void var1_1;
            long totalWeight = 0L;
            for (State state : this.children.values()) {
                totalWeight += (long)state.weight;
            }
            return (long)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private IntObjectMap<State> removeAllChildrenExcept(State stateToRetain) {
            void var2_2;
            stateToRetain = (State)this.children.remove(stateToRetain.streamId);
            IntObjectMap<State> prevChildren = this.children;
            this.initChildren();
            if (stateToRetain != null) {
                void var1_1;
                this.children.put(stateToRetain.streamId, (Object)var1_1);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void setParent(State newParent) {
            void var1_1;
            if (this.activeCountForTree != 0 && this.parent != null) {
                this.parent.removePseudoTimeQueue(this);
                this.parent.activeCountChangeForTree(-this.activeCountForTree);
            }
            this.parent = newParent;
            this.dependencyTreeDepth = newParent == null ? Integer.MAX_VALUE : var1_1.dependencyTreeDepth + 1;
        }

        private void initChildrenIfEmpty() {
            if (this.children == IntCollections.emptyMap()) {
                this.initChildren();
            }
        }

        private void initChildren() {
            this.children = new IntObjectHashMap(INITIAL_CHILDREN_MAP_SIZE);
        }

        /*
         * WARNING - void declaration
         */
        final void write(int numBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
            assert (this.stream != null);
            try {
                void var2_3;
                var2_3.write(this.stream, numBytes);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, (Throwable)var1_2, "byte distribution write error", new Object[0]);
            }
        }

        final void activeCountChangeForTree(int increment) {
            while (true) {
                assert (this_.activeCountForTree + increment >= 0);
                this_.activeCountForTree += increment;
                if (this_.parent == null) break;
                assert (this_.activeCountForTree != increment || this_.pseudoTimeQueueIndex == -1 || this_.parent.pseudoTimeQueue.containsTyped((Object)this_)) : "State[" + this_.streamId + "].activeCountForTree changed from 0 to " + increment + " is in a pseudoTimeQueue, but not in parent[ " + this_.parent.streamId + "]'s pseudoTimeQueue";
                if (this_.activeCountForTree == 0) {
                    this_.parent.removePseudoTimeQueue(this_);
                } else if (this_.activeCountForTree == increment && !this_.isDistributing()) {
                    this_.parent.offerAndInitializePseudoTime(this_);
                }
                State this_ = this_.parent;
            }
        }

        /*
         * WARNING - void declaration
         */
        final void updateStreamableBytes(int newStreamableBytes, boolean isActive) {
            void var1_1;
            if (this.isActive() != isActive) {
                void var2_2;
                if (var2_2 != false) {
                    this.activeCountChangeForTree(1);
                    this.setActive();
                } else {
                    this.activeCountChangeForTree(-1);
                    this.unsetActive();
                }
            }
            this.streamableBytes = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void updatePseudoTime(State parentState, int nsent, long totalQueuedWeights) {
            void var3_3;
            void var2_2;
            void var1_1;
            assert (this.streamId != 0 && nsent >= 0);
            this.pseudoTimeToWrite = Math.min(this.pseudoTimeToWrite, var1_1.pseudoTime) + (long)var2_2 * var3_3 / (long)this.weight;
        }

        /*
         * WARNING - void declaration
         */
        final void offerAndInitializePseudoTime(State state) {
            void var1_1;
            state.pseudoTimeToWrite = this.pseudoTime;
            this.offerPseudoTimeQueue((State)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void offerPseudoTimeQueue(State state) {
            void var1_1;
            this.pseudoTimeQueue.offer((Object)state);
            this.totalQueuedWeights += (long)var1_1.weight;
        }

        /*
         * WARNING - void declaration
         */
        final State pollPseudoTimeQueue() {
            void var1_1;
            State state = (State)this.pseudoTimeQueue.poll();
            this.totalQueuedWeights -= (long)state.weight;
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void removePseudoTimeQueue(State state) {
            if (this.pseudoTimeQueue.removeTyped((Object)state)) {
                void var1_1;
                this.totalQueuedWeights -= (long)var1_1.weight;
            }
        }

        final State peekPseudoTimeQueue() {
            return (State)this.pseudoTimeQueue.peek();
        }

        final void close() {
            this.updateStreamableBytes(0, false);
            this.stream = null;
        }

        final boolean wasStreamReservedOrActivated() {
            return (this.flags & 4) != 0;
        }

        final void setStreamReservedOrActivated() {
            this.flags = (byte)(this.flags | 4);
        }

        final boolean isActive() {
            return (this.flags & 1) != 0;
        }

        private void setActive() {
            this.flags = (byte)(this.flags | 1);
        }

        private void unsetActive() {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }

        final boolean isDistributing() {
            return (this.flags & 2) != 0;
        }

        final void setDistributing() {
            this.flags = (byte)(this.flags | 2);
        }

        final void unsetDistributing() {
            this.flags = (byte)(this.flags & 0xFFFFFFFD);
        }

        public final int priorityQueueIndex(DefaultPriorityQueue<?> queue) {
            if (queue == WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue) {
                return this.stateOnlyQueueIndex;
            }
            return this.pseudoTimeQueueIndex;
        }

        /*
         * WARNING - void declaration
         */
        public final void priorityQueueIndex(DefaultPriorityQueue<?> queue, int i) {
            void var2_2;
            if (queue == WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue) {
                this.stateOnlyQueueIndex = i;
                return;
            }
            this.pseudoTimeQueueIndex = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder(256 * (this.activeCountForTree > 0 ? this.activeCountForTree : 1));
            this.toString(sb);
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        private void toString(StringBuilder sb) {
            void var1_1;
            sb.append("{streamId ").append(this.streamId).append(" streamableBytes ").append(this.streamableBytes).append(" activeCountForTree ").append(this.activeCountForTree).append(" pseudoTimeQueueIndex ").append(this.pseudoTimeQueueIndex).append(" pseudoTimeToWrite ").append(this.pseudoTimeToWrite).append(" pseudoTime ").append(this.pseudoTime).append(" flags ").append(this.flags).append(" pseudoTimeQueue.size() ").append(this.pseudoTimeQueue.size()).append(" stateOnlyQueueIndex ").append(this.stateOnlyQueueIndex).append(" parent.streamId ").append(this.parent == null ? -1 : this.parent.streamId).append("} [");
            if (!this.pseudoTimeQueue.isEmpty()) {
                for (State state : this.pseudoTimeQueue) {
                    state.toString(sb);
                    sb.append(", ");
                }
                StringBuilder stringBuilder = sb;
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            var1_1.append(']');
        }
    }

    private static final class StatePseudoTimeComparator
    implements Serializable,
    Comparator<State> {
        private static final long serialVersionUID = -1437548640227161828L;
        static final StatePseudoTimeComparator INSTANCE = new StatePseudoTimeComparator();

        private StatePseudoTimeComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(State o1, State o2) {
            void var2_2;
            return MathUtil.compare((long)o1.pseudoTimeToWrite, (long)var2_2.pseudoTimeToWrite);
        }
    }

    private static final class StateOnlyComparator
    implements Serializable,
    Comparator<State> {
        private static final long serialVersionUID = -4806936913002105966L;
        static final StateOnlyComparator INSTANCE = new StateOnlyComparator();

        private StateOnlyComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(State o1, State o2) {
            void var2_2;
            void var1_1;
            boolean o1Actived = o1.wasStreamReservedOrActivated();
            if (o1Actived != o2.wasStreamReservedOrActivated()) {
                if (o1Actived) {
                    return -1;
                }
                return 1;
            }
            int x = o2.dependencyTreeDepth - o1.dependencyTreeDepth;
            if (x != 0) {
                void var3_3;
                return (int)var3_3;
            }
            return var1_1.streamId - var2_2.streamId;
        }
    }
}

