/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Deque;

public final class UniformStreamByteDistributor
implements StreamByteDistributor {
    private final Http2Connection.PropertyKey stateKey;
    private final Deque<State> queue = new ArrayDeque<State>(4);
    private int minAllocationChunk = 1024;
    private long totalStreamableBytes;

    /*
     * WARNING - void declaration
     */
    public UniformStreamByteDistributor(Http2Connection connection) {
        void var1_1;
        void var2_2;
        this.stateKey = connection.newKey();
        Http2Stream connectionStream = connection.connectionStream();
        connectionStream.setProperty(this.stateKey, new State((Http2Stream)var2_2));
        var1_1.addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ UniformStreamByteDistributor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamAdded(Http2Stream stream) {
                void var1_1;
                stream.setProperty(this.this$0.stateKey, this.this$0.new State((Http2Stream)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamClosed(Http2Stream stream) {
                void var1_1;
                UniformStreamByteDistributor.access$100(this.this$0, (Http2Stream)var1_1).close();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void minAllocationChunk(int minAllocationChunk) {
        void var1_1;
        ObjectUtil.checkPositive((int)minAllocationChunk, (String)"minAllocationChunk");
        this.minAllocationChunk = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void updateStreamableBytes(StreamByteDistributor.StreamState streamState) {
        void var1_1;
        this.state(streamState.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(streamState), streamState.hasFrame(), var1_1.windowSize());
    }

    @Override
    public final void updateDependencyTree(int childStreamId, int parentStreamId, short weight, boolean exclusive) {
    }

    @Override
    public final boolean distribute(int maxBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
        int size = this.queue.size();
        if (size == 0) {
            return this.totalStreamableBytes > 0L;
        }
        int chunkSize = Math.max(this.minAllocationChunk, maxBytes / size);
        State state = this.queue.pollFirst();
        do {
            state.enqueued = false;
            if (state.windowNegative) continue;
            if (maxBytes == 0 && state.streamableBytes > 0) {
                this.queue.addFirst(state);
                state.enqueued = true;
                break;
            }
            int chunk = Math.min(chunkSize, Math.min(maxBytes, state.streamableBytes));
            maxBytes -= chunk;
            state.write(chunk, writer);
        } while ((state = this.queue.pollFirst()) != null);
        return this.totalStreamableBytes > 0L;
    }

    private State state(Http2Stream stream) {
        return (State)((Http2Stream)ObjectUtil.checkNotNull((Object)stream, (String)"stream")).getProperty(this.stateKey);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$100(UniformStreamByteDistributor x0, Http2Stream x1) {
        void var1_1;
        return x0.state((Http2Stream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$202(UniformStreamByteDistributor x0, long x1) {
        void var1_1;
        x0.totalStreamableBytes = var1_1;
        return x0.totalStreamableBytes;
    }

    private final class State {
        final Http2Stream stream;
        int streamableBytes;
        boolean windowNegative;
        boolean enqueued;
        boolean writing;

        /*
         * WARNING - void declaration
         */
        State(Http2Stream stream) {
            void var2_2;
            this.stream = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final void updateStreamableBytes(int newStreamableBytes, boolean hasFrame, int windowSize) {
            void var3_3;
            void var2_2;
            assert (hasFrame || newStreamableBytes == 0) : "hasFrame: " + hasFrame + " newStreamableBytes: " + newStreamableBytes;
            int delta = newStreamableBytes - this.streamableBytes;
            if (delta != 0) {
                void var1_1;
                this.streamableBytes = var1_1;
                UniformStreamByteDistributor.access$202(UniformStreamByteDistributor.this, UniformStreamByteDistributor.this.totalStreamableBytes + (long)delta);
            }
            boolean bl = this.windowNegative = windowSize < 0;
            if (var2_2 != false && (windowSize > 0 || var3_3 == false && !this.writing)) {
                this.addToQueue();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void write(int numBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
            this.writing = true;
            try {
                void var2_4;
                var2_4.write(this.stream, numBytes);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, (Throwable)var1_2, "byte distribution write error", new Object[0]);
            }
            finally {
                this.writing = false;
            }
        }

        final void addToQueue() {
            if (!this.enqueued) {
                this.enqueued = true;
                UniformStreamByteDistributor.this.queue.addLast(this);
            }
        }

        final void removeFromQueue() {
            if (this.enqueued) {
                this.enqueued = false;
                UniformStreamByteDistributor.this.queue.remove(this);
            }
        }

        final void close() {
            this.removeFromQueue();
            this.updateStreamableBytes(0, false, 0);
        }
    }
}

