/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DecoratingHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

public class StreamBufferingEncoder
extends DecoratingHttp2ConnectionEncoder {
    private final TreeMap<Integer, PendingStream> pendingStreams = new TreeMap();
    private int maxConcurrentStreams;
    private boolean closed;
    private GoAwayDetail goAwayDetail;

    /*
     * WARNING - void declaration
     */
    public StreamBufferingEncoder(Http2ConnectionEncoder delegate) {
        this((Http2ConnectionEncoder)var1_1, 100);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StreamBufferingEncoder(Http2ConnectionEncoder delegate, int initialMaxConcurrentStreams) {
        super((Http2ConnectionEncoder)var1_1);
        void var2_2;
        void var1_1;
        this.maxConcurrentStreams = var2_2;
        this.connection().addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ StreamBufferingEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
                void var2_2;
                void var1_1;
                ByteBuf byteBuf = debugData;
                StreamBufferingEncoder.access$302(this.this$0, new GoAwayDetail((int)var1_1, (long)var2_2, ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)byteBuf.readerIndex(), (int)debugData.readableBytes(), (boolean)false)));
                StreamBufferingEncoder.access$400(this.this$0, this.this$0.goAwayDetail);
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                this.this$0.tryCreatePendingStreams();
            }
        });
    }

    public int numBufferedStreams() {
        return this.pendingStreams.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ((DecoratingHttp2FrameWriter)this).writeHeaders((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, 0, (short)16, false, padding, endStream, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        void var3_3;
        if (this.closed) {
            return promise.setFailure((Throwable)new Http2ChannelClosedException());
        }
        if (this.isExistingStream(streamId) || this.canCreateStream()) {
            return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream, promise);
        }
        if (this.goAwayDetail != null) {
            return promise.setFailure((Throwable)new Http2GoAwayException(this.goAwayDetail));
        }
        PendingStream pendingStream = this.pendingStreams.get(streamId);
        if (pendingStream == null) {
            void var2_2;
            void var1_1;
            pendingStream = new PendingStream((ChannelHandlerContext)var1_1, streamId);
            this.pendingStreams.put((int)var2_2, pendingStream);
        }
        pendingStream.frames.add(new HeadersFrame((Http2Headers)var3_3, streamDependency, weight, exclusive, padding, endOfStream, promise));
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        if (this.isExistingStream(streamId)) {
            void var3_3;
            return super.writeRstStream(ctx, streamId, (long)var3_3, promise);
        }
        PendingStream stream = this.pendingStreams.remove(streamId);
        if (stream != null) {
            void var1_1;
            var1_1.close(null);
            promise.setSuccess();
        } else {
            void var2_2;
            promise.setFailure((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", (int)var2_2));
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
        if (this.isExistingStream(streamId)) {
            return super.writeData(ctx, streamId, data, padding, endOfStream, promise);
        }
        PendingStream pendingStream = this.pendingStreams.get(streamId);
        if (pendingStream != null) {
            void var1_1;
            var1_1.frames.add(new DataFrame(data, padding, endOfStream, promise));
        } else {
            void var2_2;
            void var3_3;
            ReferenceCountUtil.safeRelease((Object)var3_3);
            promise.setFailure((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", (int)var2_2));
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remoteSettings(Http2Settings settings) throws Http2Exception {
        void var1_1;
        super.remoteSettings((Http2Settings)var1_1);
        this.maxConcurrentStreams = this.connection().local().maxActiveStreams();
        this.tryCreatePendingStreams();
    }

    @Override
    public void close() {
        try {
            if (!this.closed) {
                this.closed = true;
                Http2ChannelClosedException e = new Http2ChannelClosedException();
                while (!this.pendingStreams.isEmpty()) {
                    PendingStream pendingStream = this.pendingStreams.pollFirstEntry().getValue();
                    pendingStream.close(e);
                }
            }
            return;
        }
        finally {
            super.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryCreatePendingStreams() {
        while (!this.pendingStreams.isEmpty() && this.canCreateStream()) {
            Map.Entry<Integer, PendingStream> entry = this.pendingStreams.pollFirstEntry();
            PendingStream pendingStream = entry.getValue();
            try {
                pendingStream.sendFrames();
            }
            catch (Throwable t) {
                void var2_2;
                ((PendingStream)((Object)entry)).close((Throwable)var2_2);
            }
        }
    }

    private void cancelGoAwayStreams(GoAwayDetail goAwayDetail) {
        Iterator<PendingStream> iter = this.pendingStreams.values().iterator();
        Http2GoAwayException e = new Http2GoAwayException(goAwayDetail);
        while (iter.hasNext()) {
            PendingStream stream = iter.next();
            if (stream.streamId <= goAwayDetail.lastStreamId) continue;
            iter.remove();
            stream.close(e);
        }
    }

    private boolean canCreateStream() {
        return this.connection().local().numActiveStreams() < this.maxConcurrentStreams;
    }

    private boolean isExistingStream(int streamId) {
        return streamId <= this.connection().local().lastStreamCreated();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ GoAwayDetail access$302(StreamBufferingEncoder x0, GoAwayDetail x1) {
        void var1_1;
        x0.goAwayDetail = var1_1;
        return x0.goAwayDetail;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(StreamBufferingEncoder x0, GoAwayDetail x1) {
        void var1_1;
        x0.cancelGoAwayStreams((GoAwayDetail)var1_1);
    }

    private final class DataFrame
    extends Frame {
        final ByteBuf data;
        final int padding;
        final boolean endOfStream;

        /*
         * WARNING - void declaration
         */
        DataFrame(ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            super(promise);
            this.data = var2_2;
            this.padding = var3_3;
            this.endOfStream = endOfStream;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void release(Throwable t) {
            void var1_1;
            super.release((Throwable)var1_1);
            ReferenceCountUtil.safeRelease((Object)this.data);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void send(ChannelHandlerContext ctx, int streamId) {
            void var2_2;
            void var1_1;
            ((DecoratingHttp2FrameWriter)StreamBufferingEncoder.this).writeData((ChannelHandlerContext)var1_1, (int)var2_2, this.data, this.padding, this.endOfStream, this.promise);
        }
    }

    private final class HeadersFrame
    extends Frame {
        final Http2Headers headers;
        final int streamDependency;
        final short weight;
        final boolean exclusive;
        final int padding;
        final boolean endOfStream;

        /*
         * WARNING - void declaration
         */
        HeadersFrame(Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            super(promise);
            this.headers = var2_2;
            this.streamDependency = var3_3;
            this.weight = weight;
            this.exclusive = exclusive;
            this.padding = padding;
            this.endOfStream = endOfStream;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void send(ChannelHandlerContext ctx, int streamId) {
            void var2_2;
            void var1_1;
            ((DecoratingHttp2FrameWriter)StreamBufferingEncoder.this).writeHeaders((ChannelHandlerContext)var1_1, (int)var2_2, this.headers, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream, this.promise);
        }
    }

    private static abstract class Frame {
        final ChannelPromise promise;

        /*
         * WARNING - void declaration
         */
        Frame(ChannelPromise promise) {
            void var1_1;
            this.promise = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void release(Throwable t) {
            void var1_1;
            if (t == null) {
                this.promise.setSuccess();
                return;
            }
            this.promise.setFailure((Throwable)var1_1);
        }

        abstract void send(ChannelHandlerContext var1, int var2);
    }

    private static final class PendingStream {
        final ChannelHandlerContext ctx;
        final int streamId;
        final Queue<Frame> frames = new ArrayDeque<Frame>(2);

        /*
         * WARNING - void declaration
         */
        PendingStream(ChannelHandlerContext ctx, int streamId) {
            void var2_2;
            void var1_1;
            this.ctx = var1_1;
            this.streamId = var2_2;
        }

        final void sendFrames() {
            for (Frame frame : this.frames) {
                frame.send(this.ctx, this.streamId);
            }
        }

        final void close(Throwable t) {
            for (Frame frame : this.frames) {
                frame.release(t);
            }
        }
    }

    public static final class Http2GoAwayException
    extends Http2Exception {
        private static final long serialVersionUID = 1326785622777291198L;
        private final GoAwayDetail goAwayDetail;

        /*
         * WARNING - void declaration
         */
        public Http2GoAwayException(int lastStreamId, long errorCode, byte[] debugData) {
            this(new GoAwayDetail((int)var1_1, (long)var2_2, debugData));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Http2GoAwayException(GoAwayDetail goAwayDetail) {
            super(Http2Error.STREAM_CLOSED);
            void var1_1;
            this.goAwayDetail = var1_1;
        }

        public final int lastStreamId() {
            return this.goAwayDetail.lastStreamId;
        }

        public final long errorCode() {
            return this.goAwayDetail.errorCode;
        }

        public final byte[] debugData() {
            return (byte[])this.goAwayDetail.debugData.clone();
        }
    }

    private static final class GoAwayDetail {
        private final int lastStreamId;
        private final long errorCode;
        private final byte[] debugData;

        /*
         * WARNING - void declaration
         */
        GoAwayDetail(int lastStreamId, long errorCode, byte[] debugData) {
            void var2_2;
            void var1_1;
            this.lastStreamId = var1_1;
            this.errorCode = var2_2;
            this.debugData = (byte[])debugData.clone();
        }
    }

    public static final class Http2ChannelClosedException
    extends Http2Exception {
        private static final long serialVersionUID = 4768543442094476971L;

        public Http2ChannelClosedException() {
            super(Http2Error.REFUSED_STREAM, "Connection closed");
        }
    }
}

