/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private static final byte PSEUDO_HEADER_TOKEN = 58;
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    /*
     * WARNING - void declaration
     */
    public static ReadOnlyHttp2Headers trailers(boolean validateHeaders, AsciiString ... otherHeaders) {
        void var1_1;
        boolean bl;
        return new ReadOnlyHttp2Headers(bl, EmptyArrays.EMPTY_ASCII_STRINGS, (AsciiString[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ReadOnlyHttp2Headers clientHeaders(boolean validateHeaders, AsciiString method, AsciiString path, AsciiString scheme, AsciiString authority, AsciiString ... otherHeaders) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean bl;
        return new ReadOnlyHttp2Headers(bl, new AsciiString[]{Http2Headers.PseudoHeaderName.METHOD.value(), var1_1, Http2Headers.PseudoHeaderName.PATH.value(), var2_2, Http2Headers.PseudoHeaderName.SCHEME.value(), var3_3, Http2Headers.PseudoHeaderName.AUTHORITY.value(), authority}, otherHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public static ReadOnlyHttp2Headers serverHeaders(boolean validateHeaders, AsciiString status, AsciiString ... otherHeaders) {
        void var2_2;
        void var1_1;
        boolean bl;
        return new ReadOnlyHttp2Headers(bl, new AsciiString[]{Http2Headers.PseudoHeaderName.STATUS.value(), var1_1}, (AsciiString[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ReadOnlyHttp2Headers(boolean validateHeaders, AsciiString[] pseudoHeaders, AsciiString ... otherHeaders) {
        void var3_3;
        void var2_2;
        void var1_1;
        assert ((pseudoHeaders.length & 1) == 0);
        if ((otherHeaders.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (var1_1 != false) {
            ReadOnlyHttp2Headers.validateHeaders(pseudoHeaders, otherHeaders);
        }
        this.pseudoHeaders = var2_2;
        this.otherHeaders = var3_3;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] pseudoHeaders, AsciiString ... otherHeaders) {
        for (int i = 1; i < pseudoHeaders.length; i += 2) {
            ObjectUtil.checkNotNullArrayParam((Object)pseudoHeaders[i], (int)i, (String)"pseudoHeaders");
        }
        boolean seenNonPseudoHeader = false;
        int otherHeadersEnd = otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString name = otherHeaders[i];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName((Object)name);
            if (!seenNonPseudoHeader && !name.isEmpty() && name.byteAt(0) != 58) {
                seenNonPseudoHeader = true;
            } else if (seenNonPseudoHeader && !name.isEmpty() && name.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i + " is a pseudo header that appears after non-pseudo headers.");
            }
            ObjectUtil.checkNotNullArrayParam((Object)otherHeaders[i + 1], (int)(i + 1), (String)"otherHeaders");
        }
    }

    /*
     * WARNING - void declaration
     */
    private AsciiString get0(CharSequence name) {
        int nameHash = AsciiString.hashCode((CharSequence)name);
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            AsciiString roName = this.pseudoHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name)) continue;
            return this.pseudoHeaders[i + 1];
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            void var3_4;
            AsciiString roName = this.otherHeaders[i];
            if (roName.hashCode() != nameHash || !var3_4.contentEqualsIgnoreCase(name)) continue;
            return this.otherHeaders[i + 1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final CharSequence get(CharSequence name) {
        void var1_1;
        return this.get0((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final CharSequence get(CharSequence name, CharSequence defaultValue) {
        void var2_2;
        CharSequence value = this.get(name);
        if (value != null) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    public final CharSequence getAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final CharSequence getAndRemove(CharSequence name, CharSequence defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    /*
     * WARNING - void declaration
     */
    public final List<CharSequence> getAll(CharSequence name) {
        void var3_3;
        int nameHash = AsciiString.hashCode((CharSequence)name);
        ArrayList<AsciiString> values = new ArrayList<AsciiString>();
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            AsciiString roName = this.pseudoHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name)) continue;
            values.add(this.pseudoHeaders[i + 1]);
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString roName = this.otherHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name)) continue;
            values.add(this.otherHeaders[i + 1]);
        }
        return var3_3;
    }

    public final List<CharSequence> getAllAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    /*
     * WARNING - void declaration
     */
    public final Boolean getBoolean(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return CharSequenceValueConverter.INSTANCE.convertToBoolean((CharSequence)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getBoolean(CharSequence name, boolean defaultValue) {
        void var2_2;
        Boolean value = this.getBoolean(name);
        if (value != null) {
            void var1_1;
            return var1_1.booleanValue();
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Byte getByte(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return CharSequenceValueConverter.INSTANCE.convertToByte((CharSequence)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final byte getByte(CharSequence name, byte defaultValue) {
        void var2_2;
        Byte value = this.getByte(name);
        if (value != null) {
            void var1_1;
            return var1_1.byteValue();
        }
        return (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Character getChar(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return Character.valueOf(CharSequenceValueConverter.INSTANCE.convertToChar((CharSequence)var1_1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final char getChar(CharSequence name, char defaultValue) {
        void var2_2;
        Character value = this.getChar(name);
        if (value != null) {
            void var1_1;
            return var1_1.charValue();
        }
        return (char)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Short getShort(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return CharSequenceValueConverter.INSTANCE.convertToShort((CharSequence)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final short getShort(CharSequence name, short defaultValue) {
        void var2_2;
        Short value = this.getShort(name);
        if (value != null) {
            void var1_1;
            return var1_1.shortValue();
        }
        return (short)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Integer getInt(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return CharSequenceValueConverter.INSTANCE.convertToInt((CharSequence)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final int getInt(CharSequence name, int defaultValue) {
        void var2_2;
        Integer value = this.getInt(name);
        if (value != null) {
            void var1_1;
            return var1_1.intValue();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Long getLong(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return CharSequenceValueConverter.INSTANCE.convertToLong((CharSequence)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final long getLong(CharSequence name, long defaultValue) {
        void var2_2;
        Long value = this.getLong(name);
        if (value != null) {
            void var1_1;
            return var1_1.longValue();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Float getFloat(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return Float.valueOf(CharSequenceValueConverter.INSTANCE.convertToFloat((CharSequence)var1_1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final float getFloat(CharSequence name, float defaultValue) {
        void var2_2;
        Float value = this.getFloat(name);
        if (value != null) {
            void var1_1;
            return var1_1.floatValue();
        }
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Double getDouble(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return CharSequenceValueConverter.INSTANCE.convertToDouble((CharSequence)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final double getDouble(CharSequence name, double defaultValue) {
        void var2_2;
        Double value = this.getDouble(name);
        if (value != null) {
            void var1_1;
            return var1_1.doubleValue();
        }
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Long getTimeMillis(CharSequence name) {
        AsciiString value = this.get0(name);
        if (value != null) {
            void var1_1;
            return CharSequenceValueConverter.INSTANCE.convertToTimeMillis((CharSequence)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final long getTimeMillis(CharSequence name, long defaultValue) {
        void var2_2;
        Long value = this.getTimeMillis(name);
        if (value != null) {
            void var1_1;
            return var1_1.longValue();
        }
        return (long)var2_2;
    }

    public final Boolean getBooleanAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final boolean getBooleanAndRemove(CharSequence name, boolean defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Byte getByteAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final byte getByteAndRemove(CharSequence name, byte defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Character getCharAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final char getCharAndRemove(CharSequence name, char defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Short getShortAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final short getShortAndRemove(CharSequence name, short defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Integer getIntAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final int getIntAndRemove(CharSequence name, int defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Long getLongAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final long getLongAndRemove(CharSequence name, long defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Float getFloatAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final float getFloatAndRemove(CharSequence name, float defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Double getDoubleAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final double getDoubleAndRemove(CharSequence name, double defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    public final Long getTimeMillisAndRemove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final long getTimeMillisAndRemove(CharSequence name, long defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(CharSequence name) {
        void var1_1;
        return this.get((CharSequence)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(CharSequence name, CharSequence value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, (CharSequence)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsObject(CharSequence name, Object value) {
        void var2_2;
        void var1_1;
        if (value instanceof CharSequence) {
            return this.contains(name, (CharSequence)value);
        }
        return this.contains((CharSequence)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsBoolean(CharSequence name, boolean value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsByte(CharSequence name, byte value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsChar(CharSequence name, char value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((char)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsShort(CharSequence name, short value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsInt(CharSequence name, int value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsLong(CharSequence name, long value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((long)var2_2));
    }

    public final boolean containsFloat(CharSequence name, float value) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsDouble(CharSequence name, double value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsTimeMillis(CharSequence name, long value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, String.valueOf((long)var2_2));
    }

    public final int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    public final boolean isEmpty() {
        return this.pseudoHeaders.length == 0 && this.otherHeaders.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final Set<CharSequence> names() {
        void var1_1;
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<AsciiString> names = new LinkedHashSet<AsciiString>(this.size());
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            names.add(this.pseudoHeaders[i]);
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            names.add(this.otherHeaders[i]);
        }
        return var1_1;
    }

    public final Http2Headers add(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers add(CharSequence name, Iterable<? extends CharSequence> values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers add(CharSequence name, CharSequence ... values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addObject(CharSequence name, Object value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addObject(CharSequence name, Iterable<?> values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addObject(CharSequence name, Object ... values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addBoolean(CharSequence name, boolean value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addByte(CharSequence name, byte value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addChar(CharSequence name, char value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addLong(CharSequence name, long value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addFloat(CharSequence name, float value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addDouble(CharSequence name, double value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers addTimeMillis(CharSequence name, long value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(CharSequence name, Iterable<? extends CharSequence> values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(CharSequence name, CharSequence ... values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setObject(CharSequence name, Object value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setObject(CharSequence name, Iterable<?> values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setObject(CharSequence name, Object ... values) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setBoolean(CharSequence name, boolean value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setByte(CharSequence name, byte value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setChar(CharSequence name, char value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setInt(CharSequence name, int value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setLong(CharSequence name, long value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setFloat(CharSequence name, float value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setDouble(CharSequence name, double value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setTimeMillis(CharSequence name, long value) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    public final boolean remove(CharSequence name) {
        throw new UnsupportedOperationException("read only");
    }

    public final Http2Headers clear() {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<CharSequence> valueIterator(CharSequence name) {
        void var1_1;
        return new ReadOnlyValueIterator((CharSequence)var1_1);
    }

    @Override
    public final Http2Headers method(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers scheme(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers authority(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers path(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final Http2Headers status(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final CharSequence method() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public final CharSequence scheme() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public final CharSequence authority() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public final CharSequence path() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public final CharSequence status() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.STATUS.value());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(CharSequence name, CharSequence value, boolean caseInsensitive) {
        void var3_4;
        void var2_2;
        void var1_1;
        HashingStrategy strategy;
        int valueHash;
        int nameHash = AsciiString.hashCode((CharSequence)name);
        return ReadOnlyHttp2Headers.contains(name, nameHash, value, valueHash = (strategy = caseInsensitive ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER).hashCode((Object)value), (HashingStrategy<CharSequence>)strategy, this.otherHeaders) || ReadOnlyHttp2Headers.contains((CharSequence)var1_1, nameHash, (CharSequence)var2_2, valueHash, (HashingStrategy<CharSequence>)var3_4, this.pseudoHeaders);
    }

    private static boolean contains(CharSequence name, int nameHash, CharSequence value, int valueHash, HashingStrategy<CharSequence> hashingStrategy, AsciiString[] headers) {
        int headersEnd = headers.length - 1;
        for (int i = 0; i < headersEnd; i += 2) {
            AsciiString roName = headers[i];
            AsciiString roValue = headers[i + 1];
            if (roName.hashCode() != nameHash || roValue.hashCode() != valueHash || !roName.contentEqualsIgnoreCase(name) || !hashingStrategy.equals((Object)roValue, (Object)value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String separator = "";
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            builder.append(separator);
            builder.append(entry.getKey()).append(": ").append(entry.getValue());
            separator = ", ";
        }
        return var1_1.append(']').toString();
    }

    private final class ReadOnlyIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private int i;
        private AsciiString[] current;
        private AsciiString key;
        private AsciiString value;

        private ReadOnlyIterator() {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
        }

        @Override
        public final boolean hasNext() {
            return this.i != this.current.length;
        }

        @Override
        public final Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = this.current[this.i];
            this.value = this.current[this.i + 1];
            this.i += 2;
            if (this.i == this.current.length && this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.i = 0;
            }
            return this;
        }

        @Override
        public final CharSequence getKey() {
            return this.key;
        }

        @Override
        public final CharSequence getValue() {
            return this.value;
        }

        @Override
        public final CharSequence setValue(CharSequence value) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }

    private final class ReadOnlyValueIterator
    implements Iterator<CharSequence> {
        private int i;
        private final int nameHash;
        private final CharSequence name;
        private AsciiString[] current;
        private AsciiString next;

        /*
         * WARNING - void declaration
         */
        ReadOnlyValueIterator(CharSequence name) {
            void var2_2;
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
            this.nameHash = AsciiString.hashCode((CharSequence)name);
            this.name = var2_2;
            this.calculateNext();
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CharSequence next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AsciiString current = this.next;
            this.calculateNext();
            return var1_1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        /*
         * WARNING - void declaration
         */
        private void calculateNext() {
            while (this.i < this.current.length) {
                void var1_1;
                AsciiString roName = this.current[this.i];
                if (roName.hashCode() == this.nameHash && var1_1.contentEqualsIgnoreCase(this.name)) {
                    if (this.i + 1 < this.current.length) {
                        this.next = this.current[this.i + 1];
                        this.i += 2;
                    }
                    return;
                }
                this.i += 2;
            }
            if (this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.i = 0;
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.calculateNext();
                return;
            }
            this.next = null;
        }
    }
}

