/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;

public class InboundHttpToHttp2Adapter
extends ChannelInboundHandlerAdapter {
    private final Http2Connection connection;
    private final Http2FrameListener listener;

    /*
     * WARNING - void declaration
     */
    public InboundHttpToHttp2Adapter(Http2Connection connection, Http2FrameListener listener) {
        void var2_2;
        void var1_1;
        this.connection = var1_1;
        this.listener = var2_2;
    }

    private static int getStreamId(Http2Connection connection, HttpHeaders httpHeaders) {
        Http2Connection http2Connection;
        return httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), http2Connection.remote().incrementAndGetNextStreamId());
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (msg instanceof FullHttpMessage) {
            InboundHttpToHttp2Adapter.handle(ctx, this.connection, this.listener, (FullHttpMessage)msg);
            return;
        }
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void handle(ChannelHandlerContext ctx, Http2Connection connection, Http2FrameListener listener, FullHttpMessage message) throws Http2Exception {
        try {
            int streamId = InboundHttpToHttp2Adapter.getStreamId(connection, message.headers());
            Http2Stream stream = connection.stream(streamId);
            if (stream == null) {
                stream = connection.remote().createStream(streamId, false);
            }
            message.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)HttpScheme.HTTP.name());
            Http2Headers messageHeaders = HttpConversionUtil.toHttp2Headers((HttpMessage)message, true);
            boolean hasContent = message.content().isReadable();
            boolean hasTrailers = !message.trailingHeaders().isEmpty();
            listener.onHeadersRead(ctx, streamId, messageHeaders, 0, !hasContent && !hasTrailers);
            if (hasContent) {
                listener.onDataRead(ctx, streamId, message.content(), 0, !hasTrailers);
            }
            if (hasTrailers) {
                void var1_2;
                ChannelHandlerContext channelHandlerContext;
                void var2_3;
                Http2Headers headers = HttpConversionUtil.toHttp2Headers(message.trailingHeaders(), true);
                var2_3.onHeadersRead(channelHandlerContext, streamId, (Http2Headers)var1_2, 0, true);
            }
            stream.closeRemoteSide();
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.release();
            throw throwable;
        }
        message.release();
    }
}

