/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.internal.ObjectUtil;

public class InboundHttp2ToHttpAdapter
extends Http2EventAdapter {
    private static final ImmediateSendDetector DEFAULT_SEND_DETECTOR = new ImmediateSendDetector(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean mustSendImmediately(FullHttpMessage msg) {
            if (msg instanceof FullHttpResponse) {
                return ((FullHttpResponse)msg).status().codeClass() == HttpStatusClass.INFORMATIONAL;
            }
            if (msg instanceof FullHttpRequest) {
                void var1_1;
                return var1_1.headers().contains((CharSequence)HttpHeaderNames.EXPECT);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpMessage copyIfNeeded(ByteBufAllocator allocator, FullHttpMessage msg) {
            if (msg instanceof FullHttpRequest) {
                void var1_1;
                void var2_2;
                FullHttpRequest copy = ((FullHttpRequest)var2_2).replace(allocator.buffer(0));
                copy.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
                return var1_1;
            }
            return null;
        }
    };
    private final int maxContentLength;
    private final ImmediateSendDetector sendDetector;
    private final Http2Connection.PropertyKey messageKey;
    private final boolean propagateSettings;
    protected final Http2Connection connection;
    protected final boolean validateHttpHeaders;

    /*
     * WARNING - void declaration
     */
    protected InboundHttp2ToHttpAdapter(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.maxContentLength = ObjectUtil.checkPositive((int)var2_2, (String)"maxContentLength");
        this.validateHttpHeaders = var3_3;
        this.propagateSettings = propagateSettings;
        this.sendDetector = DEFAULT_SEND_DETECTOR;
        this.messageKey = var1_1.newKey();
    }

    /*
     * WARNING - void declaration
     */
    protected final void removeMessage(Http2Stream stream, boolean release) {
        void var2_2;
        FullHttpMessage msg = (FullHttpMessage)stream.removeProperty(this.messageKey);
        if (var2_2 != false && msg != null) {
            void var1_1;
            var1_1.release();
        }
    }

    protected final FullHttpMessage getMessage(Http2Stream stream) {
        return (FullHttpMessage)stream.getProperty(this.messageKey);
    }

    /*
     * WARNING - void declaration
     */
    protected final void putMessage(Http2Stream stream, FullHttpMessage message) {
        void var2_2;
        FullHttpMessage previous = stream.setProperty(this.messageKey, message);
        if (previous != var2_2 && previous != null) {
            void var1_1;
            var1_1.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onStreamRemoved(Http2Stream stream) {
        void var1_1;
        this.removeMessage((Http2Stream)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    protected void fireChannelRead(ChannelHandlerContext ctx, FullHttpMessage msg, boolean release, Http2Stream stream) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.removeMessage(stream, (boolean)var3_3);
        FullHttpMessage fullHttpMessage = msg;
        HttpUtil.setContentLength((HttpMessage)fullHttpMessage, (long)fullHttpMessage.content().readableBytes());
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected FullHttpMessage newMessage(Http2Stream stream, Http2Headers headers, boolean validateHttpHeaders, ByteBufAllocator alloc) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.connection.isServer()) {
            return HttpConversionUtil.toFullHttpRequest(stream.id(), headers, alloc, validateHttpHeaders);
        }
        return HttpConversionUtil.toFullHttpResponse(var1_1.id(), (Http2Headers)var2_2, alloc, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext ctx, Http2Stream stream, Http2Headers headers, boolean endOfStream, boolean allowAppend, boolean appendToTrailer) throws Http2Exception {
        FullHttpMessage msg = this.getMessage(stream);
        boolean release = true;
        if (msg == null) {
            msg = this.newMessage(stream, headers, this.validateHttpHeaders, ctx.alloc());
        } else if (allowAppend) {
            release = false;
            HttpConversionUtil.addHttp2ToHttpHeaders(stream.id(), headers, msg, appendToTrailer);
        } else {
            release = false;
            msg = null;
        }
        if (this.sendDetector.mustSendImmediately(msg)) {
            void var3_3;
            void var2_2;
            void var1_1;
            FullHttpMessage copy = endOfStream ? null : this.sendDetector.copyIfNeeded(ctx.alloc(), msg);
            this.fireChannelRead((ChannelHandlerContext)var1_1, msg, release, (Http2Stream)var2_2);
            return var3_3;
        }
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    private void processHeadersEnd(ChannelHandlerContext ctx, Http2Stream stream, FullHttpMessage msg, boolean endOfStream) {
        void var3_3;
        void var2_2;
        if (endOfStream) {
            void var1_1;
            this.fireChannelRead((ChannelHandlerContext)var1_1, msg, this.getMessage(stream) != msg, stream);
            return;
        }
        this.putMessage((Http2Stream)var2_2, (FullHttpMessage)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        void var3_3;
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.getMessage(stream);
        if (msg == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Data Frame received for unknown stream id %d", streamId);
        }
        ByteBuf content = msg.content();
        int dataReadableBytes = data.readableBytes();
        if (content.readableBytes() > this.maxContentLength - dataReadableBytes) {
            void var2_2;
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Content length exceeded max of %d for stream id %d", this.maxContentLength, (int)var2_2);
        }
        void v0 = var3_3;
        content.writeBytes((ByteBuf)v0, v0.readerIndex(), dataReadableBytes);
        if (endOfStream) {
            void var1_1;
            this.fireChannelRead((ChannelHandlerContext)var1_1, msg, false, stream);
        }
        return dataReadableBytes + padding;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.processHeadersBegin(ctx, stream, headers, endOfStream, true, true);
        if (msg != null) {
            void var3_4;
            void var2_3;
            void var1_1;
            this.processHeadersEnd((ChannelHandlerContext)var1_1, (Http2Stream)var2_3, (FullHttpMessage)var3_4, endOfStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.processHeadersBegin(ctx, stream, headers, endOfStream, true, true);
        if (msg != null) {
            void var3_4;
            void var2_3;
            void var1_1;
            if (streamDependency != 0) {
                msg.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), streamDependency);
            }
            msg.headers().setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), weight);
            this.processHeadersEnd((ChannelHandlerContext)var1_1, (Http2Stream)var2_3, (FullHttpMessage)var3_4, endOfStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.getMessage(stream);
        if (msg != null) {
            this.onRstStreamRead(stream, msg);
        }
        var1_1.fireExceptionCaught((Throwable)Http2Exception.streamError((int)var2_2, Http2Error.valueOf((long)var3_3), "HTTP/2 to HTTP layer caught stream reset", new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        void var1_1;
        void var2_2;
        FullHttpMessage msg;
        Http2Stream promisedStream = this.connection.stream(promisedStreamId);
        if (headers.status() == null) {
            headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        }
        if ((msg = this.processHeadersBegin(ctx, promisedStream, headers, false, false, false)) == null) {
            void var3_3;
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Push Promise Frame received for pre-existing stream id %d", (int)var3_3);
        }
        msg.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), (int)var2_2);
        msg.headers().setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        this.processHeadersEnd((ChannelHandlerContext)var1_1, promisedStream, msg, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        if (this.propagateSettings) {
            void var2_2;
            void var1_1;
            var1_1.fireChannelRead((Object)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onRstStreamRead(Http2Stream stream, FullHttpMessage msg) {
        void var1_1;
        this.removeMessage((Http2Stream)var1_1, true);
    }

    private static interface ImmediateSendDetector {
        public boolean mustSendImmediately(FullHttpMessage var1);

        public FullHttpMessage copyIfNeeded(ByteBufAllocator var1, FullHttpMessage var2);
    }
}

