/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.ReferenceCountUtil;

public class HttpToHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private final boolean validateHeaders;
    private int currentStreamId;
    private HttpScheme httpScheme;

    /*
     * WARNING - void declaration
     */
    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders) {
        super((Http2ConnectionDecoder)var1_1, (Http2ConnectionEncoder)var2_2, (Http2Settings)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.validateHeaders = validateHeaders;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders, boolean decoupleCloseAndGoAway) {
        this((Http2ConnectionDecoder)var1_1, (Http2ConnectionEncoder)var2_2, (Http2Settings)var3_3, validateHeaders, decoupleCloseAndGoAway, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders, boolean decoupleCloseAndGoAway, HttpScheme httpScheme) {
        super((Http2ConnectionDecoder)var1_1, (Http2ConnectionEncoder)var2_2, (Http2Settings)var3_3, decoupleCloseAndGoAway);
        void var3_3;
        void var2_2;
        void var1_1;
        this.validateHeaders = validateHeaders;
        this.httpScheme = httpScheme;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders, boolean decoupleCloseAndGoAway, boolean flushPreface, HttpScheme httpScheme) {
        super((Http2ConnectionDecoder)var1_1, (Http2ConnectionEncoder)var2_2, (Http2Settings)var3_3, decoupleCloseAndGoAway, flushPreface);
        void var3_3;
        void var2_2;
        void var1_1;
        this.validateHeaders = validateHeaders;
        this.httpScheme = httpScheme;
    }

    private int getStreamId(HttpHeaders httpHeaders) throws Exception {
        return httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), this.connection().local().incrementAndGetNextStreamId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator;
        block11: {
            if (!(msg instanceof HttpMessage) && !(msg instanceof HttpContent)) {
                ctx.write(msg, promise);
                return;
            }
            boolean release = true;
            promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
            try {
                Http2ConnectionEncoder encoder = this.encoder();
                boolean endStream = false;
                if (msg instanceof HttpMessage) {
                    HttpMessage httpMsg = (HttpMessage)msg;
                    this.currentStreamId = this.getStreamId(httpMsg.headers());
                    if (this.httpScheme != null && !httpMsg.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text())) {
                        httpMsg.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)this.httpScheme.name());
                    }
                    Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(httpMsg, this.validateHeaders);
                    endStream = msg instanceof FullHttpMessage && !((FullHttpMessage)msg).content().isReadable();
                    HttpToHttp2ConnectionHandler.writeHeaders(ctx, encoder, this.currentStreamId, httpMsg.headers(), http2Headers, endStream, promiseAggregator);
                }
                if (!endStream && msg instanceof HttpContent) {
                    boolean isLastContent = false;
                    EmptyHttpHeaders trailers = EmptyHttpHeaders.INSTANCE;
                    Http2Headers http2Trailers = EmptyHttp2Headers.INSTANCE;
                    if (msg instanceof LastHttpContent) {
                        isLastContent = true;
                        LastHttpContent lastHttpContent = (LastHttpContent)msg;
                        trailers = lastHttpContent.trailingHeaders();
                        http2Trailers = HttpConversionUtil.toHttp2Headers((HttpHeaders)trailers, this.validateHeaders);
                    }
                    ByteBuf content = ((HttpContent)msg).content();
                    endStream = isLastContent && trailers.isEmpty();
                    encoder.writeData(ctx, this.currentStreamId, content, 0, endStream, promiseAggregator.newPromise());
                    release = false;
                    if (!trailers.isEmpty()) {
                        HttpToHttp2ConnectionHandler.writeHeaders(ctx, encoder, this.currentStreamId, (HttpHeaders)trailers, http2Trailers, true, promiseAggregator);
                    }
                }
                if (!release) break block11;
            }
            catch (Throwable t) {
                block12: {
                    try {
                        void var1_1;
                        this.onError((ChannelHandlerContext)var1_1, true, t);
                        promiseAggregator.setFailure(t);
                        if (!release) break block12;
                    }
                    catch (Throwable throwable) {
                        void var3_4;
                        if (release) {
                            void var2_3;
                            ReferenceCountUtil.release((Object)var2_3);
                        }
                        var3_4.doneAllocatingPromises();
                        throw throwable;
                    }
                    ReferenceCountUtil.release((Object)msg);
                }
                promiseAggregator.doneAllocatingPromises();
                return;
            }
            ReferenceCountUtil.release((Object)msg);
        }
        promiseAggregator.doneAllocatingPromises();
        return;
    }

    /*
     * WARNING - void declaration
     */
    private static void writeHeaders(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, int streamId, HttpHeaders headers, Http2Headers http2Headers, boolean endStream, Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator) {
        void var3_4;
        void var2_2;
        ChannelHandlerContext channelHandlerContext;
        void var1_1;
        int dependencyId = headers.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
        short weight = headers.getShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        var1_1.writeHeaders(channelHandlerContext, (int)var2_2, http2Headers, dependencyId, (short)var3_4, false, 0, endStream, promiseAggregator.newPromise());
    }
}

