/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.CharSequenceMap;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;

public final class HttpConversionUtil {
    private static final CharSequenceMap<AsciiString> HTTP_TO_HTTP2_HEADER_BLACKLIST;
    public static final HttpMethod OUT_OF_MESSAGE_SEQUENCE_METHOD;
    public static final String OUT_OF_MESSAGE_SEQUENCE_PATH = "";
    public static final HttpResponseStatus OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE;
    private static final AsciiString EMPTY_REQUEST_PATH;

    private HttpConversionUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static HttpResponseStatus parseStatus(CharSequence status) throws Http2Exception {
        void var1_1;
        try {
            HttpResponseStatus result = HttpResponseStatus.parseLine((CharSequence)status);
            if (result == HttpResponseStatus.SWITCHING_PROTOCOLS) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 status code '%d'", result.code());
            }
        }
        catch (Http2Exception http2Exception) {
            Http2Exception result = http2Exception;
            throw http2Exception;
        }
        catch (Throwable t) {
            CharSequence charSequence;
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, t, "Unrecognized HTTP status code '%s' encountered in translation to HTTP/1.x", charSequence);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static FullHttpResponse toFullHttpResponse(int streamId, Http2Headers http2Headers, ByteBufAllocator alloc, boolean validateHttpHeaders) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return HttpConversionUtil.toFullHttpResponse(streamId, (Http2Headers)var1_1, var2_2.buffer(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static FullHttpResponse toFullHttpResponse(int streamId, Http2Headers http2Headers, ByteBuf content, boolean validateHttpHeaders) throws Http2Exception {
        void var2_4;
        void var3_5;
        HttpResponseStatus status = HttpConversionUtil.parseStatus(http2Headers.status());
        DefaultFullHttpResponse msg = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content, (boolean)var3_5);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, (FullHttpMessage)msg, false);
        }
        catch (Http2Exception e) {
            msg.release();
            throw e;
        }
        catch (Throwable t) {
            void var1_3;
            int n;
            msg.release();
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, (Throwable)var1_3, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public static FullHttpRequest toFullHttpRequest(int streamId, Http2Headers http2Headers, ByteBufAllocator alloc, boolean validateHttpHeaders) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return HttpConversionUtil.toFullHttpRequest(streamId, (Http2Headers)var1_1, var2_2.buffer(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static String extractPath(CharSequence method, Http2Headers headers) {
        void var1_1;
        CharSequence charSequence;
        if (HttpMethod.CONNECT.asciiName().contentEqualsIgnoreCase(charSequence)) {
            return ((CharSequence)ObjectUtil.checkNotNull((Object)headers.authority(), (String)"authority header cannot be null in the conversion to HTTP/1.x")).toString();
        }
        return ((CharSequence)ObjectUtil.checkNotNull((Object)var1_1.path(), (String)"path header cannot be null in conversion to HTTP/1.x")).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static FullHttpRequest toFullHttpRequest(int streamId, Http2Headers http2Headers, ByteBuf content, boolean validateHttpHeaders) throws Http2Exception {
        void var2_4;
        void var3_5;
        CharSequence method = (CharSequence)ObjectUtil.checkNotNull((Object)http2Headers.method(), (String)"method header cannot be null in conversion to HTTP/1.x");
        String path = HttpConversionUtil.extractPath(method, http2Headers);
        DefaultFullHttpRequest msg = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method.toString()), path.toString(), content, (boolean)var3_5);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, (FullHttpMessage)msg, false);
        }
        catch (Http2Exception e) {
            msg.release();
            throw e;
        }
        catch (Throwable t) {
            void var1_3;
            int n;
            msg.release();
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, (Throwable)var1_3, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public static HttpRequest toHttpRequest(int streamId, Http2Headers http2Headers, boolean validateHttpHeaders) throws Http2Exception {
        void var2_4;
        void var3_5;
        CharSequence method = (CharSequence)ObjectUtil.checkNotNull((Object)http2Headers.method(), (String)"method header cannot be null in conversion to HTTP/1.x");
        String path = HttpConversionUtil.extractPath(method, (Http2Headers)http2Headers);
        DefaultHttpRequest msg = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)var3_5.toString()), path.toString(), validateHttpHeaders);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, (Http2Headers)http2Headers, msg.headers(), msg.protocolVersion(), false, true);
        }
        catch (Http2Exception http2Exception) {
            http2Headers = http2Exception;
            throw http2Exception;
        }
        catch (Throwable t) {
            void var1_2;
            int n;
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, (Throwable)var1_2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public static HttpResponse toHttpResponse(int streamId, Http2Headers http2Headers, boolean validateHttpHeaders) throws Http2Exception {
        void var2_4;
        void var3_5;
        HttpResponseStatus status = HttpConversionUtil.parseStatus(http2Headers.status());
        DefaultHttpResponse msg = new DefaultHttpResponse(HttpVersion.HTTP_1_1, (HttpResponseStatus)var3_5, validateHttpHeaders);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, (Http2Headers)http2Headers, msg.headers(), msg.protocolVersion(), false, false);
        }
        catch (Http2Exception http2Exception) {
            http2Headers = http2Exception;
            throw http2Exception;
        }
        catch (Throwable t) {
            void var1_2;
            int n;
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, (Throwable)var1_2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public static void addHttp2ToHttpHeaders(int streamId, Http2Headers inputHeaders, FullHttpMessage destinationMessage, boolean addToTrailer) throws Http2Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        HttpConversionUtil.addHttp2ToHttpHeaders(streamId, (Http2Headers)var1_1, addToTrailer ? destinationMessage.trailingHeaders() : destinationMessage.headers(), destinationMessage.protocolVersion(), (boolean)var3_3, var2_2 instanceof HttpRequest);
    }

    /*
     * WARNING - void declaration
     */
    public static void addHttp2ToHttpHeaders(int streamId, Http2Headers inputHeaders, HttpHeaders outputHeaders, HttpVersion httpVersion, boolean isTrailer, boolean isRequest) throws Http2Exception {
        Http2ToHttpHeaderTranslator translator = new Http2ToHttpHeaderTranslator(streamId, outputHeaders, isRequest);
        try {
            translator.translateHeaders((Iterable<Map.Entry<CharSequence, CharSequence>>)inputHeaders);
        }
        catch (Http2Exception http2Exception) {
            inputHeaders = http2Exception;
            throw http2Exception;
        }
        catch (Throwable t) {
            void var1_2;
            throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, (Throwable)var1_2, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        outputHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        outputHeaders.remove((CharSequence)HttpHeaderNames.TRAILER);
        if (!isTrailer) {
            void var3_4;
            void var2_3;
            int n;
            outputHeaders.setInt((CharSequence)ExtensionHeaderNames.STREAM_ID.text(), n);
            HttpUtil.setKeepAlive((HttpHeaders)var2_3, (HttpVersion)var3_4, (boolean)true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Headers toHttp2Headers(HttpMessage in, boolean validateHeaders) {
        void var1_2;
        void var2_3;
        HttpMessage request;
        HttpHeaders inHeaders = in.headers();
        DefaultHttp2Headers out = new DefaultHttp2Headers(validateHeaders, inHeaders.size());
        if (in instanceof HttpRequest) {
            void var3_4;
            request = (HttpRequest)in;
            String host = inHeaders.getAsString((CharSequence)HttpHeaderNames.HOST);
            if (HttpUtil.isOriginForm((String)request.uri()) || HttpUtil.isAsteriskForm((String)request.uri())) {
                out.path((CharSequence)new AsciiString((CharSequence)request.uri()));
                HttpConversionUtil.setHttp2Scheme(inHeaders, out);
            } else {
                URI requestTargetUri = URI.create(request.uri());
                out.path((CharSequence)HttpConversionUtil.toHttp2Path(requestTargetUri));
                host = StringUtil.isNullOrEmpty((String)host) ? requestTargetUri.getAuthority() : host;
                HttpConversionUtil.setHttp2Scheme(inHeaders, requestTargetUri, out);
            }
            HttpConversionUtil.setHttp2Authority((String)var3_4, out);
            out.method((CharSequence)request.method().asciiName());
        } else if (request instanceof HttpResponse) {
            HttpMessage httpMessage;
            HttpMessage response = (HttpResponse)request;
            out.status((CharSequence)httpMessage.status().codeAsText());
        }
        HttpConversionUtil.toHttp2Headers((HttpHeaders)var2_3, out);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Headers toHttp2Headers(HttpHeaders inHeaders, boolean validateHeaders) {
        void var1_2;
        HttpHeaders httpHeaders;
        if (inHeaders.isEmpty()) {
            return EmptyHttp2Headers.INSTANCE;
        }
        DefaultHttp2Headers out = new DefaultHttp2Headers(validateHeaders, inHeaders.size());
        HttpConversionUtil.toHttp2Headers(httpHeaders, out);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static CharSequenceMap<AsciiString> toLowercaseMap(Iterator<? extends CharSequence> valuesIter, int arraySizeHint) {
        void var1_2;
        UnsupportedValueConverter valueConverter = UnsupportedValueConverter.instance();
        CharSequenceMap result = new CharSequenceMap(true, valueConverter, arraySizeHint);
        while (valuesIter.hasNext()) {
            AsciiString lowerCased = AsciiString.of((CharSequence)valuesIter.next()).toLowerCase();
            try {
                void var2_3;
                int index = lowerCased.forEachByte(ByteProcessor.FIND_COMMA);
                if (index != -1) {
                    int start = 0;
                    do {
                        result.add(lowerCased.subSequence(start, index, false).trim(), AsciiString.EMPTY_STRING);
                    } while ((start = index + 1) < lowerCased.length() && (index = lowerCased.forEachByte(start, lowerCased.length() - start, ByteProcessor.FIND_COMMA)) != -1);
                    result.add(lowerCased.subSequence(start, lowerCased.length(), false).trim(), AsciiString.EMPTY_STRING);
                    continue;
                }
                result.add(var2_3.trim(), AsciiString.EMPTY_STRING);
            }
            catch (Exception e) {
                void var3_5;
                throw new IllegalStateException((Throwable)var3_5);
            }
        }
        return var1_2;
    }

    private static void toHttp2HeadersFilterTE(Map.Entry<CharSequence, CharSequence> entry, Http2Headers out) {
        if (AsciiString.indexOf((CharSequence)entry.getValue(), (char)',', (int)0) == -1) {
            if (AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)entry.getValue()), (CharSequence)HttpHeaderValues.TRAILERS)) {
                out.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                return;
            }
        } else {
            Iterator iterator;
            iterator = StringUtil.unescapeCsvFields((CharSequence)iterator.getValue());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = (CharSequence)iterator.next();
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)charSequence), (CharSequence)HttpHeaderValues.TRAILERS)) continue;
                out.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void toHttp2Headers(HttpHeaders inHeaders, Http2Headers out) {
        Iterator iter = inHeaders.iteratorCharSequence();
        Object connectionBlacklist = HttpConversionUtil.toLowercaseMap(inHeaders.valueCharSequenceIterator((CharSequence)HttpHeaderNames.CONNECTION), 8);
        while (iter.hasNext()) {
            void var4_4;
            void var3_3;
            Map.Entry entry = (Map.Entry)iter.next();
            AsciiString aName = AsciiString.of((CharSequence)((CharSequence)entry.getKey())).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_BLACKLIST.contains(aName) || connectionBlacklist.contains((Object)aName)) continue;
            if (aName.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.TE)) {
                HttpConversionUtil.toHttp2HeadersFilterTE(entry, out);
                continue;
            }
            if (aName.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE)) {
                CharSequence valueCs = (CharSequence)entry.getValue();
                boolean invalid = false;
                for (int i = 0; i < valueCs.length(); ++i) {
                    char c = valueCs.charAt(i);
                    if (c == ';') {
                        if (i + 1 >= valueCs.length() || valueCs.charAt(i + 1) != ' ') {
                            invalid = true;
                            break;
                        }
                        ++i;
                        continue;
                    }
                    if (c <= '\u00ff') continue;
                    invalid = true;
                    break;
                }
                if (invalid) {
                    out.add(HttpHeaderNames.COOKIE, valueCs);
                    continue;
                }
                HttpConversionUtil.splitValidCookieHeader(out, (CharSequence)var3_3);
                continue;
            }
            out.add(var4_4, var3_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void splitValidCookieHeader(Http2Headers out, CharSequence valueCs) {
        try {
            void var3_4;
            AsciiString value = AsciiString.of((CharSequence)valueCs);
            int index = value.forEachByte(ByteProcessor.FIND_SEMI_COLON);
            if (index != -1) {
                int start = 0;
                do {
                    out.add(HttpHeaderNames.COOKIE, value.subSequence(start, index, false));
                    assert (index + 1 < value.length());
                    assert (value.charAt(index + 1) == ' ');
                } while ((start = index + 2) < value.length() && (index = value.forEachByte(start, value.length() - start, ByteProcessor.FIND_SEMI_COLON)) != -1);
                assert (start < value.length());
            } else {
                Http2Headers http2Headers;
                http2Headers.add(HttpHeaderNames.COOKIE, value);
                return;
            }
            out.add(HttpHeaderNames.COOKIE, value.subSequence((int)var3_4, value.length(), false));
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static AsciiString toHttp2Path(URI uri) {
        Object object;
        void var1_1;
        Object path;
        StringBuilder pathBuilder = new StringBuilder(StringUtil.length((String)uri.getRawPath()) + StringUtil.length((String)uri.getRawQuery()) + StringUtil.length((String)uri.getRawFragment()) + 2);
        if (!StringUtil.isNullOrEmpty((String)uri.getRawPath())) {
            pathBuilder.append(uri.getRawPath());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getRawQuery())) {
            pathBuilder.append('?');
            pathBuilder.append(uri.getRawQuery());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getRawFragment())) {
            pathBuilder.append('#');
            pathBuilder.append(uri.getRawFragment());
        }
        if (((String)(path = var1_1.toString())).isEmpty()) {
            return EMPTY_REQUEST_PATH;
        }
        return new AsciiString((CharSequence)object);
    }

    /*
     * WARNING - void declaration
     */
    static void setHttp2Authority(String authority, Http2Headers out) {
        if (authority != null) {
            void var3_3;
            void var2_2;
            String string;
            void var1_1;
            if (authority.isEmpty()) {
                out.authority((CharSequence)AsciiString.EMPTY_STRING);
                return;
            }
            int start = authority.indexOf(64) + 1;
            int length = authority.length() - start;
            if (length == 0) {
                throw new IllegalArgumentException("authority: " + authority);
            }
            var1_1.authority((CharSequence)new AsciiString((CharSequence)string, (int)var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setHttp2Scheme(HttpHeaders in, Http2Headers out) {
        void var1_1;
        HttpConversionUtil.setHttp2Scheme(in, URI.create(OUT_OF_MESSAGE_SEQUENCE_PATH), (Http2Headers)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void setHttp2Scheme(HttpHeaders in, URI uri, Http2Headers out) {
        void var1_1;
        String value = uri.getScheme();
        if (!StringUtil.isNullOrEmpty((String)value)) {
            void var3_3;
            out.scheme((CharSequence)new AsciiString((CharSequence)var3_3));
            return;
        }
        Object cValue = in.get((CharSequence)ExtensionHeaderNames.SCHEME.text());
        if (cValue != null) {
            Object object;
            out.scheme((CharSequence)AsciiString.of((CharSequence)object));
            return;
        }
        if (uri.getPort() == HttpScheme.HTTPS.port()) {
            out.scheme((CharSequence)HttpScheme.HTTPS.name());
            return;
        }
        if (var1_1.getPort() == HttpScheme.HTTP.port()) {
            void var2_2;
            var2_2.scheme((CharSequence)HttpScheme.HTTP.name());
            return;
        }
        throw new IllegalArgumentException(":scheme must be specified. see https://tools.ietf.org/html/rfc7540#section-8.1.2.3");
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        HTTP_TO_HTTP2_HEADER_BLACKLIST = new CharSequenceMap();
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        AsciiString keepAlive = HttpHeaderNames.KEEP_ALIVE;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(keepAlive, AsciiString.EMPTY_STRING);
        AsciiString proxyConnection = HttpHeaderNames.PROXY_CONNECTION;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(var0, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        OUT_OF_MESSAGE_SEQUENCE_METHOD = HttpMethod.OPTIONS;
        OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = HttpResponseStatus.OK;
        EMPTY_REQUEST_PATH = AsciiString.cached((String)"/");
    }

    private static final class Http2ToHttpHeaderTranslator {
        private static final CharSequenceMap<AsciiString> REQUEST_HEADER_TRANSLATIONS = new CharSequenceMap();
        private static final CharSequenceMap<AsciiString> RESPONSE_HEADER_TRANSLATIONS = new CharSequenceMap();
        private final int streamId;
        private final HttpHeaders output;
        private final CharSequenceMap<AsciiString> translations;

        /*
         * WARNING - void declaration
         */
        Http2ToHttpHeaderTranslator(int streamId, HttpHeaders output, boolean request) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.streamId = var1_1;
            this.output = var2_2;
            this.translations = var3_3 != false ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
        }

        /*
         * WARNING - void declaration
         */
        final void translateHeaders(Iterable<Map.Entry<CharSequence, CharSequence>> inputHeaders) throws Http2Exception {
            Iterator iterator;
            StringBuilder cookies = null;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Map.Entry entry = (Map.Entry)iterator.next();
                CharSequence name = (CharSequence)entry.getKey();
                CharSequence value = (CharSequence)entry.getValue();
                AsciiString translatedName = (AsciiString)this.translations.get(name);
                if (translatedName != null) {
                    this.output.add((CharSequence)translatedName, (Object)AsciiString.of((CharSequence)value));
                    continue;
                }
                if (Http2Headers.PseudoHeaderName.isPseudoHeader(name)) continue;
                if (name.length() == 0 || name.charAt(0) == ':') {
                    throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 header '%s' encountered in translation to HTTP/1.x", name);
                }
                if (HttpHeaderNames.COOKIE.equals((Object)name)) {
                    if (cookies == null) {
                        cookies = InternalThreadLocalMap.get().stringBuilder();
                    } else if (cookies.length() > 0) {
                        cookies.append("; ");
                    }
                    cookies.append(value);
                    continue;
                }
                this.output.add(name, (Object)var3_3);
            }
            if (cookies != null) {
                void var2_2;
                this.output.add((CharSequence)HttpHeaderNames.COOKIE, (Object)var2_2.toString());
            }
        }

        static {
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.SCHEME.value(), ExtensionHeaderNames.SCHEME.text());
            REQUEST_HEADER_TRANSLATIONS.add((Headers)RESPONSE_HEADER_TRANSLATIONS);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.PATH.value(), ExtensionHeaderNames.PATH.text());
        }
    }

    public static enum ExtensionHeaderNames {
        STREAM_ID("x-http2-stream-id"),
        SCHEME("x-http2-scheme"),
        PATH("x-http2-path"),
        STREAM_PROMISE_ID("x-http2-stream-promise-id"),
        STREAM_DEPENDENCY_ID("x-http2-stream-dependency-id"),
        STREAM_WEIGHT("x-http2-stream-weight");

        private final AsciiString text;

        /*
         * WARNING - void declaration
         */
        private ExtensionHeaderNames(String text) {
            void var3_3;
            this.text = AsciiString.cached((String)var3_3);
        }

        public final AsciiString text() {
            return this.text;
        }
    }
}

