/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;

@ChannelHandler.Sharable
public class Http2StreamFrameToHttpObjectCodec
extends MessageToMessageCodec<Http2StreamFrame, HttpObject> {
    private static final AttributeKey<HttpScheme> SCHEME_ATTR_KEY = AttributeKey.valueOf(HttpScheme.class, (String)"STREAMFRAMECODEC_SCHEME");
    private final boolean isServer;
    private final boolean validateHeaders;

    /*
     * WARNING - void declaration
     */
    public Http2StreamFrameToHttpObjectCodec(boolean isServer, boolean validateHeaders) {
        void var2_2;
        void var1_1;
        this.isServer = var1_1;
        this.validateHeaders = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Http2StreamFrameToHttpObjectCodec(boolean isServer) {
        this((boolean)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptInboundMessage(Object msg) throws Exception {
        void var1_1;
        return msg instanceof Http2HeadersFrame || var1_1 instanceof Http2DataFrame;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void decode(ChannelHandlerContext ctx, Http2StreamFrame frame, List<Object> out) throws Exception {
        void var2_2;
        void var3_3;
        Http2HeadersFrame headersFrame;
        if (frame instanceof Http2HeadersFrame) {
            void var1_1;
            headersFrame = (Http2HeadersFrame)frame;
            Http2Headers headers = headersFrame.headers();
            Http2FrameStream stream = headersFrame.stream();
            int id = stream == null ? 0 : stream.id();
            CharSequence status = headers.status();
            if (status != null && Http2StreamFrameToHttpObjectCodec.isInformationalResponseHeaderFrame(status)) {
                FullHttpMessage fullMsg = this.newFullMessage(id, headers, ctx.alloc());
                out.add(fullMsg);
                return;
            }
            if (headersFrame.isEndStream()) {
                DefaultLastHttpContent last;
                if (headers.method() == null && status == null) {
                    last = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
                    HttpConversionUtil.addHttp2ToHttpHeaders(id, headers, last.trailingHeaders(), HttpVersion.HTTP_1_1, true, true);
                    out.add(last);
                    return;
                }
                FullHttpMessage full = this.newFullMessage(id, headers, last.alloc());
                out.add(full);
                return;
            }
            HttpMessage req = this.newMessage(id, headers);
            if (!(status != null && Http2StreamFrameToHttpObjectCodec.isContentAlwaysEmpty(status) || HttpUtil.isContentLengthSet((HttpMessage)req))) {
                req.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            out.add(var1_1);
            return;
        }
        if (!(headersFrame instanceof Http2DataFrame)) return;
        Http2DataFrame dataFrame = (Http2DataFrame)((Object)headersFrame);
        if (dataFrame.isEndStream()) {
            out.add(new DefaultLastHttpContent(dataFrame.content().retain(), this.validateHeaders));
            return;
        }
        var3_3.add(new DefaultHttpContent(var2_2.content().retain()));
    }

    /*
     * WARNING - void declaration
     */
    private void encodeLastContent(LastHttpContent last, List<Object> out) {
        void var3_3;
        boolean needFiller;
        boolean bl = needFiller = !(last instanceof FullHttpMessage) && last.trailingHeaders().isEmpty();
        if (last.content().isReadable() || var3_3 != false) {
            out.add(new DefaultHttp2DataFrame(last.content().retain(), last.trailingHeaders().isEmpty()));
        }
        if (!last.trailingHeaders().isEmpty()) {
            void var1_1;
            void var2_2;
            Http2Headers headers = HttpConversionUtil.toHttp2Headers(last.trailingHeaders(), this.validateHeaders);
            var2_2.add(new DefaultHttp2HeadersFrame((Http2Headers)var1_1, true));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void encode(ChannelHandlerContext ctx, HttpObject obj, List<Object> out) throws Exception {
        void var1_1;
        if (obj instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)obj;
            HttpResponseStatus status = res.status();
            int code = status.code();
            HttpStatusClass httpStatusClass = status.codeClass();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL && code != 101) {
                if (res instanceof FullHttpResponse) {
                    Http2Headers headers = this.toHttp2Headers(ctx, (HttpMessage)res);
                    out.add(new DefaultHttp2HeadersFrame((Http2Headers)var1_1, false));
                    return;
                }
                throw new EncoderException(status + " must be a FullHttpResponse");
            }
        }
        if (obj instanceof HttpMessage) {
            Http2Headers headers = this.toHttp2Headers((ChannelHandlerContext)var1_1, (HttpMessage)obj);
            boolean noMoreFrames = false;
            if (obj instanceof FullHttpMessage) {
                FullHttpMessage full = (FullHttpMessage)obj;
                noMoreFrames = !full.content().isReadable() && full.trailingHeaders().isEmpty();
            }
            out.add(new DefaultHttp2HeadersFrame(headers, noMoreFrames));
        }
        if (obj instanceof LastHttpContent) {
            LastHttpContent last = (LastHttpContent)obj;
            this.encodeLastContent(last, out);
            return;
        }
        if (obj instanceof HttpContent) {
            void var3_3;
            void var2_2;
            HttpContent cont = (HttpContent)var2_2;
            var3_3.add(new DefaultHttp2DataFrame(cont.content().retain(), false));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Http2Headers toHttp2Headers(ChannelHandlerContext ctx, HttpMessage msg) {
        void var2_2;
        if (msg instanceof HttpRequest) {
            void var1_1;
            msg.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)Http2StreamFrameToHttpObjectCodec.connectionScheme((ChannelHandlerContext)var1_1));
        }
        return HttpConversionUtil.toHttp2Headers((HttpMessage)var2_2, this.validateHeaders);
    }

    /*
     * WARNING - void declaration
     */
    private HttpMessage newMessage(int id, Http2Headers headers) throws Http2Exception {
        void var2_2;
        void var1_1;
        if (this.isServer) {
            return HttpConversionUtil.toHttpRequest(id, headers, this.validateHeaders);
        }
        return HttpConversionUtil.toHttpResponse((int)var1_1, (Http2Headers)var2_2, this.validateHeaders);
    }

    /*
     * WARNING - void declaration
     */
    private FullHttpMessage newFullMessage(int id, Http2Headers headers, ByteBufAllocator alloc) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.isServer) {
            return HttpConversionUtil.toFullHttpRequest(id, headers, alloc, this.validateHeaders);
        }
        return HttpConversionUtil.toFullHttpResponse((int)var1_1, (Http2Headers)var2_2, (ByteBufAllocator)var3_3, this.validateHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        Attribute<HttpScheme> schemeAttribute = Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(ctx);
        if (schemeAttribute.get() == null) {
            void var1_1;
            void var2_2;
            HttpScheme scheme = this.isSsl(ctx) ? HttpScheme.HTTPS : HttpScheme.HTTP;
            var2_2.set((Object)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSsl(ChannelHandlerContext ctx) {
        void var1_1;
        Channel connChannel = Http2StreamFrameToHttpObjectCodec.connectionChannel(ctx);
        return null != var1_1.pipeline().get(SslHandler.class);
    }

    private static HttpScheme connectionScheme(ChannelHandlerContext ctx) {
        ChannelHandlerContext channelHandlerContext;
        ChannelHandlerContext scheme = (HttpScheme)Http2StreamFrameToHttpObjectCodec.connectionSchemeAttribute(ctx).get();
        if (scheme == null) {
            return HttpScheme.HTTP;
        }
        return channelHandlerContext;
    }

    private static Attribute<HttpScheme> connectionSchemeAttribute(ChannelHandlerContext ctx) {
        ChannelHandlerContext channelHandlerContext = Http2StreamFrameToHttpObjectCodec.connectionChannel(ctx);
        return channelHandlerContext.attr(SCHEME_ATTR_KEY);
    }

    private static Channel connectionChannel(ChannelHandlerContext ctx) {
        ChannelHandlerContext channelHandlerContext;
        ChannelHandlerContext ch = ctx.channel();
        if (ch instanceof Http2StreamChannel) {
            return ch.parent();
        }
        return channelHandlerContext;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isInformationalResponseHeaderFrame(CharSequence status) {
        if (status.length() == 3) {
            void var0_1;
            void var2_3;
            void var1_2;
            char char0 = status.charAt(0);
            char char1 = status.charAt(1);
            char char2 = status.charAt(2);
            return var1_2 == 49 && char1 >= '0' && var2_3 <= 57 && char2 >= '0' && char2 <= '9' && var0_1 != 49;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isContentAlwaysEmpty(CharSequence status) {
        if (status.length() == 3) {
            void var0_1;
            void var2_3;
            void var1_2;
            char char0 = status.charAt(0);
            char char1 = status.charAt(1);
            char char2 = status.charAt(2);
            return (char0 == '2' || var1_2 == 51) && var2_3 == 48 && var0_1 == 52;
        }
        return false;
    }
}

