/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Http2StreamChannelBootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrap.class);
    private static final Map.Entry<ChannelOption<?>, Object>[] EMPTY_OPTION_ARRAY = new Map.Entry[0];
    private static final Map.Entry<AttributeKey<?>, Object>[] EMPTY_ATTRIBUTE_ARRAY = new Map.Entry[0];
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new ConcurrentHashMap();
    private final Channel channel;
    private volatile ChannelHandler handler;
    private volatile ChannelHandlerContext multiplexCtx;

    /*
     * WARNING - void declaration
     */
    public Http2StreamChannelBootstrap(Channel channel) {
        void var1_1;
        this.channel = (Channel)ObjectUtil.checkNotNull((Object)var1_1, (String)"channel");
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Http2StreamChannelBootstrap option(ChannelOption<T> option, T value) {
        ObjectUtil.checkNotNull(option, (String)"option");
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            if (value == null) {
                this.options.remove(option);
            } else {
                void var2_3;
                void var1_1;
                this.options.put((ChannelOption<?>)var1_1, var2_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Http2StreamChannelBootstrap attr(AttributeKey<T> key, T value) {
        ObjectUtil.checkNotNull(key, (String)"key");
        if (value == null) {
            this.attrs.remove(key);
        } else {
            void var2_2;
            void var1_1;
            this.attrs.put((AttributeKey<?>)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Http2StreamChannelBootstrap handler(ChannelHandler handler) {
        void var1_1;
        this.handler = (ChannelHandler)ObjectUtil.checkNotNull((Object)var1_1, (String)"handler");
        return this;
    }

    public final Future<Http2StreamChannel> open() {
        Http2StreamChannelBootstrap http2StreamChannelBootstrap = this;
        return http2StreamChannelBootstrap.open((Promise<Http2StreamChannel>)http2StreamChannelBootstrap.channel.eventLoop().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final Future<Http2StreamChannel> open(Promise<Http2StreamChannel> promise) {
        void var1_1;
        try {
            ChannelHandlerContext ctx = this.findCtx();
            EventExecutor executor = ctx.executor();
            if (executor.inEventLoop()) {
                this.open0(ctx, promise);
            } else {
                void finalCtx;
                void var3_4;
                var3_4.execute(new Runnable(this, (ChannelHandlerContext)finalCtx, promise){
                    final /* synthetic */ ChannelHandlerContext val$finalCtx;
                    final /* synthetic */ Promise val$promise;
                    final /* synthetic */ Http2StreamChannelBootstrap this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$finalCtx = channelHandlerContext;
                        this.val$promise = promise;
                    }

                    @Override
                    public void run() {
                        if (this.this$0.channel.isActive()) {
                            this.this$0.open0(this.val$finalCtx, (Promise<Http2StreamChannel>)this.val$promise);
                            return;
                        }
                        this.val$promise.setFailure((Throwable)new ClosedChannelException());
                    }
                });
            }
        }
        catch (Throwable cause) {
            void var2_3;
            promise.setFailure((Throwable)var2_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ChannelHandlerContext findCtx() throws ClosedChannelException {
        void var1_1;
        ChannelHandlerContext ctx = this.multiplexCtx;
        if (ctx != null && !ctx.isRemoved()) {
            return ctx;
        }
        ChannelPipeline pipeline = this.channel.pipeline();
        ctx = pipeline.context(Http2MultiplexCodec.class);
        if (ctx == null) {
            void var2_2;
            ctx = var2_2.context(Http2MultiplexHandler.class);
        }
        if (ctx == null) {
            if (this.channel.isActive()) {
                throw new IllegalStateException(StringUtil.simpleClassName(Http2MultiplexCodec.class) + " or " + StringUtil.simpleClassName(Http2MultiplexHandler.class) + " must be in the ChannelPipeline of Channel " + this.channel);
            }
            throw new ClosedChannelException();
        }
        this.multiplexCtx = ctx;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void open0(ChannelHandlerContext ctx, Promise<Http2StreamChannel> promise) {
        void var3_5;
        void var2_4;
        ChannelFuture channelFuture;
        Http2StreamChannel streamChannel;
        assert (ctx.executor().inEventLoop());
        if (!promise.setUncancellable()) {
            return;
        }
        try {
            streamChannel = ctx.handler() instanceof Http2MultiplexCodec ? ((Http2MultiplexCodec)ctx.handler()).newOutboundStream() : ((Http2MultiplexHandler)ctx.handler()).newOutboundStream();
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return;
        }
        try {
            this.init(streamChannel);
        }
        catch (Exception e) {
            void var1_3;
            streamChannel.unsafe().closeForcibly();
            promise.setFailure((Throwable)var1_3);
            return;
        }
        channelFuture = channelFuture.channel().eventLoop().register((Channel)streamChannel);
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(this, (Promise)var2_4, (Http2StreamChannel)var3_5){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ Http2StreamChannel val$streamChannel;
            final /* synthetic */ Http2StreamChannelBootstrap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = promise;
                this.val$streamChannel = http2StreamChannel;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) {
                void var1_1;
                if (future.isSuccess()) {
                    this.val$promise.setSuccess((Object)this.val$streamChannel);
                    return;
                }
                if (future.isCancelled()) {
                    this.val$promise.cancel(false);
                    return;
                }
                if (this.val$streamChannel.isRegistered()) {
                    this.val$streamChannel.close();
                } else {
                    this.val$streamChannel.unsafe().closeForcibly();
                }
                this.val$promise.setFailure(var1_1.cause());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void init(Channel channel) {
        void var1_1;
        void var2_3;
        Map<ChannelOption<?>, Object> map;
        ChannelPipeline p = channel.pipeline();
        ChannelHandler handler = this.handler;
        if (handler != null) {
            p.addLast(new ChannelHandler[]{map});
        }
        map = this.options;
        synchronized (map) {
            Map.Entry<ChannelOption<?>, Object>[] optionArray = this.options.entrySet().toArray(EMPTY_OPTION_ARRAY);
        }
        Http2StreamChannelBootstrap.setChannelOptions(channel, var2_3);
        Http2StreamChannelBootstrap.setAttributes((Channel)var1_1, this.attrs.entrySet().toArray(EMPTY_ATTRIBUTE_ARRAY));
    }

    private static void setChannelOptions(Channel channel, Map.Entry<ChannelOption<?>, Object>[] options) {
        Map.Entry<ChannelOption<?>, Object>[] entryArray = options;
        int n = options.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry<ChannelOption<?>, Object> e = entryArray[i];
            Http2StreamChannelBootstrap.setChannelOption(channel, e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setChannelOption(Channel channel, ChannelOption<?> option, Object value) {
        try {
            ChannelOption<?> opt = option;
            if (!channel.config().setOption(opt, value)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", option, (Object)channel);
            }
            return;
        }
        catch (Throwable t) {
            void var3_4;
            Channel channel2;
            void var2_2;
            void var1_1;
            logger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", new Object[]{var1_1, var2_2, channel2, var3_4});
            return;
        }
    }

    private static void setAttributes(Channel channel, Map.Entry<AttributeKey<?>, Object>[] options) {
        Map.Entry<AttributeKey<?>, Object>[] entryArray = options;
        int n = options.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry<AttributeKey<?>, Object> e = entryArray[i];
            AttributeKey<?> key = e.getKey();
            channel.attr(key).set(e.getValue());
        }
    }
}

