/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.collection.CharObjectHashMap;
import io.netty.util.internal.ObjectUtil;
import java.util.Map;

public final class Http2Settings
extends CharObjectHashMap<Long> {
    private static final int DEFAULT_CAPACITY = 13;
    private static final Long FALSE = 0L;
    private static final Long TRUE = 1L;

    public Http2Settings() {
        this(13);
    }

    /*
     * WARNING - void declaration
     */
    public Http2Settings(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2Settings(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Long put(char key, Long value) {
        void var2_2;
        void var1_1;
        Http2Settings.verifyStandardSetting(key, value);
        return (Long)super.put((char)var1_1, (Object)var2_2);
    }

    public final Long headerTableSize() {
        return (Long)this.get('\u0001');
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Settings headerTableSize(long value) {
        void var1_1;
        this.put('\u0001', (long)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Boolean pushEnabled() {
        void var1_1;
        Long value = (Long)this.get('\u0002');
        if (value == null) {
            return null;
        }
        return TRUE.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Settings pushEnabled(boolean enabled) {
        void var1_1;
        this.put('\u0002', var1_1 != false ? TRUE : FALSE);
        return this;
    }

    public final Long maxConcurrentStreams() {
        return (Long)this.get('\u0003');
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Settings maxConcurrentStreams(long value) {
        void var1_1;
        this.put('\u0003', (long)var1_1);
        return this;
    }

    public final Integer initialWindowSize() {
        return this.getIntValue('\u0004');
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Settings initialWindowSize(int value) {
        void var1_1;
        this.put('\u0004', (long)var1_1);
        return this;
    }

    public final Integer maxFrameSize() {
        return this.getIntValue('\u0005');
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Settings maxFrameSize(int value) {
        void var1_1;
        this.put('\u0005', (long)var1_1);
        return this;
    }

    public final Long maxHeaderListSize() {
        return (Long)this.get('\u0006');
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Settings maxHeaderListSize(long value) {
        void var1_1;
        this.put('\u0006', (long)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Settings copyFrom(Http2Settings settings) {
        void var1_1;
        this.clear();
        this.putAll((Map)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Integer getIntValue(char key) {
        void var1_2;
        Long value = (Long)this.get(key);
        if (value == null) {
            return null;
        }
        return var1_2.intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyStandardSetting(int key, Long value) {
        ObjectUtil.checkNotNull((Object)value, (String)"value");
        switch (key) {
            case 1: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting HEADER_TABLE_SIZE is invalid: " + value + ", expected [0" + ", 4294967295" + ']');
            }
            case 2: {
                if (value == 0L || value == 1L) break;
                throw new IllegalArgumentException("Setting ENABLE_PUSH is invalid: " + value + ", expected [0, 1]");
            }
            case 3: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting MAX_CONCURRENT_STREAMS is invalid: " + value + ", expected [0" + ", 4294967295" + ']');
            }
            case 4: {
                if (value >= 0L && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("Setting INITIAL_WINDOW_SIZE is invalid: " + value + ", expected [0" + ", 2147483647" + ']');
            }
            case 5: {
                if (Http2CodecUtil.isMaxFrameSizeValid(value.intValue())) break;
                throw new IllegalArgumentException("Setting MAX_FRAME_SIZE is invalid: " + value + ", expected [16384" + ", 16777215" + ']');
            }
            case 6: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting MAX_HEADER_LIST_SIZE is invalid: " + value + ", expected [0" + ", 4294967295" + ']');
            }
            default: {
                void var1_1;
                int n;
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Non-standard setting 0x" + Integer.toHexString(n) + " is invalid: " + var1_1 + ", expected unsigned 32-bit value");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final String keyToString(char key) {
        void var1_1;
        switch (key) {
            case '\u0001': {
                return "HEADER_TABLE_SIZE";
            }
            case '\u0002': {
                return "ENABLE_PUSH";
            }
            case '\u0003': {
                return "MAX_CONCURRENT_STREAMS";
            }
            case '\u0004': {
                return "INITIAL_WINDOW_SIZE";
            }
            case '\u0005': {
                return "MAX_FRAME_SIZE";
            }
            case '\u0006': {
                return "MAX_HEADER_LIST_SIZE";
            }
        }
        return "0x" + Integer.toHexString((int)var1_1);
    }

    public static Http2Settings defaultSettings() {
        return new Http2Settings().maxHeaderListSize(8192L);
    }
}

