/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Http2ServerUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodec {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ServerUpgradeCodec.class);
    private static final List<CharSequence> REQUIRED_UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler[] handlers;
    private final Http2FrameReader frameReader;
    private Http2Settings settings;

    /*
     * WARNING - void declaration
     */
    public Http2ServerUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this(null, (Http2ConnectionHandler)var1_1, EMPTY_HANDLERS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ServerUpgradeCodec(Http2MultiplexCodec http2Codec) {
        this(null, (Http2ConnectionHandler)var1_1, EMPTY_HANDLERS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ServerUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler) {
        this((String)var1_1, (Http2ConnectionHandler)var2_2, EMPTY_HANDLERS);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ServerUpgradeCodec(String handlerName, Http2MultiplexCodec http2Codec) {
        this((String)var1_1, (Http2ConnectionHandler)var2_2, EMPTY_HANDLERS);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ServerUpgradeCodec(Http2FrameCodec http2Codec, ChannelHandler ... handlers) {
        this(null, (Http2ConnectionHandler)var1_1, (ChannelHandler[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Http2ServerUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, ChannelHandler ... handlers) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.handlerName = var1_1;
        this.connectionHandler = var2_2;
        this.handlers = var3_3;
        this.frameReader = new DefaultHttp2FrameReader();
    }

    public Collection<CharSequence> requiredUpgradeHeaders() {
        return REQUIRED_UPGRADE_HEADERS;
    }

    /*
     * WARNING - void declaration
     */
    public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders headers) {
        try {
            void var1_1;
            List upgradeHeaders = upgradeRequest.headers().getAll(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
            if (upgradeHeaders.size() != 1) {
                throw new IllegalArgumentException("There must be 1 and only 1 " + Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER + " header.");
            }
            this.settings = this.decodeSettingsHeader((ChannelHandlerContext)var1_1, (CharSequence)upgradeHeaders.get(0));
            return true;
        }
        catch (Throwable cause) {
            void var2_3;
            logger.info("Error during upgrade to HTTP/2", (Throwable)var2_3);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
        try {
            ctx.pipeline().addAfter(ctx.name(), this.handlerName, (ChannelHandler)this.connectionHandler);
            if (this.handlers != null) {
                String name = ctx.pipeline().context((ChannelHandler)this.connectionHandler).name();
                for (int i = this.handlers.length - 1; i >= 0; --i) {
                    ctx.pipeline().addAfter(name, null, this.handlers[i]);
                }
            }
            this.connectionHandler.onHttpServerUpgrade(this.settings);
            return;
        }
        catch (Http2Exception e) {
            void var1_1;
            void var2_3;
            ctx.fireExceptionCaught((Throwable)var2_3);
            var1_1.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Http2Settings decodeSettingsHeader(ChannelHandlerContext ctx, CharSequence settingsHeader) throws Http2Exception {
        Http2Settings http2Settings;
        ByteBuf header = ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)CharBuffer.wrap(settingsHeader), (Charset)CharsetUtil.UTF_8);
        try {
            void var3_4;
            ByteBuf payload = Base64.decode((ByteBuf)header, (Base64Dialect)Base64Dialect.URL_SAFE);
            ByteBuf frame = Http2ServerUpgradeCodec.createSettingsFrame(ctx, payload);
            http2Settings = this.decodeSettings((ChannelHandlerContext)http2Settings, (ByteBuf)var3_4);
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.release();
            throw throwable;
        }
        header.release();
        return http2Settings;
    }

    /*
     * WARNING - void declaration
     */
    private Http2Settings decodeSettings(ChannelHandlerContext ctx, ByteBuf frame) throws Http2Exception {
        void var1_1;
        try {
            void var3_4;
            Http2Settings decodedSettings = new Http2Settings();
            this.frameReader.readFrame((ChannelHandlerContext)var1_1, frame, new Http2FrameAdapter(this, decodedSettings){
                final /* synthetic */ Http2Settings val$decodedSettings;
                final /* synthetic */ Http2ServerUpgradeCodec this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$decodedSettings = http2Settings;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
                    void var2_2;
                    this.val$decodedSettings.copyFrom((Http2Settings)var2_2);
                }
            });
            var1_1 = var3_4;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.release();
            throw throwable;
        }
        frame.release();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf createSettingsFrame(ChannelHandlerContext ctx, ByteBuf payload) {
        ChannelHandlerContext channelHandlerContext;
        void var1_1;
        ChannelHandlerContext frame = ctx.alloc().buffer(9 + payload.readableBytes());
        Http2CodecUtil.writeFrameHeader((ByteBuf)frame, payload.readableBytes(), (byte)4, new Http2Flags(), 0);
        frame.writeBytes(payload);
        var1_1.release();
        return channelHandlerContext;
    }
}

