/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.ObjectUtil;

public class Http2OutboundFrameLogger
implements Http2FrameWriter {
    private final Http2FrameWriter writer;
    private final Http2FrameLogger logger;

    /*
     * WARNING - void declaration
     */
    public Http2OutboundFrameLogger(Http2FrameWriter writer, Http2FrameLogger logger) {
        void var2_2;
        void var1_1;
        this.writer = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)var1_1, (String)"writer");
        this.logger = (Http2FrameLogger)((Object)ObjectUtil.checkNotNull((Object)var2_2, (String)"logger"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logData(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, data, padding, endStream);
        return this.writer.writeData((ChannelHandlerContext)var1_1, (int)var2_2, (ByteBuf)var3_3, padding, endStream, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, headers, padding, endStream);
        return this.writer.writeHeaders((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, padding, endStream, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
        return this.writer.writeHeaders((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, streamDependency, weight, exclusive, padding, endStream, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logPriority(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, streamDependency, weight, exclusive);
        return this.writer.writePriority((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, weight, exclusive, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logRstStream(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, errorCode);
        return this.writer.writeRstStream((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logSettings(Http2FrameLogger.Direction.OUTBOUND, ctx, settings);
        return this.writer.writeSettings((ChannelHandlerContext)var1_1, (Http2Settings)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        this.logger.logSettingsAck(Http2FrameLogger.Direction.OUTBOUND, ctx);
        return this.writer.writeSettingsAck((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (ack) {
            this.logger.logPingAck(Http2FrameLogger.Direction.OUTBOUND, ctx, data);
        } else {
            this.logger.logPing(Http2FrameLogger.Direction.OUTBOUND, ctx, data);
        }
        return this.writer.writePing((ChannelHandlerContext)var1_1, (boolean)var2_2, (long)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logPushPromise(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, promisedStreamId, headers, padding);
        return this.writer.writePushPromise((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, headers, padding, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logGoAway(Http2FrameLogger.Direction.OUTBOUND, ctx, lastStreamId, errorCode, debugData);
        return this.writer.writeGoAway((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, debugData, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logWindowsUpdate(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, windowSizeIncrement);
        return this.writer.writeWindowUpdate((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logUnknownFrame(Http2FrameLogger.Direction.OUTBOUND, ctx, frameType, streamId, flags, payload);
        return this.writer.writeFrame((ChannelHandlerContext)var1_1, (byte)var2_2, (int)var3_3, flags, payload, promise);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.writer.configuration();
    }
}

