/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2MultiplexActiveStreamsException;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.MaxCapacityQueue;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.net.ssl.SSLException;

public final class Http2MultiplexHandler
extends Http2ChannelDuplexHandler {
    static final ChannelFutureListener CHILD_CHANNEL_REGISTRATION_LISTENER = new ChannelFutureListener(){

        public final void operationComplete(ChannelFuture future) {
            Http2MultiplexHandler.registerDone(future);
        }
    };
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    private volatile ChannelHandlerContext ctx;

    /*
     * WARNING - void declaration
     */
    public Http2MultiplexHandler(ChannelHandler inboundStreamHandler) {
        this((ChannelHandler)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2MultiplexHandler(ChannelHandler inboundStreamHandler, ChannelHandler upgradeStreamHandler) {
        void var2_2;
        void var1_1;
        this.inboundStreamHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)var1_1, (String)"inboundStreamHandler");
        this.upgradeStreamHandler = var2_2;
    }

    static void registerDone(ChannelFuture future) {
        if (!future.isSuccess()) {
            ChannelFuture channelFuture;
            ChannelFuture childChannel = future.channel();
            if (childChannel.isRegistered()) {
                childChannel.close();
                return;
            }
            channelFuture.unsafe().closeForcibly();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void handlerAdded0(ChannelHandlerContext ctx) {
        void var1_1;
        if (ctx.executor() != ctx.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = var1_1;
    }

    @Override
    protected final void handlerRemoved0(ChannelHandlerContext ctx) {
        this.readCompletePendingQueue.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        this.parentReadInProgress = true;
        if (msg instanceof Http2StreamFrame) {
            if (msg instanceof Http2WindowUpdateFrame) {
                return;
            }
            Http2StreamFrame streamFrame = (Http2StreamFrame)msg;
            Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream = (Http2FrameCodec.DefaultHttp2FrameStream)streamFrame.stream();
            AbstractHttp2StreamChannel channel = (AbstractHttp2StreamChannel)defaultHttp2FrameStream.attachment;
            if (msg instanceof Http2ResetFrame || msg instanceof Http2PriorityFrame) {
                channel.pipeline().fireUserEventTriggered(msg);
                return;
            }
            ((AbstractHttp2StreamChannel)((Object)defaultHttp2FrameStream)).fireChildRead((Http2Frame)var1_1);
            return;
        }
        if (msg instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame((ChannelHandlerContext)var1_1, (Http2GoAwayFrame)msg);
        }
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (ctx.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        var1_1.fireChannelWritabilityChanged();
    }

    /*
     * WARNING - void declaration
     */
    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        void var1_1;
        void var2_2;
        if (evt instanceof Http2FrameStreamEvent) {
            Http2FrameStreamEvent event = (Http2FrameStreamEvent)evt;
            Http2FrameCodec.DefaultHttp2FrameStream stream = (Http2FrameCodec.DefaultHttp2FrameStream)event.stream();
            if (event.type() == Http2FrameStreamEvent.Type.State) {
                switch (stream.state()) {
                    case HALF_CLOSED_LOCAL: {
                        if (stream.id() != 1) break;
                    }
                    case HALF_CLOSED_REMOTE: 
                    case OPEN: {
                        Http2MultiplexHandlerStreamChannel ch;
                        if (stream.attachment != null) break;
                        if (stream.id() == 1 && !Http2MultiplexHandler.isServer(ctx)) {
                            if (this.upgradeStreamHandler == null) {
                                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
                            }
                            ch = new Http2MultiplexHandlerStreamChannel(stream, this.upgradeStreamHandler);
                            ch.closeOutbound();
                        } else {
                            ch = new Http2MultiplexHandlerStreamChannel(stream, this.inboundStreamHandler);
                        }
                        ChannelFuture future = ctx.channel().eventLoop().register((Channel)var2_2);
                        if (future.isDone()) {
                            Http2MultiplexHandler.registerDone(future);
                            return;
                        }
                        future.addListener((GenericFutureListener)CHILD_CHANNEL_REGISTRATION_LISTENER);
                        return;
                    }
                    case CLOSED: {
                        void var3_3;
                        AbstractHttp2StreamChannel channel = (AbstractHttp2StreamChannel)var3_3.attachment;
                        if (channel == null) break;
                        var1_1.streamClosed();
                    }
                }
            }
            return;
        }
        if (var2_2 == ChannelInputShutdownReadComplete.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_INPUT_SHUTDOWN_READ_COMPLETE_VISITOR);
        } else if (var2_2 == ChannelOutputShutdownEvent.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_OUTPUT_SHUTDOWN_EVENT_VISITOR);
        } else if (var2_2 == SslCloseCompletionEvent.SUCCESS) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.SSL_CLOSE_COMPLETION_EVENT_VISITOR);
        }
        var1_1.fireUserEventTriggered((Object)var2_2);
    }

    final Http2StreamChannel newOutboundStream() {
        Http2MultiplexHandler http2MultiplexHandler = this;
        return http2MultiplexHandler.new Http2MultiplexHandlerStreamChannel((Http2FrameCodec.DefaultHttp2FrameStream)http2MultiplexHandler.newStream(), null);
    }

    /*
     * WARNING - void declaration
     */
    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause2) throws Exception {
        void var2_2;
        void var1_1;
        if (cause2 instanceof Http2FrameStreamException) {
            Http2FrameStreamException exception = (Http2FrameStreamException)cause2;
            Http2FrameStream http2FrameStream = exception.stream();
            AbstractHttp2StreamChannel childChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)http2FrameStream).attachment;
            try {
                childChannel.pipeline().fireExceptionCaught(cause2.getCause());
                childChannel.closeWithError(exception.error());
                return;
            }
            catch (Throwable cause2) {
                ((AbstractHttp2StreamChannel)((Object)http2FrameStream)).closeWithError(var1_1.error());
                throw cause2;
            }
        }
        if (cause2 instanceof Http2MultiplexActiveStreamsException) {
            this.fireExceptionCaughtForActiveStream(cause2.getCause());
            return;
        }
        if (cause2.getCause() instanceof SSLException) {
            this.fireExceptionCaughtForActiveStream(cause2);
        }
        var1_1.fireExceptionCaught((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void fireExceptionCaughtForActiveStream(Throwable cause) throws Http2Exception {
        void var1_1;
        this.forEachActiveStream(new Http2FrameStreamVisitor(this, (Throwable)var1_1){
            final /* synthetic */ Throwable val$cause;
            final /* synthetic */ Http2MultiplexHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$cause = throwable;
            }

            @Override
            public boolean visit(Http2FrameStream stream) {
                AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream).attachment;
                abstractHttp2StreamChannel.pipeline().fireExceptionCaught(this.val$cause);
                return true;
            }
        });
    }

    private static boolean isServer(ChannelHandlerContext ctx) {
        return ctx.channel().parent() instanceof ServerChannel;
    }

    /*
     * WARNING - void declaration
     */
    private void onHttp2GoAwayFrame(ChannelHandlerContext ctx, Http2GoAwayFrame goAwayFrame) {
        if (goAwayFrame.lastStreamId() == Integer.MAX_VALUE) {
            return;
        }
        try {
            void var2_2;
            boolean server = Http2MultiplexHandler.isServer(ctx);
            this.forEachActiveStream(new Http2FrameStreamVisitor(this, (Http2GoAwayFrame)var2_2, server){
                final /* synthetic */ Http2GoAwayFrame val$goAwayFrame;
                final /* synthetic */ boolean val$server;
                final /* synthetic */ Http2MultiplexHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$goAwayFrame = http2GoAwayFrame;
                    this.val$server = bl;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean visit(Http2FrameStream stream) {
                    void var2_2;
                    int streamId = stream.id();
                    if (streamId > this.val$goAwayFrame.lastStreamId() && Http2CodecUtil.isStreamIdValid((int)var2_2, this.val$server)) {
                        AbstractHttp2StreamChannel abstractHttp2StreamChannel;
                        abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)((Object)abstractHttp2StreamChannel)).attachment;
                        abstractHttp2StreamChannel.pipeline().fireUserEventTriggered((Object)this.val$goAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
            return;
        }
        catch (Http2Exception e) {
            void var1_1;
            void var3_4;
            ctx.fireExceptionCaught((Throwable)var3_4);
            var1_1.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.processPendingReadCompleteQueue();
        var1_1.fireChannelReadComplete();
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        AbstractHttp2StreamChannel childChannel = this.readCompletePendingQueue.poll();
        if (childChannel != null) {
            try {
                do {
                    childChannel.fireChildReadComplete();
                } while ((childChannel = this.readCompletePendingQueue.poll()) != null);
            }
            finally {
                this.parentReadInProgress = false;
                this.readCompletePendingQueue.clear();
                this.ctx.flush();
            }
        } else {
            this.parentReadInProgress = false;
        }
    }

    private final class Http2MultiplexHandlerStreamChannel
    extends AbstractHttp2StreamChannel {
        /*
         * WARNING - void declaration
         */
        Http2MultiplexHandlerStreamChannel(Http2FrameCodec.DefaultHttp2FrameStream stream, ChannelHandler inboundHandler) {
            void var3_3;
            void var2_2;
            super((Http2FrameCodec.DefaultHttp2FrameStream)var2_2, ++Http2MultiplexHandler.this.idCount, (ChannelHandler)var3_3);
        }

        @Override
        protected final boolean isParentReadInProgress() {
            return Http2MultiplexHandler.this.parentReadInProgress;
        }

        @Override
        protected final void addChannelToReadCompletePendingQueue() {
            while (!Http2MultiplexHandler.this.readCompletePendingQueue.offer(this)) {
                Http2MultiplexHandler.this.processPendingReadCompleteQueue();
            }
        }

        @Override
        protected final ChannelHandlerContext parentContext() {
            return Http2MultiplexHandler.this.ctx;
        }
    }
}

