/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.MaxCapacityQueue;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayDeque;
import java.util.Queue;

@Deprecated
public class Http2MultiplexCodec
extends Http2FrameCodec {
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    volatile ChannelHandlerContext ctx;

    /*
     * WARNING - void declaration
     */
    Http2MultiplexCodec(Http2ConnectionEncoder encoder, Http2ConnectionDecoder decoder, Http2Settings initialSettings, ChannelHandler inboundStreamHandler, ChannelHandler upgradeStreamHandler, boolean decoupleCloseAndGoAway, boolean flushPreface) {
        super((Http2ConnectionEncoder)var1_1, (Http2ConnectionDecoder)var2_2, (Http2Settings)var3_3, decoupleCloseAndGoAway, flushPreface);
        void var3_3;
        void var2_2;
        void var1_1;
        this.inboundStreamHandler = inboundStreamHandler;
        this.upgradeStreamHandler = upgradeStreamHandler;
    }

    @Override
    public void onHttpClientUpgrade() throws Http2Exception {
        if (this.upgradeStreamHandler == null) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
        }
        super.onHttpClientUpgrade();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (ctx.executor() != ctx.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        super.handlerRemoved0((ChannelHandlerContext)var1_1);
        this.readCompletePendingQueue.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void onHttp2Frame(ChannelHandlerContext ctx, Http2Frame frame) {
        void var2_2;
        void var1_1;
        if (frame instanceof Http2StreamFrame) {
            Http2StreamFrame msg = (Http2StreamFrame)frame;
            frame = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)msg.stream()).attachment;
            ((AbstractHttp2StreamChannel)frame).fireChildRead((Http2Frame)var1_1);
            return;
        }
        if (frame instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame((ChannelHandlerContext)var1_1, (Http2GoAwayFrame)frame);
        }
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void onHttp2StreamStateChanged(ChannelHandlerContext ctx, Http2FrameCodec.DefaultHttp2FrameStream stream) {
        switch (stream.state()) {
            case HALF_CLOSED_LOCAL: {
                if (stream.id() != 1) break;
            }
            case HALF_CLOSED_REMOTE: 
            case OPEN: {
                void var2_2;
                Http2MultiplexCodecStreamChannel streamChannel;
                if (stream.attachment != null) break;
                if (stream.id() == 1 && !this.connection().isServer()) {
                    assert (this.upgradeStreamHandler != null);
                    streamChannel = new Http2MultiplexCodecStreamChannel(stream, this.upgradeStreamHandler);
                    streamChannel.closeOutbound();
                } else {
                    streamChannel = new Http2MultiplexCodecStreamChannel((Http2FrameCodec.DefaultHttp2FrameStream)((Object)streamChannel), this.inboundStreamHandler);
                }
                ChannelFuture future = ctx.channel().eventLoop().register((Channel)var2_2);
                if (future.isDone()) {
                    Http2MultiplexHandler.registerDone(future);
                    return;
                }
                future.addListener((GenericFutureListener)Http2MultiplexHandler.CHILD_CHANNEL_REGISTRATION_LISTENER);
                return;
            }
            case CLOSED: {
                void var1_1;
                void var2_2;
                AbstractHttp2StreamChannel channel = (AbstractHttp2StreamChannel)var2_2.attachment;
                if (channel == null) break;
                var1_1.streamClosed();
            }
        }
    }

    final Http2StreamChannel newOutboundStream() {
        Http2MultiplexCodec http2MultiplexCodec = this;
        return http2MultiplexCodec.new Http2MultiplexCodecStreamChannel(http2MultiplexCodec.newStream(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void onHttp2FrameStreamException(ChannelHandlerContext ctx, Http2FrameStreamException cause) {
        ctx = cause.stream();
        AbstractHttp2StreamChannel channel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)ctx).attachment;
        try {
            channel.pipeline().fireExceptionCaught(cause.getCause());
            channel.closeWithError(cause.error());
            return;
        }
        catch (Throwable throwable) {
            void var2_2;
            void var1_1;
            var1_1.closeWithError(var2_2.error());
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onHttp2GoAwayFrame(ChannelHandlerContext ctx, Http2GoAwayFrame goAwayFrame) {
        if (goAwayFrame.lastStreamId() == Integer.MAX_VALUE) {
            return;
        }
        try {
            this.forEachActiveStream(new Http2FrameStreamVisitor(this, goAwayFrame){
                final /* synthetic */ Http2GoAwayFrame val$goAwayFrame;
                final /* synthetic */ Http2MultiplexCodec this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$goAwayFrame = http2GoAwayFrame;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean visit(Http2FrameStream stream) {
                    void var2_2;
                    int streamId = stream.id();
                    AbstractHttp2StreamChannel channel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream).attachment;
                    if (streamId > this.val$goAwayFrame.lastStreamId() && this.this$0.connection().local().isValidStreamId((int)var2_2)) {
                        void var1_1;
                        var1_1.pipeline().fireUserEventTriggered((Object)this.val$goAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
            return;
        }
        catch (Http2Exception e) {
            void var1_1;
            void var2_3;
            ctx.fireExceptionCaught((Throwable)var2_3);
            var1_1.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.processPendingReadCompleteQueue();
        this.channelReadComplete0((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        try {
            AbstractHttp2StreamChannel childChannel;
            while ((childChannel = this.readCompletePendingQueue.poll()) != null) {
                void var1_1;
                var1_1.fireChildReadComplete();
            }
            this.parentReadInProgress = false;
        }
        catch (Throwable throwable) {
            this.parentReadInProgress = false;
            this.readCompletePendingQueue.clear();
            Http2MultiplexCodec http2MultiplexCodec = this;
            http2MultiplexCodec.flush0(http2MultiplexCodec.ctx);
            throw throwable;
        }
        this.readCompletePendingQueue.clear();
        Http2MultiplexCodec http2MultiplexCodec = this;
        http2MultiplexCodec.flush0(http2MultiplexCodec.ctx);
    }

    /*
     * WARNING - void declaration
     */
    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        this.parentReadInProgress = true;
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (ctx.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        super.channelWritabilityChanged((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void onUserEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        void var2_2;
        void var1_1;
        if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_INPUT_SHUTDOWN_READ_COMPLETE_VISITOR);
        } else if (evt == ChannelOutputShutdownEvent.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_OUTPUT_SHUTDOWN_EVENT_VISITOR);
        } else if (evt == SslCloseCompletionEvent.SUCCESS) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.SSL_CLOSE_COMPLETION_EVENT_VISITOR);
        }
        super.onUserEventTriggered((ChannelHandlerContext)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void flush0(ChannelHandlerContext ctx) {
        void var1_1;
        this.flush((ChannelHandlerContext)var1_1);
    }

    private final class Http2MultiplexCodecStreamChannel
    extends AbstractHttp2StreamChannel {
        /*
         * WARNING - void declaration
         */
        Http2MultiplexCodecStreamChannel(Http2FrameCodec.DefaultHttp2FrameStream stream, ChannelHandler inboundHandler) {
            void var3_3;
            void var2_2;
            super((Http2FrameCodec.DefaultHttp2FrameStream)var2_2, ++Http2MultiplexCodec.this.idCount, (ChannelHandler)var3_3);
        }

        @Override
        protected final boolean isParentReadInProgress() {
            return Http2MultiplexCodec.this.parentReadInProgress;
        }

        @Override
        protected final void addChannelToReadCompletePendingQueue() {
            while (!Http2MultiplexCodec.this.readCompletePendingQueue.offer(this)) {
                Http2MultiplexCodec.this.processPendingReadCompleteQueue();
            }
        }

        @Override
        protected final ChannelHandlerContext parentContext() {
            return Http2MultiplexCodec.this.ctx;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final ChannelFuture write0(ChannelHandlerContext ctx, Object msg) {
            void var3_3;
            void var2_2;
            void var1_1;
            ChannelPromise promise = ctx.newPromise();
            ((Http2ConnectionHandler)Http2MultiplexCodec.this).write((ChannelHandlerContext)var1_1, var2_2, promise);
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void flush0(ChannelHandlerContext ctx) {
            void var1_1;
            Http2MultiplexCodec.this.flush0((ChannelHandlerContext)var1_1);
        }
    }
}

