/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;

public interface Http2Headers
extends Headers<CharSequence, CharSequence, Http2Headers> {
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator();

    public Iterator<CharSequence> valueIterator(CharSequence var1);

    public Http2Headers method(CharSequence var1);

    public Http2Headers scheme(CharSequence var1);

    public Http2Headers authority(CharSequence var1);

    public Http2Headers path(CharSequence var1);

    public Http2Headers status(CharSequence var1);

    public CharSequence method();

    public CharSequence scheme();

    public CharSequence authority();

    public CharSequence path();

    public CharSequence status();

    public boolean contains(CharSequence var1, CharSequence var2, boolean var3);

    public static enum PseudoHeaderName {
        METHOD(":method", true),
        SCHEME(":scheme", true),
        AUTHORITY(":authority", true),
        PATH(":path", true),
        STATUS(":status", false),
        PROTOCOL(":protocol", true);

        private static final char PSEUDO_HEADER_PREFIX = ':';
        private static final byte PSEUDO_HEADER_PREFIX_BYTE = 58;
        private final AsciiString value;
        private final boolean requestOnly;

        /*
         * WARNING - void declaration
         */
        private PseudoHeaderName(String value, boolean requestOnly) {
            void var3_3;
            this.value = AsciiString.cached((String)var3_3);
            this.requestOnly = requestOnly;
        }

        public final AsciiString value() {
            return this.value;
        }

        public static boolean hasPseudoHeaderFormat(CharSequence headerName) {
            CharSequence charSequence;
            if (headerName instanceof AsciiString) {
                CharSequence asciiHeaderName = (AsciiString)headerName;
                return asciiHeaderName.length() > 0 && charSequence.byteAt(0) == 58;
            }
            return charSequence.length() > 0 && charSequence.charAt(0) == ':';
        }

        public static boolean isPseudoHeader(CharSequence header) {
            return PseudoHeaderName.getPseudoHeader(header) != null;
        }

        public static boolean isPseudoHeader(AsciiString header) {
            return PseudoHeaderName.getPseudoHeader(header) != null;
        }

        public static boolean isPseudoHeader(String header) {
            return PseudoHeaderName.getPseudoHeader(header) != null;
        }

        public static PseudoHeaderName getPseudoHeader(CharSequence header) {
            CharSequence charSequence;
            if (header instanceof AsciiString) {
                return PseudoHeaderName.getPseudoHeader((AsciiString)header);
            }
            return PseudoHeaderName.getPseudoHeaderName(charSequence);
        }

        /*
         * WARNING - void declaration
         */
        private static PseudoHeaderName getPseudoHeaderName(CharSequence header) {
            int length = header.length();
            if (length > 0 && header.charAt(0) == ':') {
                void var1_1;
                switch (var1_1) {
                    case 5: {
                        if (":path".contentEquals(header)) {
                            return PATH;
                        }
                        return null;
                    }
                    case 7: {
                        if (":method" == header) {
                            return METHOD;
                        }
                        if (":scheme" == header) {
                            return SCHEME;
                        }
                        if (":status" == header) {
                            return STATUS;
                        }
                        if (":method".contentEquals(header)) {
                            return METHOD;
                        }
                        if (":scheme".contentEquals(header)) {
                            return SCHEME;
                        }
                        if (":status".contentEquals(header)) {
                            return STATUS;
                        }
                        return null;
                    }
                    case 9: {
                        if (":protocol".contentEquals(header)) {
                            return PROTOCOL;
                        }
                        return null;
                    }
                    case 10: {
                        CharSequence charSequence;
                        if (":authority".contentEquals(charSequence)) {
                            return AUTHORITY;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public static PseudoHeaderName getPseudoHeader(AsciiString header) {
            int length = header.length();
            if (length > 0 && header.charAt(0) == ':') {
                void var1_1;
                switch (var1_1) {
                    case 5: {
                        if (PATH.value().equals((Object)header)) {
                            return PATH;
                        }
                        return null;
                    }
                    case 7: {
                        if (header == METHOD.value()) {
                            return METHOD;
                        }
                        if (header == SCHEME.value()) {
                            return SCHEME;
                        }
                        if (header == STATUS.value()) {
                            return STATUS;
                        }
                        if (METHOD.value().equals((Object)header)) {
                            return METHOD;
                        }
                        if (SCHEME.value().equals((Object)header)) {
                            return SCHEME;
                        }
                        if (STATUS.value().equals((Object)header)) {
                            return STATUS;
                        }
                        return null;
                    }
                    case 9: {
                        if (PROTOCOL.value().equals((Object)header)) {
                            return PROTOCOL;
                        }
                        return null;
                    }
                    case 10: {
                        AsciiString asciiString;
                        if (AUTHORITY.value().equals((Object)asciiString)) {
                            return AUTHORITY;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        public final boolean isRequestOnly() {
            return this.requestOnly;
        }
    }
}

