/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameLogger
extends ChannelHandlerAdapter {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final InternalLogger logger;
    private final InternalLogLevel level;

    /*
     * WARNING - void declaration
     */
    public Http2FrameLogger(LogLevel level) {
        this(Http2FrameLogger.checkAndConvertLevel((LogLevel)var1_1), InternalLoggerFactory.getInstance(Http2FrameLogger.class));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2FrameLogger(LogLevel level, String name) {
        this(Http2FrameLogger.checkAndConvertLevel((LogLevel)var1_1), InternalLoggerFactory.getInstance((String)((String)ObjectUtil.checkNotNull((Object)var2_2, (String)"name"))));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2FrameLogger(LogLevel level, Class<?> clazz) {
        this(Http2FrameLogger.checkAndConvertLevel((LogLevel)var1_1), InternalLoggerFactory.getInstance((Class)((Class)ObjectUtil.checkNotNull((Object)var2_2, (String)"clazz"))));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Http2FrameLogger(InternalLogLevel level, InternalLogger logger) {
        void var2_2;
        void var1_1;
        this.level = var1_1;
        this.logger = var2_2;
    }

    private static InternalLogLevel checkAndConvertLevel(LogLevel level) {
        return ((LogLevel)ObjectUtil.checkNotNull((Object)level, (String)"level")).toInternalLevel();
    }

    public boolean isEnabled() {
        return this.logger.isEnabled(this.level);
    }

    /*
     * WARNING - void declaration
     */
    public void logData(Direction direction, ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} DATA: streamId={} padding={} endStream={} length={} bytes={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, padding, endStream, data.readableBytes(), this.toString(data)});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logHeaders(Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} padding={} endStream={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, headers, padding, endStream});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logHeaders(Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} streamDependency={} weight={} exclusive={} padding={} endStream={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, headers, streamDependency, weight, exclusive, padding, endStream});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logPriority(Direction direction, ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} PRIORITY: streamId={} streamDependency={} weight={} exclusive={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, streamDependency, weight, exclusive});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logRstStream(Direction direction, ChannelHandlerContext ctx, int streamId, long errorCode) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} RST_STREAM: streamId={} errorCode={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, errorCode});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logSettingsAck(Direction direction, ChannelHandlerContext ctx) {
        void var1_1;
        void var2_2;
        this.logger.log(this.level, "{} {} SETTINGS: ack=true", (Object)var2_2.channel(), (Object)var1_1.name());
    }

    /*
     * WARNING - void declaration
     */
    public void logSettings(Direction direction, ChannelHandlerContext ctx, Http2Settings settings) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} SETTINGS: ack=false settings={}", new Object[]{var2_2.channel(), var1_1.name(), var3_3});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logPing(Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} PING: ack=false bytes={}", new Object[]{var2_2.channel(), var1_1.name(), (long)var3_3});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logPingAck(Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} PING: ack=true bytes={}", new Object[]{var2_2.channel(), var1_1.name(), (long)var3_3});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logPushPromise(Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} PUSH_PROMISE: streamId={} promisedStreamId={} headers={} padding={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, promisedStreamId, headers, padding});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logGoAway(Direction direction, ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} GO_AWAY: lastStreamId={} errorCode={} length={} bytes={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, errorCode, debugData.readableBytes(), this.toString(debugData)});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logWindowsUpdate(Direction direction, ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} WINDOW_UPDATE: streamId={} windowSizeIncrement={}", new Object[]{var2_2.channel(), var1_1.name(), (int)var3_3, windowSizeIncrement});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logUnknownFrame(Direction direction, ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf data) {
        if (this.isEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.logger.log(this.level, "{} {} UNKNOWN: frameType={} streamId={} flags={} length={} bytes={}", new Object[]{var2_2.channel(), var1_1.name(), var3_3 & 0xFF, streamId, flags.value(), data.readableBytes(), this.toString(data)});
        }
    }

    /*
     * WARNING - void declaration
     */
    private String toString(ByteBuf buf) {
        void var2_2;
        void var1_1;
        if (this.level == InternalLogLevel.TRACE || buf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump((ByteBuf)buf);
        }
        int length = Math.min(buf.readableBytes(), 64);
        void v0 = var1_1;
        return ByteBufUtil.hexDump((ByteBuf)v0, (int)v0.readerIndex(), (int)var2_2) + "...";
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

