/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2EmptyDataFrameConnectionDecoder;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.internal.ObjectUtil;

public class Http2FrameCodecBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2FrameCodec, Http2FrameCodecBuilder> {
    private Http2FrameWriter frameWriter;

    protected Http2FrameCodecBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    Http2FrameCodecBuilder(boolean server) {
        void var1_1;
        this.server((boolean)var1_1);
        this.gracefulShutdownTimeoutMillis(0L);
    }

    public static Http2FrameCodecBuilder forClient() {
        return new Http2FrameCodecBuilder(false);
    }

    public static Http2FrameCodecBuilder forServer() {
        return new Http2FrameCodecBuilder(true);
    }

    /*
     * WARNING - void declaration
     */
    Http2FrameCodecBuilder frameWriter(Http2FrameWriter frameWriter) {
        void var1_1;
        this.frameWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)var1_1, (String)"frameWriter");
        return this;
    }

    @Override
    public Http2Settings initialSettings() {
        return super.initialSettings();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder initialSettings(Http2Settings settings) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.initialSettings((Http2Settings)var1_1);
    }

    @Override
    public long gracefulShutdownTimeoutMillis() {
        return super.gracefulShutdownTimeoutMillis();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.gracefulShutdownTimeoutMillis((long)var1_1);
    }

    @Override
    public boolean isServer() {
        return super.isServer();
    }

    @Override
    public int maxReservedStreams() {
        return super.maxReservedStreams();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder maxReservedStreams(int maxReservedStreams) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.maxReservedStreams((int)var1_1);
    }

    @Override
    public boolean isValidateHeaders() {
        return super.isValidateHeaders();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder validateHeaders(boolean validateHeaders) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.validateHeaders((boolean)var1_1);
    }

    @Override
    public Http2FrameLogger frameLogger() {
        return super.frameLogger();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder frameLogger(Http2FrameLogger frameLogger) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.frameLogger((Http2FrameLogger)var1_1);
    }

    @Override
    public boolean encoderEnforceMaxConcurrentStreams() {
        return super.encoderEnforceMaxConcurrentStreams();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder encoderEnforceMaxConcurrentStreams(boolean encoderEnforceMaxConcurrentStreams) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.encoderEnforceMaxConcurrentStreams((boolean)var1_1);
    }

    @Override
    public int encoderEnforceMaxQueuedControlFrames() {
        return super.encoderEnforceMaxQueuedControlFrames();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder encoderEnforceMaxQueuedControlFrames(int maxQueuedControlFrames) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.encoderEnforceMaxQueuedControlFrames((int)var1_1);
    }

    @Override
    public Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector() {
        return super.headerSensitivityDetector();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder headerSensitivityDetector(Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.headerSensitivityDetector((Http2HeadersEncoder.SensitivityDetector)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder encoderIgnoreMaxHeaderListSize(boolean ignoreMaxHeaderListSize) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.encoderIgnoreMaxHeaderListSize((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public Http2FrameCodecBuilder initialHuffmanDecodeCapacity(int initialHuffmanDecodeCapacity) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.initialHuffmanDecodeCapacity((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder autoAckSettingsFrame(boolean autoAckSettings) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.autoAckSettingsFrame((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder autoAckPingFrame(boolean autoAckPingFrame) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.autoAckPingFrame((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder decoupleCloseAndGoAway(boolean decoupleCloseAndGoAway) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.decoupleCloseAndGoAway((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder flushPreface(boolean flushPreface) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.flushPreface((boolean)var1_1);
    }

    @Override
    public int decoderEnforceMaxConsecutiveEmptyDataFrames() {
        return super.decoderEnforceMaxConsecutiveEmptyDataFrames();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder decoderEnforceMaxConsecutiveEmptyDataFrames(int maxConsecutiveEmptyFrames) {
        void var1_1;
        return (Http2FrameCodecBuilder)super.decoderEnforceMaxConsecutiveEmptyDataFrames((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodecBuilder decoderEnforceMaxRstFramesPerWindow(int maxRstFramesPerWindow, int secondsPerWindow) {
        void var2_2;
        void var1_1;
        return (Http2FrameCodecBuilder)super.decoderEnforceMaxRstFramesPerWindow((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2FrameCodec build() {
        Http2FrameWriter frameWriter = this.frameWriter;
        if (frameWriter != null) {
            void var1_1;
            void var2_2;
            DefaultHttp2Connection connection = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
            Long maxHeaderListSize = this.initialSettings().maxHeaderListSize();
            Http2FrameReader frameReader = new DefaultHttp2FrameReader(maxHeaderListSize == null ? new DefaultHttp2HeadersDecoder(this.isValidateHeaders()) : new DefaultHttp2HeadersDecoder(this.isValidateHeaders(), maxHeaderListSize));
            if (this.frameLogger() != null) {
                frameWriter = new Http2OutboundFrameLogger(frameWriter, this.frameLogger());
                frameReader = new Http2InboundFrameLogger(frameReader, this.frameLogger());
            }
            Http2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(connection, frameWriter);
            if (this.encoderEnforceMaxConcurrentStreams()) {
                encoder = new StreamBufferingEncoder(encoder);
            }
            Http2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(connection, encoder, frameReader, this.promisedRequestVerifier(), this.isAutoAckSettingsFrame(), this.isAutoAckPingFrame(), this.isValidateHeaders());
            int maxConsecutiveEmptyDataFrames = this.decoderEnforceMaxConsecutiveEmptyDataFrames();
            if (maxConsecutiveEmptyDataFrames > 0) {
                void var3_4;
                decoder = new Http2EmptyDataFrameConnectionDecoder(decoder, (int)var3_4);
            }
            return this.build((Http2ConnectionDecoder)var2_2, (Http2ConnectionEncoder)var1_1, this.initialSettings());
        }
        return (Http2FrameCodec)super.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Http2FrameCodec build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        void var1_1;
        void var3_3;
        void var2_2;
        Http2FrameCodec codec = new Http2FrameCodec((Http2ConnectionEncoder)var2_2, decoder, (Http2Settings)var3_3, this.decoupleCloseAndGoAway(), this.flushPreface());
        codec.gracefulShutdownTimeoutMillis(this.gracefulShutdownTimeoutMillis());
        return var1_1;
    }
}

