/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.DefaultHttp2PriorityFrame;
import io.netty.handler.codec.http2.DefaultHttp2PushPromiseFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.DefaultHttp2UnknownFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.Http2UnknownFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameCodec
extends Http2ConnectionHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Http2FrameCodec.class);
    private static final Class<?>[] SUPPORTED_MESSAGES = new Class[]{Http2DataFrame.class, Http2HeadersFrame.class, Http2WindowUpdateFrame.class, Http2ResetFrame.class, Http2PingFrame.class, Http2SettingsFrame.class, Http2SettingsAckFrame.class, Http2GoAwayFrame.class, Http2PushPromiseFrame.class, Http2PriorityFrame.class, Http2UnknownFrame.class};
    protected final Http2Connection.PropertyKey streamKey;
    private final Http2Connection.PropertyKey upgradeKey;
    private final Integer initialFlowControlWindowSize;
    ChannelHandlerContext ctx;
    private int numBufferedStreams;
    private final IntObjectMap<DefaultHttp2FrameStream> frameStreamToInitializeMap = new IntObjectHashMap(8);

    /*
     * WARNING - void declaration
     */
    Http2FrameCodec(Http2ConnectionEncoder encoder, Http2ConnectionDecoder decoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway, boolean flushPreface) {
        super(decoder, (Http2ConnectionEncoder)var1_1, initialSettings, decoupleCloseAndGoAway, flushPreface);
        void var3_3;
        void var2_2;
        void var1_1;
        var2_2.frameListener(new FrameListener());
        this.connection().addListener(new ConnectionListener());
        this.connection().remote().flowController().listener(new Http2RemoteFlowControllerListener());
        this.streamKey = this.connection().newKey();
        this.upgradeKey = this.connection().newKey();
        this.initialFlowControlWindowSize = var3_3.initialWindowSize();
    }

    DefaultHttp2FrameStream newStream() {
        return new DefaultHttp2FrameStream();
    }

    /*
     * WARNING - void declaration
     */
    final void forEachActiveStream(Http2FrameStreamVisitor streamVisitor) throws Http2Exception {
        assert (this.ctx.executor().inEventLoop());
        if (this.connection().numActiveStreams() > 0) {
            void var1_1;
            this.connection().forEachActiveStream(new Http2StreamVisitor(this, (Http2FrameStreamVisitor)var1_1){
                final /* synthetic */ Http2FrameStreamVisitor val$streamVisitor;
                final /* synthetic */ Http2FrameCodec this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$streamVisitor = http2FrameStreamVisitor;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean visit(Http2Stream stream) {
                    try {
                        return this.val$streamVisitor.visit((Http2FrameStream)stream.getProperty(this.this$0.streamKey));
                    }
                    catch (Throwable cause) {
                        void var1_2;
                        this.this$0.onError(this.this$0.ctx, false, (Throwable)var1_2);
                        return false;
                    }
                }
            });
        }
    }

    int numInitializingStreams() {
        return this.frameStreamToInitializeMap.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.handlerAdded(ctx);
        this.handlerAdded0(ctx);
        Http2Connection connection = this.connection();
        if (connection.isServer()) {
            void var1_1;
            this.tryExpandConnectionFlowControlWindow((Http2Connection)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryExpandConnectionFlowControlWindow(Http2Connection connection) throws Http2Exception {
        if (this.initialFlowControlWindowSize != null) {
            Http2Stream connectionStream = connection.connectionStream();
            Http2LocalFlowController localFlowController = connection.local().flowController();
            int delta = this.initialFlowControlWindowSize - localFlowController.initialWindowSize(connectionStream);
            if (delta > 0) {
                void var3_3;
                void var2_2;
                void var1_1;
                var1_1.incrementWindowSize((Http2Stream)var2_2, Math.max(delta << 1, (int)var3_3));
                Http2FrameCodec http2FrameCodec = this;
                http2FrameCodec.flush(http2FrameCodec.ctx);
            }
        }
    }

    void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    public final void userEventTriggered(ChannelHandlerContext ctx22, Object evt) throws Exception {
        block5: {
            void var1_1;
            ChannelHandlerContext ctx22;
            void var2_3;
            block4: {
                if (evt == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
                    Http2FrameCodec http2FrameCodec = this;
                    http2FrameCodec.tryExpandConnectionFlowControlWindow(http2FrameCodec.connection());
                    ctx22.executor().execute(new Runnable(this, ctx22, evt){
                        final /* synthetic */ ChannelHandlerContext val$ctx;
                        final /* synthetic */ Object val$evt;
                        final /* synthetic */ Http2FrameCodec this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$ctx = channelHandlerContext;
                            this.val$evt = object;
                        }

                        @Override
                        public void run() {
                            this.val$ctx.fireUserEventTriggered(this.val$evt);
                        }
                    });
                    return;
                }
                if (!(evt instanceof HttpServerUpgradeHandler.UpgradeEvent)) break block4;
                HttpServerUpgradeHandler.UpgradeEvent upgrade = (HttpServerUpgradeHandler.UpgradeEvent)evt;
                try {
                    void var3_4;
                    this.onUpgradeEvent(ctx22, upgrade.retain());
                    Http2Stream stream = this.connection().stream(1);
                    if (stream.getProperty(this.streamKey) == null) {
                        this.onStreamActive0(stream);
                    }
                    upgrade.upgradeRequest().headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 1);
                    var3_4.setProperty(this.upgradeKey, Boolean.TRUE);
                    InboundHttpToHttp2Adapter.handle(ctx22, this.connection(), this.decoder().frameListener(), (FullHttpMessage)upgrade.upgradeRequest().retain());
                }
                catch (Throwable ctx22) {
                    var2_3.release();
                    throw ctx22;
                }
                upgrade.release();
                break block5;
            }
            this.onUserEventTriggered(ctx22, var2_3);
            var1_1.fireUserEventTriggered((Object)var2_3);
        }
    }

    void onUserEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        void var2_3;
        Http2PriorityFrame priorityFrame;
        Http2PushPromiseFrame pushPromiseFrame;
        void var1_1;
        Http2ResetFrame rstFrame;
        Http2Frame frame;
        Http2DataFrame dataFrame;
        if (msg instanceof Http2DataFrame) {
            dataFrame = (Http2DataFrame)msg;
            this.encoder().writeData(ctx, dataFrame.stream().id(), dataFrame.content(), dataFrame.padding(), dataFrame.isEndStream(), promise);
            return;
        }
        if (dataFrame instanceof Http2HeadersFrame) {
            this.writeHeadersFrame(ctx, (Http2HeadersFrame)((Object)dataFrame), promise);
            return;
        }
        if (dataFrame instanceof Http2WindowUpdateFrame) {
            frame = (Http2WindowUpdateFrame)((Object)dataFrame);
            Http2FrameStream frameStream = frame.stream();
            try {
                if (frameStream == null) {
                    this.increaseInitialConnectionWindow(frame.windowSizeIncrement());
                } else {
                    this.consumeBytes(frameStream.id(), frame.windowSizeIncrement());
                }
                promise.setSuccess();
                return;
            }
            catch (Throwable t) {
                void var1_2;
                promise.setFailure((Throwable)var1_2);
                return;
            }
        }
        if (frame instanceof Http2ResetFrame) {
            rstFrame = (Http2ResetFrame)frame;
            int id = rstFrame.stream().id();
            if (this.connection().streamMayHaveExisted(id)) {
                this.encoder().writeRstStream((ChannelHandlerContext)var1_1, rstFrame.stream().id(), rstFrame.errorCode(), promise);
                return;
            }
            ReferenceCountUtil.release((Object)rstFrame);
            promise.setFailure((Throwable)Http2Exception.streamError(rstFrame.stream().id(), Http2Error.PROTOCOL_ERROR, "Stream never existed", new Object[0]));
            return;
        }
        if (rstFrame instanceof Http2PingFrame) {
            frame = (Http2PingFrame)((Object)rstFrame);
            this.encoder().writePing((ChannelHandlerContext)var1_1, frame.ack(), frame.content(), promise);
            return;
        }
        if (frame instanceof Http2SettingsFrame) {
            this.encoder().writeSettings((ChannelHandlerContext)var1_1, ((Http2SettingsFrame)frame).settings(), promise);
            return;
        }
        if (frame instanceof Http2SettingsAckFrame) {
            this.encoder().writeSettingsAck((ChannelHandlerContext)var1_1, promise);
            return;
        }
        if (frame instanceof Http2GoAwayFrame) {
            this.writeGoAwayFrame((ChannelHandlerContext)var1_1, (Http2GoAwayFrame)frame, promise);
            return;
        }
        if (frame instanceof Http2PushPromiseFrame) {
            pushPromiseFrame = (Http2PushPromiseFrame)frame;
            this.writePushPromise((ChannelHandlerContext)var1_1, pushPromiseFrame, promise);
            return;
        }
        if (pushPromiseFrame instanceof Http2PriorityFrame) {
            priorityFrame = (Http2PriorityFrame)((Object)pushPromiseFrame);
            this.encoder().writePriority((ChannelHandlerContext)var1_1, priorityFrame.stream().id(), priorityFrame.streamDependency(), priorityFrame.weight(), priorityFrame.exclusive(), promise);
            return;
        }
        if (priorityFrame instanceof Http2UnknownFrame) {
            Http2UnknownFrame unknownFrame = (Http2UnknownFrame)((Object)priorityFrame);
            this.encoder().writeFrame((ChannelHandlerContext)var1_1, unknownFrame.frameType(), unknownFrame.stream().id(), unknownFrame.flags(), var2_3.content(), promise);
            return;
        }
        if (!(var2_3 instanceof Http2Frame)) {
            void var3_4;
            var1_1.write((Object)var2_3, (ChannelPromise)var3_4);
            return;
        }
        ReferenceCountUtil.release((Object)var2_3);
        throw new UnsupportedMessageTypeException((Object)var2_3, (Class[])SUPPORTED_MESSAGES);
    }

    /*
     * WARNING - void declaration
     */
    private void increaseInitialConnectionWindow(int deltaBytes) throws Http2Exception {
        void var1_1;
        this.connection().local().flowController().incrementWindowSize(this.connection().connectionStream(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean consumeBytes(int streamId, int bytes) throws Http2Exception {
        void var2_3;
        void var3_4;
        Http2Stream stream = this.connection().stream(streamId);
        if (stream != null && streamId == 1) {
            void var1_2;
            Boolean upgraded = (Boolean)stream.getProperty(this.upgradeKey);
            if (Boolean.TRUE.equals(var1_2)) {
                return false;
            }
        }
        return this.connection().local().flowController().consumeBytes((Http2Stream)var3_4, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeGoAwayFrame(ChannelHandlerContext ctx, Http2GoAwayFrame frame, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (frame.lastStreamId() >= 0) {
            frame.release();
            throw new IllegalArgumentException("Last stream id must not be set on GOAWAY frame");
        }
        int n = this.connection().remote().lastStreamCreated();
        long lastStreamId = (long)n + ((long)frame.extraStreamIds() << 1);
        if (lastStreamId > Integer.MAX_VALUE) {
            lastStreamId = Integer.MAX_VALUE;
        }
        this.goAway((ChannelHandlerContext)var1_1, (int)lastStreamId, frame.errorCode(), var2_2.content(), (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeHeadersFrame(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame, ChannelPromise promise) {
        if (Http2CodecUtil.isStreamIdValid(headersFrame.stream().id())) {
            this.encoder().writeHeaders(ctx, headersFrame.stream().id(), headersFrame.headers(), headersFrame.padding(), headersFrame.isEndStream(), promise);
            return;
        }
        if (this.initializeNewStream(ctx, (DefaultHttp2FrameStream)headersFrame.stream(), promise)) {
            void var3_3;
            void var2_2;
            void var1_1;
            promise = promise.unvoid();
            int streamId = headersFrame.stream().id();
            this.encoder().writeHeaders((ChannelHandlerContext)var1_1, streamId, headersFrame.headers(), headersFrame.padding(), var2_2.isEndStream(), promise);
            if (!promise.isDone()) {
                ++this.numBufferedStreams;
                promise.addListener((GenericFutureListener)new ChannelFutureListener(this, streamId){
                    final /* synthetic */ int val$streamId;
                    final /* synthetic */ Http2FrameCodec this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$streamId = n;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void operationComplete(ChannelFuture channelFuture) {
                        void var1_1;
                        this.this$0.numBufferedStreams--;
                        Http2FrameCodec.access$400(this.this$0, (ChannelFuture)var1_1, this.val$streamId);
                    }
                });
                return;
            }
            this.handleHeaderFuture((ChannelFuture)var3_3, streamId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writePushPromise(ChannelHandlerContext ctx, Http2PushPromiseFrame pushPromiseFrame, ChannelPromise promise) {
        if (Http2CodecUtil.isStreamIdValid(pushPromiseFrame.pushStream().id())) {
            this.encoder().writePushPromise(ctx, pushPromiseFrame.stream().id(), pushPromiseFrame.pushStream().id(), pushPromiseFrame.http2Headers(), pushPromiseFrame.padding(), promise);
            return;
        }
        if (this.initializeNewStream(ctx, (DefaultHttp2FrameStream)pushPromiseFrame.pushStream(), promise)) {
            void var3_3;
            void var2_2;
            void var1_1;
            int streamId = pushPromiseFrame.stream().id();
            this.encoder().writePushPromise((ChannelHandlerContext)var1_1, streamId, pushPromiseFrame.pushStream().id(), pushPromiseFrame.http2Headers(), var2_2.padding(), promise);
            if (promise.isDone()) {
                this.handleHeaderFuture((ChannelFuture)promise, streamId);
                return;
            }
            ++this.numBufferedStreams;
            var3_3.addListener((GenericFutureListener)new ChannelFutureListener(this, streamId){
                final /* synthetic */ int val$streamId;
                final /* synthetic */ Http2FrameCodec this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$streamId = n;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture channelFuture) {
                    void var1_1;
                    this.this$0.numBufferedStreams--;
                    Http2FrameCodec.access$400(this.this$0, (ChannelFuture)var1_1, this.val$streamId);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean initializeNewStream(ChannelHandlerContext ctx, DefaultHttp2FrameStream http2FrameStream, ChannelPromise promise) {
        void var1_1;
        void var2_2;
        Http2Connection connection = this.connection();
        int streamId = connection.local().incrementAndGetNextStreamId();
        if (streamId < 0) {
            void var3_3;
            var3_3.setFailure((Throwable)new Http2NoMoreStreamIdsException());
            this.onHttp2Frame(ctx, new DefaultHttp2GoAwayFrame(connection.isServer() ? Integer.MAX_VALUE : 0x7FFFFFFE, Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii((ByteBufAllocator)ctx.alloc(), (CharSequence)"Stream IDs exhausted on local stream creation")));
            return false;
        }
        DefaultHttp2FrameStream.access$502(http2FrameStream, streamId);
        Object old = this.frameStreamToInitializeMap.put(streamId, (Object)var2_2);
        assert (var1_1 == null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void handleHeaderFuture(ChannelFuture channelFuture, int streamId) {
        if (!channelFuture.isSuccess()) {
            void var2_2;
            this.frameStreamToInitializeMap.remove((int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onStreamActive0(Http2Stream stream) {
        void var1_1;
        if (stream.id() != 1 && this.connection().local().isValidStreamId(stream.id())) {
            return;
        }
        DefaultHttp2FrameStream stream2 = this.newStream().setStreamAndProperty(this.streamKey, stream);
        Http2FrameCodec http2FrameCodec = this;
        http2FrameCodec.onHttp2StreamStateChanged(http2FrameCodec.ctx, (DefaultHttp2FrameStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onConnectionError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception http2Ex) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!outbound) {
            ctx.fireExceptionCaught(cause);
        }
        super.onConnectionError((ChannelHandlerContext)var1_1, (boolean)var2_2, (Throwable)var3_3, http2Ex);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException streamException) {
        void var2_2;
        int streamId = streamException.streamId();
        Http2Stream connectionStream = this.connection().stream(streamId);
        if (connectionStream == null) {
            Http2FrameCodec.onHttp2UnknownStreamError(ctx, cause, streamException);
            super.onStreamError(ctx, outbound, cause, streamException);
            return;
        }
        Http2FrameStream stream = (Http2FrameStream)connectionStream.getProperty(this.streamKey);
        if (stream == null) {
            LOG.warn("Stream exception thrown without stream object attached.", cause);
            super.onStreamError(ctx, outbound, cause, streamException);
            return;
        }
        if (var2_2 == false) {
            void var3_3;
            void var1_1;
            this.onHttp2FrameStreamException((ChannelHandlerContext)var1_1, new Http2FrameStreamException(stream, streamException.error(), (Throwable)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void onHttp2UnknownStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException streamException) {
        void var1_1;
        void var2_2;
        LOG.log(InternalLogLevel.DEBUG, "Stream exception thrown for unknown stream {}.", (Object)var2_2.streamId(), (Object)var1_1);
    }

    @Override
    protected final boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && this.numBufferedStreams == 0;
    }

    /*
     * WARNING - void declaration
     */
    private void onUpgradeEvent(ChannelHandlerContext ctx, HttpServerUpgradeHandler.UpgradeEvent evt) {
        void var2_2;
        ctx.fireUserEventTriggered((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void onHttp2StreamWritabilityChanged(ChannelHandlerContext ctx, DefaultHttp2FrameStream stream, boolean writable) {
        void var2_2;
        ctx.fireUserEventTriggered((Object)var2_2.writabilityChanged);
    }

    /*
     * WARNING - void declaration
     */
    void onHttp2StreamStateChanged(ChannelHandlerContext ctx, DefaultHttp2FrameStream stream) {
        void var2_2;
        ctx.fireUserEventTriggered((Object)var2_2.stateChanged);
    }

    /*
     * WARNING - void declaration
     */
    void onHttp2Frame(ChannelHandlerContext ctx, Http2Frame frame) {
        void var2_2;
        ctx.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void onHttp2FrameStreamException(ChannelHandlerContext ctx, Http2FrameStreamException cause) {
        void var2_2;
        ctx.fireExceptionCaught((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(Http2FrameCodec x0, ChannelFuture x1, int x2) {
        void var2_2;
        void var1_1;
        x0.handleHeaderFuture((ChannelFuture)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(Http2FrameCodec x0, Http2Stream x1) {
        void var1_1;
        x0.onStreamActive0((Http2Stream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(Http2FrameCodec x0, ChannelHandlerContext x1, DefaultHttp2FrameStream x2, boolean x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.onHttp2StreamWritabilityChanged((ChannelHandlerContext)var1_1, (DefaultHttp2FrameStream)var2_2, (boolean)var3_3);
    }

    static class DefaultHttp2FrameStream
    implements Http2FrameStream {
        private volatile int id = -1;
        private volatile Http2Stream stream;
        final Http2FrameStreamEvent stateChanged = Http2FrameStreamEvent.stateChanged(this);
        final Http2FrameStreamEvent writabilityChanged = Http2FrameStreamEvent.writabilityChanged(this);
        Channel attachment;

        DefaultHttp2FrameStream() {
        }

        /*
         * WARNING - void declaration
         */
        DefaultHttp2FrameStream setStreamAndProperty(Http2Connection.PropertyKey streamKey, Http2Stream stream) {
            void var1_1;
            void var2_2;
            assert (this.id == -1 || stream.id() == this.id);
            this.stream = stream;
            var2_2.setProperty((Http2Connection.PropertyKey)var1_1, this);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int id() {
            void var1_1;
            Http2Stream stream = this.stream;
            if (stream == null) {
                return this.id;
            }
            return var1_1.id();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Http2Stream.State state() {
            void var1_1;
            Http2Stream stream = this.stream;
            if (stream == null) {
                return Http2Stream.State.IDLE;
            }
            return var1_1.state();
        }

        public String toString() {
            return String.valueOf(this.id());
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$502(DefaultHttp2FrameStream x0, int x1) {
            void var1_1;
            x0.id = var1_1;
            return x0.id;
        }
    }

    private final class Http2RemoteFlowControllerListener
    implements Http2RemoteFlowController.Listener {
        private Http2RemoteFlowControllerListener() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writabilityChanged(Http2Stream stream) {
            void var1_1;
            void var2_2;
            DefaultHttp2FrameStream frameStream = (DefaultHttp2FrameStream)stream.getProperty(Http2FrameCodec.this.streamKey);
            if (frameStream == null) {
                return;
            }
            Http2FrameCodec.access$800(Http2FrameCodec.this, Http2FrameCodec.this.ctx, (DefaultHttp2FrameStream)var2_2, Http2FrameCodec.this.connection().remote().flowController().isWritable((Http2Stream)var1_1));
        }
    }

    private final class FrameListener
    implements Http2FrameListener {
        private FrameListener() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (streamId == 0) {
                return;
            }
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2UnknownFrame((byte)var2_2, flags, payload).stream(this.requireStream((int)var3_3)).retain());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
            void var2_2;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2SettingsFrame((Http2Settings)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPingRead(ChannelHandlerContext ctx, long data) {
            void var2_2;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2PingFrame((long)var2_2, false));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPingAckRead(ChannelHandlerContext ctx, long data) {
            void var2_2;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2PingFrame((long)var2_2, true));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
            void var2_2;
            void var3_3;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2ResetFrame((long)var3_3).stream(this.requireStream((int)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
            void var2_2;
            void var3_3;
            void var1_1;
            if (streamId == 0) {
                return;
            }
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2WindowUpdateFrame((int)var3_3).stream(this.requireStream((int)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.onHeadersRead((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, padding, endStream);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
            void var2_2;
            void var3_3;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2HeadersFrame((Http2Headers)var3_3, endOfStream, padding).stream(this.requireStream((int)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
            void var2_2;
            void var3_3;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2DataFrame((ByteBuf)var3_3, endOfStream, padding).stream(this.requireStream((int)var2_2)).retain());
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
            void var3_3;
            void var2_2;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2GoAwayFrame((int)var2_2, (long)var3_3, debugData).retain());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
            void var2_2;
            void var3_3;
            void var1_1;
            Http2Stream http2Stream = Http2FrameCodec.this.connection().stream(streamId);
            if (http2Stream == null) {
                return;
            }
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2PriorityFrame((int)var3_3, weight, exclusive).stream(this.requireStream((int)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onSettingsAckRead(ChannelHandlerContext ctx) {
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, Http2SettingsAckFrame.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
            void var2_2;
            void var3_3;
            void var1_1;
            Http2FrameCodec.this.onHttp2Frame((ChannelHandlerContext)var1_1, new DefaultHttp2PushPromiseFrame(headers, padding, promisedStreamId).pushStream(new DefaultHttp2FrameStream().setStreamAndProperty(Http2FrameCodec.this.streamKey, Http2FrameCodec.this.connection().stream((int)var3_3))).stream(this.requireStream((int)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        private Http2FrameStream requireStream(int streamId) {
            void var2_2;
            Http2FrameStream stream = (Http2FrameStream)Http2FrameCodec.this.connection().stream(streamId).getProperty(Http2FrameCodec.this.streamKey);
            if (stream == null) {
                void var1_1;
                throw new IllegalStateException("Stream object required for identifier: " + (int)var1_1);
            }
            return var2_2;
        }
    }

    private final class ConnectionListener
    extends Http2ConnectionAdapter {
        private ConnectionListener() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onStreamAdded(Http2Stream stream) {
            DefaultHttp2FrameStream frameStream = (DefaultHttp2FrameStream)Http2FrameCodec.this.frameStreamToInitializeMap.remove(stream.id());
            if (frameStream != null) {
                void var1_1;
                void var2_2;
                var2_2.setStreamAndProperty(Http2FrameCodec.this.streamKey, (Http2Stream)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onStreamActive(Http2Stream stream) {
            void var1_1;
            Http2FrameCodec.access$700(Http2FrameCodec.this, (Http2Stream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onStreamClosed(Http2Stream stream) {
            void var1_1;
            this.onHttp2StreamStateChanged0((Http2Stream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onStreamHalfClosed(Http2Stream stream) {
            void var1_1;
            this.onHttp2StreamStateChanged0((Http2Stream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void onHttp2StreamStateChanged0(Http2Stream stream) {
            DefaultHttp2FrameStream stream2 = (DefaultHttp2FrameStream)stream.getProperty(Http2FrameCodec.this.streamKey);
            if (stream2 != null) {
                void var1_1;
                Http2FrameCodec.this.onHttp2StreamStateChanged(Http2FrameCodec.this.ctx, (DefaultHttp2FrameStream)var1_1);
            }
        }
    }
}

