/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

public final class Http2Flags {
    public static final short END_STREAM = 1;
    public static final short END_HEADERS = 4;
    public static final short ACK = 1;
    public static final short PADDED = 8;
    public static final short PRIORITY = 32;
    private short value;

    public Http2Flags() {
    }

    /*
     * WARNING - void declaration
     */
    public Http2Flags(short value) {
        void var1_1;
        this.value = var1_1;
    }

    public final short value() {
        return this.value;
    }

    public final boolean endOfStream() {
        return this.isFlagSet((short)1);
    }

    public final boolean endOfHeaders() {
        return this.isFlagSet((short)4);
    }

    public final boolean priorityPresent() {
        return this.isFlagSet((short)32);
    }

    public final boolean ack() {
        return this.isFlagSet((short)1);
    }

    public final boolean paddingPresent() {
        return this.isFlagSet((short)8);
    }

    public final int getNumPriorityBytes() {
        if (this.priorityPresent()) {
            return 5;
        }
        return 0;
    }

    public final int getPaddingPresenceFieldLength() {
        if (this.paddingPresent()) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Flags endOfStream(boolean endOfStream) {
        void var1_1;
        return this.setFlag((boolean)var1_1, (short)1);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Flags endOfHeaders(boolean endOfHeaders) {
        void var1_1;
        return this.setFlag((boolean)var1_1, (short)4);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Flags priorityPresent(boolean priorityPresent) {
        void var1_1;
        return this.setFlag((boolean)var1_1, (short)32);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Flags paddingPresent(boolean paddingPresent) {
        void var1_1;
        return this.setFlag((boolean)var1_1, (short)8);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Flags ack(boolean ack) {
        void var1_1;
        return this.setFlag((boolean)var1_1, (short)1);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Flags setFlag(boolean on, short mask) {
        void var2_2;
        this.value = on ? (short)(this.value | mask) : (short)(this.value & ~var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isFlagSet(short mask) {
        void var1_1;
        return (this.value & var1_1) != 0;
    }

    public final int hashCode() {
        int n = 31 + this.value;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((Http2Flags)var1_1).value;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("value = ").append(this.value).append(" (");
        if (this.ack()) {
            builder.append("ACK,");
        }
        if (this.endOfHeaders()) {
            builder.append("END_OF_HEADERS,");
        }
        if (this.endOfStream()) {
            builder.append("END_OF_STREAM,");
        }
        if (this.priorityPresent()) {
            builder.append("PRIORITY_PRESENT,");
        }
        if (this.paddingPresent()) {
            builder.append("PADDING_PRESENT,");
        }
        builder.append(')');
        return var1_1.toString();
    }
}

