/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.ThrowableUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Http2Exception
extends Exception {
    private static final long serialVersionUID = -6941186345430164209L;
    private final Http2Error error;
    private final ShutdownHint shutdownHint;

    /*
     * WARNING - void declaration
     */
    public Http2Exception(Http2Error error) {
        this((Http2Error)var1_1, ShutdownHint.HARD_SHUTDOWN);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2Exception(Http2Error error, ShutdownHint shutdownHint) {
        void var2_2;
        void var1_1;
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)var2_2, (String)"shutdownHint"));
    }

    /*
     * WARNING - void declaration
     */
    public Http2Exception(Http2Error error, String message) {
        this((Http2Error)var1_1, (String)var2_2, ShutdownHint.HARD_SHUTDOWN);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2Exception(Http2Error error, String message, ShutdownHint shutdownHint) {
        super((String)var2_2);
        void var3_3;
        void var1_1;
        void var2_2;
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)var3_3, (String)"shutdownHint"));
    }

    /*
     * WARNING - void declaration
     */
    public Http2Exception(Http2Error error, String message, Throwable cause) {
        this((Http2Error)var1_1, (String)var2_2, (Throwable)var3_3, ShutdownHint.HARD_SHUTDOWN);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2Exception(Http2Error error, String message, Throwable cause, ShutdownHint shutdownHint) {
        super((String)var2_2, (Throwable)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)((Object)shutdownHint), (String)"shutdownHint"));
    }

    /*
     * WARNING - void declaration
     */
    static Http2Exception newStatic(Http2Error error, String message, ShutdownHint shutdownHint, Class<?> clazz, String method) {
        void var3_3;
        Object object;
        void var2_2;
        void var1_1;
        Object exception;
        exception = PlatformDependent.javaVersion() >= 7 ? new StacklessHttp2Exception(error, message, shutdownHint, true) : new StacklessHttp2Exception((Http2Error)((Object)exception), (String)var1_1, (ShutdownHint)var2_2);
        return (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)object, (Class)var3_3, (String)method);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="uses Java 7+ Exception.<init>(String, Throwable, boolean, boolean) but is guarded by version checks")
    private Http2Exception(Http2Error error, String message, ShutdownHint shutdownHint, boolean shared) {
        super((String)var2_2, null, false, true);
        void var3_3;
        void var1_1;
        void var2_2;
        assert (shared);
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)var3_3, (String)"shutdownHint"));
    }

    public Http2Error error() {
        return this.error;
    }

    public ShutdownHint shutdownHint() {
        return this.shutdownHint;
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Exception connectionError(Http2Error error, String fmt, Object ... args) {
        void var2_2;
        void var1_1;
        Http2Error http2Error;
        return new Http2Exception(http2Error, Http2Exception.formatErrorMessage((String)var1_1, (Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Exception connectionError(Http2Error error, Throwable cause, String fmt, Object ... args) {
        void var1_1;
        void var3_3;
        void var2_2;
        Http2Error http2Error;
        return new Http2Exception(http2Error, Http2Exception.formatErrorMessage((String)var2_2, (Object[])var3_3), (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Exception closedStreamError(Http2Error error, String fmt, Object ... args) {
        void var2_2;
        void var1_1;
        Http2Error http2Error;
        return new ClosedStreamCreationException(http2Error, Http2Exception.formatErrorMessage((String)var1_1, (Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Exception streamError(int id, Http2Error error, String fmt, Object ... args) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        if (id == 0) {
            return Http2Exception.connectionError(error, fmt, args);
        }
        return new StreamException(n, (Http2Error)var1_1, Http2Exception.formatErrorMessage((String)var2_2, (Object[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Exception streamError(int id, Http2Error error, Throwable cause, String fmt, Object ... args) {
        void var2_2;
        void var3_3;
        void var1_1;
        int n;
        if (id == 0) {
            return Http2Exception.connectionError(error, cause, fmt, args);
        }
        return new StreamException(n, (Http2Error)var1_1, Http2Exception.formatErrorMessage((String)var3_3, args), (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Http2Exception headerListSizeError(int id, Http2Error error, boolean onDecode, String fmt, Object ... args) {
        void var2_2;
        void var3_3;
        void var1_1;
        int n;
        if (id == 0) {
            return Http2Exception.connectionError(error, fmt, args);
        }
        return new HeaderListSizeException(n, (Http2Error)var1_1, Http2Exception.formatErrorMessage((String)var3_3, args), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String formatErrorMessage(String fmt, Object[] args) {
        void var1_1;
        String string;
        if (fmt == null) {
            if (args == null || args.length == 0) {
                return "Unexpected error";
            }
            return "Unexpected error: " + Arrays.toString(args);
        }
        return String.format(string, (Object[])var1_1);
    }

    public static boolean isStreamError(Http2Exception e) {
        return e instanceof StreamException;
    }

    public static int streamId(Http2Exception e) {
        if (Http2Exception.isStreamError(e)) {
            Http2Exception http2Exception;
            return ((StreamException)http2Exception).streamId();
        }
        return 0;
    }

    private static final class StacklessHttp2Exception
    extends Http2Exception {
        private static final long serialVersionUID = 1077888485687219443L;

        /*
         * WARNING - void declaration
         */
        StacklessHttp2Exception(Http2Error error, String message, ShutdownHint shutdownHint) {
            super((Http2Error)var1_1, (String)var2_2, (ShutdownHint)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        StacklessHttp2Exception(Http2Error error, String message, ShutdownHint shutdownHint, boolean shared) {
            super((Http2Error)var1_1, (String)var2_2, (ShutdownHint)var3_3, shared);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class CompositeStreamException
    extends Http2Exception
    implements Iterable<StreamException> {
        private static final long serialVersionUID = 7091134858213711015L;
        private final List<StreamException> exceptions;

        /*
         * WARNING - void declaration
         */
        public CompositeStreamException(Http2Error error, int initialCapacity) {
            super((Http2Error)var1_1, ShutdownHint.NO_SHUTDOWN);
            void var2_2;
            void var1_1;
            this.exceptions = new ArrayList<StreamException>((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void add(StreamException e) {
            void var1_1;
            this.exceptions.add((StreamException)var1_1);
        }

        @Override
        public final Iterator<StreamException> iterator() {
            return this.exceptions.iterator();
        }
    }

    public static final class HeaderListSizeException
    extends StreamException {
        private static final long serialVersionUID = -8807603212183882637L;
        private final boolean decode;

        /*
         * WARNING - void declaration
         */
        HeaderListSizeException(int streamId, Http2Error error, String message, boolean decode) {
            super((int)var1_1, (Http2Error)var2_2, (String)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.decode = decode;
        }

        public final boolean duringDecode() {
            return this.decode;
        }
    }

    public static class StreamException
    extends Http2Exception {
        private static final long serialVersionUID = 602472544416984384L;
        private final int streamId;

        /*
         * WARNING - void declaration
         */
        StreamException(int streamId, Http2Error error, String message) {
            super((Http2Error)var2_2, (String)var3_3, ShutdownHint.NO_SHUTDOWN);
            void var1_1;
            void var3_3;
            void var2_2;
            this.streamId = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        StreamException(int streamId, Http2Error error, String message, Throwable cause) {
            super((Http2Error)var2_2, (String)var3_3, cause, ShutdownHint.NO_SHUTDOWN);
            void var1_1;
            void var3_3;
            void var2_2;
            this.streamId = var1_1;
        }

        public int streamId() {
            return this.streamId;
        }
    }

    public static final class ClosedStreamCreationException
    extends Http2Exception {
        private static final long serialVersionUID = -6746542974372246206L;

        /*
         * WARNING - void declaration
         */
        public ClosedStreamCreationException(Http2Error error) {
            super((Http2Error)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ClosedStreamCreationException(Http2Error error, String message) {
            super((Http2Error)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ClosedStreamCreationException(Http2Error error, String message, Throwable cause) {
            super((Http2Error)var1_1, (String)var2_2, (Throwable)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public static enum ShutdownHint {
        NO_SHUTDOWN,
        GRACEFUL_SHUTDOWN,
        HARD_SHUTDOWN;

    }
}

