/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;

public final class Http2DataChunkedInput
implements ChunkedInput<Http2DataFrame> {
    private final ChunkedInput<ByteBuf> input;
    private final Http2FrameStream stream;
    private boolean endStreamSent;

    /*
     * WARNING - void declaration
     */
    public Http2DataChunkedInput(ChunkedInput<ByteBuf> input, Http2FrameStream stream) {
        void var2_2;
        void var1_1;
        this.input = (ChunkedInput)ObjectUtil.checkNotNull((Object)var1_1, (String)"input");
        this.stream = (Http2FrameStream)ObjectUtil.checkNotNull((Object)var2_2, (String)"stream");
    }

    public final boolean isEndOfInput() throws Exception {
        if (this.input.isEndOfInput()) {
            return this.endStreamSent;
        }
        return false;
    }

    public final void close() throws Exception {
        this.input.close();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final Http2DataFrame readChunk(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        return this.readChunk(var1_1.alloc());
    }

    /*
     * WARNING - void declaration
     */
    public final Http2DataFrame readChunk(ByteBufAllocator allocator) throws Exception {
        void var1_1;
        if (this.endStreamSent) {
            return null;
        }
        if (this.input.isEndOfInput()) {
            this.endStreamSent = true;
            return new DefaultHttp2DataFrame(true).stream(this.stream);
        }
        ByteBuf buf = (ByteBuf)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(buf, this.input.isEndOfInput()).stream(this.stream);
        if (dataFrame.isEndStream()) {
            this.endStreamSent = true;
        }
        return var1_1;
    }

    public final long length() {
        return this.input.length();
    }

    public final long progress() {
        return this.input.progress();
    }
}

