/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

final class Http2ControlFrameLimitEncoder
extends DecoratingHttp2ConnectionEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ControlFrameLimitEncoder.class);
    private final int maxOutstandingControlFrames;
    private final ChannelFutureListener outstandingControlFramesListener = new ChannelFutureListener(this){
        final /* synthetic */ Http2ControlFrameLimitEncoder this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void operationComplete(ChannelFuture future) {
            this.this$0.outstandingControlFrames--;
        }
    };
    private Http2LifecycleManager lifecycleManager;
    private int outstandingControlFrames;
    private boolean limitReached;

    /*
     * WARNING - void declaration
     */
    Http2ControlFrameLimitEncoder(Http2ConnectionEncoder delegate, int maxOutstandingControlFrames) {
        super((Http2ConnectionEncoder)var1_1);
        void var2_2;
        void var1_1;
        this.maxOutstandingControlFrames = ObjectUtil.checkPositive((int)var2_2, (String)"maxOutstandingControlFrames");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        void var1_1;
        this.lifecycleManager = lifecycleManager;
        super.lifecycleManager((Http2LifecycleManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var3_3;
        void var1_1;
        ChannelPromise newPromise = this.handleOutstandingControlFrames(ctx, promise);
        if (newPromise == null) {
            void var2_2;
            return var2_2;
        }
        return super.writeSettingsAck((ChannelHandlerContext)var1_1, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (ack) {
            ChannelPromise newPromise = this.handleOutstandingControlFrames(ctx, promise);
            if (newPromise == null) {
                return promise;
            }
            return super.writePing(ctx, ack, data, newPromise);
        }
        return super.writePing((ChannelHandlerContext)var1_1, (boolean)var2_2, (long)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        ChannelPromise newPromise = this.handleOutstandingControlFrames(ctx, promise);
        if (newPromise == null) {
            return promise;
        }
        return super.writeRstStream((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, newPromise);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelPromise handleOutstandingControlFrames(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_2;
        if (!this.limitReached) {
            if (this.outstandingControlFrames == this.maxOutstandingControlFrames) {
                ctx.flush();
            }
            if (this.outstandingControlFrames == this.maxOutstandingControlFrames) {
                void var1_1;
                void var3_3;
                this.limitReached = true;
                Http2Exception exception = Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Maximum number %d of outstanding control frames reached", this.maxOutstandingControlFrames);
                logger.info("Maximum number {} of outstanding control frames reached. Closing channel {}", new Object[]{this.maxOutstandingControlFrames, ctx.channel(), exception});
                this.lifecycleManager.onError(ctx, true, (Throwable)var3_3);
                var1_1.close();
            }
            ++this.outstandingControlFrames;
            return promise.unvoid().addListener((GenericFutureListener)this.outstandingControlFramesListener);
        }
        return var2_2;
    }
}

