/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Http2ConnectionHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler,
Http2LifecycleManager {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ConnectionHandler.class);
    private static final Http2Headers HEADERS_TOO_LARGE_HEADERS = ReadOnlyHttp2Headers.serverHeaders(false, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.codeAsText(), new AsciiString[0]);
    private static final ByteBuf HTTP_1_X_BUF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{72, 84, 84, 80, 47, 49, 46})).asReadOnly();
    private final Http2ConnectionDecoder decoder;
    private final Http2ConnectionEncoder encoder;
    private final Http2Settings initialSettings;
    private final boolean decoupleCloseAndGoAway;
    private final boolean flushPreface;
    private ChannelFutureListener closeListener;
    private BaseDecoder byteDecoder;
    private long gracefulShutdownTimeoutMillis;

    /*
     * WARNING - void declaration
     */
    protected Http2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        this((Http2ConnectionDecoder)var1_1, (Http2ConnectionEncoder)var2_2, (Http2Settings)var3_3, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Http2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway) {
        this((Http2ConnectionDecoder)var1_1, (Http2ConnectionEncoder)var2_2, (Http2Settings)var3_3, decoupleCloseAndGoAway, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Http2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway, boolean flushPreface) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.initialSettings = (Http2Settings)((Object)ObjectUtil.checkNotNull((Object)var3_3, (String)"initialSettings"));
        this.decoder = (Http2ConnectionDecoder)ObjectUtil.checkNotNull((Object)decoder, (String)"decoder");
        this.encoder = (Http2ConnectionEncoder)ObjectUtil.checkNotNull((Object)encoder, (String)"encoder");
        this.decoupleCloseAndGoAway = decoupleCloseAndGoAway;
        this.flushPreface = flushPreface;
        if (var2_2.connection() != var1_1.connection()) {
            throw new IllegalArgumentException("Encoder and Decoder do not share the same connection object");
        }
    }

    public long gracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    /*
     * WARNING - void declaration
     */
    public void gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        void var1_1;
        if (gracefulShutdownTimeoutMillis < -1L) {
            throw new IllegalArgumentException("gracefulShutdownTimeoutMillis: " + gracefulShutdownTimeoutMillis + " (expected: -1 for indefinite or >= 0)");
        }
        this.gracefulShutdownTimeoutMillis = var1_1;
    }

    public Http2Connection connection() {
        return this.encoder.connection();
    }

    public Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    public Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    private boolean prefaceSent() {
        return this.byteDecoder != null && this.byteDecoder.prefaceSent();
    }

    public void onHttpClientUpgrade() throws Http2Exception {
        if (this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client-side HTTP upgrade requested for a server", new Object[0]);
        }
        if (!this.prefaceSent()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "HTTP upgrade must occur after preface was sent", new Object[0]);
        }
        if (this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is received", new Object[0]);
        }
        this.connection().local().createStream(1, true);
    }

    /*
     * WARNING - void declaration
     */
    public void onHttpServerUpgrade(Http2Settings settings) throws Http2Exception {
        void var1_1;
        if (!this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server-side HTTP upgrade requested for a client", new Object[0]);
        }
        if (!this.prefaceSent()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "HTTP upgrade must occur after preface was sent", new Object[0]);
        }
        if (this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is received", new Object[0]);
        }
        this.encoder.remoteSettings((Http2Settings)var1_1);
        this.connection().remote().createStream(1, true);
    }

    /*
     * WARNING - void declaration
     */
    public void flush(ChannelHandlerContext ctx) {
        try {
            this.encoder.flowController().writePendingBytes();
            ctx.flush();
            return;
        }
        catch (Http2Exception e) {
            this.onError(ctx, true, e);
            return;
        }
        catch (Throwable cause) {
            void var2_3;
            void var1_1;
            this.onError((ChannelHandlerContext)var1_1, true, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, (Throwable)var2_3, "Error flushing", new Object[0]));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.encoder.lifecycleManager(this);
        this.decoder.lifecycleManager(this);
        this.encoder.flowController().channelHandlerContext(ctx);
        this.decoder.flowController().channelHandlerContext(ctx);
        this.byteDecoder = new PrefaceDecoder((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (this.byteDecoder != null) {
            void var1_1;
            this.byteDecoder.handlerRemoved((ChannelHandlerContext)var1_1);
            this.byteDecoder = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.byteDecoder == null) {
            this.byteDecoder = new PrefaceDecoder(ctx);
        }
        this.byteDecoder.channelActive(ctx);
        super.channelActive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.byteDecoder != null) {
            void var1_1;
            this.byteDecoder.channelInactive((ChannelHandlerContext)var1_1);
            this.byteDecoder = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        try {
            if (ctx.channel().isWritable()) {
                this.flush(ctx);
            }
            this.encoder.flowController().channelWritabilityChanged();
        }
        catch (Throwable throwable) {
            void var1_1;
            super.channelWritabilityChanged((ChannelHandlerContext)var1_1);
            throw throwable;
        }
        super.channelWritabilityChanged(ctx);
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        this.byteDecoder.decode((ChannelHandlerContext)var1_1, (ByteBuf)var2_2, (List<Object>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        if (this.decoupleCloseAndGoAway) {
            ctx.close(promise);
            return;
        }
        promise = promise.unvoid();
        if (!ctx.channel().isActive() || !this.prefaceSent()) {
            ctx.close(promise);
            return;
        }
        ChannelFuture f = this.connection().goAwaySent() ? ctx.write((Object)Unpooled.EMPTY_BUFFER) : this.goAway(ctx, null, ctx.newPromise());
        ctx.flush();
        this.doGracefulShutdown((ChannelHandlerContext)var1_1, (ChannelFuture)var3_3, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFutureListener newClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        long gracefulShutdownTimeoutMillis = this.gracefulShutdownTimeoutMillis;
        if (gracefulShutdownTimeoutMillis < 0L) {
            return new ClosingChannelFutureListener(ctx, promise);
        }
        return new ClosingChannelFutureListener((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2, (long)var3_3, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private void doGracefulShutdown(ChannelHandlerContext ctx, ChannelFuture future, ChannelPromise promise) {
        void var3_3;
        ChannelFutureListener listener = this.newClosingChannelFutureListener(ctx, promise);
        if (this.isGracefulShutdownComplete()) {
            future.addListener((GenericFutureListener)listener);
            return;
        }
        if (this.closeListener == null) {
            this.closeListener = listener;
            return;
        }
        if (var3_3 != null) {
            void var1_1;
            void var2_2;
            ChannelFutureListener oldCloseListener = this.closeListener;
            this.closeListener = new ChannelFutureListener(this, (ChannelFutureListener)var2_2, (ChannelFutureListener)var1_1){
                final /* synthetic */ ChannelFutureListener val$oldCloseListener;
                final /* synthetic */ ChannelFutureListener val$listener;
                final /* synthetic */ Http2ConnectionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$oldCloseListener = channelFutureListener;
                    this.val$listener = channelFutureListener2;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    try {
                        this.val$oldCloseListener.operationComplete((Future)future);
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        this.val$listener.operationComplete((Future)var1_1);
                        throw throwable;
                    }
                    this.val$listener.operationComplete((Future)future);
                }
            };
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.deregister((ChannelPromise)var2_2);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        try {
            this.channelReadComplete0(ctx);
            this.flush(ctx);
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.flush((ChannelHandlerContext)var1_1);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void channelReadComplete0(ChannelHandlerContext ctx) {
        void var1_1;
        this.discardSomeReadBytes();
        if (!ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
        var1_1.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        if (Http2CodecUtil.getEmbeddedHttp2Exception(cause) != null) {
            this.onError(ctx, false, cause);
            return;
        }
        super.exceptionCaught((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeStreamLocal(Http2Stream stream, ChannelFuture future) {
        void var2_2;
        void var1_1;
        switch (stream.state()) {
            case HALF_CLOSED_LOCAL: 
            case OPEN: {
                stream.closeLocalSide();
                return;
            }
        }
        this.closeStream((Http2Stream)var1_1, (ChannelFuture)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeStreamRemote(Http2Stream stream, ChannelFuture future) {
        void var2_2;
        void var1_1;
        switch (stream.state()) {
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                stream.closeRemoteSide();
                return;
            }
        }
        this.closeStream((Http2Stream)var1_1, (ChannelFuture)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeStream(Http2Stream stream, ChannelFuture future) {
        void var1_1;
        void var2_2;
        if (future.isDone()) {
            this.doCloseStream(stream, future);
            return;
        }
        var2_2.addListener((GenericFutureListener)new ChannelFutureListener(this, (Http2Stream)var1_1){
            final /* synthetic */ Http2Stream val$stream;
            final /* synthetic */ Http2ConnectionHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$stream = http2Stream;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) {
                void var1_1;
                Http2ConnectionHandler.access$900(this.this$0, this.val$stream, (ChannelFuture)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onError(ChannelHandlerContext ctx, boolean outbound, Throwable cause) {
        void var1_1;
        Object embedded = Http2CodecUtil.getEmbeddedHttp2Exception(cause);
        if (Http2Exception.isStreamError((Http2Exception)embedded)) {
            this.onStreamError(ctx, outbound, cause, (Http2Exception.StreamException)embedded);
        } else if (embedded instanceof Http2Exception.CompositeStreamException) {
            embedded = (Http2Exception.CompositeStreamException)embedded;
            embedded = ((Http2Exception.CompositeStreamException)embedded).iterator();
            while (embedded.hasNext()) {
                Http2Exception.StreamException streamException = (Http2Exception.StreamException)embedded.next();
                this.onStreamError(ctx, outbound, cause, streamException);
            }
        } else {
            void var3_3;
            void var2_2;
            this.onConnectionError(ctx, (boolean)var2_2, (Throwable)var3_3, (Http2Exception)embedded);
        }
        var1_1.flush();
    }

    protected boolean isGracefulShutdownComplete() {
        return this.connection().numActiveStreams() == 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void onConnectionError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception http2Ex) {
        void var2_3;
        void var1_1;
        void var3_4;
        if (http2Ex == null) {
            http2Ex = new Http2Exception(Http2Error.INTERNAL_ERROR, cause.getMessage(), cause);
        }
        ChannelPromise promise = ctx.newPromise();
        ChannelFuture future = this.goAway(ctx, http2Ex, ctx.newPromise());
        if (http2Ex.shutdownHint() == Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN) {
            this.doGracefulShutdown(ctx, future, promise);
            return;
        }
        var3_4.addListener((GenericFutureListener)this.newClosingChannelFutureListener((ChannelHandlerContext)var1_1, (ChannelPromise)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    protected void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException http2Ex) {
        int streamId = http2Ex.streamId();
        Http2Stream stream = this.connection().stream(streamId);
        if (http2Ex instanceof Http2Exception.HeaderListSizeException && ((Http2Exception.HeaderListSizeException)http2Ex).duringDecode() && this.connection().isServer()) {
            if (stream == null) {
                try {
                    stream = this.encoder.connection().remote().createStream(streamId, true);
                }
                catch (Http2Exception http2Exception) {
                    this.resetUnknownStream(ctx, streamId, http2Ex.error().code(), ctx.newPromise());
                    return;
                }
            }
            if (stream != null && !stream.isHeadersSent()) {
                try {
                    this.handleServerHeaderDecodeSizeError(ctx, stream);
                }
                catch (Throwable cause2) {
                    this.onError(ctx, outbound, Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, cause2, "Error DecodeSizeError", new Object[0]));
                }
            }
        }
        if (stream == null) {
            void var2_2;
            if (var2_2 == false || this.connection().local().mayHaveCreatedStream(streamId)) {
                void var3_4;
                this.resetUnknownStream(ctx, (int)var3_4, http2Ex.error().code(), ctx.newPromise());
                return;
            }
        } else {
            void var1_1;
            this.resetStream(ctx, stream, http2Ex.error().code(), var1_1.newPromise());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleServerHeaderDecodeSizeError(ChannelHandlerContext ctx, Http2Stream stream) {
        void var1_1;
        void var2_2;
        this.encoder().writeHeaders(ctx, var2_2.id(), HEADERS_TOO_LARGE_HEADERS, 0, true, var1_1.newPromise());
    }

    protected Http2FrameWriter frameWriter() {
        return this.encoder().frameWriter();
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture resetUnknownStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        void var2_3;
        void var3_4;
        ChannelFuture future = this.frameWriter().writeRstStream(ctx, streamId, (long)var3_4, promise);
        if (future.isDone()) {
            this.closeConnectionOnError(ctx, future);
        } else {
            void var1_1;
            future.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var1_1){
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ Http2ConnectionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ctx = channelHandlerContext;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    void var1_1;
                    Http2ConnectionHandler.access$1000(this.this$0, this.val$ctx, (ChannelFuture)var1_1);
                }
            });
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture resetStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        void var3_3;
        void var1_1;
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            void var2_2;
            return this.resetUnknownStream(ctx, (int)var2_2, errorCode, promise.unvoid());
        }
        return this.resetStream((ChannelHandlerContext)var1_1, stream, (long)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture resetStream(ChannelHandlerContext ctx, Http2Stream stream, long errorCode, ChannelPromise promise) {
        void var3_4;
        void future22;
        promise = promise.unvoid();
        if (stream.isResetSent()) {
            return promise.setSuccess();
        }
        stream.resetSent();
        Object future22 = stream.state() == Http2Stream.State.IDLE || this.connection().local().created(stream) && !stream.isHeadersSent() && !stream.isPushPromiseSent() ? promise.setSuccess() : this.frameWriter().writeRstStream(ctx, stream.id(), (long)future22, promise);
        if (future22.isDone()) {
            this.processRstStreamWriteResult(ctx, stream, (ChannelFuture)future22);
        } else {
            void var2_2;
            void var1_1;
            future22.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var1_1, (Http2Stream)var2_2){
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ Http2Stream val$stream;
                final /* synthetic */ Http2ConnectionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ctx = channelHandlerContext;
                    this.val$stream = http2Stream;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    void var1_1;
                    Http2ConnectionHandler.access$1100(this.this$0, this.val$ctx, this.val$stream, (ChannelFuture)var1_1);
                }
            });
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture goAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        promise = promise.unvoid();
        Http2Connection connection = this.connection();
        try {
            if (!connection.goAwaySent(lastStreamId, errorCode, debugData)) {
                debugData.release();
                promise.trySuccess();
                return promise;
            }
        }
        catch (Throwable cause) {
            debugData.release();
            promise.tryFailure(cause);
            return promise;
        }
        debugData.retain();
        ChannelFuture future = this.frameWriter().writeGoAway(ctx, lastStreamId, errorCode, debugData, promise);
        if (future.isDone()) {
            Http2ConnectionHandler.processGoAwayWriteResult(ctx, lastStreamId, errorCode, debugData, future);
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            future.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, debugData){
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ int val$lastStreamId;
                final /* synthetic */ long val$errorCode;
                final /* synthetic */ ByteBuf val$debugData;
                final /* synthetic */ Http2ConnectionHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ctx = channelHandlerContext;
                    this.val$lastStreamId = n;
                    this.val$errorCode = l;
                    this.val$debugData = byteBuf;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    void var1_1;
                    Http2ConnectionHandler.access$1200(this.val$ctx, this.val$lastStreamId, this.val$errorCode, this.val$debugData, (ChannelFuture)var1_1);
                }
            });
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private void checkCloseConnection(ChannelFuture future) {
        if (this.closeListener != null && this.isGracefulShutdownComplete()) {
            ChannelFutureListener closeListener = this.closeListener;
            this.closeListener = null;
            try {
                void var2_3;
                var2_3.operationComplete((Future)future);
                return;
            }
            catch (Exception e) {
                void var1_2;
                throw new IllegalStateException("Close listener threw an unexpected exception", (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture goAway(ChannelHandlerContext ctx, Http2Exception cause, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        long errorCode = cause != null ? cause.error().code() : Http2Error.NO_ERROR.code();
        int lastKnownStream = cause != null && cause.shutdownHint() == Http2Exception.ShutdownHint.HARD_SHUTDOWN ? Integer.MAX_VALUE : this.connection().remote().lastStreamCreated();
        return this.goAway(ctx, lastKnownStream, errorCode, Http2CodecUtil.toByteBuf((ChannelHandlerContext)var1_1, (Throwable)var2_2), (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void processRstStreamWriteResult(ChannelHandlerContext ctx, Http2Stream stream, ChannelFuture future) {
        void var3_3;
        void var1_1;
        if (future.isSuccess()) {
            void var2_2;
            this.closeStream((Http2Stream)var2_2, future);
            return;
        }
        this.onConnectionError((ChannelHandlerContext)var1_1, true, var3_3.cause(), null);
    }

    /*
     * WARNING - void declaration
     */
    private void closeConnectionOnError(ChannelHandlerContext ctx, ChannelFuture future) {
        if (!future.isSuccess()) {
            void var2_2;
            void var1_1;
            this.onConnectionError((ChannelHandlerContext)var1_1, true, var2_2.cause(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doCloseStream(Http2Stream stream, ChannelFuture future) {
        void var2_2;
        stream.close();
        this.checkCloseConnection((ChannelFuture)var2_2);
    }

    private static ByteBuf clientPrefaceString(Http2Connection connection) {
        if (connection.isServer()) {
            return Http2CodecUtil.connectionPrefaceBuf();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void processGoAwayWriteResult(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelFuture future) {
        try {
            if (future.isSuccess()) {
                if (errorCode != Http2Error.NO_ERROR.code()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} Sent GOAWAY: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", new Object[]{ctx.channel(), lastStreamId, errorCode, debugData.toString(CharsetUtil.UTF_8), future.cause()});
                    }
                    ctx.close();
                }
            } else {
                ChannelHandlerContext channelHandlerContext;
                if (logger.isDebugEnabled()) {
                    void var2_3;
                    void var1_2;
                    logger.debug("{} Sending GOAWAY failed: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", new Object[]{ctx.channel(), (int)var1_2, (long)var2_3, debugData.toString(CharsetUtil.UTF_8), future.cause()});
                }
                channelHandlerContext.close();
            }
            return;
        }
        finally {
            debugData.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BaseDecoder access$302(Http2ConnectionHandler x0, BaseDecoder x1) {
        void var1_1;
        x0.byteDecoder = var1_1;
        return x0.byteDecoder;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(Http2ConnectionHandler x0, Http2Stream x1, ChannelFuture x2) {
        void var2_2;
        void var1_1;
        x0.doCloseStream((Http2Stream)var1_1, (ChannelFuture)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(Http2ConnectionHandler x0, ChannelHandlerContext x1, ChannelFuture x2) {
        void var2_2;
        void var1_1;
        x0.closeConnectionOnError((ChannelHandlerContext)var1_1, (ChannelFuture)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(Http2ConnectionHandler x0, ChannelHandlerContext x1, Http2Stream x2, ChannelFuture x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.processRstStreamWriteResult((ChannelHandlerContext)var1_1, (Http2Stream)var2_2, (ChannelFuture)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(ChannelHandlerContext x0, int x1, long x2, ByteBuf x3, ChannelFuture x4) {
        void var2_2;
        void var1_1;
        Http2ConnectionHandler.processGoAwayWriteResult(x0, (int)var1_1, (long)var2_2, x3, x4);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;
        private final Future<?> timeoutTask;
        private boolean closed;

        /*
         * WARNING - void declaration
         */
        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            this.ctx = var1_1;
            this.promise = var2_2;
            this.timeoutTask = null;
        }

        /*
         * WARNING - void declaration
         */
        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelPromise promise, long timeout, TimeUnit unit) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.ctx = ctx;
            this.promise = var2_2;
            this.timeoutTask = var1_1.executor().schedule(new Runnable(this){
                final /* synthetic */ ClosingChannelFutureListener this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    this.this$0.doClose();
                }
            }, (long)var3_3, unit);
        }

        public final void operationComplete(ChannelFuture sentGoAwayFuture) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            this.doClose();
        }

        private void doClose() {
            if (this.closed) {
                assert (this.timeoutTask != null);
                return;
            }
            this.closed = true;
            if (this.promise == null) {
                this.ctx.close();
                return;
            }
            this.ctx.close(this.promise);
        }
    }

    private final class FrameDecoder
    extends BaseDecoder {
        private FrameDecoder() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            try {
                void var3_4;
                Http2ConnectionHandler.this.decoder.decodeFrame(ctx, in, (List<Object>)var3_4);
                return;
            }
            catch (Throwable e) {
                void var2_3;
                void var1_1;
                Http2ConnectionHandler.this.onError((ChannelHandlerContext)var1_1, false, (Throwable)var2_3);
                return;
            }
        }
    }

    private final class PrefaceDecoder
    extends BaseDecoder {
        private ByteBuf clientPrefaceString;
        private boolean prefaceSent;

        /*
         * WARNING - void declaration
         */
        PrefaceDecoder(ChannelHandlerContext ctx) throws Exception {
            void var2_2;
            this.clientPrefaceString = Http2ConnectionHandler.clientPrefaceString(Http2ConnectionHandler.this.encoder.connection());
            this.sendPreface((ChannelHandlerContext)var2_2);
        }

        @Override
        public final boolean prefaceSent() {
            return this.prefaceSent;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            try {
                if (ctx.channel().isActive() && this.readClientPrefaceString(in) && this.verifyFirstFrameIsSettings(in)) {
                    void var3_4;
                    Http2ConnectionHandler.access$302(Http2ConnectionHandler.this, new FrameDecoder());
                    Http2ConnectionHandler.this.byteDecoder.decode(ctx, in, (List<Object>)var3_4);
                }
                return;
            }
            catch (Throwable e) {
                void var2_3;
                void var1_1;
                Http2ConnectionHandler.this.onError((ChannelHandlerContext)var1_1, false, (Throwable)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.sendPreface(ctx);
            if (Http2ConnectionHandler.this.flushPreface) {
                void var1_1;
                var1_1.flush();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
            void var1_1;
            this.cleanup();
            super.channelInactive((ChannelHandlerContext)var1_1);
        }

        @Override
        public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.cleanup();
        }

        private void cleanup() {
            if (this.clientPrefaceString != null) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean readClientPrefaceString(ByteBuf in) throws Http2Exception {
            void var1_1;
            void var2_2;
            block7: {
                String chunk;
                block6: {
                    if (this.clientPrefaceString == null) {
                        return true;
                    }
                    int prefaceRemaining = this.clientPrefaceString.readableBytes();
                    int bytesRead = Math.min(in.readableBytes(), prefaceRemaining);
                    if (bytesRead == 0) break block6;
                    ByteBuf byteBuf = in;
                    if (ByteBufUtil.equals((ByteBuf)byteBuf, (int)byteBuf.readerIndex(), (ByteBuf)this.clientPrefaceString, (int)this.clientPrefaceString.readerIndex(), (int)bytesRead)) break block7;
                }
                ByteBuf byteBuf = in;
                int http1Index = ByteBufUtil.indexOf((ByteBuf)HTTP_1_X_BUF, (ByteBuf)byteBuf.slice(byteBuf.readerIndex(), Math.min(in.readableBytes(), 1024)));
                if (http1Index != -1) {
                    ByteBuf byteBuf2 = in;
                    chunk = byteBuf2.toString(byteBuf2.readerIndex(), (int)(var2_2 - in.readerIndex()), CharsetUtil.US_ASCII);
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Unexpected HTTP/1.x request: %s", chunk);
                }
                void v3 = chunk;
                String receivedBytes = ByteBufUtil.hexDump((ByteBuf)v3, (int)v3.readerIndex(), (int)Math.min(chunk.readableBytes(), this.clientPrefaceString.readableBytes()));
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP/2 client preface string missing or corrupt. Hex dump for received bytes: %s", var1_1);
            }
            var1_1.skipBytes((int)var2_2);
            this.clientPrefaceString.skipBytes((int)var2_2);
            if (!this.clientPrefaceString.isReadable()) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean verifyFirstFrameIsSettings(ByteBuf in) throws Http2Exception {
            void var3_3;
            void var2_2;
            if (in.readableBytes() < 5) {
                return false;
            }
            ByteBuf byteBuf = in;
            short frameType = byteBuf.getUnsignedByte(byteBuf.readerIndex() + 3);
            ByteBuf byteBuf2 = in;
            short flags = byteBuf2.getUnsignedByte(byteBuf2.readerIndex() + 4);
            if (var2_2 != 4 || (var3_3 & 1) != 0) {
                void var1_1;
                Object[] objectArray = new Object[1];
                void v3 = var1_1;
                objectArray[0] = ByteBufUtil.hexDump((ByteBuf)v3, (int)v3.readerIndex(), (int)5);
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "First received frame was not SETTINGS. Hex dump for first 5 bytes: %s", objectArray);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private void sendPreface(ChannelHandlerContext ctx) throws Exception {
            void var2_2;
            if (this.prefaceSent || !ctx.channel().isActive()) {
                return;
            }
            this.prefaceSent = true;
            boolean isClient = !Http2ConnectionHandler.this.connection().isServer();
            if (isClient) {
                ctx.write((Object)Http2CodecUtil.connectionPrefaceBuf()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            Http2ConnectionHandler.this.encoder.writeSettings(ctx, Http2ConnectionHandler.this.initialSettings, ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            if (var2_2 != false) {
                void var1_1;
                Http2ConnectionHandler.this.userEventTriggered((ChannelHandlerContext)var1_1, Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE);
            }
        }
    }

    private abstract class BaseDecoder {
        private BaseDecoder() {
        }

        public abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3) throws Exception;

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
        }

        /*
         * WARNING - void declaration
         */
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            void var1_1;
            Http2ConnectionHandler.this.encoder().close();
            Http2ConnectionHandler.this.decoder().close();
            Http2ConnectionHandler.this.connection().close((Promise<Void>)var1_1.voidPromise());
        }

        public boolean prefaceSent() {
            return true;
        }
    }
}

