/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.CharObjectMap;
import io.netty.util.internal.ObjectUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Http2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler upgradeToHandler;
    private final ChannelHandler http2MultiplexHandler;

    /*
     * WARNING - void declaration
     */
    public Http2ClientUpgradeCodec(Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(null, (Http2FrameCodec)var1_1, (ChannelHandler)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ClientUpgradeCodec(String handlerName, Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this((String)var1_1, (Http2ConnectionHandler)var2_2, (ChannelHandler)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this(null, (Http2ConnectionHandler)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this(null, (Http2ConnectionHandler)var1_1, (Http2MultiplexHandler)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((String)var1_1, (Http2ConnectionHandler)v0, (ChannelHandler)v0, null);
    }

    /*
     * WARNING - void declaration
     */
    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        void var3_3;
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((String)var1_1, (Http2ConnectionHandler)v0, (ChannelHandler)v0, (Http2MultiplexHandler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, ChannelHandler upgradeToHandler, Http2MultiplexHandler http2MultiplexHandler) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.handlerName = var1_1;
        this.connectionHandler = (Http2ConnectionHandler)ObjectUtil.checkNotNull((Object)var2_2, (String)"connectionHandler");
        this.upgradeToHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)var3_3, (String)"upgradeToHandler");
        this.http2MultiplexHandler = http2MultiplexHandler;
    }

    public CharSequence protocol() {
        return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        void var1_1;
        void var2_2;
        CharSequence settingsValue = this.getSettingsHeaderValue(ctx);
        var2_2.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, (Object)var1_1);
        return UPGRADE_HEADERS;
    }

    /*
     * WARNING - void declaration
     */
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        try {
            ctx.pipeline().addAfter(ctx.name(), this.handlerName, this.upgradeToHandler);
            if (this.http2MultiplexHandler != null) {
                String name = ctx.pipeline().context((ChannelHandler)this.connectionHandler).name();
                ctx.pipeline().addAfter(name, null, this.http2MultiplexHandler);
            }
            this.connectionHandler.onHttpClientUpgrade();
            return;
        }
        catch (Http2Exception e) {
            void var1_1;
            void var2_3;
            ctx.fireExceptionCaught((Throwable)var2_3);
            var1_1.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private CharSequence getSettingsHeaderValue(ChannelHandlerContext ctx) {
        String string;
        ByteBuf buf = null;
        ByteBuf encodedBuf = null;
        try {
            Http2Settings settings = this.connectionHandler.decoder().localSettings();
            int payloadLength = 6 * settings.size();
            buf = string.alloc().buffer(payloadLength);
            for (CharObjectMap.PrimitiveEntry entry : settings.entries()) {
                buf.writeChar((int)entry.key());
                buf.writeInt(((Long)entry.value()).intValue());
            }
            encodedBuf = Base64.encode((ByteBuf)buf, (Base64Dialect)Base64Dialect.URL_SAFE);
            string = encodedBuf.toString(CharsetUtil.UTF_8);
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            ReferenceCountUtil.release((Object)var2_3);
            ReferenceCountUtil.release((Object)var3_4);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)buf);
        ReferenceCountUtil.release((Object)encodedBuf);
        return string;
    }
}

