/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.util.internal.StringUtil;

public abstract class Http2ChannelDuplexHandler
extends ChannelDuplexHandler {
    private volatile Http2FrameCodec frameCodec;

    /*
     * WARNING - void declaration
     */
    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.frameCodec = Http2ChannelDuplexHandler.requireHttp2FrameCodec(ctx);
        this.handlerAdded0((ChannelHandlerContext)var1_1);
    }

    protected void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            void var1_1;
            this.handlerRemoved0((ChannelHandlerContext)var1_1);
            return;
        }
        finally {
            this.frameCodec = null;
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    public final Http2FrameStream newStream() {
        void var1_1;
        Http2FrameCodec codec = this.frameCodec;
        if (codec == null) {
            throw new IllegalStateException(StringUtil.simpleClassName(Http2FrameCodec.class) + " not found. Has the handler been added to a pipeline?");
        }
        return var1_1.newStream();
    }

    /*
     * WARNING - void declaration
     */
    protected final void forEachActiveStream(Http2FrameStreamVisitor streamVisitor) throws Http2Exception {
        void var1_1;
        this.frameCodec.forEachActiveStream((Http2FrameStreamVisitor)var1_1);
    }

    private static Http2FrameCodec requireHttp2FrameCodec(ChannelHandlerContext ctx) {
        ChannelHandlerContext channelHandlerContext;
        ChannelHandlerContext frameCodecCtx = ctx.pipeline().context(Http2FrameCodec.class);
        if (frameCodecCtx == null) {
            throw new IllegalArgumentException(Http2FrameCodec.class.getSimpleName() + " was not found in the channel pipeline.");
        }
        return (Http2FrameCodec)channelHandlerContext.handler();
    }
}

