/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.List;

final class HpackStaticTable {
    static final int NOT_FOUND = -1;
    private static final List<HpackHeaderField> STATIC_TABLE;
    private static final int HEADER_NAMES_TABLE_SIZE = 512;
    private static final int HEADER_NAMES_TABLE_SHIFT;
    private static final HeaderNameIndex[] HEADER_NAMES;
    private static final int HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SIZE = 64;
    private static final int HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SHIFT;
    private static final HeaderIndex[] HEADERS_WITH_NON_EMPTY_VALUES;
    static final int length;

    private static HpackHeaderField newEmptyHeaderField(AsciiString name) {
        AsciiString asciiString;
        return new HpackHeaderField((CharSequence)asciiString, (CharSequence)AsciiString.EMPTY_STRING);
    }

    private static HpackHeaderField newEmptyHeaderField(String name) {
        String string;
        return new HpackHeaderField((CharSequence)AsciiString.cached((String)string), (CharSequence)AsciiString.EMPTY_STRING);
    }

    /*
     * WARNING - void declaration
     */
    private static HpackHeaderField newHeaderField(AsciiString name, String value) {
        void var1_1;
        AsciiString asciiString;
        return new HpackHeaderField((CharSequence)asciiString, (CharSequence)AsciiString.cached((String)var1_1));
    }

    private static HpackHeaderField newPseudoHeaderMethodField(HttpMethod method) {
        HttpMethod httpMethod;
        return new HpackHeaderField((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value(), (CharSequence)httpMethod.asciiName());
    }

    /*
     * WARNING - void declaration
     */
    private static HpackHeaderField newPseudoHeaderField(Http2Headers.PseudoHeaderName name, AsciiString value) {
        void var1_1;
        Http2Headers.PseudoHeaderName pseudoHeaderName;
        return new HpackHeaderField((CharSequence)pseudoHeaderName.value(), (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static HpackHeaderField newPseudoHeaderField(Http2Headers.PseudoHeaderName name, String value) {
        void var1_1;
        Http2Headers.PseudoHeaderName pseudoHeaderName;
        return new HpackHeaderField((CharSequence)pseudoHeaderName.value(), (CharSequence)AsciiString.cached((String)var1_1));
    }

    private static HpackHeaderField newEmptyPseudoHeaderField(Http2Headers.PseudoHeaderName name) {
        Http2Headers.PseudoHeaderName pseudoHeaderName;
        return new HpackHeaderField((CharSequence)pseudoHeaderName.value(), (CharSequence)AsciiString.EMPTY_STRING);
    }

    static HpackHeaderField getEntry(int index) {
        int n;
        return STATIC_TABLE.get(n - 1);
    }

    static int getIndex(CharSequence name) {
        HeaderNameIndex headerNameIndex;
        HeaderNameIndex entry = HpackStaticTable.getEntry(name);
        if (entry == null) {
            return -1;
        }
        return headerNameIndex.index;
    }

    /*
     * WARNING - void declaration
     */
    static int getIndexInsensitive(CharSequence name, CharSequence value) {
        void var1_1;
        CharSequence charSequence;
        if (value.length() == 0) {
            HeaderNameIndex entry = HpackStaticTable.getEntry(name);
            if (entry == null || !entry.emptyValue) {
                return -1;
            }
            return entry.index;
        }
        int bucket = HpackStaticTable.headerBucket(value);
        HeaderIndex header = HEADERS_WITH_NON_EMPTY_VALUES[bucket];
        if (header == null) {
            return -1;
        }
        if (HpackUtil.equalsVariableTime(header.name, charSequence) && HpackUtil.equalsVariableTime(header.value, (CharSequence)var1_1)) {
            void var2_4;
            return var2_4.index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static HeaderNameIndex getEntry(CharSequence name) {
        CharSequence charSequence;
        int bucket = HpackStaticTable.headerNameBucket(name);
        HeaderNameIndex entry = HEADER_NAMES[bucket];
        if (entry == null) {
            return null;
        }
        if (HpackUtil.equalsVariableTime(entry.name, charSequence)) {
            void var1_2;
            return var1_2;
        }
        return null;
    }

    private static int headerNameBucket(CharSequence name) {
        return HpackStaticTable.bucket(name, HEADER_NAMES_TABLE_SHIFT, 511);
    }

    private static int headerBucket(CharSequence value) {
        return HpackStaticTable.bucket(value, HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SHIFT, 63);
    }

    /*
     * WARNING - void declaration
     */
    private static int bucket(CharSequence s, int shift, int mask) {
        void var2_2;
        void var1_1;
        return AsciiString.hashCode((CharSequence)s) >> var1_1 & var2_2;
    }

    private HpackStaticTable() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        Object tableEntry;
        int bucket;
        HpackHeaderField entry;
        int index;
        STATIC_TABLE = Arrays.asList(HpackStaticTable.newEmptyPseudoHeaderField(Http2Headers.PseudoHeaderName.AUTHORITY), HpackStaticTable.newPseudoHeaderMethodField(HttpMethod.GET), HpackStaticTable.newPseudoHeaderMethodField(HttpMethod.POST), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.PATH, "/"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.PATH, "/index.html"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.SCHEME, "http"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.SCHEME, "https"), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.OK.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.NO_CONTENT.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.PARTIAL_CONTENT.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.NOT_MODIFIED.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.BAD_REQUEST.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.NOT_FOUND.codeAsText()), HpackStaticTable.newPseudoHeaderField(Http2Headers.PseudoHeaderName.STATUS, HttpResponseStatus.INTERNAL_SERVER_ERROR.codeAsText()), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT_CHARSET), HpackStaticTable.newHeaderField(HttpHeaderNames.ACCEPT_ENCODING, "gzip, deflate"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT_LANGUAGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT_RANGES), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCEPT), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.AGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ALLOW), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.AUTHORIZATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CACHE_CONTROL), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_DISPOSITION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_ENCODING), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_LANGUAGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_LENGTH), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_LOCATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_RANGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.CONTENT_TYPE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.COOKIE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.DATE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.ETAG), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.EXPECT), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.EXPIRES), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.FROM), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.HOST), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_MATCH), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_MODIFIED_SINCE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_NONE_MATCH), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_RANGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.IF_UNMODIFIED_SINCE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.LAST_MODIFIED), HpackStaticTable.newEmptyHeaderField("link"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.LOCATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.MAX_FORWARDS), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.PROXY_AUTHENTICATE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.PROXY_AUTHORIZATION), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.RANGE), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.REFERER), HpackStaticTable.newEmptyHeaderField("refresh"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.RETRY_AFTER), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.SERVER), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.SET_COOKIE), HpackStaticTable.newEmptyHeaderField("strict-transport-security"), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.TRANSFER_ENCODING), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.USER_AGENT), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.VARY), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.VIA), HpackStaticTable.newEmptyHeaderField(HttpHeaderNames.WWW_AUTHENTICATE));
        HEADER_NAMES_TABLE_SHIFT = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? 22 : 18;
        HEADER_NAMES = new HeaderNameIndex[512];
        for (index = STATIC_TABLE.size(); index > 0; --index) {
            entry = HpackStaticTable.getEntry(index);
            bucket = HpackStaticTable.headerNameBucket(entry.name);
            tableEntry = HEADER_NAMES[bucket];
            if (tableEntry != null && !HpackUtil.equalsVariableTime(((HeaderNameIndex)tableEntry).name, entry.name)) {
                throw new IllegalStateException("Hash bucket collision between " + ((HeaderNameIndex)tableEntry).name + " and " + entry.name);
            }
            HpackStaticTable.HEADER_NAMES[bucket] = new HeaderNameIndex(entry.name, index, entry.value.length() == 0);
        }
        HEADERS_WITH_NON_EMPTY_VALUES_TABLE_SHIFT = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? 0 : 6;
        HEADERS_WITH_NON_EMPTY_VALUES = new HeaderIndex[64];
        for (index = STATIC_TABLE.size(); index > 0; --index) {
            void var1_1;
            entry = HpackStaticTable.getEntry(index);
            if (entry.value.length() <= 0) continue;
            bucket = HpackStaticTable.headerBucket(entry.value);
            tableEntry = HEADERS_WITH_NON_EMPTY_VALUES[bucket];
            if (tableEntry != null) {
                void var3_3;
                throw new IllegalStateException("Hash bucket collision between " + var3_3.value + " and " + entry.value);
            }
            HpackStaticTable.HEADERS_WITH_NON_EMPTY_VALUES[var2_2] = new HeaderIndex(entry.name, var1_1.value, index);
        }
        length = STATIC_TABLE.size();
    }

    private static final class HeaderIndex {
        final CharSequence name;
        final CharSequence value;
        final int index;

        /*
         * WARNING - void declaration
         */
        HeaderIndex(CharSequence name, CharSequence value, int index) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.value = var2_2;
            this.index = var3_3;
        }
    }

    private static final class HeaderNameIndex {
        final CharSequence name;
        final int index;
        final boolean emptyValue;

        /*
         * WARNING - void declaration
         */
        HeaderNameIndex(CharSequence name, int index, boolean emptyValue) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.index = var2_2;
            this.emptyValue = var3_3;
        }
    }
}

