/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

final class HpackHuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;
    private final EncodedLengthProcessor encodedLengthProcessor = new EncodedLengthProcessor();
    private final EncodeProcessor encodeProcessor = new EncodeProcessor();

    HpackHuffmanEncoder() {
        this(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    }

    /*
     * WARNING - void declaration
     */
    private HpackHuffmanEncoder(int[] codes, byte[] lengths) {
        void var2_2;
        void var1_1;
        this.codes = var1_1;
        this.lengths = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void encode(ByteBuf out, CharSequence data) {
        void var2_3;
        ObjectUtil.checkNotNull((Object)out, (String)"out");
        if (data instanceof AsciiString) {
            AsciiString string = (AsciiString)data;
            try {
                this.encodeProcessor.out = out;
                var2_3.forEachByte((ByteProcessor)this.encodeProcessor);
            }
            catch (Exception exception) {
                out = exception;
                PlatformDependent.throwException((Throwable)exception);
            }
            finally {
                this.encodeProcessor.end();
            }
        } else {
            void var1_1;
            this.encodeSlowPath((ByteBuf)var1_1, (CharSequence)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeSlowPath(ByteBuf out, CharSequence data) {
        long current = 0L;
        int n = 0;
        for (int i = 0; i < data.length(); ++i) {
            int b = AsciiString.c2b((char)data.charAt(i)) & 0xFF;
            int code = this.codes[b];
            byte nbits = this.lengths[b];
            current <<= nbits;
            current |= (long)code;
            n += nbits;
            while (n >= 8) {
                out.writeByte((int)(current >> (n -= 8)));
            }
        }
        if (n > 0) {
            void var3_3;
            void var1_1;
            current <<= 8 - n;
            current |= (long)(255 >>> n);
            var1_1.writeByte((int)var3_3);
        }
    }

    final int getEncodedLength(CharSequence data) {
        Exception exception;
        if (data instanceof AsciiString) {
            AsciiString string = (AsciiString)data;
            try {
                this.encodedLengthProcessor.reset();
                exception.forEachByte(this.encodedLengthProcessor);
                return this.encodedLengthProcessor.length();
            }
            catch (Exception exception2) {
                exception = exception2;
                PlatformDependent.throwException((Throwable)exception2);
                return -1;
            }
        }
        return this.getEncodedLengthSlowPath((CharSequence)((Object)exception));
    }

    /*
     * WARNING - void declaration
     */
    private int getEncodedLengthSlowPath(CharSequence data) {
        void var2_2;
        long len = 0L;
        for (int i = 0; i < data.length(); ++i) {
            len += (long)this.lengths[AsciiString.c2b((char)data.charAt(i)) & 0xFF];
        }
        return (int)(var2_2 + 7L >> 3);
    }

    private final class EncodedLengthProcessor
    implements ByteProcessor {
        private long len;

        private EncodedLengthProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean process(byte value) {
            void var1_1;
            this.len += (long)HpackHuffmanEncoder.this.lengths[var1_1 & 0xFF];
            return true;
        }

        final void reset() {
            this.len = 0L;
        }

        final int length() {
            return (int)(this.len + 7L >> 3);
        }
    }

    private final class EncodeProcessor
    implements ByteProcessor {
        ByteBuf out;
        private long current;
        private int n;

        private EncodeProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean process(byte value) {
            void var2_2;
            void var1_1;
            int b = value & 0xFF;
            byte nbits = HpackHuffmanEncoder.this.lengths[b];
            this.current <<= nbits;
            this.current |= (long)HpackHuffmanEncoder.this.codes[var1_1];
            this.n += var2_2;
            while (this.n >= 8) {
                this.n -= 8;
                this.out.writeByte((int)(this.current >> this.n));
            }
            return true;
        }

        final void end() {
            try {
                if (this.n > 0) {
                    this.current <<= 8 - this.n;
                    this.current |= (long)(255 >>> this.n);
                    this.out.writeByte((int)this.current);
                }
                return;
            }
            finally {
                this.out = null;
                this.current = 0L;
                this.n = 0;
            }
        }
    }
}

