/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanEncoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.util.Iterator;
import java.util.Map;

final class HpackEncoder {
    static final int NOT_FOUND = -1;
    static final int HUFF_CODE_THRESHOLD = 512;
    private final NameEntry[] nameEntries;
    private final NameValueEntry[] nameValueEntries;
    private final NameValueEntry head;
    private NameValueEntry latest;
    private final HpackHuffmanEncoder hpackHuffmanEncoder;
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private final int huffCodeThreshold;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    HpackEncoder(boolean ignoreMaxHeaderListSize) {
        this((boolean)var1_1, 64, 512);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    HpackEncoder(boolean ignoreMaxHeaderListSize, int arraySizeHint, int huffCodeThreshold) {
        void var3_3;
        void var2_2;
        void var1_1;
        AsciiString asciiString = AsciiString.EMPTY_STRING;
        this.latest = this.head = new NameValueEntry(-1, (CharSequence)asciiString, (CharSequence)asciiString, Integer.MAX_VALUE, null);
        this.hpackHuffmanEncoder = new HpackHuffmanEncoder();
        this.ignoreMaxHeaderListSize = var1_1;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 0xFFFFFFFFL;
        this.nameEntries = new NameEntry[MathUtil.findNextPositivePowerOfTwo((int)Math.max(2, Math.min((int)var2_2, 128)))];
        this.nameValueEntries = new NameValueEntry[this.nameEntries.length];
        this.hashMask = (byte)(this.nameEntries.length - 1);
        this.huffCodeThreshold = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeHeaders(int streamId, ByteBuf out, Http2Headers headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(out, headers, sensitivityDetector);
            return;
        }
        this.encodeHeadersEnforceMaxHeaderListSize((int)var1_1, (ByteBuf)var2_2, (Http2Headers)var3_3, sensitivityDetector);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeHeadersEnforceMaxHeaderListSize(int streamId, ByteBuf out, Http2Headers headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) throws Http2Exception {
        void var3_3;
        void var2_2;
        long headerSize = 0L;
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = headers.iterator();
        while (iterator.hasNext()) {
            CharSequence value;
            Map.Entry<CharSequence, CharSequence> header = iterator.next();
            CharSequence name = header.getKey();
            if ((headerSize += HpackHeaderField.sizeOf(name, value = header.getValue())) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize((ByteBuf)var2_2, (Http2Headers)var3_3, sensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf out, Http2Headers headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = headers.iterator();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> header = iterator.next();
            CharSequence name = header.getKey();
            CharSequence value = header.getValue();
            this.encodeHeader(out, name, value, sensitivityDetector.isSensitive(name, value), HpackHeaderField.sizeOf(name, value));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeHeader(ByteBuf out, CharSequence name, CharSequence value, boolean sensitive, long headerSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        int valueHash;
        int nameIndex;
        if (sensitive) {
            nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out, name, value, HpackUtil.IndexType.NEVER, nameIndex);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            int staticTableIndex = HpackStaticTable.getIndexInsensitive(name, value);
            if (staticTableIndex == -1) {
                int nameIndex2 = HpackStaticTable.getIndex(name);
                this.encodeLiteral(out, name, value, HpackUtil.IndexType.NONE, nameIndex2);
                return;
            }
            HpackEncoder.encodeInteger(out, 128, 7, staticTableIndex);
            return;
        }
        if (headerSize > this.maxHeaderTableSize) {
            nameIndex = this.getNameIndex(name);
            this.encodeLiteral(out, name, value, HpackUtil.IndexType.NONE, nameIndex);
            return;
        }
        int nameHash = AsciiString.hashCode((CharSequence)name);
        NameValueEntry headerField = this.getEntryInsensitive(name, nameHash, value, valueHash = AsciiString.hashCode((CharSequence)value));
        if (headerField != null) {
            HpackEncoder.encodeInteger(out, 128, 7, this.getIndexPlusOffset(headerField.counter));
            return;
        }
        int staticTableIndex = HpackStaticTable.getIndexInsensitive(name, value);
        if (staticTableIndex != -1) {
            HpackEncoder.encodeInteger(out, 128, 7, staticTableIndex);
            return;
        }
        this.ensureCapacity(headerSize);
        this.encodeAndAddEntries((ByteBuf)var1_1, (CharSequence)var2_2, nameHash, (CharSequence)var3_3, valueHash);
        this.size += headerSize;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void encodeAndAddEntries(ByteBuf out, CharSequence name, int nameHash, CharSequence value, int valueHash) {
        int staticTableIndex = HpackStaticTable.getIndex(name);
        int nextCounter = this.latestCounter() - 1;
        if (staticTableIndex != -1) {
            void var3_3;
            void var6_6;
            void var2_2;
            void var1_1;
            this.encodeLiteral((ByteBuf)var1_1, (CharSequence)var2_2, value, HpackUtil.IndexType.INCREMENTAL, (int)var6_6);
            this.addNameValueEntry(HpackStaticTable.getEntry((int)var6_6).name, value, (int)var3_3, valueHash, nextCounter);
            return;
        }
        NameEntry e = this.getEntry(name, nameHash);
        if (e == null) {
            this.encodeLiteral(out, name, value, HpackUtil.IndexType.INCREMENTAL, -1);
            this.addNameEntry(name, nameHash, nextCounter);
            this.addNameValueEntry(name, value, nameHash, valueHash, nextCounter);
            return;
        }
        this.encodeLiteral(out, name, value, HpackUtil.IndexType.INCREMENTAL, this.getIndexPlusOffset(e.counter));
        this.addNameValueEntry(e.name, value, nameHash, valueHash, nextCounter);
        e.counter = nextCounter;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxHeaderTableSize(ByteBuf out, long maxHeaderTableSize) throws Http2Exception {
        void var2_2;
        void var1_1;
        if (maxHeaderTableSize < 0L || maxHeaderTableSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderTableSize);
        }
        if (this.maxHeaderTableSize == maxHeaderTableSize) {
            return;
        }
        this.maxHeaderTableSize = maxHeaderTableSize;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger((ByteBuf)var1_1, 32, 5, (long)var2_2);
    }

    public final long getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxHeaderListSize(long maxHeaderListSize) throws Http2Exception {
        void var1_1;
        if (maxHeaderListSize < 0L || maxHeaderListSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderListSize);
        }
        this.maxHeaderListSize = var1_1;
    }

    public final long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    /*
     * WARNING - void declaration
     */
    private static void encodeInteger(ByteBuf out, int mask, int n, int i) {
        void var3_3;
        void var2_2;
        void var1_1;
        HpackEncoder.encodeInteger(out, (int)var1_1, (int)var2_2, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void encodeInteger(ByteBuf out, int mask, int n, long i) {
        ByteBuf byteBuf;
        void var2_2;
        void var3_3;
        void var1_1;
        assert (n >= 0 && n <= 8) : "N: " + n;
        int nbits = 255 >>> 8 - n;
        if (i < (long)nbits) {
            out.writeByte((int)((long)mask | i));
            return;
        }
        out.writeByte(var1_1 | nbits);
        void length = var3_3 - (long)var2_2;
        while ((length & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)(length & 0x7FL | 0x80L));
            length >>>= 7;
        }
        byteBuf.writeByte((int)length);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeStringLiteral(ByteBuf out, CharSequence string) {
        void var1_1;
        void var2_2;
        int huffmanLength;
        if (string.length() >= this.huffCodeThreshold && (huffmanLength = this.hpackHuffmanEncoder.getEncodedLength(string)) < string.length()) {
            void var3_3;
            HpackEncoder.encodeInteger(out, 128, 7, (int)var3_3);
            this.hpackHuffmanEncoder.encode(out, string);
            return;
        }
        HpackEncoder.encodeInteger(out, 0, 7, string.length());
        if (string instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)string;
            out.writeBytes(asciiString.array(), asciiString.arrayOffset(), var2_2.length());
            return;
        }
        var1_1.writeCharSequence((CharSequence)var2_2, CharsetUtil.ISO_8859_1);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeLiteral(ByteBuf out, CharSequence name, CharSequence value, HpackUtil.IndexType indexType, int nameIndex) {
        void var3_3;
        void var1_1;
        boolean nameIndexValid = nameIndex != -1;
        switch (indexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(out, 64, 6, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(out, 0, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(out, 16, 4, nameIndexValid ? nameIndex : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!nameIndexValid) {
            void var2_2;
            this.encodeStringLiteral(out, (CharSequence)var2_2);
        }
        this.encodeStringLiteral((ByteBuf)var1_1, (CharSequence)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private int getNameIndex(CharSequence name) {
        void var1_1;
        int index = HpackStaticTable.getIndex(name);
        if (index != -1) {
            void var2_2;
            return (int)var2_2;
        }
        CharSequence charSequence = name;
        NameEntry e = this.getEntry(charSequence, AsciiString.hashCode((CharSequence)charSequence));
        if (e == null) {
            return -1;
        }
        return this.getIndexPlusOffset(var1_1.counter);
    }

    private void ensureCapacity(long headerSize) {
        while (this.maxHeaderTableSize - this.size < headerSize) {
            this.remove();
        }
    }

    final int length() {
        if (this.isEmpty()) {
            return 0;
        }
        HpackEncoder hpackEncoder = this;
        return hpackEncoder.getIndex(hpackEncoder.head.after.counter);
    }

    final long size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    final HpackHeaderField getHeaderField(int index) {
        void var2_2;
        NameValueEntry entry = this.head;
        while (index++ < this.length()) {
            entry = entry.after;
        }
        return var2_2;
    }

    private NameValueEntry getEntryInsensitive(CharSequence name, int nameHash, CharSequence value, int valueHash) {
        int h = HpackEncoder.hash(nameHash, valueHash);
        NameValueEntry e = this.nameValueEntries[this.bucket(h)];
        while (e != null) {
            if (e.hash == h && HpackUtil.equalsVariableTime(value, e.value) && HpackUtil.equalsVariableTime(name, e.name)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private NameEntry getEntry(CharSequence name, int nameHash) {
        NameEntry e = this.nameEntries[this.bucket(nameHash)];
        while (e != null) {
            if (e.hash == nameHash && HpackUtil.equalsConstantTime(name, e.name) != 0) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int getIndexPlusOffset(int counter) {
        void var1_1;
        return this.getIndex((int)var1_1) + HpackStaticTable.length;
    }

    private int getIndex(int counter) {
        return counter - this.latestCounter() + 1;
    }

    private int latestCounter() {
        return this.latest.counter;
    }

    /*
     * WARNING - void declaration
     */
    private void addNameEntry(CharSequence name, int nameHash, int nextCounter) {
        void var3_3;
        void var1_1;
        void var2_2;
        int bucket = this.bucket(nameHash);
        this.nameEntries[bucket] = new NameEntry((int)var2_2, (CharSequence)var1_1, (int)var3_3, this.nameEntries[bucket]);
    }

    /*
     * WARNING - void declaration
     */
    private void addNameValueEntry(CharSequence name, CharSequence value, int nameHash, int valueHash, int nextCounter) {
        void var1_1;
        void var2_2;
        void var3_3;
        NameValueEntry e;
        int hash = HpackEncoder.hash(nameHash, valueHash);
        int bucket = this.bucket(hash);
        this.nameValueEntries[bucket] = e = new NameValueEntry((int)var3_3, name, (CharSequence)var2_2, nextCounter, this.nameValueEntries[bucket]);
        this.latest.after = e;
        this.latest = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void remove() {
        void var1_1;
        NameValueEntry eldest = this.head.after;
        this.removeNameValueEntry(eldest);
        this.removeNameEntryMatchingCounter(eldest.name, eldest.counter);
        this.head.after = eldest.after;
        eldest.unlink();
        this.size -= (long)var1_1.size();
        if (this.isEmpty()) {
            this.latest = this.head;
        }
    }

    private boolean isEmpty() {
        return this.size == 0L;
    }

    /*
     * WARNING - void declaration
     */
    private void removeNameValueEntry(NameValueEntry eldest) {
        void var1_1;
        int bucket = this.bucket(eldest.hash);
        NameValueEntry e = this.nameValueEntries[bucket];
        if (e == eldest) {
            this.nameValueEntries[var2_2] = eldest.next;
            return;
        }
        while (e.next != eldest) {
            e = e.next;
        }
        var3_3.next = var1_1.next;
    }

    private void removeNameEntryMatchingCounter(CharSequence name, int counter) {
        int hash = AsciiString.hashCode((CharSequence)name);
        int bucket = this.bucket(hash);
        NameEntry e = this.nameEntries[bucket];
        if (e == null) {
            return;
        }
        if (counter == e.counter) {
            this.nameEntries[bucket] = e.next;
            e.unlink();
            return;
        }
        NameEntry prev = e;
        e = e.next;
        while (e != null) {
            if (counter == e.counter) {
                prev.next = e.next;
                e.unlink();
                return;
            }
            prev = e;
            e = e.next;
        }
    }

    private int bucket(int h) {
        return h & this.hashMask;
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(int nameHash, int valueHash) {
        void var1_1;
        return nameHash * 31 + var1_1;
    }

    private static final class NameValueEntry
    extends HpackHeaderField {
        NameValueEntry after;
        NameValueEntry next;
        final int hash;
        final int counter;

        /*
         * WARNING - void declaration
         */
        NameValueEntry(int hash, CharSequence name, CharSequence value, int counter, NameValueEntry next) {
            super((CharSequence)var2_2, (CharSequence)var3_3);
            void var1_1;
            void var3_3;
            void var2_2;
            this.next = next;
            this.hash = var1_1;
            this.counter = counter;
        }

        final void unlink() {
            this.after = null;
            this.next = null;
        }
    }

    private static final class NameEntry {
        NameEntry next;
        final CharSequence name;
        final int hash;
        int counter;

        /*
         * WARNING - void declaration
         */
        NameEntry(int hash, CharSequence name, int counter, NameEntry next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.hash = var1_1;
            this.name = var2_2;
            this.counter = var3_3;
            this.next = next;
        }

        final void unlink() {
            this.next = null;
        }
    }
}

