/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.HpackHeaderField;

final class HpackDynamicTable {
    HpackHeaderField[] hpackHeaderFields;
    int head;
    int tail;
    private long size;
    private long capacity = -1L;

    /*
     * WARNING - void declaration
     */
    HpackDynamicTable(long initialCapacity) {
        void var1_1;
        this.setCapacity((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int length() {
        void var1_1;
        int length = this.head < this.tail ? this.hpackHeaderFields.length - this.tail + this.head : this.head - this.tail;
        return (int)var1_1;
    }

    public final long size() {
        return this.size;
    }

    public final long capacity() {
        return this.capacity;
    }

    /*
     * WARNING - void declaration
     */
    public final HpackHeaderField getEntry(int index) {
        void var1_1;
        if (index <= 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.length());
        }
        int i = this.head - index;
        if (i < 0) {
            return this.hpackHeaderFields[i + this.hpackHeaderFields.length];
        }
        return this.hpackHeaderFields[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final void add(HpackHeaderField header) {
        void var2_2;
        void var1_1;
        int headerSize = header.size();
        if ((long)headerSize > this.capacity) {
            this.clear();
            return;
        }
        while (this.capacity - this.size < (long)headerSize) {
            this.remove();
        }
        this.hpackHeaderFields[this.head++] = var1_1;
        this.size += (long)var2_2;
        if (this.head == this.hpackHeaderFields.length) {
            this.head = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final HpackHeaderField remove() {
        void var1_1;
        HpackHeaderField removed = this.hpackHeaderFields[this.tail];
        if (removed == null) {
            return null;
        }
        this.size -= (long)removed.size();
        this.hpackHeaderFields[this.tail++] = null;
        if (this.tail == this.hpackHeaderFields.length) {
            this.tail = 0;
        }
        return var1_1;
    }

    public final void clear() {
        while (this.tail != this.head) {
            this.hpackHeaderFields[this.tail++] = null;
            if (this.tail != this.hpackHeaderFields.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCapacity(long capacity) {
        void var1_2;
        void var2_4;
        if (capacity < 0L || capacity > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("capacity is invalid: " + capacity);
        }
        if (this.capacity == capacity) {
            return;
        }
        this.capacity = capacity;
        if (capacity == 0L) {
            this.clear();
        } else {
            while (this.size > capacity) {
                this.remove();
            }
        }
        int maxEntries = (int)(capacity / 32L);
        if (capacity % 32L != 0L) {
            ++maxEntries;
        }
        if (this.hpackHeaderFields != null && this.hpackHeaderFields.length == maxEntries) {
            return;
        }
        HpackHeaderField[] tmp = new HpackHeaderField[maxEntries];
        int len = this.length();
        if (this.hpackHeaderFields != null) {
            int cursor = this.tail;
            for (int i = 0; i < len; ++i) {
                HpackHeaderField entry;
                tmp[i] = entry = this.hpackHeaderFields[cursor++];
                if (cursor != this.hpackHeaderFields.length) continue;
                cursor = 0;
            }
        }
        this.tail = 0;
        this.head = this.tail + var2_4;
        this.hpackHeaderFields = var1_2;
    }
}

