/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;

public class DelegatingDecompressorFrameListener
extends Http2FrameListenerDecorator {
    private final Http2Connection connection;
    private final boolean strict;
    private boolean flowControllerInitialized;
    private final Http2Connection.PropertyKey propertyKey;

    /*
     * WARNING - void declaration
     */
    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener) {
        this((Http2Connection)var1_1, (Http2FrameListener)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener, boolean strict) {
        super((Http2FrameListener)var2_2);
        void var1_1;
        void var3_3;
        void var2_2;
        this.connection = connection;
        this.strict = var3_3;
        this.propertyKey = connection.newKey();
        var1_1.addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ DelegatingDecompressorFrameListener this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamRemoved(Http2Stream stream) {
                Http2Decompressor decompressor = this.this$0.decompressor(stream);
                if (decompressor != null) {
                    void var1_1;
                    DelegatingDecompressorFrameListener.cleanup((Http2Decompressor)var1_1);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        Http2Exception buf;
        Http2Stream stream = this.connection.stream(streamId);
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null) {
            return this.listener.onDataRead(ctx, streamId, data, padding, endOfStream);
        }
        EmbeddedChannel channel = decompressor.decompressor();
        int compressedBytes = data.readableBytes() + padding;
        decompressor.incrementCompressedBytes(compressedBytes);
        try {
            channel.writeInbound(new Object[]{data.retain()});
            buf = DelegatingDecompressorFrameListener.nextReadableBuf(channel);
            if (buf == null && endOfStream && channel.finish()) {
                buf = DelegatingDecompressorFrameListener.nextReadableBuf(channel);
            }
            if (buf == null) {
                if (endOfStream) {
                    this.listener.onDataRead(ctx, streamId, Unpooled.EMPTY_BUFFER, padding, true);
                }
                decompressor.incrementDecompressedBytes(compressedBytes);
                return compressedBytes;
            }
            try {
                Http2LocalFlowController flowController = this.connection.local().flowController();
                decompressor.incrementDecompressedBytes(padding);
                while (true) {
                    ByteBuf nextBuf;
                    boolean decompressedEndOfStream;
                    if ((decompressedEndOfStream = (nextBuf = DelegatingDecompressorFrameListener.nextReadableBuf(channel)) == null && endOfStream) && channel.finish()) {
                        nextBuf = DelegatingDecompressorFrameListener.nextReadableBuf(channel);
                        decompressedEndOfStream = nextBuf == null;
                    }
                    decompressor.incrementDecompressedBytes(buf.readableBytes());
                    flowController.consumeBytes(stream, this.listener.onDataRead(ctx, streamId, (ByteBuf)buf, padding, decompressedEndOfStream));
                    if (nextBuf == null) break;
                    padding = 0;
                    buf.release();
                    buf = nextBuf;
                }
                return 0;
            }
            finally {
                buf.release();
            }
        }
        catch (Http2Exception http2Exception) {
            buf = http2Exception;
            throw http2Exception;
        }
        catch (Throwable t) {
            void var3_5;
            throw Http2Exception.streamError(stream.id(), Http2Error.INTERNAL_ERROR, (Throwable)var3_5, "Decompressor error detected while delegating data read on streamId %d", stream.id());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, padding, endStream);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, streamDependency, weight, exclusive, padding, endStream);
    }

    /*
     * WARNING - void declaration
     */
    protected EmbeddedChannel newContentDecompressor(ChannelHandlerContext ctx, CharSequence contentEncoding) throws Http2Exception {
        void var2_2;
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)var2_2)});
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase((CharSequence)var2_2)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{new BrotliDecoder()});
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase((CharSequence)var2_2)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{new SnappyFrameDecoder()});
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase((CharSequence)var2_2)) {
            void var1_1;
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), var1_1.channel().config(), new ChannelHandler[]{new ZstdDecoder()});
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence contentEncoding) throws Http2Exception {
        return HttpHeaderValues.IDENTITY;
    }

    /*
     * WARNING - void declaration
     */
    private void initDecompressor(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            return;
        }
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null && !endOfStream) {
            EmbeddedChannel channel;
            CharSequence contentEncoding = (CharSequence)headers.get(HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding == null) {
                contentEncoding = HttpHeaderValues.IDENTITY;
            }
            if ((channel = this.newContentDecompressor(ctx, contentEncoding)) != null) {
                void var2_3;
                decompressor = new Http2Decompressor(channel);
                var2_3.setProperty(this.propertyKey, decompressor);
                CharSequence targetContentEncoding = this.getTargetContentEncoding(contentEncoding);
                if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(targetContentEncoding)) {
                    headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    void var1_1;
                    headers.set(HttpHeaderNames.CONTENT_ENCODING, var1_1);
                }
            }
        }
        if (decompressor != null) {
            void var3_4;
            var3_4.remove((Object)HttpHeaderNames.CONTENT_LENGTH);
            if (!this.flowControllerInitialized) {
                this.flowControllerInitialized = true;
                DelegatingDecompressorFrameListener delegatingDecompressorFrameListener = this;
                this.connection.local().flowController(delegatingDecompressorFrameListener.new ConsumedBytesConverter(delegatingDecompressorFrameListener.connection.local().flowController()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    Http2Decompressor decompressor(Http2Stream stream) {
        void var1_1;
        if (stream == null) {
            return null;
        }
        return (Http2Decompressor)var1_1.getProperty(this.propertyKey);
    }

    private static void cleanup(Http2Decompressor decompressor) {
        decompressor.decompressor().finishAndReleaseAll();
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf nextReadableBuf(EmbeddedChannel decompressor) {
        void var1_1;
        while (true) {
            ByteBuf buf;
            if ((buf = (ByteBuf)decompressor.readInbound()) == null) {
                return null;
            }
            if (buf.isReadable()) break;
            buf.release();
        }
        return var1_1;
    }

    private static final class Http2Decompressor {
        private final EmbeddedChannel decompressor;
        private int compressed;
        private int decompressed;

        /*
         * WARNING - void declaration
         */
        Http2Decompressor(EmbeddedChannel decompressor) {
            void var1_1;
            this.decompressor = var1_1;
        }

        final EmbeddedChannel decompressor() {
            return this.decompressor;
        }

        /*
         * WARNING - void declaration
         */
        final void incrementCompressedBytes(int delta) {
            void var1_1;
            assert (delta >= 0);
            this.compressed += var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void incrementDecompressedBytes(int delta) {
            void var1_1;
            assert (delta >= 0);
            this.decompressed += var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final int consumeBytes(int streamId, int decompressedBytes) throws Http2Exception {
            void var3_4;
            void var2_2;
            ObjectUtil.checkPositiveOrZero((int)decompressedBytes, (String)"decompressedBytes");
            if (this.decompressed - decompressedBytes < 0) {
                throw Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d. decompressed: %d decompressedBytes: %d", streamId, this.decompressed, decompressedBytes);
            }
            double consumedRatio = (double)decompressedBytes / (double)this.decompressed;
            int consumedCompressed = Math.min(this.compressed, (int)Math.ceil((double)this.compressed * consumedRatio));
            if (this.compressed - consumedCompressed < 0) {
                void var1_1;
                throw Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, "overflow when converting decompressed bytes to compressed bytes for stream %d.decompressedBytes: %d decompressed: %d compressed: %d consumedCompressed: %d", (int)var1_1, decompressedBytes, this.decompressed, this.compressed, consumedCompressed);
            }
            this.decompressed -= var2_2;
            this.compressed -= consumedCompressed;
            return (int)var3_4;
        }
    }

    private final class ConsumedBytesConverter
    implements Http2LocalFlowController {
        private final Http2LocalFlowController flowController;

        /*
         * WARNING - void declaration
         */
        ConsumedBytesConverter(Http2LocalFlowController flowController) {
            void var2_2;
            this.flowController = (Http2LocalFlowController)ObjectUtil.checkNotNull((Object)var2_2, (String)"flowController");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Http2LocalFlowController frameWriter(Http2FrameWriter frameWriter) {
            void var1_1;
            return this.flowController.frameWriter((Http2FrameWriter)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void channelHandlerContext(ChannelHandlerContext ctx) throws Http2Exception {
            void var1_1;
            this.flowController.channelHandlerContext((ChannelHandlerContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void initialWindowSize(int newWindowSize) throws Http2Exception {
            void var1_1;
            this.flowController.initialWindowSize((int)var1_1);
        }

        @Override
        public final int initialWindowSize() {
            return this.flowController.initialWindowSize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int windowSize(Http2Stream stream) {
            void var1_1;
            return this.flowController.windowSize((Http2Stream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
            void var2_2;
            void var1_1;
            this.flowController.incrementWindowSize((Http2Stream)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void receiveFlowControlledFrame(Http2Stream stream, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.flowController.receiveFlowControlledFrame((Http2Stream)var1_1, (ByteBuf)var2_2, (int)var3_3, endOfStream);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean consumeBytes(Http2Stream stream, int numBytes2) throws Http2Exception {
            Http2Decompressor decompressor = DelegatingDecompressorFrameListener.this.decompressor(stream);
            if (decompressor != null) {
                void var3_5;
                numBytes2 = var3_5.consumeBytes(stream.id(), numBytes2);
            }
            try {
                return this.flowController.consumeBytes(stream, numBytes2);
            }
            catch (Http2Exception http2Exception) {
                Http2Exception numBytes2 = http2Exception;
                throw http2Exception;
            }
            catch (Throwable t) {
                void var2_4;
                void var1_1;
                throw Http2Exception.streamError(var1_1.id(), Http2Error.INTERNAL_ERROR, (Throwable)var2_4, "Error while returning bytes to flow control window", new Object[0]);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int unconsumedBytes(Http2Stream stream) {
            void var1_1;
            return this.flowController.unconsumedBytes((Http2Stream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int initialWindowSize(Http2Stream stream) {
            void var1_1;
            return this.flowController.initialWindowSize((Http2Stream)var1_1);
        }
    }
}

