/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2UnknownFrame;
import io.netty.util.internal.StringUtil;

public final class DefaultHttp2UnknownFrame
extends DefaultByteBufHolder
implements Http2UnknownFrame {
    private final byte frameType;
    private final Http2Flags flags;
    private Http2FrameStream stream;

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2UnknownFrame(byte frameType, Http2Flags flags) {
        this((byte)var1_1, (Http2Flags)var2_2, Unpooled.EMPTY_BUFFER);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2UnknownFrame(byte frameType, Http2Flags flags, ByteBuf data) {
        super((ByteBuf)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.frameType = var1_1;
        this.flags = var2_2;
    }

    @Override
    public final Http2FrameStream stream() {
        return this.stream;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2UnknownFrame stream(Http2FrameStream stream) {
        void var1_1;
        this.stream = var1_1;
        return this;
    }

    @Override
    public final byte frameType() {
        return this.frameType;
    }

    @Override
    public final Http2Flags flags() {
        return this.flags;
    }

    @Override
    public final String name() {
        return "UNKNOWN";
    }

    @Override
    public final DefaultHttp2UnknownFrame copy() {
        DefaultHttp2UnknownFrame defaultHttp2UnknownFrame = this;
        return defaultHttp2UnknownFrame.replace(defaultHttp2UnknownFrame.content().copy());
    }

    @Override
    public final DefaultHttp2UnknownFrame duplicate() {
        DefaultHttp2UnknownFrame defaultHttp2UnknownFrame = this;
        return defaultHttp2UnknownFrame.replace(defaultHttp2UnknownFrame.content().duplicate());
    }

    @Override
    public final DefaultHttp2UnknownFrame retainedDuplicate() {
        DefaultHttp2UnknownFrame defaultHttp2UnknownFrame = this;
        return defaultHttp2UnknownFrame.replace(defaultHttp2UnknownFrame.content().retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2UnknownFrame replace(ByteBuf content) {
        void var1_1;
        return new DefaultHttp2UnknownFrame(this.frameType, this.flags, (ByteBuf)var1_1).stream(this.stream);
    }

    @Override
    public final DefaultHttp2UnknownFrame retain() {
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2UnknownFrame retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "(frameType=" + this.frameType + ", stream=" + this.stream + ", flags=" + this.flags + ", content=" + this.contentToString() + ')';
    }

    @Override
    public final DefaultHttp2UnknownFrame touch() {
        super.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2UnknownFrame touch(Object hint) {
        void var1_1;
        super.touch((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        void var2_2;
        if (!(o instanceof DefaultHttp2UnknownFrame)) {
            return false;
        }
        DefaultHttp2UnknownFrame other = (DefaultHttp2UnknownFrame)o;
        Http2FrameStream otherStream = other.stream();
        return (this.stream == otherStream || otherStream != null && var2_2.equals(this.stream)) && this.flags.equals(other.flags()) && this.frameType == other.frameType() && super.equals((Object)var1_1);
    }

    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.frameType;
        int hash = n * 31 + this.flags.hashCode();
        if (this.stream != null) {
            hash = hash * 31 + this.stream.hashCode();
        }
        return n;
    }
}

