/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2RemoteFlowController.class);
    private static final int MIN_WRITABLE_CHUNK = 32768;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private final StreamByteDistributor streamByteDistributor;
    private final FlowState connectionState;
    private int initialWindowSize = 65535;
    private WritabilityMonitor monitor;
    private ChannelHandlerContext ctx;

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2RemoteFlowController(Http2Connection connection) {
        this((Http2Connection)var1_1, (Http2RemoteFlowController.Listener)null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2RemoteFlowController(Http2Connection connection, StreamByteDistributor streamByteDistributor) {
        this((Http2Connection)var1_1, (StreamByteDistributor)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2RemoteFlowController(Http2Connection connection, Http2RemoteFlowController.Listener listener) {
        this(connection, new WeightedFairQueueByteDistributor((Http2Connection)var1_1), (Http2RemoteFlowController.Listener)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2RemoteFlowController(Http2Connection connection, StreamByteDistributor streamByteDistributor, Http2RemoteFlowController.Listener listener) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.streamByteDistributor = (StreamByteDistributor)ObjectUtil.checkNotNull((Object)var2_2, (String)"streamWriteDistributor");
        this.stateKey = connection.newKey();
        this.connectionState = new FlowState(connection.connectionStream());
        connection.connectionStream().setProperty(this.stateKey, this.connectionState);
        this.listener((Http2RemoteFlowController.Listener)var3_3);
        this.monitor.windowSize(this.connectionState, this.initialWindowSize);
        var1_1.addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ DefaultHttp2RemoteFlowController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamAdded(Http2Stream stream) {
                void var1_1;
                stream.setProperty(this.this$0.stateKey, this.this$0.new FlowState((Http2Stream)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamActive(Http2Stream stream) {
                void var1_1;
                this.this$0.monitor.windowSize(DefaultHttp2RemoteFlowController.access$100(this.this$0, (Http2Stream)var1_1), this.this$0.initialWindowSize);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamClosed(Http2Stream stream) {
                void var1_1;
                DefaultHttp2RemoteFlowController.access$100(this.this$0, (Http2Stream)var1_1).cancel(Http2Error.STREAM_CLOSED, null);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamHalfClosed(Http2Stream stream) {
                if (Http2Stream.State.HALF_CLOSED_LOCAL == stream.state()) {
                    void var1_1;
                    DefaultHttp2RemoteFlowController.access$100(this.this$0, (Http2Stream)var1_1).cancel(Http2Error.STREAM_CLOSED, null);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelHandlerContext(ChannelHandlerContext ctx) throws Http2Exception {
        void var1_1;
        this.ctx = (ChannelHandlerContext)ObjectUtil.checkNotNull((Object)var1_1, (String)"ctx");
        this.channelWritabilityChanged();
        if (this.isChannelWritable()) {
            this.writePendingBytes();
        }
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialWindowSize(int newWindowSize) throws Http2Exception {
        void var1_1;
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.initialWindowSize((int)var1_1);
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int windowSize(Http2Stream stream) {
        void var1_1;
        return this.state((Http2Stream)var1_1).windowSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWritable(Http2Stream stream) {
        void var1_1;
        return this.monitor.isWritable(this.state((Http2Stream)var1_1));
    }

    @Override
    public void channelWritabilityChanged() throws Http2Exception {
        this.monitor.channelWritabilityChange();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateDependencyTree(int childStreamId, int parentStreamId, short weight, boolean exclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (weight > 0 && weight <= 256) : "Invalid weight";
        assert (childStreamId != parentStreamId) : "A stream cannot depend on itself";
        assert (childStreamId > 0 && parentStreamId >= 0) : "childStreamId must be > 0. parentStreamId must be >= 0.";
        this.streamByteDistributor.updateDependencyTree((int)var1_1, (int)var2_2, (short)var3_3, exclusive);
    }

    private boolean isChannelWritable() {
        return this.ctx != null && this.isChannelWritable0();
    }

    private boolean isChannelWritable0() {
        return this.ctx.channel().isWritable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void listener(Http2RemoteFlowController.Listener listener) {
        void var1_1;
        this.monitor = listener == null ? new WritabilityMonitor() : new ListenerWritabilityMonitor((Http2RemoteFlowController.Listener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
        void var2_2;
        void var1_1;
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.incrementWindowSize(this.state((Http2Stream)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addFlowControlled(Http2Stream stream, Http2RemoteFlowController.FlowControlled frame) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull((Object)frame, (String)"frame");
        try {
            this.monitor.enqueueFrame(this.state(stream), frame);
            return;
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            var2_3.error(this.ctx, (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasFlowControlled(Http2Stream stream) {
        void var1_1;
        return this.state((Http2Stream)var1_1).hasFrame();
    }

    private FlowState state(Http2Stream stream) {
        return (FlowState)stream.getProperty(this.stateKey);
    }

    private int connectionWindowSize() {
        return this.connectionState.windowSize();
    }

    private int minUsableChannelBytes() {
        return Math.max(this.ctx.channel().config().getWriteBufferLowWaterMark(), 32768);
    }

    /*
     * WARNING - void declaration
     */
    private int maxUsableChannelBytes() {
        void var1_1;
        int channelWritableBytes = (int)Math.min(Integer.MAX_VALUE, this.ctx.channel().bytesBeforeUnwritable());
        int usableBytes = channelWritableBytes > 0 ? Math.max(channelWritableBytes, this.minUsableChannelBytes()) : 0;
        return Math.min(this.connectionState.windowSize(), (int)var1_1);
    }

    private int writableBytes() {
        return Math.min(this.connectionWindowSize(), this.maxUsableChannelBytes());
    }

    @Override
    public void writePendingBytes() throws Http2Exception {
        this.monitor.writePendingBytes();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ FlowState access$100(DefaultHttp2RemoteFlowController x0, Http2Stream x1) {
        void var1_1;
        return x0.state((Http2Stream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$202(DefaultHttp2RemoteFlowController x0, int x1) {
        void var1_1;
        x0.initialWindowSize = var1_1;
        return x0.initialWindowSize;
    }

    private final class ListenerWritabilityMonitor
    extends WritabilityMonitor
    implements Http2StreamVisitor {
        private final Http2RemoteFlowController.Listener listener;

        /*
         * WARNING - void declaration
         */
        ListenerWritabilityMonitor(Http2RemoteFlowController.Listener listener) {
            void var2_2;
            this.listener = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean visit(Http2Stream stream) throws Http2Exception {
            FlowState state = DefaultHttp2RemoteFlowController.access$100(DefaultHttp2RemoteFlowController.this, stream);
            if (this.isWritable(state) != state.markedWritability()) {
                void var1_1;
                this.notifyWritabilityChanged((FlowState)var1_1);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void windowSize(FlowState state, int initialWindowSize) {
            void var2_3;
            super.windowSize(state, (int)var2_3);
            try {
                this.checkStateWritability(state);
                return;
            }
            catch (Http2Exception e) {
                void var1_2;
                throw new RuntimeException("Caught unexpected exception from window", (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void incrementWindowSize(FlowState state, int delta) throws Http2Exception {
            void var1_1;
            void var2_2;
            super.incrementWindowSize(state, (int)var2_2);
            this.checkStateWritability((FlowState)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void initialWindowSize(int newWindowSize) throws Http2Exception {
            void var1_1;
            super.initialWindowSize((int)var1_1);
            if (this.isWritableConnection()) {
                this.checkAllWritabilityChanged();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void enqueueFrame(FlowState state, Http2RemoteFlowController.FlowControlled frame) throws Http2Exception {
            void var1_1;
            void var2_2;
            super.enqueueFrame(state, (Http2RemoteFlowController.FlowControlled)var2_2);
            this.checkConnectionThenStreamWritabilityChanged((FlowState)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void stateCancelled(FlowState state) {
            try {
                this.checkConnectionThenStreamWritabilityChanged(state);
                return;
            }
            catch (Http2Exception e) {
                void var1_2;
                throw new RuntimeException("Caught unexpected exception from checkAllWritabilityChanged", (Throwable)var1_2);
            }
        }

        @Override
        final void channelWritabilityChange() throws Http2Exception {
            if (DefaultHttp2RemoteFlowController.this.connectionState.markedWritability() != DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.checkAllWritabilityChanged();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void checkStateWritability(FlowState state) throws Http2Exception {
            if (this.isWritable(state) != state.markedWritability()) {
                void var1_1;
                if (state == DefaultHttp2RemoteFlowController.this.connectionState) {
                    this.checkAllWritabilityChanged();
                    return;
                }
                this.notifyWritabilityChanged((FlowState)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void notifyWritabilityChanged(FlowState state) {
            FlowState flowState = state;
            flowState.markedWritability(!flowState.markedWritability());
            try {
                this.listener.writabilityChanged(state.stream);
                return;
            }
            catch (Throwable cause) {
                void var1_2;
                logger.error("Caught Throwable from listener.writabilityChanged", (Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void checkConnectionThenStreamWritabilityChanged(FlowState state) throws Http2Exception {
            if (this.isWritableConnection() != DefaultHttp2RemoteFlowController.this.connectionState.markedWritability()) {
                this.checkAllWritabilityChanged();
                return;
            }
            if (this.isWritable(state) != state.markedWritability()) {
                void var1_1;
                this.notifyWritabilityChanged((FlowState)var1_1);
            }
        }

        private void checkAllWritabilityChanged() throws Http2Exception {
            DefaultHttp2RemoteFlowController.this.connectionState.markedWritability(this.isWritableConnection());
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(this);
        }
    }

    private class WritabilityMonitor
    implements StreamByteDistributor.Writer {
        private boolean inWritePendingBytes;
        private long totalPendingBytes;

        private WritabilityMonitor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Http2Stream stream, int numBytes) {
            void var2_2;
            void var1_1;
            DefaultHttp2RemoteFlowController.access$100(DefaultHttp2RemoteFlowController.this, (Http2Stream)var1_1).writeAllocatedBytes((int)var2_2);
        }

        void channelWritabilityChange() throws Http2Exception {
        }

        void stateCancelled(FlowState state) {
        }

        /*
         * WARNING - void declaration
         */
        void windowSize(FlowState state, int initialWindowSize) {
            void var2_2;
            state.windowSize((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        void incrementWindowSize(FlowState state, int delta) throws Http2Exception {
            void var2_2;
            state.incrementStreamWindow((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        void enqueueFrame(FlowState state, Http2RemoteFlowController.FlowControlled frame) throws Http2Exception {
            void var2_2;
            state.enqueueFrame((Http2RemoteFlowController.FlowControlled)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final void incrementPendingBytes(int delta) {
            void var1_1;
            this.totalPendingBytes += (long)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final boolean isWritable(FlowState state) {
            void var1_1;
            return this.isWritableConnection() && var1_1.isWritable();
        }

        final void writePendingBytes() throws Http2Exception {
            if (this.inWritePendingBytes) {
                return;
            }
            this.inWritePendingBytes = true;
            try {
                int bytesToWrite = DefaultHttp2RemoteFlowController.this.writableBytes();
                while (DefaultHttp2RemoteFlowController.this.streamByteDistributor.distribute(bytesToWrite, this) && (bytesToWrite = DefaultHttp2RemoteFlowController.this.writableBytes()) > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable0()) {
                }
                return;
            }
            finally {
                this.inWritePendingBytes = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        void initialWindowSize(int newWindowSize) throws Http2Exception {
            void var2_2;
            void var1_1;
            ObjectUtil.checkPositiveOrZero((int)newWindowSize, (String)"newWindowSize");
            int delta = newWindowSize - DefaultHttp2RemoteFlowController.this.initialWindowSize;
            DefaultHttp2RemoteFlowController.access$202(DefaultHttp2RemoteFlowController.this, (int)var1_1);
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(new Http2StreamVisitor(this, delta){
                final /* synthetic */ int val$delta;
                final /* synthetic */ WritabilityMonitor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$delta = n;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean visit(Http2Stream stream) throws Http2Exception {
                    void var1_1;
                    DefaultHttp2RemoteFlowController.access$100(this.this$1.DefaultHttp2RemoteFlowController.this, (Http2Stream)var1_1).incrementStreamWindow(this.val$delta);
                    return true;
                }
            });
            if (var2_2 > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.writePendingBytes();
            }
        }

        final boolean isWritableConnection() {
            return (long)DefaultHttp2RemoteFlowController.this.connectionState.windowSize() - this.totalPendingBytes > 0L && DefaultHttp2RemoteFlowController.this.isChannelWritable();
        }
    }

    private final class FlowState
    implements StreamByteDistributor.StreamState {
        private final Http2Stream stream;
        private final Deque<Http2RemoteFlowController.FlowControlled> pendingWriteQueue;
        private int window;
        private long pendingBytes;
        private boolean markedWritable;
        private boolean writing;
        private boolean cancelled;

        /*
         * WARNING - void declaration
         */
        FlowState(Http2Stream stream) {
            void var2_2;
            this.stream = var2_2;
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        final boolean isWritable() {
            return (long)this.windowSize() > this.pendingBytes() && !this.cancelled;
        }

        @Override
        public final Http2Stream stream() {
            return this.stream;
        }

        final boolean markedWritability() {
            return this.markedWritable;
        }

        /*
         * WARNING - void declaration
         */
        final void markedWritability(boolean isWritable) {
            void var1_1;
            this.markedWritable = var1_1;
        }

        @Override
        public final int windowSize() {
            return this.window;
        }

        /*
         * WARNING - void declaration
         */
        final void windowSize(int initialWindowSize) {
            void var1_1;
            this.window = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final int writeAllocatedBytes(int allocated) {
            void var1_1;
            int writtenBytes;
            int initialAllocated = allocated;
            try {
                int maxBytes;
                Http2RemoteFlowController.FlowControlled frame;
                assert (!this.writing);
                this.writing = true;
                boolean writeOccurred = false;
                while (!(this.cancelled || (frame = this.peek()) == null || (maxBytes = Math.min(allocated, this.writableWindow())) <= 0 && frame.size() > 0)) {
                    writeOccurred = true;
                    int initialFrameSize = frame.size();
                    try {
                        frame.write(DefaultHttp2RemoteFlowController.this.ctx, Math.max(0, maxBytes));
                        if (frame.size() != 0) continue;
                        this.pendingWriteQueue.remove();
                        frame.writeComplete();
                    }
                    finally {
                        allocated -= initialFrameSize - frame.size();
                    }
                }
                if (!writeOccurred) {
                    this.writing = false;
                    writtenBytes = initialAllocated - allocated;
                    this.decrementPendingBytes(writtenBytes, false);
                    this.decrementFlowControlWindow(writtenBytes);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, null);
                    }
                    return -1;
                }
                this.writing = false;
                writtenBytes = initialAllocated - writtenBytes;
                this.decrementPendingBytes(writtenBytes, false);
                this.decrementFlowControlWindow(writtenBytes);
                if (this.cancelled) {
                    this.cancel(Http2Error.INTERNAL_ERROR, null);
                }
            }
            catch (Throwable t) {
                try {
                    this.cancelled = true;
                    Throwable cause = t;
                    this.writing = false;
                    writtenBytes = initialAllocated - writtenBytes;
                    this.decrementPendingBytes(writtenBytes, false);
                    this.decrementFlowControlWindow(writtenBytes);
                    if (this.cancelled) {
                        void var3_7;
                        this.cancel(Http2Error.INTERNAL_ERROR, (Throwable)var3_7);
                    }
                }
                catch (Throwable throwable) {
                    void var2_2;
                    this.writing = false;
                    writtenBytes = var2_2 - writtenBytes;
                    this.decrementPendingBytes(writtenBytes, false);
                    this.decrementFlowControlWindow(writtenBytes);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, null);
                    }
                    throw throwable;
                }
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final int incrementStreamWindow(int delta) throws Http2Exception {
            void var1_1;
            if (delta > 0 && Integer.MAX_VALUE - delta < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
            }
            this.window += var1_1;
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            return this.window;
        }

        private int writableWindow() {
            return Math.min(this.window, DefaultHttp2RemoteFlowController.this.connectionWindowSize());
        }

        @Override
        public final long pendingBytes() {
            return this.pendingBytes;
        }

        /*
         * WARNING - void declaration
         */
        final void enqueueFrame(Http2RemoteFlowController.FlowControlled frame) {
            void var1_1;
            Http2RemoteFlowController.FlowControlled last = this.pendingWriteQueue.peekLast();
            if (last == null) {
                this.enqueueFrameWithoutMerge(frame);
                return;
            }
            int lastSize = last.size();
            if (last.merge(DefaultHttp2RemoteFlowController.this.ctx, frame)) {
                void var3_3;
                void var2_2;
                this.incrementPendingBytes(var2_2.size() - var3_3, true);
                return;
            }
            this.enqueueFrameWithoutMerge((Http2RemoteFlowController.FlowControlled)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void enqueueFrameWithoutMerge(Http2RemoteFlowController.FlowControlled frame) {
            void var1_1;
            this.pendingWriteQueue.offer(frame);
            this.incrementPendingBytes(var1_1.size(), true);
        }

        @Override
        public final boolean hasFrame() {
            return !this.pendingWriteQueue.isEmpty();
        }

        private Http2RemoteFlowController.FlowControlled peek() {
            return this.pendingWriteQueue.peek();
        }

        /*
         * WARNING - void declaration
         */
        final void cancel(Http2Error error, Throwable cause) {
            this.cancelled = true;
            if (this.writing) {
                return;
            }
            Http2RemoteFlowController.FlowControlled frame = this.pendingWriteQueue.poll();
            if (frame != null) {
                void var2_2;
                Http2Exception exception = Http2Exception.streamError(this.stream.id(), error, (Throwable)var2_2, "Stream closed before write could take place", new Object[0]);
                do {
                    this.writeError(frame, exception);
                } while ((frame = this.pendingWriteQueue.poll()) != null);
            }
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            DefaultHttp2RemoteFlowController.this.monitor.stateCancelled(this);
        }

        /*
         * WARNING - void declaration
         */
        private void incrementPendingBytes(int numBytes, boolean updateStreamableBytes) {
            void var2_2;
            void var1_1;
            this.pendingBytes += (long)numBytes;
            DefaultHttp2RemoteFlowController.this.monitor.incrementPendingBytes((int)var1_1);
            if (var2_2 != false) {
                DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void decrementPendingBytes(int bytes, boolean updateStreamableBytes) {
            void var2_2;
            void var1_1;
            this.incrementPendingBytes((int)(-var1_1), (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void decrementFlowControlWindow(int bytes) {
            try {
                int negativeBytes = -bytes;
                DefaultHttp2RemoteFlowController.this.connectionState.incrementStreamWindow(negativeBytes);
                this.incrementStreamWindow(negativeBytes);
                return;
            }
            catch (Http2Exception e) {
                void var1_2;
                throw new IllegalStateException("Invalid window state when writing frame: " + e.getMessage(), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeError(Http2RemoteFlowController.FlowControlled frame, Http2Exception cause) {
            void var2_2;
            void var1_1;
            assert (DefaultHttp2RemoteFlowController.this.ctx != null);
            this.decrementPendingBytes(frame.size(), true);
            var1_1.error(DefaultHttp2RemoteFlowController.this.ctx, (Throwable)var2_2);
        }
    }
}

