/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

public class DefaultHttp2LocalFlowController
implements Http2LocalFlowController {
    public static final float DEFAULT_WINDOW_UPDATE_RATIO = 0.5f;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private Http2FrameWriter frameWriter;
    private ChannelHandlerContext ctx;
    private float windowUpdateRatio;
    private int initialWindowSize = 65535;
    private static final FlowState REDUCED_FLOW_STATE = new FlowState(){

        @Override
        public final int windowSize() {
            return 0;
        }

        @Override
        public final int initialWindowSize() {
            return 0;
        }

        @Override
        public final void window(int initialWindowSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void incrementInitialStreamWindow(int delta) {
        }

        @Override
        public final boolean writeWindowUpdateIfNeeded() throws Http2Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean consumeBytes(int numBytes) throws Http2Exception {
            return false;
        }

        @Override
        public final int unconsumedBytes() {
            return 0;
        }

        @Override
        public final float windowUpdateRatio() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void windowUpdateRatio(float ratio) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void receiveFlowControlledFrame(int dataLength) throws Http2Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void incrementFlowControlWindows(int delta) throws Http2Exception {
        }

        @Override
        public final void endOfStream(boolean endOfStream) {
            throw new UnsupportedOperationException();
        }
    };

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2LocalFlowController(Http2Connection connection) {
        this((Http2Connection)var1_1, 0.5f, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2LocalFlowController(Http2Connection connection, float windowUpdateRatio, boolean autoRefillConnectionWindow) {
        void var1_1;
        void var2_3;
        void var3_4;
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.windowUpdateRatio(windowUpdateRatio);
        this.stateKey = connection.newKey();
        DefaultState connectionState = var3_4 != false ? new AutoRefillState(connection.connectionStream(), this.initialWindowSize) : new DefaultState(connection.connectionStream(), this.initialWindowSize);
        connection.connectionStream().setProperty(this.stateKey, var2_3);
        var1_1.addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ DefaultHttp2LocalFlowController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void onStreamAdded(Http2Stream stream) {
                stream.setProperty(this.this$0.stateKey, REDUCED_FLOW_STATE);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamActive(Http2Stream stream) {
                void var1_1;
                stream.setProperty(this.this$0.stateKey, this.this$0.new DefaultState((Http2Stream)var1_1, this.this$0.initialWindowSize));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamClosed(Http2Stream stream) {
                try {
                    void var3_5;
                    void var2_2;
                    FlowState state = DefaultHttp2LocalFlowController.access$300(this.this$0, stream);
                    int unconsumedBytes = state.unconsumedBytes();
                    if (this.this$0.ctx != null && unconsumedBytes > 0 && DefaultHttp2LocalFlowController.access$500(this.this$0, (FlowState)var2_2, (int)var3_5)) {
                        this.this$0.ctx.flush();
                    }
                    stream.setProperty(this.this$0.stateKey, REDUCED_FLOW_STATE);
                }
                catch (Http2Exception http2Exception) {
                    try {
                        Http2Exception http2Exception2 = http2Exception;
                        PlatformDependent.throwException((Throwable)http2Exception);
                        stream.setProperty(this.this$0.stateKey, REDUCED_FLOW_STATE);
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        var1_1.setProperty(this.this$0.stateKey, REDUCED_FLOW_STATE);
                        throw throwable;
                    }
                    return;
                }
                return;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultHttp2LocalFlowController frameWriter(Http2FrameWriter frameWriter) {
        void var1_1;
        this.frameWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)var1_1, (String)"frameWriter");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelHandlerContext(ChannelHandlerContext ctx) {
        void var1_1;
        this.ctx = (ChannelHandlerContext)ObjectUtil.checkNotNull((Object)var1_1, (String)"ctx");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialWindowSize(int newWindowSize) throws Http2Exception {
        void var1_2;
        void var2_3;
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        int delta = newWindowSize - this.initialWindowSize;
        this.initialWindowSize = newWindowSize;
        WindowUpdateVisitor visitor = new WindowUpdateVisitor((int)var2_3);
        this.connection.forEachActiveStream(visitor);
        var1_2.throwIfError();
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int windowSize(Http2Stream stream) {
        void var1_1;
        return this.state((Http2Stream)var1_1).windowSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int initialWindowSize(Http2Stream stream) {
        void var1_1;
        return this.state((Http2Stream)var1_1).initialWindowSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
        void var1_1;
        void var2_2;
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        FlowState state = this.state(stream);
        state.incrementInitialStreamWindow((int)var2_2);
        var1_1.writeWindowUpdateIfNeeded();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean consumeBytes(Http2Stream stream, int numBytes) throws Http2Exception {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        ObjectUtil.checkPositiveOrZero((int)numBytes, (String)"numBytes");
        if (numBytes == 0) {
            return false;
        }
        if (stream != null && !DefaultHttp2LocalFlowController.isClosed(stream)) {
            void var2_2;
            void var1_1;
            if (stream.id() == 0) {
                throw new UnsupportedOperationException("Returning bytes for the connection window is not supported");
            }
            DefaultHttp2LocalFlowController defaultHttp2LocalFlowController = this;
            return defaultHttp2LocalFlowController.consumeAllBytes(defaultHttp2LocalFlowController.state((Http2Stream)var1_1), (int)var2_2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean consumeAllBytes(FlowState state, int numBytes) throws Http2Exception {
        void var2_2;
        void var1_1;
        return this.connectionState().consumeBytes(numBytes) | var1_1.consumeBytes((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int unconsumedBytes(Http2Stream stream) {
        void var1_1;
        return this.state((Http2Stream)var1_1).unconsumedBytes();
    }

    private static void checkValidRatio(float ratio) {
        if (Double.compare(ratio, 0.0) <= 0 || Double.compare(ratio, 1.0) >= 0) {
            float f;
            throw new IllegalArgumentException("Invalid ratio: " + f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void windowUpdateRatio(float ratio) {
        void var1_1;
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(ratio);
        this.windowUpdateRatio = var1_1;
    }

    public float windowUpdateRatio() {
        return this.windowUpdateRatio;
    }

    /*
     * WARNING - void declaration
     */
    public void windowUpdateRatio(Http2Stream stream, float ratio) throws Http2Exception {
        void var1_1;
        void var2_2;
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(ratio);
        FlowState state = this.state(stream);
        state.windowUpdateRatio((float)var2_2);
        var1_1.writeWindowUpdateIfNeeded();
    }

    /*
     * WARNING - void declaration
     */
    public float windowUpdateRatio(Http2Stream stream) throws Http2Exception {
        void var1_1;
        return this.state((Http2Stream)var1_1).windowUpdateRatio();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveFlowControlledFrame(Http2Stream stream, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        int dataLength = data.readableBytes() + padding;
        FlowState connectionState = this.connectionState();
        connectionState.receiveFlowControlledFrame(dataLength);
        if (stream != null && !DefaultHttp2LocalFlowController.isClosed(stream)) {
            void var1_1;
            FlowState state = this.state(stream);
            state.endOfStream(endOfStream);
            var1_1.receiveFlowControlledFrame(dataLength);
            return;
        }
        if (dataLength > 0) {
            void var2_3;
            void var3_5;
            var3_5.consumeBytes((int)var2_3);
        }
    }

    private FlowState connectionState() {
        return (FlowState)this.connection.connectionStream().getProperty(this.stateKey);
    }

    private FlowState state(Http2Stream stream) {
        return (FlowState)stream.getProperty(this.stateKey);
    }

    private static boolean isClosed(Http2Stream stream) {
        return stream.state() == Http2Stream.State.CLOSED;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ FlowState access$300(DefaultHttp2LocalFlowController x0, Http2Stream x1) {
        void var1_1;
        return x0.state((Http2Stream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$500(DefaultHttp2LocalFlowController x0, FlowState x1, int x2) throws Http2Exception {
        void var2_2;
        void var1_1;
        return x0.consumeAllBytes((FlowState)var1_1, (int)var2_2);
    }

    private final class WindowUpdateVisitor
    implements Http2StreamVisitor {
        private Http2Exception.CompositeStreamException compositeException;
        private final int delta;

        /*
         * WARNING - void declaration
         */
        WindowUpdateVisitor(int delta) {
            void var2_2;
            this.delta = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean visit(Http2Stream stream) throws Http2Exception {
            try {
                FlowState state = DefaultHttp2LocalFlowController.access$300(DefaultHttp2LocalFlowController.this, stream);
                state.incrementFlowControlWindows(this.delta);
                state.incrementInitialStreamWindow(this.delta);
            }
            catch (Http2Exception.StreamException e) {
                void var1_2;
                if (this.compositeException == null) {
                    this.compositeException = new Http2Exception.CompositeStreamException(e.error(), 4);
                }
                this.compositeException.add((Http2Exception.StreamException)var1_2);
            }
            return true;
        }

        public final void throwIfError() throws Http2Exception.CompositeStreamException {
            if (this.compositeException != null) {
                throw this.compositeException;
            }
        }
    }

    private static interface FlowState {
        public int windowSize();

        public int initialWindowSize();

        public void window(int var1);

        public void incrementInitialStreamWindow(int var1);

        public boolean writeWindowUpdateIfNeeded() throws Http2Exception;

        public boolean consumeBytes(int var1) throws Http2Exception;

        public int unconsumedBytes();

        public float windowUpdateRatio();

        public void windowUpdateRatio(float var1);

        public void receiveFlowControlledFrame(int var1) throws Http2Exception;

        public void incrementFlowControlWindows(int var1) throws Http2Exception;

        public void endOfStream(boolean var1);
    }

    private class DefaultState
    implements FlowState {
        private final Http2Stream stream;
        private int window;
        private int processedWindow;
        private int initialStreamWindowSize;
        private float streamWindowUpdateRatio;
        private int lowerBound;
        private boolean endOfStream;

        /*
         * WARNING - void declaration
         */
        DefaultState(Http2Stream stream, int initialWindowSize) {
            void var3_3;
            void var2_2;
            this.stream = var2_2;
            this.window((int)var3_3);
            this.streamWindowUpdateRatio = DefaultHttp2LocalFlowController.this.windowUpdateRatio;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void window(int initialWindowSize) {
            void var1_1;
            assert (DefaultHttp2LocalFlowController.this.ctx == null || DefaultHttp2LocalFlowController.this.ctx.executor().inEventLoop());
            DefaultState defaultState = this;
            defaultState.processedWindow = this.initialStreamWindowSize = var1_1;
            defaultState.window = this.initialStreamWindowSize;
        }

        @Override
        public int windowSize() {
            return this.window;
        }

        @Override
        public int initialWindowSize() {
            return this.initialStreamWindowSize;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endOfStream(boolean endOfStream) {
            void var1_1;
            this.endOfStream = var1_1;
        }

        @Override
        public float windowUpdateRatio() {
            return this.streamWindowUpdateRatio;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void windowUpdateRatio(float ratio) {
            void var1_1;
            assert (DefaultHttp2LocalFlowController.this.ctx == null || DefaultHttp2LocalFlowController.this.ctx.executor().inEventLoop());
            this.streamWindowUpdateRatio = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void incrementInitialStreamWindow(int delta) {
            void var1_1;
            delta = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, (long)this.initialStreamWindowSize + (long)delta));
            delta -= this.initialStreamWindowSize;
            this.initialStreamWindowSize += var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void incrementFlowControlWindows(int delta) throws Http2Exception {
            void var1_1;
            if (delta > 0 && this.window > Integer.MAX_VALUE - delta) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window overflowed for stream: %d", this.stream.id());
            }
            this.window += delta;
            this.processedWindow += delta;
            this.lowerBound = Math.min((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void receiveFlowControlledFrame(int dataLength) throws Http2Exception {
            void var1_1;
            assert (dataLength >= 0);
            this.window -= var1_1;
            if (this.window < this.lowerBound) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window exceeded for stream: %d", this.stream.id());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void returnProcessedBytes(int delta) throws Http2Exception {
            void var1_1;
            if (this.processedWindow - delta < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d", this.stream.id());
            }
            this.processedWindow -= var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean consumeBytes(int numBytes) throws Http2Exception {
            void var1_1;
            this.returnProcessedBytes((int)var1_1);
            return this.writeWindowUpdateIfNeeded();
        }

        @Override
        public int unconsumedBytes() {
            return this.processedWindow - this.window;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean writeWindowUpdateIfNeeded() throws Http2Exception {
            void var1_1;
            if (this.endOfStream || this.initialStreamWindowSize <= 0 || DefaultHttp2LocalFlowController.isClosed(this.stream)) {
                return false;
            }
            int threshold = (int)((float)this.initialStreamWindowSize * this.streamWindowUpdateRatio);
            if (this.processedWindow <= var1_1) {
                this.writeWindowUpdate();
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private void writeWindowUpdate() throws Http2Exception {
            void var1_1;
            int deltaWindowSize = this.initialStreamWindowSize - this.processedWindow;
            try {
                this.incrementFlowControlWindows(deltaWindowSize);
            }
            catch (Throwable t) {
                void var1_2;
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, (Throwable)var1_2, "Attempting to return too many bytes for stream %d", this.stream.id());
            }
            DefaultHttp2LocalFlowController.this.frameWriter.writeWindowUpdate(DefaultHttp2LocalFlowController.this.ctx, this.stream.id(), (int)var1_1, DefaultHttp2LocalFlowController.this.ctx.newPromise());
        }
    }

    private final class AutoRefillState
    extends DefaultState {
        /*
         * WARNING - void declaration
         */
        AutoRefillState(Http2Stream stream, int initialWindowSize) {
            void var3_3;
            void var2_2;
            super((Http2Stream)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void receiveFlowControlledFrame(int dataLength) throws Http2Exception {
            void var1_1;
            super.receiveFlowControlledFrame(dataLength);
            super.consumeBytes((int)var1_1);
        }

        @Override
        public final boolean consumeBytes(int numBytes) throws Http2Exception {
            return false;
        }
    }
}

