/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.util.internal.ObjectUtil;
import java.io.Closeable;

public class DefaultHttp2HeadersEncoder
implements Http2HeadersEncoder,
Http2HeadersEncoder.Configuration,
Closeable {
    private final HpackEncoder hpackEncoder;
    private final Http2HeadersEncoder.SensitivityDetector sensitivityDetector;
    private ByteBuf tableSizeChangeOutput;

    public DefaultHttp2HeadersEncoder() {
        this(NEVER_SENSITIVE);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        this((Http2HeadersEncoder.SensitivityDetector)var1_1, new HpackEncoder());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, boolean ignoreMaxHeaderListSize) {
        this((Http2HeadersEncoder.SensitivityDetector)var1_1, new HpackEncoder((boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, boolean ignoreMaxHeaderListSize, int dynamicTableArraySizeHint) {
        this((Http2HeadersEncoder.SensitivityDetector)var1_1, (boolean)var2_2, (int)var3_3, 512);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, boolean ignoreMaxHeaderListSize, int dynamicTableArraySizeHint, int huffCodeThreshold) {
        this((Http2HeadersEncoder.SensitivityDetector)var1_1, new HpackEncoder((boolean)var2_2, (int)var3_3, huffCodeThreshold));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, HpackEncoder hpackEncoder) {
        void var2_2;
        void var1_1;
        this.sensitivityDetector = (Http2HeadersEncoder.SensitivityDetector)ObjectUtil.checkNotNull((Object)var1_1, (String)"sensitiveDetector");
        this.hpackEncoder = (HpackEncoder)ObjectUtil.checkNotNull((Object)var2_2, (String)"hpackEncoder");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void encodeHeaders(int streamId2, Http2Headers headers, ByteBuf buffer) throws Http2Exception {
        try {
            void var2_4;
            void var3_5;
            if (this.tableSizeChangeOutput != null && this.tableSizeChangeOutput.isReadable()) {
                buffer.writeBytes(this.tableSizeChangeOutput);
                this.tableSizeChangeOutput.clear();
            }
            this.hpackEncoder.encodeHeaders(streamId2, (ByteBuf)var3_5, (Http2Headers)var2_4, this.sensitivityDetector);
            return;
        }
        catch (Http2Exception http2Exception) {
            Http2Exception streamId2 = http2Exception;
            throw http2Exception;
        }
        catch (Throwable t) {
            void var1_3;
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, t, "Failed encoding headers block: %s", var1_3.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void maxHeaderTableSize(long max) throws Http2Exception {
        void var1_1;
        if (this.tableSizeChangeOutput == null) {
            this.tableSizeChangeOutput = Unpooled.buffer();
        }
        this.hpackEncoder.setMaxHeaderTableSize(this.tableSizeChangeOutput, (long)var1_1);
    }

    @Override
    public long maxHeaderTableSize() {
        return this.hpackEncoder.getMaxHeaderTableSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void maxHeaderListSize(long max) throws Http2Exception {
        void var1_1;
        this.hpackEncoder.setMaxHeaderListSize((long)var1_1);
    }

    @Override
    public long maxHeaderListSize() {
        return this.hpackEncoder.getMaxHeaderListSize();
    }

    @Override
    public Http2HeadersEncoder.Configuration configuration() {
        return this;
    }

    @Override
    public void close() {
        if (this.tableSizeChangeOutput != null) {
            this.tableSizeChangeOutput.release();
            this.tableSizeChangeOutput = null;
        }
    }
}

