/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private static final float HEADERS_COUNT_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_COUNT_WEIGHT_HISTORICAL = 0.8f;
    private final HpackDecoder hpackDecoder;
    private final boolean validateHeaders;
    private final boolean validateHeaderValues;
    private long maxHeaderListSizeGoAway;
    private float headerArraySizeAccumulator = 8.0f;

    public DefaultHttp2HeadersDecoder() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersDecoder(boolean validateHeaders) {
        this((boolean)var1_1, 8192L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersDecoder(boolean validateHeaders, boolean validateHeaderValues) {
        this((boolean)var1_1, (boolean)var2_2, 8192L);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersDecoder(boolean validateHeaders, long maxHeaderListSize) {
        this((boolean)var1_1, false, new HpackDecoder((long)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersDecoder(boolean validateHeaders, boolean validateHeaderValues, long maxHeaderListSize) {
        this((boolean)var1_1, (boolean)var2_2, new HpackDecoder((long)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2HeadersDecoder(boolean validateHeaders, long maxHeaderListSize, @Deprecated int initialHuffmanDecodeCapacity) {
        this((boolean)var1_1, false, new HpackDecoder((long)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    DefaultHttp2HeadersDecoder(boolean validateHeaders, boolean validateHeaderValues, HpackDecoder hpackDecoder) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.hpackDecoder = (HpackDecoder)ObjectUtil.checkNotNull((Object)hpackDecoder, (String)"hpackDecoder");
        this.validateHeaders = var1_1;
        this.validateHeaderValues = var2_2;
        this.maxHeaderListSizeGoAway = Http2CodecUtil.calculateMaxHeaderListSizeGoAway(var3_3.getMaxHeaderListSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void maxHeaderTableSize(long max) throws Http2Exception {
        void var1_1;
        this.hpackDecoder.setMaxHeaderTableSize((long)var1_1);
    }

    @Override
    public long maxHeaderTableSize() {
        return this.hpackDecoder.getMaxHeaderTableSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void maxHeaderListSize(long max, long goAwayMax) throws Http2Exception {
        void var3_2;
        void var1_1;
        if (goAwayMax < max || goAwayMax < 0L) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Header List Size GO_AWAY %d must be non-negative and >= %d", goAwayMax, max);
        }
        this.hpackDecoder.setMaxHeaderListSize((long)var1_1);
        this.maxHeaderListSizeGoAway = var3_2;
    }

    @Override
    public long maxHeaderListSize() {
        return this.hpackDecoder.getMaxHeaderListSize();
    }

    @Override
    public long maxHeaderListSizeGoAway() {
        return this.maxHeaderListSizeGoAway;
    }

    @Override
    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Headers decodeHeaders(int streamId, ByteBuf headerBlock) throws Http2Exception {
        try {
            void var2_2;
            void var1_1;
            Http2Headers headers = this.newHeaders();
            this.hpackDecoder.decode((int)var1_1, (ByteBuf)var2_2, headers, this.validateHeaders);
            this.headerArraySizeAccumulator = 0.2f * (float)headers.size() + 0.8f * this.headerArraySizeAccumulator;
            return headers;
        }
        catch (Http2Exception http2Exception) {
            Http2Exception headers = http2Exception;
            throw http2Exception;
        }
        catch (Throwable e) {
            void var3_5;
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, e, "Error decoding headers: %s", var3_5.getMessage());
        }
    }

    protected final int numberOfHeadersGuess() {
        return (int)this.headerArraySizeAccumulator;
    }

    protected final boolean validateHeaders() {
        return this.validateHeaders;
    }

    protected boolean validateHeaderValues() {
        return this.validateHeaderValues;
    }

    protected Http2Headers newHeaders() {
        return new DefaultHttp2Headers(this.validateHeaders, this.validateHeaderValues, (int)this.headerArraySizeAccumulator);
    }
}

