/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.PlatformDependent;

public class DefaultHttp2Headers
extends DefaultHeaders<CharSequence, CharSequence, Http2Headers>
implements Http2Headers {
    private static final ByteProcessor HTTP2_NAME_VALIDATOR_PROCESSOR = new ByteProcessor(){

        public final boolean process(byte value) {
            return !AsciiString.isUpperCase((byte)value);
        }
    };
    static final DefaultHeaders.NameValidator<CharSequence> HTTP2_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        public final void validateName(CharSequence name) {
            if (name == null || name.length() == 0) {
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "empty headers are not allowed [%s]", name));
            }
            if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(name)) {
                if (!Http2Headers.PseudoHeaderName.isPseudoHeader(name)) {
                    PlatformDependent.throwException((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 pseudo-header '%s' encountered.", name));
                }
                return;
            }
            if (name instanceof AsciiString) {
                int index2;
                try {
                    index2 = ((AsciiString)name).forEachByte(HTTP2_NAME_VALIDATOR_PROCESSOR);
                }
                catch (Http2Exception http2Exception) {
                    Http2Exception index2 = http2Exception;
                    PlatformDependent.throwException((Throwable)http2Exception);
                    return;
                }
                catch (Throwable t) {
                    PlatformDependent.throwException((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, t, "unexpected error. invalid header name [%s]", name));
                    return;
                }
                if (index2 != -1) {
                    PlatformDependent.throwException((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name [%s]", name));
                }
                return;
            }
            for (int i = 0; i < name.length(); ++i) {
                if (!AsciiString.isUpperCase((char)name.charAt(i))) continue;
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name [%s]", name));
            }
        }
    };
    private static final DefaultHeaders.ValueValidator<CharSequence> VALUE_VALIDATOR = new DefaultHeaders.ValueValidator<CharSequence>(){

        /*
         * WARNING - void declaration
         */
        public final void validate(CharSequence value) {
            int index = HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value);
            if (index != -1) {
                void var2_2;
                void var1_1;
                throw new IllegalArgumentException("a header value contains prohibited character 0x" + Integer.toHexString(var1_1.charAt(index)) + " at index " + (int)var2_2 + '.');
            }
        }
    };
    private DefaultHeaders.HeaderEntry<CharSequence, CharSequence> firstNonPseudo;

    public DefaultHttp2Headers() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2Headers(boolean validate) {
        super(AsciiString.CASE_SENSITIVE_HASHER, (ValueConverter)CharSequenceValueConverter.INSTANCE, var1_1 != false ? HTTP2_NAME_VALIDATOR : DefaultHeaders.NameValidator.NOT_NULL);
        void var1_1;
        this.firstNonPseudo = this.head;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2Headers(boolean validate, int arraySizeHint) {
        super(AsciiString.CASE_SENSITIVE_HASHER, (ValueConverter)CharSequenceValueConverter.INSTANCE, var1_1 != false ? HTTP2_NAME_VALIDATOR : DefaultHeaders.NameValidator.NOT_NULL, (int)var2_2);
        void var2_2;
        void var1_1;
        this.firstNonPseudo = this.head;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2Headers(boolean validate, boolean validateValues, int arraySizeHint) {
        super(AsciiString.CASE_SENSITIVE_HASHER, (ValueConverter)CharSequenceValueConverter.INSTANCE, var1_1 != false ? HTTP2_NAME_VALIDATOR : DefaultHeaders.NameValidator.NOT_NULL, (int)var3_3, var2_2 != false ? VALUE_VALIDATOR : DefaultHeaders.ValueValidator.NO_VALIDATION);
        void var2_2;
        void var3_3;
        void var1_1;
        this.firstNonPseudo = this.head;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateName(DefaultHeaders.NameValidator<CharSequence> validator, boolean forAdd, CharSequence name) {
        void var2_2;
        void var1_1;
        super.validateName((DefaultHeaders.NameValidator)var1_1, forAdd, (Object)name);
        if (this.nameValidator() == HTTP2_NAME_VALIDATOR && var2_2 != false && Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(name) && this.contains(name)) {
            void var3_3;
            PlatformDependent.throwException((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Duplicate HTTP/2 pseudo-header '%s' encountered.", var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void validateValue(DefaultHeaders.ValueValidator<CharSequence> validator, CharSequence name, CharSequence value) {
        void var3_3;
        void var1_1;
        super.validateValue((DefaultHeaders.ValueValidator)var1_1, (Object)name, (Object)value);
        if (this.nameValidator() == HTTP2_NAME_VALIDATOR && (value == null || var3_3.length() == 0) && Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(name)) {
            void var2_2;
            PlatformDependent.throwException((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP/2 pseudo-header '%s' must not be empty.", var2_2));
        }
    }

    public Http2Headers clear() {
        this.firstNonPseudo = this.head;
        return (Http2Headers)super.clear();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof Http2Headers && this.equals((Http2Headers)var1_1, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Headers method(CharSequence value) {
        void var1_1;
        this.set(Http2Headers.PseudoHeaderName.METHOD.value(), var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Headers scheme(CharSequence value) {
        void var1_1;
        this.set(Http2Headers.PseudoHeaderName.SCHEME.value(), var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Headers authority(CharSequence value) {
        void var1_1;
        this.set(Http2Headers.PseudoHeaderName.AUTHORITY.value(), var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Headers path(CharSequence value) {
        void var1_1;
        this.set(Http2Headers.PseudoHeaderName.PATH.value(), var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Headers status(CharSequence value) {
        void var1_1;
        this.set(Http2Headers.PseudoHeaderName.STATUS.value(), var1_1);
        return this;
    }

    @Override
    public CharSequence method() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public CharSequence scheme() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public CharSequence authority() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public CharSequence path() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public CharSequence status() {
        return (CharSequence)this.get(Http2Headers.PseudoHeaderName.STATUS.value());
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(CharSequence name, CharSequence value) {
        void var2_2;
        void var1_1;
        return this.contains((CharSequence)var1_1, (CharSequence)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean caseInsensitive) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.contains(var1_1, var2_2, var3_3 != false ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    /*
     * WARNING - void declaration
     */
    protected final DefaultHeaders.HeaderEntry<CharSequence, CharSequence> newHeaderEntry(int h, CharSequence name, CharSequence value, DefaultHeaders.HeaderEntry<CharSequence, CharSequence> next) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new Http2HeaderEntry((int)var1_1, (CharSequence)var2_2, (CharSequence)var3_3, next);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ DefaultHeaders.HeaderEntry access$102(DefaultHttp2Headers x0, DefaultHeaders.HeaderEntry x1) {
        void var1_1;
        x0.firstNonPseudo = var1_1;
        return x0.firstNonPseudo;
    }

    private final class Http2HeaderEntry
    extends DefaultHeaders.HeaderEntry<CharSequence, CharSequence> {
        /*
         * WARNING - void declaration
         */
        Http2HeaderEntry(int hash, CharSequence key, CharSequence value, DefaultHeaders.HeaderEntry<CharSequence, CharSequence> next) {
            void var3_3;
            void var2_2;
            super((int)var2_2, (Object)key);
            this.value = value;
            this.next = next;
            if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat((CharSequence)var3_3)) {
                this.after = DefaultHttp2Headers.this.firstNonPseudo;
                this.before = DefaultHttp2Headers.this.firstNonPseudo.before();
            } else {
                this.after = DefaultHttp2Headers.this.head;
                this.before = DefaultHttp2Headers.this.head.before();
                if (DefaultHttp2Headers.this.firstNonPseudo == DefaultHttp2Headers.this.head) {
                    DefaultHttp2Headers.access$102(DefaultHttp2Headers.this, this);
                }
            }
            this.pointNeighborsToThis();
        }

        protected final void remove() {
            Http2HeaderEntry http2HeaderEntry = this;
            if (http2HeaderEntry == http2HeaderEntry.DefaultHttp2Headers.this.firstNonPseudo) {
                DefaultHttp2Headers.access$102(DefaultHttp2Headers.this, DefaultHttp2Headers.this.firstNonPseudo.after());
            }
            super.remove();
        }
    }
}

