/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public final class DefaultHttp2GoAwayFrame
extends DefaultByteBufHolder
implements Http2GoAwayFrame {
    private final long errorCode;
    private final int lastStreamId;
    private int extraStreamIds;

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2GoAwayFrame(Http2Error error) {
        this(var1_1.code());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2GoAwayFrame(long errorCode) {
        this((long)var1_1, Unpooled.EMPTY_BUFFER);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2GoAwayFrame(Http2Error error, ByteBuf content) {
        this(var1_1.code(), (ByteBuf)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2GoAwayFrame(long errorCode, ByteBuf content) {
        this(-1, (long)var1_1, (ByteBuf)var3_2);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    DefaultHttp2GoAwayFrame(int lastStreamId, long errorCode, ByteBuf content) {
        super(content);
        void var1_1;
        void var2_2;
        this.errorCode = var2_2;
        this.lastStreamId = var1_1;
    }

    @Override
    public final String name() {
        return "GOAWAY";
    }

    @Override
    public final long errorCode() {
        return this.errorCode;
    }

    @Override
    public final int extraStreamIds() {
        return this.extraStreamIds;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Http2GoAwayFrame setExtraStreamIds(int extraStreamIds) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)extraStreamIds, (String)"extraStreamIds");
        this.extraStreamIds = var1_1;
        return this;
    }

    @Override
    public final int lastStreamId() {
        return this.lastStreamId;
    }

    @Override
    public final Http2GoAwayFrame copy() {
        return new DefaultHttp2GoAwayFrame(this.lastStreamId, this.errorCode, this.content().copy());
    }

    @Override
    public final Http2GoAwayFrame duplicate() {
        return (Http2GoAwayFrame)super.duplicate();
    }

    @Override
    public final Http2GoAwayFrame retainedDuplicate() {
        return (Http2GoAwayFrame)super.retainedDuplicate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Http2GoAwayFrame replace(ByteBuf content) {
        void var1_1;
        return new DefaultHttp2GoAwayFrame(this.errorCode, (ByteBuf)var1_1).setExtraStreamIds(this.extraStreamIds);
    }

    @Override
    public final Http2GoAwayFrame retain() {
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Http2GoAwayFrame retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public final Http2GoAwayFrame touch() {
        super.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Http2GoAwayFrame touch(Object hint) {
        void var1_1;
        super.touch((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof DefaultHttp2GoAwayFrame)) {
            return false;
        }
        DefaultHttp2GoAwayFrame other = (DefaultHttp2GoAwayFrame)o;
        return this.errorCode == other.errorCode && this.extraStreamIds == other.extraStreamIds && super.equals((Object)var1_1);
    }

    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        n = n * 31 + this.extraStreamIds;
        return n;
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "(errorCode=" + this.errorCode + ", content=" + this.content() + ", extraStreamIds=" + this.extraStreamIds + ", lastStreamId=" + this.lastStreamId + ')';
    }
}

