/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.collection.CharObjectMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.Closeable;
import java.util.Iterator;

public class DefaultHttp2FrameWriter
implements Http2FrameSizePolicy,
Http2FrameWriter,
Http2FrameWriter.Configuration {
    private static final String STREAM_ID = "Stream ID";
    private static final String STREAM_DEPENDENCY = "Stream Dependency";
    private static final ByteBuf ZERO_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)255).writeZero(255)).asReadOnly();
    private final Http2HeadersEncoder headersEncoder;
    private int maxFrameSize;

    public DefaultHttp2FrameWriter() {
        this(new DefaultHttp2HeadersEncoder());
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2FrameWriter(Http2HeadersEncoder.SensitivityDetector headersSensitivityDetector) {
        this(new DefaultHttp2HeadersEncoder((Http2HeadersEncoder.SensitivityDetector)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2FrameWriter(Http2HeadersEncoder.SensitivityDetector headersSensitivityDetector, boolean ignoreMaxHeaderListSize) {
        this(new DefaultHttp2HeadersEncoder((Http2HeadersEncoder.SensitivityDetector)var1_1, (boolean)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2FrameWriter(Http2HeadersEncoder headersEncoder) {
        void var1_1;
        this.headersEncoder = var1_1;
        this.maxFrameSize = 16384;
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this;
    }

    @Override
    public Http2HeadersEncoder.Configuration headersConfiguration() {
        return this.headersEncoder.configuration();
    }

    @Override
    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void maxFrameSize(int max) throws Http2Exception {
        void var1_1;
        if (!Http2CodecUtil.isMaxFrameSizeValid(max)) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", max);
        }
        this.maxFrameSize = var1_1;
    }

    @Override
    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (this.headersEncoder instanceof Closeable) {
            try {
                ((Closeable)((Object)this.headersEncoder)).close();
                return;
            }
            catch (Exception e) {
                void var1_1;
                throw new RuntimeException((Throwable)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        ByteBuf frameHeader = null;
        try {
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            Http2CodecUtil.verifyPadding(padding);
            int remainingData = data.readableBytes();
            Http2Flags flags = new Http2Flags();
            flags.endOfStream(false);
            flags.paddingPresent(false);
            if (remainingData > this.maxFrameSize) {
                frameHeader = ctx.alloc().buffer(9);
                Http2CodecUtil.writeFrameHeaderInternal(frameHeader, this.maxFrameSize, (byte)0, flags, streamId);
                do {
                    ctx.write((Object)frameHeader.retainedSlice(), promiseAggregator.newPromise());
                    ctx.write((Object)data.readRetainedSlice(this.maxFrameSize), promiseAggregator.newPromise());
                } while ((remainingData -= this.maxFrameSize) > this.maxFrameSize);
            }
            if (padding == 0) {
                if (frameHeader != null) {
                    frameHeader.release();
                    frameHeader = null;
                }
                ByteBuf frameHeader2 = ctx.alloc().buffer(9);
                flags.endOfStream(endStream);
                Http2CodecUtil.writeFrameHeaderInternal(frameHeader2, remainingData, (byte)0, flags, streamId);
                ctx.write((Object)frameHeader2, promiseAggregator.newPromise());
                ByteBuf lastFrame = data.readSlice(remainingData);
                data = null;
                ctx.write((Object)lastFrame, promiseAggregator.newPromise());
            } else {
                if (remainingData != this.maxFrameSize) {
                    if (frameHeader != null) {
                        frameHeader.release();
                        frameHeader = null;
                    }
                } else {
                    ByteBuf lastFrame;
                    remainingData -= this.maxFrameSize;
                    if (frameHeader == null) {
                        lastFrame = ctx.alloc().buffer(9);
                        Http2CodecUtil.writeFrameHeaderInternal(lastFrame, this.maxFrameSize, (byte)0, flags, streamId);
                    } else {
                        lastFrame = frameHeader.slice();
                        frameHeader = null;
                    }
                    ctx.write((Object)lastFrame, promiseAggregator.newPromise());
                    lastFrame = data.readableBytes() != this.maxFrameSize ? data.readSlice(this.maxFrameSize) : data;
                    data = null;
                    ctx.write((Object)lastFrame, promiseAggregator.newPromise());
                }
                do {
                    int frameDataBytes = Math.min(remainingData, this.maxFrameSize);
                    int framePaddingBytes = Math.min(padding, Math.max(0, this.maxFrameSize - 1 - frameDataBytes));
                    ByteBuf frameHeader2 = ctx.alloc().buffer(10);
                    flags.endOfStream(endStream && (remainingData -= frameDataBytes) == 0 && (padding -= framePaddingBytes) == 0);
                    flags.paddingPresent(framePaddingBytes > 0);
                    Http2CodecUtil.writeFrameHeaderInternal(frameHeader2, framePaddingBytes + frameDataBytes, (byte)0, flags, streamId);
                    DefaultHttp2FrameWriter.writePaddingLength(frameHeader2, framePaddingBytes);
                    ctx.write((Object)frameHeader2, promiseAggregator.newPromise());
                    if (data != null) {
                        if (remainingData == 0) {
                            ByteBuf lastFrame = data.readSlice(frameDataBytes);
                            data = null;
                            ctx.write((Object)lastFrame, promiseAggregator.newPromise());
                        } else {
                            void var10_14;
                            ctx.write((Object)data.readRetainedSlice((int)var10_14), promiseAggregator.newPromise());
                        }
                    }
                    if (DefaultHttp2FrameWriter.paddingBytes(framePaddingBytes) <= 0) continue;
                    ctx.write((Object)ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(framePaddingBytes)), promiseAggregator.newPromise());
                } while (remainingData != 0 || padding != 0);
            }
        }
        catch (Throwable cause) {
            if (frameHeader != null) {
                frameHeader.release();
            }
            try {
                if (data != null) {
                    void var3_4;
                    var3_4.release();
                }
            }
            finally {
                promiseAggregator.setFailure(cause);
                promiseAggregator.doneAllocatingPromises();
            }
            return promiseAggregator;
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeHeadersInternal((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, padding, endStream, false, 0, (short)0, false, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeHeadersInternal((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, padding, endStream, true, streamDependency, weight, exclusive, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        try {
            void var1_1;
            void var3_3;
            void var2_2;
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamDependency, STREAM_DEPENDENCY);
            DefaultHttp2FrameWriter.verifyWeight(weight);
            ByteBuf buf = ctx.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 5, (byte)2, new Http2Flags(), (int)var2_2);
            buf.writeInt(exclusive ? (int)(0x80000000L | (long)streamDependency) : var3_3);
            buf.writeByte(weight - 1);
            return var1_1.write((Object)buf, promise);
        }
        catch (Throwable t) {
            return promise.setFailure(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        try {
            void var1_1;
            void var3_3;
            void var2_2;
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyErrorCode(errorCode);
            ByteBuf buf = ctx.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 4, (byte)3, new Http2Flags(), (int)var2_2);
            buf.writeInt((int)var3_3);
            return var1_1.write((Object)buf, promise);
        }
        catch (Throwable t) {
            return promise.setFailure(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise) {
        try {
            void var1_1;
            Iterator iterator;
            ObjectUtil.checkNotNull((Object)((Object)settings), (String)"settings");
            int payloadLength = 6 * settings.size();
            ByteBuf buf = ctx.alloc().buffer(payloadLength + 9);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)4, new Http2Flags(), 0);
            for (CharObjectMap.PrimitiveEntry entry : iterator.entries()) {
                buf.writeChar((int)entry.key());
                buf.writeInt(((Long)entry.value()).intValue());
            }
            return var1_1.write((Object)buf, promise);
        }
        catch (Throwable t) {
            void var3_3;
            return var3_3.setFailure(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        try {
            void var1_1;
            ByteBuf buf = ctx.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 0, (byte)4, new Http2Flags().ack(true), 0);
            return var1_1.write((Object)buf, promise);
        }
        catch (Throwable t) {
            void var3_4;
            void var2_2;
            return var2_2.setFailure((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
        void var1_1;
        void var3_4;
        void var2_3;
        Http2Flags flags = ack ? new Http2Flags().ack(true) : new Http2Flags();
        ByteBuf buf = ctx.alloc().buffer(17);
        Http2CodecUtil.writeFrameHeaderInternal(buf, 8, (byte)6, (Http2Flags)var2_3, 0);
        buf.writeLong((long)var3_4);
        return var1_1.write((Object)buf, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise) {
        ByteBuf headerBlock = null;
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        try {
            void var3_4;
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamId(promisedStreamId, "Promised Stream ID");
            Http2CodecUtil.verifyPadding(padding);
            headerBlock = ctx.alloc().buffer();
            this.headersEncoder.encodeHeaders(streamId, headers, headerBlock);
            Http2Flags flags = new Http2Flags().paddingPresent(padding > 0);
            int nonFragmentLength = padding + 4;
            int maxFragmentLength = this.maxFrameSize - nonFragmentLength;
            ByteBuf byteBuf = headerBlock;
            ByteBuf fragment = byteBuf.readRetainedSlice(Math.min(byteBuf.readableBytes(), maxFragmentLength));
            flags.endOfHeaders(!headerBlock.isReadable());
            int payloadLength = fragment.readableBytes() + nonFragmentLength;
            ByteBuf buf = ctx.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)5, flags, streamId);
            DefaultHttp2FrameWriter.writePaddingLength(buf, padding);
            buf.writeInt((int)var3_4);
            ctx.write((Object)buf, promiseAggregator.newPromise());
            ctx.write((Object)fragment, promiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(padding) > 0) {
                ctx.write((Object)ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(padding)), promiseAggregator.newPromise());
            }
            if (!flags.endOfHeaders()) {
                void var2_3;
                void var1_1;
                this.writeContinuationFrames((ChannelHandlerContext)var1_1, (int)var2_3, headerBlock, promiseAggregator);
            }
        }
        catch (Http2Exception e) {
            promiseAggregator.setFailure(e);
        }
        catch (Throwable t) {
            promiseAggregator.setFailure(t);
            promiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException((Throwable)t);
        }
        finally {
            if (headerBlock != null) {
                headerBlock.release();
            }
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        try {
            void var3_4;
            void var2_3;
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(lastStreamId, "Last Stream ID");
            DefaultHttp2FrameWriter.verifyErrorCode(errorCode);
            int payloadLength = 8 + debugData.readableBytes();
            ByteBuf buf = ctx.alloc().buffer(17);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)7, new Http2Flags(), 0);
            buf.writeInt((int)var2_3);
            buf.writeInt((int)var3_4);
            ctx.write((Object)buf, promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            try {
                debugData.release();
            }
            finally {
                promiseAggregator.setFailure(t);
                promiseAggregator.doneAllocatingPromises();
            }
            return promiseAggregator;
        }
        try {
            void var1_1;
            var1_1.write((Object)debugData, promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            promiseAggregator.setFailure(t);
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        try {
            void var1_1;
            void var3_3;
            void var2_2;
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyWindowSizeIncrement(windowSizeIncrement);
            ByteBuf buf = ctx.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 4, (byte)8, new Http2Flags(), (int)var2_2);
            buf.writeInt((int)var3_3);
            return var1_1.write((Object)buf, promise);
        }
        catch (Throwable t) {
            return promise.setFailure(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        try {
            void var3_4;
            void var2_3;
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamId, STREAM_ID);
            ByteBuf buf = ctx.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payload.readableBytes(), (byte)var2_3, flags, (int)var3_4);
            ctx.write((Object)buf, promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            try {
                payload.release();
            }
            finally {
                promiseAggregator.setFailure(t);
                promiseAggregator.doneAllocatingPromises();
            }
            return promiseAggregator;
        }
        try {
            void var1_1;
            var1_1.write((Object)payload, promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            promiseAggregator.setFailure(t);
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture writeHeadersInternal(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, boolean hasPriority, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        ByteBuf headerBlock = null;
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            if (hasPriority) {
                DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamDependency, STREAM_DEPENDENCY);
                Http2CodecUtil.verifyPadding(padding);
                DefaultHttp2FrameWriter.verifyWeight(weight);
            }
            headerBlock = ctx.alloc().buffer();
            this.headersEncoder.encodeHeaders(streamId, headers, headerBlock);
            Http2Flags flags = new Http2Flags().endOfStream(endStream).priorityPresent(hasPriority).paddingPresent(padding > 0);
            int nonFragmentBytes = padding + flags.getNumPriorityBytes();
            int maxFragmentLength = this.maxFrameSize - nonFragmentBytes;
            ByteBuf byteBuf = headerBlock;
            ByteBuf fragment = byteBuf.readRetainedSlice(Math.min(byteBuf.readableBytes(), maxFragmentLength));
            flags.endOfHeaders(!headerBlock.isReadable());
            int payloadLength = fragment.readableBytes() + nonFragmentBytes;
            ByteBuf buf = ctx.alloc().buffer(15);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)1, flags, streamId);
            DefaultHttp2FrameWriter.writePaddingLength(buf, padding);
            if (hasPriority) {
                buf.writeInt(exclusive ? (int)(0x80000000L | (long)streamDependency) : streamDependency);
                buf.writeByte(weight - 1);
            }
            ctx.write((Object)buf, promiseAggregator.newPromise());
            ctx.write((Object)fragment, promiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(padding) > 0) {
                ctx.write((Object)ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(padding)), promiseAggregator.newPromise());
            }
            if (!flags.endOfHeaders()) {
                void var2_3;
                void var1_1;
                this.writeContinuationFrames((ChannelHandlerContext)var1_1, (int)var2_3, headerBlock, promiseAggregator);
            }
        }
        catch (Http2Exception e) {
            promiseAggregator.setFailure(e);
        }
        catch (Throwable t) {
            void var3_6;
            promiseAggregator.setFailure(t);
            promiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException((Throwable)var3_6);
        }
        finally {
            if (headerBlock != null) {
                headerBlock.release();
            }
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    private ChannelFuture writeContinuationFrames(ChannelHandlerContext ctx, int streamId, ByteBuf headerBlock, Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator) {
        Http2Flags flags = new Http2Flags();
        if (headerBlock.isReadable()) {
            ByteBuf buf = null;
            do {
                int fragmentReadableBytes = Math.min(headerBlock.readableBytes(), this.maxFrameSize);
                ByteBuf fragment = headerBlock.readRetainedSlice(fragmentReadableBytes);
                if (headerBlock.isReadable()) {
                    if (buf == null) {
                        buf = ctx.alloc().buffer(9);
                        Http2CodecUtil.writeFrameHeaderInternal(buf, fragmentReadableBytes, (byte)9, flags, streamId);
                    }
                    ctx.write((Object)buf.retainedSlice(), promiseAggregator.newPromise());
                } else {
                    if (buf != null) {
                        buf.release();
                    }
                    flags = flags.endOfHeaders(true);
                    buf = ctx.alloc().buffer(9);
                    Http2CodecUtil.writeFrameHeaderInternal(buf, fragmentReadableBytes, (byte)9, flags, streamId);
                    ctx.write((Object)buf, promiseAggregator.newPromise());
                }
                ctx.write((Object)fragment, promiseAggregator.newPromise());
            } while (headerBlock.isReadable());
        }
        return promiseAggregator;
    }

    private static int paddingBytes(int padding) {
        return padding - 1;
    }

    /*
     * WARNING - void declaration
     */
    private static void writePaddingLength(ByteBuf buf, int padding) {
        if (padding > 0) {
            void var1_1;
            ByteBuf byteBuf;
            byteBuf.writeByte((int)(var1_1 - true));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyStreamId(int streamId, String argumentName) {
        void var1_1;
        ObjectUtil.checkPositive((int)streamId, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyStreamOrConnectionId(int streamId, String argumentName) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)streamId, (String)var1_1);
    }

    private static void verifyWeight(short weight) {
        if (weight <= 0 || weight > 256) {
            short s;
            throw new IllegalArgumentException("Invalid weight: " + s);
        }
    }

    private static void verifyErrorCode(long errorCode) {
        if (errorCode < 0L || errorCode > 0xFFFFFFFFL) {
            long l;
            throw new IllegalArgumentException("Invalid errorCode: " + l);
        }
    }

    private static void verifyWindowSizeIncrement(int windowSizeIncrement) {
        ObjectUtil.checkPositiveOrZero((int)windowSizeIncrement, (String)"windowSizeIncrement");
    }
}

