/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.PlatformDependent;

public class DefaultHttp2FrameReader
implements Http2FrameReader,
Http2FrameReader.Configuration,
Http2FrameSizePolicy {
    private final Http2HeadersDecoder headersDecoder;
    private boolean readingHeaders = true;
    private boolean readError;
    private byte frameType;
    private int streamId;
    private Http2Flags flags;
    private int payloadLength;
    private HeadersContinuation headersContinuation;
    private int maxFrameSize;

    public DefaultHttp2FrameReader() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2FrameReader(boolean validateHeaders) {
        this(new DefaultHttp2HeadersDecoder((boolean)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2FrameReader(Http2HeadersDecoder headersDecoder) {
        void var1_1;
        this.headersDecoder = var1_1;
        this.maxFrameSize = 16384;
    }

    @Override
    public Http2HeadersDecoder.Configuration headersConfiguration() {
        return this.headersDecoder.configuration();
    }

    @Override
    public Http2FrameReader.Configuration configuration() {
        return this;
    }

    @Override
    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void maxFrameSize(int max) throws Http2Exception {
        void var1_1;
        if (!Http2CodecUtil.isMaxFrameSizeValid(max)) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", max);
        }
        this.maxFrameSize = var1_1;
    }

    @Override
    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void close() {
        this.closeHeadersContinuation();
    }

    private void closeHeadersContinuation() {
        if (this.headersContinuation != null) {
            this.headersContinuation.close();
            this.headersContinuation = null;
        }
    }

    @Override
    public void readFrame(ChannelHandlerContext ctx, ByteBuf input, Http2FrameListener listener) throws Http2Exception {
        if (this.readError) {
            ByteBuf byteBuf = input;
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        try {
            do {
                if (this.readingHeaders && !this.preProcessFrame(input)) {
                    return;
                }
                if (input.readableBytes() < this.payloadLength) {
                    return;
                }
                ByteBuf framePayload = input.readSlice(this.payloadLength);
                this.readingHeaders = true;
                this.verifyFrameState();
                this.processPayloadState(ctx, framePayload, listener);
            } while (input.isReadable());
            return;
        }
        catch (Http2Exception e) {
            this.readError = !Http2Exception.isStreamError(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.readError = true;
            throw e;
        }
        catch (Throwable cause) {
            this.readError = true;
            PlatformDependent.throwException((Throwable)cause);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean preProcessFrame(ByteBuf in) throws Http2Exception {
        void var1_1;
        if (in.readableBytes() < 9) {
            return false;
        }
        this.payloadLength = in.readUnsignedMedium();
        if (this.payloadLength > this.maxFrameSize) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length: %d exceeds maximum: %d", this.payloadLength, this.maxFrameSize);
        }
        this.frameType = in.readByte();
        this.flags = new Http2Flags(in.readUnsignedByte());
        this.streamId = Http2CodecUtil.readUnsignedInt((ByteBuf)var1_1);
        this.readingHeaders = false;
        return true;
    }

    private void verifyFrameState() throws Http2Exception {
        switch (this.frameType) {
            case 0: {
                this.verifyDataFrame();
                return;
            }
            case 1: {
                this.verifyHeadersFrame();
                return;
            }
            case 2: {
                this.verifyPriorityFrame();
                return;
            }
            case 3: {
                this.verifyRstStreamFrame();
                return;
            }
            case 4: {
                this.verifySettingsFrame();
                return;
            }
            case 5: {
                this.verifyPushPromiseFrame();
                return;
            }
            case 6: {
                this.verifyPingFrame();
                return;
            }
            case 7: {
                this.verifyGoAwayFrame();
                return;
            }
            case 8: {
                this.verifyWindowUpdateFrame();
                return;
            }
            case 9: {
                this.verifyContinuationFrame();
                return;
            }
        }
        this.verifyUnknownFrame();
    }

    /*
     * WARNING - void declaration
     */
    private void processPayloadState(ChannelHandlerContext ctx, ByteBuf in, Http2FrameListener listener) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (in.readableBytes() == this.payloadLength);
        switch (this.frameType) {
            case 0: {
                this.readDataFrame(ctx, in, listener);
                return;
            }
            case 1: {
                this.readHeadersFrame(ctx, in, listener);
                return;
            }
            case 2: {
                this.readPriorityFrame(ctx, in, listener);
                return;
            }
            case 3: {
                this.readRstStreamFrame(ctx, in, listener);
                return;
            }
            case 4: {
                this.readSettingsFrame(ctx, in, listener);
                return;
            }
            case 5: {
                this.readPushPromiseFrame(ctx, in, listener);
                return;
            }
            case 6: {
                this.readPingFrame(ctx, in.readLong(), listener);
                return;
            }
            case 7: {
                this.readGoAwayFrame(ctx, in, listener);
                return;
            }
            case 8: {
                this.readWindowUpdateFrame(ctx, in, listener);
                return;
            }
            case 9: {
                this.readContinuationFrame(in, listener);
                return;
            }
        }
        this.readUnknownFrame((ChannelHandlerContext)var1_1, (ByteBuf)var2_2, (Http2FrameListener)var3_3);
    }

    private void verifyDataFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        if (this.payloadLength < this.flags.getPaddingPresenceFieldLength()) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyHeadersFrame() throws Http2Exception {
        void var1_1;
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        int requiredLength = this.flags.getPaddingPresenceFieldLength() + this.flags.getNumPriorityBytes();
        if (this.payloadLength < var1_1) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small for HEADERS frame with stream %d.", this.payloadLength, this.streamId);
        }
    }

    private void verifyPriorityFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        if (this.payloadLength != 5) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifyRstStreamFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        if (this.payloadLength != 4) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifySettingsFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.flags.ack() && this.payloadLength > 0) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Ack settings frame must have an empty payload.", new Object[0]);
        }
        if (this.payloadLength % 6 > 0) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d invalid.", this.payloadLength);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyPushPromiseFrame() throws Http2Exception {
        void var1_1;
        this.verifyNotProcessingHeaders();
        int minLength = this.flags.getPaddingPresenceFieldLength() + 4;
        if (this.payloadLength < var1_1) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small for PUSH_PROMISE frame with stream id %d.", this.payloadLength, this.streamId);
        }
    }

    private void verifyPingFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.payloadLength != 8) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d incorrect size for ping.", this.payloadLength);
        }
    }

    private void verifyGoAwayFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.payloadLength < 8) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    private void verifyWindowUpdateFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader.verifyStreamOrConnectionId(this.streamId, "Stream ID");
        if (this.payloadLength != 4) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifyContinuationFrame() throws Http2Exception {
        this.verifyAssociatedWithAStream();
        if (this.headersContinuation == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received %s frame but not currently processing headers.", this.frameType);
        }
        if (this.streamId != this.headersContinuation.getStreamId()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Continuation stream ID does not match pending headers. Expected %d, but received %d.", this.headersContinuation.getStreamId(), this.streamId);
        }
    }

    private void verifyUnknownFrame() throws Http2Exception {
        this.verifyNotProcessingHeaders();
    }

    /*
     * WARNING - void declaration
     */
    private void readDataFrame(ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var2_2;
        void var1_1;
        void var3_3;
        int padding = this.readPadding(payload);
        this.verifyPadding(padding);
        int dataLength = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(payload.readableBytes(), padding);
        ByteBuf byteBuf = payload;
        byteBuf.writerIndex(byteBuf.readerIndex() + dataLength);
        var3_3.onDataRead((ChannelHandlerContext)var1_1, this.streamId, (ByteBuf)var2_2, padding, this.flags.endOfStream());
    }

    /*
     * WARNING - void declaration
     */
    private void readHeadersFrame(final ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        final int headersStreamId = this.streamId;
        final Http2Flags headersFlags = this.flags;
        final int padding = this.readPadding(payload);
        this.verifyPadding(padding);
        if (this.flags.priorityPresent()) {
            long word1 = payload.readUnsignedInt();
            final boolean exclusive = (word1 & 0x80000000L) != 0L;
            final int streamDependency = (int)(word1 & Integer.MAX_VALUE);
            if (streamDependency == this.streamId) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HEADERS frame for stream %d cannot depend on itself.", this.streamId);
            }
            final short weight = (short)(payload.readUnsignedByte() + 1);
            int lenToRead = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(payload.readableBytes(), padding);
            this.headersContinuation = new HeadersContinuation(){
                {
                    void var1_1;
                }

                @Override
                public int getStreamId() {
                    return headersStreamId;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void processFragment(boolean endOfHeaders, ByteBuf fragment, int len, Http2FrameListener listener) throws Http2Exception {
                    void var1_1;
                    void var3_3;
                    void var2_2;
                    HeadersBlockBuilder hdrBlockBuilder = this.headersBlockBuilder();
                    hdrBlockBuilder.addFragment((ByteBuf)var2_2, (int)var3_3, ctx.alloc(), endOfHeaders);
                    if (var1_1 != false) {
                        listener.onHeadersRead(ctx, headersStreamId, hdrBlockBuilder.headers(), streamDependency, weight, exclusive, padding, headersFlags.endOfStream());
                    }
                }
            };
            this.headersContinuation.processFragment(this.flags.endOfHeaders(), payload, lenToRead, listener);
            DefaultHttp2FrameReader defaultHttp2FrameReader = this;
            defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
            return;
        }
        this.headersContinuation = new HeadersContinuation((ChannelHandlerContext)var1_1, padding, headersFlags){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ int val$padding;
            final /* synthetic */ Http2Flags val$headersFlags;
            {
                void var1_1;
                this.val$ctx = channelHandlerContext;
                this.val$padding = n2;
                this.val$headersFlags = http2Flags;
            }

            @Override
            public int getStreamId() {
                return headersStreamId;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void processFragment(boolean endOfHeaders, ByteBuf fragment, int len, Http2FrameListener listener) throws Http2Exception {
                void var1_1;
                void var3_3;
                void var2_2;
                HeadersBlockBuilder hdrBlockBuilder = this.headersBlockBuilder();
                hdrBlockBuilder.addFragment((ByteBuf)var2_2, (int)var3_3, this.val$ctx.alloc(), endOfHeaders);
                if (var1_1 != false) {
                    listener.onHeadersRead(this.val$ctx, headersStreamId, hdrBlockBuilder.headers(), this.val$padding, this.val$headersFlags.endOfStream());
                }
            }
        };
        int len = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(payload.readableBytes(), padding);
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), (ByteBuf)var2_2, len, (Http2FrameListener)var3_3);
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
    }

    private void resetHeadersContinuationIfEnd(boolean endOfHeaders) {
        if (endOfHeaders) {
            this.closeHeadersContinuation();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readPriorityFrame(ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var2_3;
        void var1_1;
        void var3_4;
        long word1 = payload.readUnsignedInt();
        boolean exclusive = (word1 & 0x80000000L) != 0L;
        int streamDependency = (int)(word1 & Integer.MAX_VALUE);
        if (streamDependency == this.streamId) {
            throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "A stream cannot depend on itself.", new Object[0]);
        }
        short weight = (short)(payload.readUnsignedByte() + 1);
        var3_4.onPriorityRead((ChannelHandlerContext)var1_1, this.streamId, streamDependency, (short)var2_3, exclusive);
    }

    /*
     * WARNING - void declaration
     */
    private void readRstStreamFrame(ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var1_1;
        void var3_3;
        long errorCode = payload.readUnsignedInt();
        var3_3.onRstStreamRead((ChannelHandlerContext)var1_1, this.streamId, errorCode);
    }

    /*
     * WARNING - void declaration
     */
    private void readSettingsFrame(ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var1_1;
        void var3_4;
        if (this.flags.ack()) {
            listener.onSettingsAckRead(ctx);
            return;
        }
        int numSettings = this.payloadLength / 6;
        Http2Settings settings = new Http2Settings();
        for (int index = 0; index < numSettings; ++index) {
            char id = (char)payload.readUnsignedShort();
            long value = payload.readUnsignedInt();
            try {
                settings.put(id, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                void var1_2;
                if (id == '\u0004') {
                    throw Http2Exception.connectionError(Http2Error.FLOW_CONTROL_ERROR, e, "Failed setting initial window size: %s", e.getMessage());
                }
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, e, "Protocol error: %s", var1_2.getMessage());
            }
        }
        var3_4.onSettingsRead((ChannelHandlerContext)var1_1, settings);
    }

    /*
     * WARNING - void declaration
     */
    private void readPushPromiseFrame(final ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var3_4;
        void var1_2;
        void var2_3;
        final int pushPromiseStreamId = this.streamId;
        final int padding = this.readPadding(payload);
        this.verifyPadding(padding);
        final int promisedStreamId = Http2CodecUtil.readUnsignedInt(payload);
        this.headersContinuation = new HeadersContinuation(){
            {
                void var1_1;
            }

            @Override
            public int getStreamId() {
                return pushPromiseStreamId;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void processFragment(boolean endOfHeaders, ByteBuf fragment, int len, Http2FrameListener listener) throws Http2Exception {
                void var1_1;
                void var3_3;
                void var2_2;
                this.headersBlockBuilder().addFragment((ByteBuf)var2_2, (int)var3_3, ctx.alloc(), endOfHeaders);
                if (var1_1 != false) {
                    listener.onPushPromiseRead(ctx, pushPromiseStreamId, promisedStreamId, this.headersBlockBuilder().headers(), padding);
                }
            }
        };
        int len = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(payload.readableBytes(), padding);
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), (ByteBuf)var2_3, (int)var1_2, (Http2FrameListener)var3_4);
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
    }

    /*
     * WARNING - void declaration
     */
    private void readPingFrame(ChannelHandlerContext ctx, long data, Http2FrameListener listener) throws Http2Exception {
        void var2_2;
        void var1_1;
        if (this.flags.ack()) {
            listener.onPingAckRead(ctx, data);
            return;
        }
        listener.onPingRead((ChannelHandlerContext)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void readGoAwayFrame(ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var2_2;
        void var1_1;
        void var3_3;
        int lastStreamId = Http2CodecUtil.readUnsignedInt(payload);
        long errorCode = payload.readUnsignedInt();
        var3_3.onGoAwayRead((ChannelHandlerContext)var1_1, lastStreamId, errorCode, (ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void readWindowUpdateFrame(ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var2_3;
        void var1_1;
        void var3_4;
        int windowSizeIncrement = Http2CodecUtil.readUnsignedInt(payload);
        if (windowSizeIncrement == 0) {
            if (this.streamId == 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received WINDOW_UPDATE with delta 0 for connection stream", new Object[0]);
            }
            throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Received WINDOW_UPDATE with delta 0 for stream: %d", this.streamId);
        }
        var3_4.onWindowUpdateRead((ChannelHandlerContext)var1_1, this.streamId, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private void readContinuationFrame(ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var2_2;
        void var1_1;
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), (ByteBuf)var1_1, this.payloadLength, (Http2FrameListener)var2_2);
        DefaultHttp2FrameReader defaultHttp2FrameReader = this;
        defaultHttp2FrameReader.resetHeadersContinuationIfEnd(defaultHttp2FrameReader.flags.endOfHeaders());
    }

    /*
     * WARNING - void declaration
     */
    private void readUnknownFrame(ChannelHandlerContext ctx, ByteBuf payload, Http2FrameListener listener) throws Http2Exception {
        void var2_2;
        void var1_1;
        listener.onUnknownFrame((ChannelHandlerContext)var1_1, this.frameType, this.streamId, this.flags, (ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int readPadding(ByteBuf payload) {
        void var1_1;
        if (!this.flags.paddingPresent()) {
            return 0;
        }
        return var1_1.readUnsignedByte() + 1;
    }

    private void verifyPadding(int padding) throws Http2Exception {
        int n;
        if ((n = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(this.payloadLength, n)) < 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Frame payload too small for padding.", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int lengthWithoutTrailingPadding(int readableBytes, int padding) {
        void var1_1;
        int n;
        if (padding == 0) {
            return readableBytes;
        }
        return n - (var1_1 - true);
    }

    private void verifyNotProcessingHeaders() throws Http2Exception {
        if (this.headersContinuation != null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received frame of type %s while processing headers on stream %d.", this.frameType, this.headersContinuation.getStreamId());
        }
    }

    private void verifyAssociatedWithAStream() throws Http2Exception {
        if (this.streamId == 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Frame of type %s must be associated with a stream.", this.frameType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyStreamOrConnectionId(int streamId, String argumentName) throws Http2Exception {
        if (streamId < 0) {
            void var1_1;
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "%s must be >= 0", var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HeadersContinuation access$302(DefaultHttp2FrameReader x0, HeadersContinuation x1) {
        void var1_1;
        x0.headersContinuation = var1_1;
        return x0.headersContinuation;
    }

    protected class HeadersBlockBuilder {
        private ByteBuf headerBlock;
        final /* synthetic */ DefaultHttp2FrameReader this$0;

        /*
         * WARNING - void declaration
         */
        protected HeadersBlockBuilder(DefaultHttp2FrameReader this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        private void headerSizeExceeded() throws Http2Exception {
            this.close();
            Http2CodecUtil.headerListSizeExceeded(this.this$0.headersDecoder.configuration().maxHeaderListSizeGoAway());
        }

        /*
         * WARNING - void declaration
         */
        final void addFragment(ByteBuf fragment, int len, ByteBufAllocator alloc, boolean endOfHeaders) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.headerBlock == null) {
                if ((long)len > this.this$0.headersDecoder.configuration().maxHeaderListSizeGoAway()) {
                    this.headerSizeExceeded();
                }
                if (endOfHeaders) {
                    this.headerBlock = fragment.readRetainedSlice(len);
                    return;
                }
                this.headerBlock = alloc.buffer(len).writeBytes(fragment, len);
                return;
            }
            if (this.this$0.headersDecoder.configuration().maxHeaderListSizeGoAway() - (long)len < (long)this.headerBlock.readableBytes()) {
                this.headerSizeExceeded();
            }
            if (this.headerBlock.isWritable(len)) {
                this.headerBlock.writeBytes(fragment, len);
                return;
            }
            ByteBuf buf = alloc.buffer(this.headerBlock.readableBytes() + len);
            buf.writeBytes(this.headerBlock).writeBytes((ByteBuf)var1_1, (int)var2_2);
            this.headerBlock.release();
            this.headerBlock = var3_3;
        }

        Http2Headers headers() throws Http2Exception {
            try {
                Http2Headers http2Headers = this.this$0.headersDecoder.decodeHeaders(this.this$0.streamId, this.headerBlock);
                return http2Headers;
            }
            finally {
                this.close();
            }
        }

        void close() {
            if (this.headerBlock != null) {
                this.headerBlock.release();
                this.headerBlock = null;
            }
            DefaultHttp2FrameReader.access$302(this.this$0, null);
        }
    }

    private abstract class HeadersContinuation {
        private final HeadersBlockBuilder builder;

        private HeadersContinuation() {
            this.builder = new HeadersBlockBuilder(DefaultHttp2FrameReader.this);
        }

        abstract int getStreamId();

        abstract void processFragment(boolean var1, ByteBuf var2, int var3, Http2FrameListener var4) throws Http2Exception;

        final HeadersBlockBuilder headersBlockBuilder() {
            return this.builder;
        }

        final void close() {
            this.builder.close();
        }
    }
}

