/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public final class DefaultHttp2DataFrame
extends AbstractHttp2StreamFrame
implements Http2DataFrame {
    private final ByteBuf content;
    private final boolean endStream;
    private final int padding;
    private final int initialFlowControlledBytes;

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2DataFrame(ByteBuf content) {
        this((ByteBuf)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2DataFrame(boolean endStream) {
        this(Unpooled.EMPTY_BUFFER, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2DataFrame(ByteBuf content, boolean endStream) {
        this((ByteBuf)var1_1, (boolean)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2DataFrame(ByteBuf content, boolean endStream, int padding) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)var1_1, (String)"content");
        this.endStream = var2_2;
        Http2CodecUtil.verifyPadding(padding);
        this.padding = padding;
        if ((long)this.content().readableBytes() + (long)padding > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("content + padding must be <= Integer.MAX_VALUE");
        }
        this.initialFlowControlledBytes = this.content().readableBytes() + var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2DataFrame stream(Http2FrameStream stream) {
        void var1_1;
        super.stream((Http2FrameStream)var1_1);
        return this;
    }

    @Override
    public final String name() {
        return "DATA";
    }

    @Override
    public final boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public final int padding() {
        return this.padding;
    }

    @Override
    public final ByteBuf content() {
        return ByteBufUtil.ensureAccessible((ByteBuf)this.content);
    }

    @Override
    public final int initialFlowControlledBytes() {
        return this.initialFlowControlledBytes;
    }

    @Override
    public final DefaultHttp2DataFrame copy() {
        DefaultHttp2DataFrame defaultHttp2DataFrame = this;
        return defaultHttp2DataFrame.replace(defaultHttp2DataFrame.content().copy());
    }

    @Override
    public final DefaultHttp2DataFrame duplicate() {
        DefaultHttp2DataFrame defaultHttp2DataFrame = this;
        return defaultHttp2DataFrame.replace(defaultHttp2DataFrame.content().duplicate());
    }

    @Override
    public final DefaultHttp2DataFrame retainedDuplicate() {
        DefaultHttp2DataFrame defaultHttp2DataFrame = this;
        return defaultHttp2DataFrame.replace(defaultHttp2DataFrame.content().retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2DataFrame replace(ByteBuf content) {
        void var1_1;
        return new DefaultHttp2DataFrame((ByteBuf)var1_1, this.endStream, this.padding);
    }

    public final int refCnt() {
        return this.content.refCnt();
    }

    public final boolean release() {
        return this.content.release();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean release(int decrement) {
        void var1_1;
        return this.content.release((int)var1_1);
    }

    @Override
    public final DefaultHttp2DataFrame retain() {
        this.content.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2DataFrame retain(int increment) {
        void var1_1;
        this.content.retain((int)var1_1);
        return this;
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "(stream=" + this.stream() + ", content=" + this.content + ", endStream=" + this.endStream + ", padding=" + this.padding + ')';
    }

    @Override
    public final DefaultHttp2DataFrame touch() {
        this.content.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultHttp2DataFrame touch(Object hint) {
        void var1_1;
        this.content.touch((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof DefaultHttp2DataFrame)) {
            return false;
        }
        DefaultHttp2DataFrame other = (DefaultHttp2DataFrame)o;
        return super.equals(other) && this.content.equals((Object)other.content()) && this.endStream == other.endStream && this.padding == var1_1.padding;
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.content.hashCode();
        n = n * 31 + (this.endStream ? 0 : 1);
        n = n * 31 + this.padding;
        return n;
    }
}

